// third_party/blink/public/mojom/sms/sms_receiver.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SMS_SMS_RECEIVER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SMS_SMS_RECEIVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/sms/sms_receiver.mojom-shared.h"
#include "third_party/blink/public/mojom/sms/sms_receiver.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class SmsReceiverProxy;

template <typename ImplRefTraits>
class SmsReceiverStub;

class SmsReceiverRequestValidator;
class SmsReceiverResponseValidator;


class BLINK_COMMON_EXPORT SmsReceiver
    : public SmsReceiverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SmsReceiverInterfaceBase;
  using Proxy_ = SmsReceiverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SmsReceiverStub<ImplRefTraits>;

  using RequestValidator_ = SmsReceiverRequestValidator;
  using ResponseValidator_ = SmsReceiverResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReceiveMinVersion = 0,
    kAbortMinVersion = 0,
  };
  virtual ~SmsReceiver() {}


  using ReceiveCallback = base::OnceCallback<void(SmsStatus, const base::Optional<std::string>&)>;
  
  virtual void Receive(ReceiveCallback callback) = 0;

  
  virtual void Abort() = 0;
};



class BLINK_COMMON_EXPORT SmsReceiverProxy
    : public SmsReceiver {
 public:
  using InterfaceType = SmsReceiver;

  explicit SmsReceiverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Receive(ReceiveCallback callback) final;
  
  void Abort() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT SmsReceiverStubDispatch {
 public:
  static bool Accept(SmsReceiver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SmsReceiver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SmsReceiver>>
class SmsReceiverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SmsReceiverStub() {}
  ~SmsReceiverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmsReceiverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmsReceiverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SmsReceiverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SmsReceiverResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SMS_SMS_RECEIVER_MOJOM_H_