// third_party/blink/public/mojom/service_worker/service_worker.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-forward.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-forward.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom.h"
#include "third_party/blink/public/mojom/notifications/notification.mojom.h"
#include "third_party/blink/public/mojom/payments/payment_app.mojom.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class ServiceWorkerHostProxy;

template <typename ImplRefTraits>
class ServiceWorkerHostStub;

class ServiceWorkerHostRequestValidator;
class ServiceWorkerHostResponseValidator;


class BLINK_COMMON_EXPORT ServiceWorkerHost
    : public ServiceWorkerHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerHostInterfaceBase;
  using Proxy_ = ServiceWorkerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerHostStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerHostRequestValidator;
  using ResponseValidator_ = ServiceWorkerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetCachedMetadataMinVersion = 0,
    kClearCachedMetadataMinVersion = 0,
    kGetClientsMinVersion = 0,
    kGetClientMinVersion = 0,
    kOpenNewTabMinVersion = 0,
    kOpenPaymentHandlerWindowMinVersion = 0,
    kPostMessageToClientMinVersion = 0,
    kFocusClientMinVersion = 0,
    kNavigateClientMinVersion = 0,
    kSkipWaitingMinVersion = 0,
    kClaimClientsMinVersion = 0,
  };
  virtual ~ServiceWorkerHost() {}

  
  virtual void SetCachedMetadata(const ::GURL& url, ::base::span<const ::uint8_t> data) = 0;

  
  virtual void ClearCachedMetadata(const ::GURL& url) = 0;


  using GetClientsCallback = base::OnceCallback<void(std::vector<::blink::mojom::ServiceWorkerClientInfoPtr>)>;
  
  virtual void GetClients(::blink::mojom::ServiceWorkerClientQueryOptionsPtr options, GetClientsCallback callback) = 0;


  using GetClientCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerClientInfoPtr)>;
  
  virtual void GetClient(const std::string& client_uuid, GetClientCallback callback) = 0;


  using OpenNewTabCallback = base::OnceCallback<void(bool, ::blink::mojom::ServiceWorkerClientInfoPtr, const base::Optional<std::string>&)>;
  
  virtual void OpenNewTab(const ::GURL& url, OpenNewTabCallback callback) = 0;


  using OpenPaymentHandlerWindowCallback = base::OnceCallback<void(bool, ::blink::mojom::ServiceWorkerClientInfoPtr, const base::Optional<std::string>&)>;
  
  virtual void OpenPaymentHandlerWindow(const ::GURL& url, OpenPaymentHandlerWindowCallback callback) = 0;

  
  virtual void PostMessageToClient(const std::string& client_uuid, ::blink::TransferableMessage message) = 0;


  using FocusClientCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerClientInfoPtr)>;
  
  virtual void FocusClient(const std::string& client_uuid, FocusClientCallback callback) = 0;


  using NavigateClientCallback = base::OnceCallback<void(bool, ::blink::mojom::ServiceWorkerClientInfoPtr, const base::Optional<std::string>&)>;
  
  virtual void NavigateClient(const std::string& client_uuid, const ::GURL& url, NavigateClientCallback callback) = 0;


  using SkipWaitingCallback = base::OnceCallback<void(bool)>;
  
  virtual void SkipWaiting(SkipWaitingCallback callback) = 0;


  using ClaimClientsCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const base::Optional<std::string>&)>;
  
  virtual void ClaimClients(ClaimClientsCallback callback) = 0;
};

class ServiceWorkerProxy;

template <typename ImplRefTraits>
class ServiceWorkerStub;

class ServiceWorkerRequestValidator;
class ServiceWorkerResponseValidator;


class BLINK_COMMON_EXPORT ServiceWorker
    : public ServiceWorkerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerInterfaceBase;
  using Proxy_ = ServiceWorkerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerRequestValidator;
  using ResponseValidator_ = ServiceWorkerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeGlobalScopeMinVersion = 0,
    kDispatchInstallEventMinVersion = 0,
    kDispatchActivateEventMinVersion = 0,
    kDispatchBackgroundFetchAbortEventMinVersion = 0,
    kDispatchBackgroundFetchClickEventMinVersion = 0,
    kDispatchBackgroundFetchFailEventMinVersion = 0,
    kDispatchBackgroundFetchSuccessEventMinVersion = 0,
    kDispatchCookieChangeEventMinVersion = 0,
    kDispatchFetchEventForMainResourceMinVersion = 0,
    kDispatchNotificationClickEventMinVersion = 0,
    kDispatchNotificationCloseEventMinVersion = 0,
    kDispatchPushEventMinVersion = 0,
    kDispatchPushSubscriptionChangeEventMinVersion = 0,
    kDispatchSyncEventMinVersion = 0,
    kDispatchPeriodicSyncEventMinVersion = 0,
    kDispatchAbortPaymentEventMinVersion = 0,
    kDispatchCanMakePaymentEventMinVersion = 0,
    kDispatchPaymentRequestEventMinVersion = 0,
    kDispatchExtendableMessageEventMinVersion = 0,
    kDispatchContentDeleteEventMinVersion = 0,
    kPingMinVersion = 0,
    kSetIdleDelayMinVersion = 0,
    kAddMessageToConsoleMinVersion = 0,
  };
  virtual ~ServiceWorker() {}

  
  virtual void InitializeGlobalScope(::mojo::PendingAssociatedRemote<ServiceWorkerHost> service_worker_host, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr registration_info, ::blink::mojom::ServiceWorkerObjectInfoPtr service_worker_info, FetchHandlerExistence fetch_handler_existence, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> reporting_observer_receiver) = 0;


  using DispatchInstallEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus, uint32_t)>;
  
  virtual void DispatchInstallEvent(DispatchInstallEventCallback callback) = 0;


  using DispatchActivateEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchActivateEvent(DispatchActivateEventCallback callback) = 0;


  using DispatchBackgroundFetchAbortEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchBackgroundFetchAbortEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchAbortEventCallback callback) = 0;


  using DispatchBackgroundFetchClickEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchBackgroundFetchClickEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchClickEventCallback callback) = 0;


  using DispatchBackgroundFetchFailEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchBackgroundFetchFailEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchFailEventCallback callback) = 0;


  using DispatchBackgroundFetchSuccessEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchBackgroundFetchSuccessEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchSuccessEventCallback callback) = 0;


  using DispatchCookieChangeEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchCookieChangeEvent(const ::net::CookieChangeInfo& change, DispatchCookieChangeEventCallback callback) = 0;


  using DispatchFetchEventForMainResourceCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchFetchEventForMainResource(::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForMainResourceCallback callback) = 0;


  using DispatchNotificationClickEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchNotificationClickEvent(const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, int32_t action_index, const base::Optional<::base::string16>& reply, DispatchNotificationClickEventCallback callback) = 0;


  using DispatchNotificationCloseEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchNotificationCloseEvent(const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, DispatchNotificationCloseEventCallback callback) = 0;


  using DispatchPushEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchPushEvent(const base::Optional<std::string>& payload, DispatchPushEventCallback callback) = 0;


  using DispatchPushSubscriptionChangeEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchPushSubscriptionChangeEvent(::blink::mojom::PushSubscriptionPtr old_subscription, ::blink::mojom::PushSubscriptionPtr new_subscription, DispatchPushSubscriptionChangeEventCallback callback) = 0;


  using DispatchSyncEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchSyncEvent(const std::string& tag, bool last_chance, ::base::TimeDelta timeout, DispatchSyncEventCallback callback) = 0;


  using DispatchPeriodicSyncEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchPeriodicSyncEvent(const std::string& tag, ::base::TimeDelta timeout, DispatchPeriodicSyncEventCallback callback) = 0;


  using DispatchAbortPaymentEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_abort_payment, DispatchAbortPaymentEventCallback callback) = 0;


  using DispatchCanMakePaymentEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchCanMakePaymentEvent(::payments::mojom::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) = 0;


  using DispatchPaymentRequestEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchPaymentRequestEvent(::payments::mojom::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> response_callback, DispatchPaymentRequestEventCallback callback) = 0;


  using DispatchExtendableMessageEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchExtendableMessageEvent(ExtendableMessageEventPtr event, DispatchExtendableMessageEventCallback callback) = 0;


  using DispatchContentDeleteEventCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerEventStatus)>;
  
  virtual void DispatchContentDeleteEvent(const std::string& id, DispatchContentDeleteEventCallback callback) = 0;


  using PingCallback = base::OnceCallback<void()>;
  
  virtual void Ping(PingCallback callback) = 0;

  
  virtual void SetIdleDelay(::base::TimeDelta delay) = 0;

  
  virtual void AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message) = 0;
};



class BLINK_COMMON_EXPORT ServiceWorkerHostProxy
    : public ServiceWorkerHost {
 public:
  using InterfaceType = ServiceWorkerHost;

  explicit ServiceWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCachedMetadata(const ::GURL& url, ::base::span<const ::uint8_t> data) final;
  
  void ClearCachedMetadata(const ::GURL& url) final;
  
  void GetClients(::blink::mojom::ServiceWorkerClientQueryOptionsPtr options, GetClientsCallback callback) final;
  
  void GetClient(const std::string& client_uuid, GetClientCallback callback) final;
  
  void OpenNewTab(const ::GURL& url, OpenNewTabCallback callback) final;
  
  void OpenPaymentHandlerWindow(const ::GURL& url, OpenPaymentHandlerWindowCallback callback) final;
  
  void PostMessageToClient(const std::string& client_uuid, ::blink::TransferableMessage message) final;
  
  void FocusClient(const std::string& client_uuid, FocusClientCallback callback) final;
  
  void NavigateClient(const std::string& client_uuid, const ::GURL& url, NavigateClientCallback callback) final;
  
  void SkipWaiting(SkipWaitingCallback callback) final;
  
  void ClaimClients(ClaimClientsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT ServiceWorkerProxy
    : public ServiceWorker {
 public:
  using InterfaceType = ServiceWorker;

  explicit ServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InitializeGlobalScope(::mojo::PendingAssociatedRemote<ServiceWorkerHost> service_worker_host, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr registration_info, ::blink::mojom::ServiceWorkerObjectInfoPtr service_worker_info, FetchHandlerExistence fetch_handler_existence, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> reporting_observer_receiver) final;
  
  void DispatchInstallEvent(DispatchInstallEventCallback callback) final;
  
  void DispatchActivateEvent(DispatchActivateEventCallback callback) final;
  
  void DispatchBackgroundFetchAbortEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchAbortEventCallback callback) final;
  
  void DispatchBackgroundFetchClickEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchClickEventCallback callback) final;
  
  void DispatchBackgroundFetchFailEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchFailEventCallback callback) final;
  
  void DispatchBackgroundFetchSuccessEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchSuccessEventCallback callback) final;
  
  void DispatchCookieChangeEvent(const ::net::CookieChangeInfo& change, DispatchCookieChangeEventCallback callback) final;
  
  void DispatchFetchEventForMainResource(::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForMainResourceCallback callback) final;
  
  void DispatchNotificationClickEvent(const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, int32_t action_index, const base::Optional<::base::string16>& reply, DispatchNotificationClickEventCallback callback) final;
  
  void DispatchNotificationCloseEvent(const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, DispatchNotificationCloseEventCallback callback) final;
  
  void DispatchPushEvent(const base::Optional<std::string>& payload, DispatchPushEventCallback callback) final;
  
  void DispatchPushSubscriptionChangeEvent(::blink::mojom::PushSubscriptionPtr old_subscription, ::blink::mojom::PushSubscriptionPtr new_subscription, DispatchPushSubscriptionChangeEventCallback callback) final;
  
  void DispatchSyncEvent(const std::string& tag, bool last_chance, ::base::TimeDelta timeout, DispatchSyncEventCallback callback) final;
  
  void DispatchPeriodicSyncEvent(const std::string& tag, ::base::TimeDelta timeout, DispatchPeriodicSyncEventCallback callback) final;
  
  void DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_abort_payment, DispatchAbortPaymentEventCallback callback) final;
  
  void DispatchCanMakePaymentEvent(::payments::mojom::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) final;
  
  void DispatchPaymentRequestEvent(::payments::mojom::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> response_callback, DispatchPaymentRequestEventCallback callback) final;
  
  void DispatchExtendableMessageEvent(ExtendableMessageEventPtr event, DispatchExtendableMessageEventCallback callback) final;
  
  void DispatchContentDeleteEvent(const std::string& id, DispatchContentDeleteEventCallback callback) final;
  
  void Ping(PingCallback callback) final;
  
  void SetIdleDelay(::base::TimeDelta delay) final;
  
  void AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ServiceWorkerHostStubDispatch {
 public:
  static bool Accept(ServiceWorkerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerHost>>
class ServiceWorkerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerHostStub() {}
  ~ServiceWorkerHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerStubDispatch {
 public:
  static bool Accept(ServiceWorker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorker>>
class ServiceWorkerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerStub() {}
  ~ServiceWorkerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT ExtendableMessageEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtendableMessageEvent, T>::value>;
  using DataView = ExtendableMessageEventDataView;
  using Data_ = internal::ExtendableMessageEvent_Data;

  template <typename... Args>
  static ExtendableMessageEventPtr New(Args&&... args) {
    return ExtendableMessageEventPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtendableMessageEventPtr From(const U& u) {
    return mojo::TypeConverter<ExtendableMessageEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtendableMessageEvent>::Convert(*this);
  }


  ExtendableMessageEvent();

  ExtendableMessageEvent(
      ::blink::TransferableMessage message,
      const ::url::Origin& source_origin,
      ::blink::mojom::ServiceWorkerClientInfoPtr source_info_for_client,
      ::blink::mojom::ServiceWorkerObjectInfoPtr source_info_for_service_worker);

  ~ExtendableMessageEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtendableMessageEventPtr>
  ExtendableMessageEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtendableMessageEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtendableMessageEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtendableMessageEvent_UnserializedMessageContext<
            UserType, ExtendableMessageEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ExtendableMessageEvent::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ExtendableMessageEvent::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtendableMessageEvent_UnserializedMessageContext<
            UserType, ExtendableMessageEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtendableMessageEvent::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::TransferableMessage message;
  
  ::url::Origin source_origin;
  
  ::blink::mojom::ServiceWorkerClientInfoPtr source_info_for_client;
  
  ::blink::mojom::ServiceWorkerObjectInfoPtr source_info_for_service_worker;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ExtendableMessageEvent);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExtendableMessageEventPtr ExtendableMessageEvent::Clone() const {
  return New(
      mojo::Clone(message),
      mojo::Clone(source_origin),
      mojo::Clone(source_info_for_client),
      mojo::Clone(source_info_for_service_worker)
  );
}

template <typename T, ExtendableMessageEvent::EnableIfSame<T>*>
bool ExtendableMessageEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->source_origin, other_struct.source_origin))
    return false;
  if (!mojo::Equals(this->source_info_for_client, other_struct.source_info_for_client))
    return false;
  if (!mojo::Equals(this->source_info_for_service_worker, other_struct.source_info_for_service_worker))
    return false;
  return true;
}

template <typename T, ExtendableMessageEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.message, rhs.message))
    return true;
  if (std::less<>{}(rhs.message, lhs.message))
    return false;
  if (std::less<>{}(lhs.source_origin, rhs.source_origin))
    return true;
  if (std::less<>{}(rhs.source_origin, lhs.source_origin))
    return false;
  if (std::less<>{}(lhs.source_info_for_client, rhs.source_info_for_client))
    return true;
  if (std::less<>{}(rhs.source_info_for_client, lhs.source_info_for_client))
    return false;
  if (std::less<>{}(lhs.source_info_for_service_worker, rhs.source_info_for_service_worker))
    return true;
  if (std::less<>{}(rhs.source_info_for_service_worker, lhs.source_info_for_service_worker))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ExtendableMessageEvent::DataView,
                                         ::blink::mojom::ExtendableMessageEventPtr> {
  static bool IsNull(const ::blink::mojom::ExtendableMessageEventPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ExtendableMessageEventPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::ExtendableMessageEvent::message)& message(
       ::blink::mojom::ExtendableMessageEventPtr& input) {
    return input->message;
  }

  static const decltype(::blink::mojom::ExtendableMessageEvent::source_origin)& source_origin(
      const ::blink::mojom::ExtendableMessageEventPtr& input) {
    return input->source_origin;
  }

  static const decltype(::blink::mojom::ExtendableMessageEvent::source_info_for_client)& source_info_for_client(
      const ::blink::mojom::ExtendableMessageEventPtr& input) {
    return input->source_info_for_client;
  }

  static  decltype(::blink::mojom::ExtendableMessageEvent::source_info_for_service_worker)& source_info_for_service_worker(
       ::blink::mojom::ExtendableMessageEventPtr& input) {
    return input->source_info_for_service_worker;
  }

  static bool Read(::blink::mojom::ExtendableMessageEvent::DataView input, ::blink::mojom::ExtendableMessageEventPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_H_