// third_party/blink/public/mojom/page_state/page_state.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/page_state/page_state.mojom-shared.h"
#include "third_party/blink/public/mojom/page_state/page_state.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/referrer_policy.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {












class BLINK_COMMON_EXPORT Element {
 public:
  using DataView = ElementDataView;
  using Data_ = internal::Element_Data;
  using Tag = Data_::Element_Tag;

  static ElementPtr New() {
    return ElementPtr(base::in_place);
  }
  // Construct an instance holding |blob_uuid|.
  static ElementPtr
  NewBlobUuid(
      const std::string& blob_uuid) {
    auto result = ElementPtr(base::in_place);
    result->set_blob_uuid(std::move(blob_uuid));
    return result;
  }
  // Construct an instance holding |bytes|.
  static ElementPtr
  NewBytes(
      std::vector<uint8_t> bytes) {
    auto result = ElementPtr(base::in_place);
    result->set_bytes(std::move(bytes));
    return result;
  }
  // Construct an instance holding |file|.
  static ElementPtr
  NewFile(
      FilePtr file) {
    auto result = ElementPtr(base::in_place);
    result->set_file(std::move(file));
    return result;
  }
  // Construct an instance holding |DEPRECATED_file_system_file|.
  static ElementPtr
  NewDeprecatedFileSystemFile(
      DEPRECATED_FileSystemFilePtr DEPRECATED_file_system_file) {
    auto result = ElementPtr(base::in_place);
    result->set_DEPRECATED_file_system_file(std::move(DEPRECATED_file_system_file));
    return result;
  }

  template <typename U>
  static ElementPtr From(const U& u) {
    return mojo::TypeConverter<ElementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Element>::Convert(*this);
  }

  Element();
  ~Element();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ElementPtr>
  ElementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Element>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_blob_uuid() const { return tag_ == Tag::BLOB_UUID; }

  
  std::string& get_blob_uuid() const {
    DCHECK(tag_ == Tag::BLOB_UUID);
    return *(data_.blob_uuid);
  }

  
  void set_blob_uuid(
      const std::string& blob_uuid);
  
  bool is_bytes() const { return tag_ == Tag::BYTES; }

  
  std::vector<uint8_t>& get_bytes() const {
    DCHECK(tag_ == Tag::BYTES);
    return *(data_.bytes);
  }

  
  void set_bytes(
      std::vector<uint8_t> bytes);
  
  bool is_file() const { return tag_ == Tag::FILE; }

  
  FilePtr& get_file() const {
    DCHECK(tag_ == Tag::FILE);
    return *(data_.file);
  }

  
  void set_file(
      FilePtr file);
  
  bool is_DEPRECATED_file_system_file() const { return tag_ == Tag::DEPRECATED_FILE_SYSTEM_FILE; }

  
  DEPRECATED_FileSystemFilePtr& get_DEPRECATED_file_system_file() const {
    DCHECK(tag_ == Tag::DEPRECATED_FILE_SYSTEM_FILE);
    return *(data_.DEPRECATED_file_system_file);
  }

  
  void set_DEPRECATED_file_system_file(
      DEPRECATED_FileSystemFilePtr DEPRECATED_file_system_file);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Element::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Element::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    std::string* blob_uuid;
    std::vector<uint8_t>* bytes;
    FilePtr* file;
    DEPRECATED_FileSystemFilePtr* DEPRECATED_file_system_file;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT DEPRECATED_FileSystemFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DEPRECATED_FileSystemFile, T>::value>;
  using DataView = DEPRECATED_FileSystemFileDataView;
  using Data_ = internal::DEPRECATED_FileSystemFile_Data;

  template <typename... Args>
  static DEPRECATED_FileSystemFilePtr New(Args&&... args) {
    return DEPRECATED_FileSystemFilePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DEPRECATED_FileSystemFilePtr From(const U& u) {
    return mojo::TypeConverter<DEPRECATED_FileSystemFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DEPRECATED_FileSystemFile>::Convert(*this);
  }


  DEPRECATED_FileSystemFile();

  DEPRECATED_FileSystemFile(
      const ::GURL& filesystem_url,
      uint64_t offset,
      uint64_t length,
      ::base::Time modification_time);

  ~DEPRECATED_FileSystemFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DEPRECATED_FileSystemFilePtr>
  DEPRECATED_FileSystemFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DEPRECATED_FileSystemFile::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DEPRECATED_FileSystemFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DEPRECATED_FileSystemFile_UnserializedMessageContext<
            UserType, DEPRECATED_FileSystemFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DEPRECATED_FileSystemFile::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DEPRECATED_FileSystemFile::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DEPRECATED_FileSystemFile_UnserializedMessageContext<
            UserType, DEPRECATED_FileSystemFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DEPRECATED_FileSystemFile::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL filesystem_url;
  
  uint64_t offset;
  
  uint64_t length;
  
  ::base::Time modification_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT File {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<File, T>::value>;
  using DataView = FileDataView;
  using Data_ = internal::File_Data;

  template <typename... Args>
  static FilePtr New(Args&&... args) {
    return FilePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilePtr From(const U& u) {
    return mojo::TypeConverter<FilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, File>::Convert(*this);
  }


  File();

  File(
      const ::base::string16& path,
      uint64_t offset,
      uint64_t length,
      ::base::Time modification_time);

  ~File();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilePtr>
  FilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, File::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        File::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        File::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::File_UnserializedMessageContext<
            UserType, File::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<File::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return File::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::File_UnserializedMessageContext<
            UserType, File::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<File::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::string16 path;
  
  uint64_t offset;
  
  uint64_t length;
  
  ::base::Time modification_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT RequestBody {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestBody, T>::value>;
  using DataView = RequestBodyDataView;
  using Data_ = internal::RequestBody_Data;

  template <typename... Args>
  static RequestBodyPtr New(Args&&... args) {
    return RequestBodyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestBodyPtr From(const U& u) {
    return mojo::TypeConverter<RequestBodyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestBody>::Convert(*this);
  }


  RequestBody();

  RequestBody(
      std::vector<ElementPtr> elements,
      int64_t identifier,
      bool contains_sensitive_info);

  ~RequestBody();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestBodyPtr>
  RequestBodyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestBody::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestBody::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestBody_UnserializedMessageContext<
            UserType, RequestBody::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RequestBody::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RequestBody::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestBody_UnserializedMessageContext<
            UserType, RequestBody::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestBody::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<ElementPtr> elements;
  
  int64_t identifier;
  
  bool contains_sensitive_info;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(RequestBody);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT HttpBody {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpBody, T>::value>;
  using DataView = HttpBodyDataView;
  using Data_ = internal::HttpBody_Data;

  template <typename... Args>
  static HttpBodyPtr New(Args&&... args) {
    return HttpBodyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpBodyPtr From(const U& u) {
    return mojo::TypeConverter<HttpBodyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpBody>::Convert(*this);
  }


  HttpBody();

  HttpBody(
      const base::Optional<::base::string16>& http_content_type,
      RequestBodyPtr request_body,
      bool contains_passwords);

  ~HttpBody();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpBodyPtr>
  HttpBodyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpBody::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpBody::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpBody_UnserializedMessageContext<
            UserType, HttpBody::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HttpBody::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HttpBody::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpBody_UnserializedMessageContext<
            UserType, HttpBody::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpBody::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<::base::string16> http_content_type;
  
  RequestBodyPtr request_body;
  
  bool contains_passwords;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(HttpBody);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ViewState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewState, T>::value>;
  using DataView = ViewStateDataView;
  using Data_ = internal::ViewState_Data;

  template <typename... Args>
  static ViewStatePtr New(Args&&... args) {
    return ViewStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewStatePtr From(const U& u) {
    return mojo::TypeConverter<ViewStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewState>::Convert(*this);
  }


  ViewState();

  ViewState(
      const ::gfx::PointF& visual_viewport_scroll_offset,
      const ::gfx::Point& scroll_offset,
      double page_scale_factor);

  ViewState(
      const ::gfx::PointF& visual_viewport_scroll_offset,
      const ::gfx::Point& scroll_offset,
      double page_scale_factor,
      const base::Optional<::base::string16>& scroll_anchor_selector,
      const base::Optional<::gfx::PointF>& scroll_anchor_offset,
      uint64_t scroll_anchor_simhash);

  ~ViewState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewStatePtr>
  ViewStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewState_UnserializedMessageContext<
            UserType, ViewState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ViewState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ViewState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewState_UnserializedMessageContext<
            UserType, ViewState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::PointF visual_viewport_scroll_offset;
  
  ::gfx::Point scroll_offset;
  
  double page_scale_factor;
  
  base::Optional<::base::string16> scroll_anchor_selector;
  
  base::Optional<::gfx::PointF> scroll_anchor_offset;
  
  uint64_t scroll_anchor_simhash;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FrameState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameState, T>::value>;
  using DataView = FrameStateDataView;
  using Data_ = internal::FrameState_Data;

  template <typename... Args>
  static FrameStatePtr New(Args&&... args) {
    return FrameStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameStatePtr From(const U& u) {
    return mojo::TypeConverter<FrameStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameState>::Convert(*this);
  }


  FrameState();

  FrameState(
      const base::Optional<::base::string16>& url_string,
      const base::Optional<::base::string16>& referrer,
      const base::Optional<::base::string16>& target,
      const base::Optional<::base::string16>& state_object,
      std::vector<base::Optional<::base::string16>> document_state,
      ScrollRestorationType scroll_restoration_type,
      ViewStatePtr view_state,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      ::network::mojom::ReferrerPolicy referrer_policy,
      HttpBodyPtr http_body,
      std::vector<FrameStatePtr> children);

  FrameState(
      const base::Optional<::base::string16>& url_string,
      const base::Optional<::base::string16>& referrer,
      const base::Optional<::base::string16>& target,
      const base::Optional<::base::string16>& state_object,
      std::vector<base::Optional<::base::string16>> document_state,
      ScrollRestorationType scroll_restoration_type,
      ViewStatePtr view_state,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      ::network::mojom::ReferrerPolicy referrer_policy,
      HttpBodyPtr http_body,
      std::vector<FrameStatePtr> children,
      const base::Optional<std::string>& initiator_origin);

  ~FrameState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameStatePtr>
  FrameStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameState_UnserializedMessageContext<
            UserType, FrameState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FrameState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FrameState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameState_UnserializedMessageContext<
            UserType, FrameState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<::base::string16> url_string;
  
  base::Optional<::base::string16> referrer;
  
  base::Optional<::base::string16> target;
  
  base::Optional<::base::string16> state_object;
  
  std::vector<base::Optional<::base::string16>> document_state;
  
  ScrollRestorationType scroll_restoration_type;
  
  ViewStatePtr view_state;
  
  int64_t item_sequence_number;
  
  int64_t document_sequence_number;
  
  ::network::mojom::ReferrerPolicy referrer_policy;
  
  HttpBodyPtr http_body;
  
  std::vector<FrameStatePtr> children;
  
  base::Optional<std::string> initiator_origin;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(FrameState);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PageState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageState, T>::value>;
  using DataView = PageStateDataView;
  using Data_ = internal::PageState_Data;

  template <typename... Args>
  static PageStatePtr New(Args&&... args) {
    return PageStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageStatePtr From(const U& u) {
    return mojo::TypeConverter<PageStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageState>::Convert(*this);
  }


  PageState();

  PageState(
      std::vector<base::Optional<::base::string16>> referenced_files,
      FrameStatePtr top);

  ~PageState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageStatePtr>
  PageStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageState_UnserializedMessageContext<
            UserType, PageState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PageState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PageState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageState_UnserializedMessageContext<
            UserType, PageState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<base::Optional<::base::string16>> referenced_files;
  
  FrameStatePtr top;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PageState);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ElementPtr Element::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::BLOB_UUID:
      rv->set_blob_uuid(mojo::Clone(*data_.blob_uuid));
      break;
    case Tag::BYTES:
      rv->set_bytes(mojo::Clone(*data_.bytes));
      break;
    case Tag::FILE:
      rv->set_file(mojo::Clone(*data_.file));
      break;
    case Tag::DEPRECATED_FILE_SYSTEM_FILE:
      rv->set_DEPRECATED_file_system_file(mojo::Clone(*data_.DEPRECATED_file_system_file));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Element>::value>::type*>
bool Element::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::BLOB_UUID:
      return mojo::Equals(*(data_.blob_uuid), *(other.data_.blob_uuid));
    case Tag::BYTES:
      return mojo::Equals(*(data_.bytes), *(other.data_.bytes));
    case Tag::FILE:
      return mojo::Equals(*(data_.file), *(other.data_.file));
    case Tag::DEPRECATED_FILE_SYSTEM_FILE:
      return mojo::Equals(*(data_.DEPRECATED_file_system_file), *(other.data_.DEPRECATED_file_system_file));
  }

  return false;
}
template <typename StructPtrType>
DEPRECATED_FileSystemFilePtr DEPRECATED_FileSystemFile::Clone() const {
  return New(
      mojo::Clone(filesystem_url),
      mojo::Clone(offset),
      mojo::Clone(length),
      mojo::Clone(modification_time)
  );
}

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>*>
bool DEPRECATED_FileSystemFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filesystem_url, other_struct.filesystem_url))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->modification_time, other_struct.modification_time))
    return false;
  return true;
}

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.filesystem_url, rhs.filesystem_url))
    return true;
  if (std::less<>{}(rhs.filesystem_url, lhs.filesystem_url))
    return false;
  if (std::less<>{}(lhs.offset, rhs.offset))
    return true;
  if (std::less<>{}(rhs.offset, lhs.offset))
    return false;
  if (std::less<>{}(lhs.length, rhs.length))
    return true;
  if (std::less<>{}(rhs.length, lhs.length))
    return false;
  if (std::less<>{}(lhs.modification_time, rhs.modification_time))
    return true;
  if (std::less<>{}(rhs.modification_time, lhs.modification_time))
    return false;
  return false;
}
template <typename StructPtrType>
FilePtr File::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(offset),
      mojo::Clone(length),
      mojo::Clone(modification_time)
  );
}

template <typename T, File::EnableIfSame<T>*>
bool File::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->modification_time, other_struct.modification_time))
    return false;
  return true;
}

template <typename T, File::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.path, rhs.path))
    return true;
  if (std::less<>{}(rhs.path, lhs.path))
    return false;
  if (std::less<>{}(lhs.offset, rhs.offset))
    return true;
  if (std::less<>{}(rhs.offset, lhs.offset))
    return false;
  if (std::less<>{}(lhs.length, rhs.length))
    return true;
  if (std::less<>{}(rhs.length, lhs.length))
    return false;
  if (std::less<>{}(lhs.modification_time, rhs.modification_time))
    return true;
  if (std::less<>{}(rhs.modification_time, lhs.modification_time))
    return false;
  return false;
}
template <typename StructPtrType>
RequestBodyPtr RequestBody::Clone() const {
  return New(
      mojo::Clone(elements),
      mojo::Clone(identifier),
      mojo::Clone(contains_sensitive_info)
  );
}

template <typename T, RequestBody::EnableIfSame<T>*>
bool RequestBody::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->elements, other_struct.elements))
    return false;
  if (!mojo::Equals(this->identifier, other_struct.identifier))
    return false;
  if (!mojo::Equals(this->contains_sensitive_info, other_struct.contains_sensitive_info))
    return false;
  return true;
}

template <typename T, RequestBody::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.elements, rhs.elements))
    return true;
  if (std::less<>{}(rhs.elements, lhs.elements))
    return false;
  if (std::less<>{}(lhs.identifier, rhs.identifier))
    return true;
  if (std::less<>{}(rhs.identifier, lhs.identifier))
    return false;
  if (std::less<>{}(lhs.contains_sensitive_info, rhs.contains_sensitive_info))
    return true;
  if (std::less<>{}(rhs.contains_sensitive_info, lhs.contains_sensitive_info))
    return false;
  return false;
}
template <typename StructPtrType>
HttpBodyPtr HttpBody::Clone() const {
  return New(
      mojo::Clone(http_content_type),
      mojo::Clone(request_body),
      mojo::Clone(contains_passwords)
  );
}

template <typename T, HttpBody::EnableIfSame<T>*>
bool HttpBody::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->http_content_type, other_struct.http_content_type))
    return false;
  if (!mojo::Equals(this->request_body, other_struct.request_body))
    return false;
  if (!mojo::Equals(this->contains_passwords, other_struct.contains_passwords))
    return false;
  return true;
}

template <typename T, HttpBody::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.http_content_type, rhs.http_content_type))
    return true;
  if (std::less<>{}(rhs.http_content_type, lhs.http_content_type))
    return false;
  if (std::less<>{}(lhs.request_body, rhs.request_body))
    return true;
  if (std::less<>{}(rhs.request_body, lhs.request_body))
    return false;
  if (std::less<>{}(lhs.contains_passwords, rhs.contains_passwords))
    return true;
  if (std::less<>{}(rhs.contains_passwords, lhs.contains_passwords))
    return false;
  return false;
}
template <typename StructPtrType>
ViewStatePtr ViewState::Clone() const {
  return New(
      mojo::Clone(visual_viewport_scroll_offset),
      mojo::Clone(scroll_offset),
      mojo::Clone(page_scale_factor),
      mojo::Clone(scroll_anchor_selector),
      mojo::Clone(scroll_anchor_offset),
      mojo::Clone(scroll_anchor_simhash)
  );
}

template <typename T, ViewState::EnableIfSame<T>*>
bool ViewState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->visual_viewport_scroll_offset, other_struct.visual_viewport_scroll_offset))
    return false;
  if (!mojo::Equals(this->scroll_offset, other_struct.scroll_offset))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->scroll_anchor_selector, other_struct.scroll_anchor_selector))
    return false;
  if (!mojo::Equals(this->scroll_anchor_offset, other_struct.scroll_anchor_offset))
    return false;
  if (!mojo::Equals(this->scroll_anchor_simhash, other_struct.scroll_anchor_simhash))
    return false;
  return true;
}

template <typename T, ViewState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.visual_viewport_scroll_offset, rhs.visual_viewport_scroll_offset))
    return true;
  if (std::less<>{}(rhs.visual_viewport_scroll_offset, lhs.visual_viewport_scroll_offset))
    return false;
  if (std::less<>{}(lhs.scroll_offset, rhs.scroll_offset))
    return true;
  if (std::less<>{}(rhs.scroll_offset, lhs.scroll_offset))
    return false;
  if (std::less<>{}(lhs.page_scale_factor, rhs.page_scale_factor))
    return true;
  if (std::less<>{}(rhs.page_scale_factor, lhs.page_scale_factor))
    return false;
  if (std::less<>{}(lhs.scroll_anchor_selector, rhs.scroll_anchor_selector))
    return true;
  if (std::less<>{}(rhs.scroll_anchor_selector, lhs.scroll_anchor_selector))
    return false;
  if (std::less<>{}(lhs.scroll_anchor_offset, rhs.scroll_anchor_offset))
    return true;
  if (std::less<>{}(rhs.scroll_anchor_offset, lhs.scroll_anchor_offset))
    return false;
  if (std::less<>{}(lhs.scroll_anchor_simhash, rhs.scroll_anchor_simhash))
    return true;
  if (std::less<>{}(rhs.scroll_anchor_simhash, lhs.scroll_anchor_simhash))
    return false;
  return false;
}
template <typename StructPtrType>
FrameStatePtr FrameState::Clone() const {
  return New(
      mojo::Clone(url_string),
      mojo::Clone(referrer),
      mojo::Clone(target),
      mojo::Clone(state_object),
      mojo::Clone(document_state),
      mojo::Clone(scroll_restoration_type),
      mojo::Clone(view_state),
      mojo::Clone(item_sequence_number),
      mojo::Clone(document_sequence_number),
      mojo::Clone(referrer_policy),
      mojo::Clone(http_body),
      mojo::Clone(children),
      mojo::Clone(initiator_origin)
  );
}

template <typename T, FrameState::EnableIfSame<T>*>
bool FrameState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url_string, other_struct.url_string))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->target, other_struct.target))
    return false;
  if (!mojo::Equals(this->state_object, other_struct.state_object))
    return false;
  if (!mojo::Equals(this->document_state, other_struct.document_state))
    return false;
  if (!mojo::Equals(this->scroll_restoration_type, other_struct.scroll_restoration_type))
    return false;
  if (!mojo::Equals(this->view_state, other_struct.view_state))
    return false;
  if (!mojo::Equals(this->item_sequence_number, other_struct.item_sequence_number))
    return false;
  if (!mojo::Equals(this->document_sequence_number, other_struct.document_sequence_number))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->http_body, other_struct.http_body))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  return true;
}

template <typename T, FrameState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url_string, rhs.url_string))
    return true;
  if (std::less<>{}(rhs.url_string, lhs.url_string))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.target, rhs.target))
    return true;
  if (std::less<>{}(rhs.target, lhs.target))
    return false;
  if (std::less<>{}(lhs.state_object, rhs.state_object))
    return true;
  if (std::less<>{}(rhs.state_object, lhs.state_object))
    return false;
  if (std::less<>{}(lhs.document_state, rhs.document_state))
    return true;
  if (std::less<>{}(rhs.document_state, lhs.document_state))
    return false;
  if (std::less<>{}(lhs.scroll_restoration_type, rhs.scroll_restoration_type))
    return true;
  if (std::less<>{}(rhs.scroll_restoration_type, lhs.scroll_restoration_type))
    return false;
  if (std::less<>{}(lhs.view_state, rhs.view_state))
    return true;
  if (std::less<>{}(rhs.view_state, lhs.view_state))
    return false;
  if (std::less<>{}(lhs.item_sequence_number, rhs.item_sequence_number))
    return true;
  if (std::less<>{}(rhs.item_sequence_number, lhs.item_sequence_number))
    return false;
  if (std::less<>{}(lhs.document_sequence_number, rhs.document_sequence_number))
    return true;
  if (std::less<>{}(rhs.document_sequence_number, lhs.document_sequence_number))
    return false;
  if (std::less<>{}(lhs.referrer_policy, rhs.referrer_policy))
    return true;
  if (std::less<>{}(rhs.referrer_policy, lhs.referrer_policy))
    return false;
  if (std::less<>{}(lhs.http_body, rhs.http_body))
    return true;
  if (std::less<>{}(rhs.http_body, lhs.http_body))
    return false;
  if (std::less<>{}(lhs.children, rhs.children))
    return true;
  if (std::less<>{}(rhs.children, lhs.children))
    return false;
  if (std::less<>{}(lhs.initiator_origin, rhs.initiator_origin))
    return true;
  if (std::less<>{}(rhs.initiator_origin, lhs.initiator_origin))
    return false;
  return false;
}
template <typename StructPtrType>
PageStatePtr PageState::Clone() const {
  return New(
      mojo::Clone(referenced_files),
      mojo::Clone(top)
  );
}

template <typename T, PageState::EnableIfSame<T>*>
bool PageState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->referenced_files, other_struct.referenced_files))
    return false;
  if (!mojo::Equals(this->top, other_struct.top))
    return false;
  return true;
}

template <typename T, PageState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.referenced_files, rhs.referenced_files))
    return true;
  if (std::less<>{}(rhs.referenced_files, lhs.referenced_files))
    return false;
  if (std::less<>{}(lhs.top, rhs.top))
    return true;
  if (std::less<>{}(rhs.top, lhs.top))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DEPRECATED_FileSystemFile::DataView,
                                         ::blink::mojom::DEPRECATED_FileSystemFilePtr> {
  static bool IsNull(const ::blink::mojom::DEPRECATED_FileSystemFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DEPRECATED_FileSystemFilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DEPRECATED_FileSystemFile::filesystem_url)& filesystem_url(
      const ::blink::mojom::DEPRECATED_FileSystemFilePtr& input) {
    return input->filesystem_url;
  }

  static decltype(::blink::mojom::DEPRECATED_FileSystemFile::offset) offset(
      const ::blink::mojom::DEPRECATED_FileSystemFilePtr& input) {
    return input->offset;
  }

  static decltype(::blink::mojom::DEPRECATED_FileSystemFile::length) length(
      const ::blink::mojom::DEPRECATED_FileSystemFilePtr& input) {
    return input->length;
  }

  static const decltype(::blink::mojom::DEPRECATED_FileSystemFile::modification_time)& modification_time(
      const ::blink::mojom::DEPRECATED_FileSystemFilePtr& input) {
    return input->modification_time;
  }

  static bool Read(::blink::mojom::DEPRECATED_FileSystemFile::DataView input, ::blink::mojom::DEPRECATED_FileSystemFilePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::File::DataView,
                                         ::blink::mojom::FilePtr> {
  static bool IsNull(const ::blink::mojom::FilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::File::path)& path(
      const ::blink::mojom::FilePtr& input) {
    return input->path;
  }

  static decltype(::blink::mojom::File::offset) offset(
      const ::blink::mojom::FilePtr& input) {
    return input->offset;
  }

  static decltype(::blink::mojom::File::length) length(
      const ::blink::mojom::FilePtr& input) {
    return input->length;
  }

  static const decltype(::blink::mojom::File::modification_time)& modification_time(
      const ::blink::mojom::FilePtr& input) {
    return input->modification_time;
  }

  static bool Read(::blink::mojom::File::DataView input, ::blink::mojom::FilePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RequestBody::DataView,
                                         ::blink::mojom::RequestBodyPtr> {
  static bool IsNull(const ::blink::mojom::RequestBodyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RequestBodyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::RequestBody::elements)& elements(
      const ::blink::mojom::RequestBodyPtr& input) {
    return input->elements;
  }

  static decltype(::blink::mojom::RequestBody::identifier) identifier(
      const ::blink::mojom::RequestBodyPtr& input) {
    return input->identifier;
  }

  static decltype(::blink::mojom::RequestBody::contains_sensitive_info) contains_sensitive_info(
      const ::blink::mojom::RequestBodyPtr& input) {
    return input->contains_sensitive_info;
  }

  static bool Read(::blink::mojom::RequestBody::DataView input, ::blink::mojom::RequestBodyPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::HttpBody::DataView,
                                         ::blink::mojom::HttpBodyPtr> {
  static bool IsNull(const ::blink::mojom::HttpBodyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::HttpBodyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::HttpBody::http_content_type)& http_content_type(
      const ::blink::mojom::HttpBodyPtr& input) {
    return input->http_content_type;
  }

  static const decltype(::blink::mojom::HttpBody::request_body)& request_body(
      const ::blink::mojom::HttpBodyPtr& input) {
    return input->request_body;
  }

  static decltype(::blink::mojom::HttpBody::contains_passwords) contains_passwords(
      const ::blink::mojom::HttpBodyPtr& input) {
    return input->contains_passwords;
  }

  static bool Read(::blink::mojom::HttpBody::DataView input, ::blink::mojom::HttpBodyPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ViewState::DataView,
                                         ::blink::mojom::ViewStatePtr> {
  static bool IsNull(const ::blink::mojom::ViewStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ViewStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ViewState::visual_viewport_scroll_offset)& visual_viewport_scroll_offset(
      const ::blink::mojom::ViewStatePtr& input) {
    return input->visual_viewport_scroll_offset;
  }

  static const decltype(::blink::mojom::ViewState::scroll_offset)& scroll_offset(
      const ::blink::mojom::ViewStatePtr& input) {
    return input->scroll_offset;
  }

  static decltype(::blink::mojom::ViewState::page_scale_factor) page_scale_factor(
      const ::blink::mojom::ViewStatePtr& input) {
    return input->page_scale_factor;
  }

  static const decltype(::blink::mojom::ViewState::scroll_anchor_selector)& scroll_anchor_selector(
      const ::blink::mojom::ViewStatePtr& input) {
    return input->scroll_anchor_selector;
  }

  static const decltype(::blink::mojom::ViewState::scroll_anchor_offset)& scroll_anchor_offset(
      const ::blink::mojom::ViewStatePtr& input) {
    return input->scroll_anchor_offset;
  }

  static decltype(::blink::mojom::ViewState::scroll_anchor_simhash) scroll_anchor_simhash(
      const ::blink::mojom::ViewStatePtr& input) {
    return input->scroll_anchor_simhash;
  }

  static bool Read(::blink::mojom::ViewState::DataView input, ::blink::mojom::ViewStatePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FrameState::DataView,
                                         ::blink::mojom::FrameStatePtr> {
  static bool IsNull(const ::blink::mojom::FrameStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FrameStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::FrameState::url_string)& url_string(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->url_string;
  }

  static const decltype(::blink::mojom::FrameState::referrer)& referrer(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::FrameState::target)& target(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->target;
  }

  static const decltype(::blink::mojom::FrameState::state_object)& state_object(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->state_object;
  }

  static const decltype(::blink::mojom::FrameState::document_state)& document_state(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->document_state;
  }

  static decltype(::blink::mojom::FrameState::scroll_restoration_type) scroll_restoration_type(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->scroll_restoration_type;
  }

  static const decltype(::blink::mojom::FrameState::view_state)& view_state(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->view_state;
  }

  static decltype(::blink::mojom::FrameState::item_sequence_number) item_sequence_number(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->item_sequence_number;
  }

  static decltype(::blink::mojom::FrameState::document_sequence_number) document_sequence_number(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->document_sequence_number;
  }

  static decltype(::blink::mojom::FrameState::referrer_policy) referrer_policy(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::blink::mojom::FrameState::http_body)& http_body(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->http_body;
  }

  static const decltype(::blink::mojom::FrameState::children)& children(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->children;
  }

  static const decltype(::blink::mojom::FrameState::initiator_origin)& initiator_origin(
      const ::blink::mojom::FrameStatePtr& input) {
    return input->initiator_origin;
  }

  static bool Read(::blink::mojom::FrameState::DataView input, ::blink::mojom::FrameStatePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PageState::DataView,
                                         ::blink::mojom::PageStatePtr> {
  static bool IsNull(const ::blink::mojom::PageStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PageStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PageState::referenced_files)& referenced_files(
      const ::blink::mojom::PageStatePtr& input) {
    return input->referenced_files;
  }

  static const decltype(::blink::mojom::PageState::top)& top(
      const ::blink::mojom::PageStatePtr& input) {
    return input->top;
  }

  static bool Read(::blink::mojom::PageState::DataView input, ::blink::mojom::PageStatePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::Element::DataView,
                                        ::blink::mojom::ElementPtr> {
  static bool IsNull(const ::blink::mojom::ElementPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ElementPtr* output) { output->reset(); }

  static ::blink::mojom::Element::Tag GetTag(const ::blink::mojom::ElementPtr& input) {
    return input->which();
  }

  static const std::string& blob_uuid(const ::blink::mojom::ElementPtr& input) {
    return input->get_blob_uuid();
  }

  static const std::vector<uint8_t>& bytes(const ::blink::mojom::ElementPtr& input) {
    return input->get_bytes();
  }

  static const ::blink::mojom::FilePtr& file(const ::blink::mojom::ElementPtr& input) {
    return input->get_file();
  }

  static const ::blink::mojom::DEPRECATED_FileSystemFilePtr& DEPRECATED_file_system_file(const ::blink::mojom::ElementPtr& input) {
    return input->get_DEPRECATED_file_system_file();
  }

  static bool Read(::blink::mojom::Element::DataView input, ::blink::mojom::ElementPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_H_