// third_party/blink/public/mojom/input/input_handler.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-blink-forward.h"
#include "cc/mojom/overscroll_behavior.mojom-blink.h"
#include "cc/mojom/touch_action.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "third_party/blink/public/mojom/input/gesture_event.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-blink.h"
#include "third_party/blink/public/mojom/input/pointer_lock_result.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-blink.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/selection_menu/selection_menu_behavior.mojom-blink-forward.h"
#include "ui/base/ime/mojom/ime_types.mojom-blink.h"
#include "ui/events/mojom/event.mojom-blink.h"
#include "ui/events/mojom/event_constants.mojom-blink.h"
#include "ui/events/mojom/scroll_granularity.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/range/mojom/range.mojom-blink.h"
#include "ui/latency/mojom/latency_info.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/common/input/web_coalesced_input_event_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class WidgetInputHandlerHostProxy;

template <typename ImplRefTraits>
class WidgetInputHandlerHostStub;

class WidgetInputHandlerHostRequestValidator;
class WidgetInputHandlerHostResponseValidator;


class PLATFORM_EXPORT WidgetInputHandlerHost
    : public WidgetInputHandlerHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WidgetInputHandlerHostInterfaceBase;
  using Proxy_ = WidgetInputHandlerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = WidgetInputHandlerHostStub<ImplRefTraits>;

  using RequestValidator_ = WidgetInputHandlerHostRequestValidator;
  using ResponseValidator_ = WidgetInputHandlerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetTouchActionFromMainMinVersion = 0,
    kDidOverscrollMinVersion = 0,
    kDidStartScrollingViewportMinVersion = 0,
    kImeCancelCompositionMinVersion = 0,
    kImeCompositionRangeChangedMinVersion = 0,
    kSetMouseCaptureMinVersion = 0,
    kRequestMouseLockMinVersion = 0,
  };
  virtual ~WidgetInputHandlerHost() {}

  
  virtual void SetTouchActionFromMain(::cc::TouchAction touch_action) = 0;

  
  virtual void DidOverscroll(DidOverscrollParamsPtr params) = 0;

  
  virtual void DidStartScrollingViewport() = 0;

  
  virtual void ImeCancelComposition() = 0;

  
  virtual void ImeCompositionRangeChanged(const ::gfx::Range& range, const WTF::Vector<::gfx::Rect>& bounds) = 0;

  
  virtual void SetMouseCapture(bool capture) = 0;


  using RequestMouseLockCallback = base::OnceCallback<void(::blink::mojom::blink::PointerLockResult, ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext>)>;
  
  virtual void RequestMouseLock(bool from_user_gesture, bool privileged, bool unadjusted_movement, RequestMouseLockCallback callback) = 0;
};

class FrameWidgetInputHandlerProxy;

template <typename ImplRefTraits>
class FrameWidgetInputHandlerStub;

class FrameWidgetInputHandlerRequestValidator;


class PLATFORM_EXPORT FrameWidgetInputHandler
    : public FrameWidgetInputHandlerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameWidgetInputHandlerInterfaceBase;
  using Proxy_ = FrameWidgetInputHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameWidgetInputHandlerStub<ImplRefTraits>;

  using RequestValidator_ = FrameWidgetInputHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddImeTextSpansToExistingTextMinVersion = 0,
    kClearImeTextSpansByTypeMinVersion = 0,
    kSetCompositionFromExistingTextMinVersion = 0,
    kExtendSelectionAndDeleteMinVersion = 0,
    kDeleteSurroundingTextMinVersion = 0,
    kDeleteSurroundingTextInCodePointsMinVersion = 0,
    kSetEditableSelectionOffsetsMinVersion = 0,
    kExecuteEditCommandMinVersion = 0,
    kUndoMinVersion = 0,
    kRedoMinVersion = 0,
    kCutMinVersion = 0,
    kCopyMinVersion = 0,
    kCopyToFindPboardMinVersion = 0,
    kPasteMinVersion = 0,
    kPasteAndMatchStyleMinVersion = 0,
    kDeleteMinVersion = 0,
    kSelectAllMinVersion = 0,
    kCollapseSelectionMinVersion = 0,
    kReplaceMinVersion = 0,
    kReplaceMisspellingMinVersion = 0,
    kSelectRangeMinVersion = 0,
    kAdjustSelectionByCharacterOffsetMinVersion = 0,
    kMoveRangeSelectionExtentMinVersion = 0,
    kScrollFocusedEditableNodeIntoRectMinVersion = 0,
    kMoveCaretMinVersion = 0,
  };
  virtual ~FrameWidgetInputHandler() {}

  
  virtual void AddImeTextSpansToExistingText(uint32_t start, uint32_t end, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans) = 0;

  
  virtual void ClearImeTextSpansByType(uint32_t start, uint32_t end, ::ui::ImeTextSpan::Type type) = 0;

  
  virtual void SetCompositionFromExistingText(int32_t start, int32_t end, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans) = 0;

  
  virtual void ExtendSelectionAndDelete(int32_t before, int32_t after) = 0;

  
  virtual void DeleteSurroundingText(int32_t before, int32_t after) = 0;

  
  virtual void DeleteSurroundingTextInCodePoints(int32_t before, int32_t after) = 0;

  
  virtual void SetEditableSelectionOffsets(int32_t start, int32_t end) = 0;

  
  virtual void ExecuteEditCommand(const WTF::String& command, const ::WTF::String& value) = 0;

  
  virtual void Undo() = 0;

  
  virtual void Redo() = 0;

  
  virtual void Cut() = 0;

  
  virtual void Copy() = 0;

  
  virtual void CopyToFindPboard() = 0;

  
  virtual void Paste() = 0;

  
  virtual void PasteAndMatchStyle() = 0;

  
  virtual void Delete() = 0;

  
  virtual void SelectAll() = 0;

  
  virtual void CollapseSelection() = 0;

  
  virtual void Replace(const ::WTF::String& word) = 0;

  
  virtual void ReplaceMisspelling(const ::WTF::String& word) = 0;

  
  virtual void SelectRange(const ::gfx::Point& base, const ::gfx::Point& extent) = 0;

  
  virtual void AdjustSelectionByCharacterOffset(int32_t start, int32_t end, ::blink::mojom::blink::SelectionMenuBehavior behavior) = 0;

  
  virtual void MoveRangeSelectionExtent(const ::gfx::Point& extent) = 0;

  
  virtual void ScrollFocusedEditableNodeIntoRect(const ::gfx::Rect& rect) = 0;

  
  virtual void MoveCaret(const ::gfx::Point& point) = 0;
};

class WidgetInputHandlerProxy;

template <typename ImplRefTraits>
class WidgetInputHandlerStub;

class WidgetInputHandlerRequestValidator;
class WidgetInputHandlerResponseValidator;


class PLATFORM_EXPORT WidgetInputHandler
    : public WidgetInputHandlerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WidgetInputHandlerInterfaceBase;
  using Proxy_ = WidgetInputHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WidgetInputHandlerStub<ImplRefTraits>;

  using RequestValidator_ = WidgetInputHandlerRequestValidator;
  using ResponseValidator_ = WidgetInputHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetFocusMinVersion = 0,
    kMouseCaptureLostMinVersion = 0,
    kSetEditCommandsForNextKeyEventMinVersion = 0,
    kCursorVisibilityChangedMinVersion = 0,
    kImeSetCompositionMinVersion = 0,
    kImeCommitTextMinVersion = 0,
    kImeFinishComposingTextMinVersion = 0,
    kRequestTextInputStateUpdateMinVersion = 0,
    kRequestCompositionUpdatesMinVersion = 0,
    kDispatchEventMinVersion = 0,
    kDispatchNonBlockingEventMinVersion = 0,
    kWaitForInputProcessedMinVersion = 0,
    kAttachSynchronousCompositorMinVersion = 0,
    kGetFrameWidgetInputHandlerMinVersion = 0,
  };
  virtual ~WidgetInputHandler() {}

  
  virtual void SetFocus(bool focused) = 0;

  
  virtual void MouseCaptureLost() = 0;

  
  virtual void SetEditCommandsForNextKeyEvent(WTF::Vector<EditCommandPtr> commands) = 0;

  
  virtual void CursorVisibilityChanged(bool visible) = 0;

  
  virtual void ImeSetComposition(const ::WTF::String& text, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t start, int32_t end) = 0;


  using ImeCommitTextCallback = base::OnceCallback<void()>;
  
  virtual void ImeCommitText(const ::WTF::String& text, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t relative_cursor_position, ImeCommitTextCallback callback) = 0;

  
  virtual void ImeFinishComposingText(bool keep_selection) = 0;

  
  virtual void RequestTextInputStateUpdate() = 0;

  
  virtual void RequestCompositionUpdates(bool immediate_request, bool monitor_request) = 0;


  using DispatchEventCallback = base::OnceCallback<void(::blink::mojom::blink::InputEventResultSource, const ::ui::LatencyInfo&, ::blink::mojom::blink::InputEventResultState, DidOverscrollParamsPtr, TouchActionOptionalPtr)>;
  
  virtual void DispatchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, DispatchEventCallback callback) = 0;

  
  virtual void DispatchNonBlockingEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) = 0;


  using WaitForInputProcessedCallback = base::OnceCallback<void()>;
  
  virtual void WaitForInputProcessed(WaitForInputProcessedCallback callback) = 0;

  
  virtual void AttachSynchronousCompositor(::mojo::PendingRemote<::blink::mojom::blink::SynchronousCompositorControlHost> control_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::SynchronousCompositorHost> host, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::SynchronousCompositor> compositor_request) = 0;

  
  virtual void GetFrameWidgetInputHandler(::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> interface_request) = 0;
};



class PLATFORM_EXPORT WidgetInputHandlerHostProxy
    : public WidgetInputHandlerHost {
 public:
  using InterfaceType = WidgetInputHandlerHost;

  explicit WidgetInputHandlerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetTouchActionFromMain(::cc::TouchAction touch_action) final;
  
  void DidOverscroll(DidOverscrollParamsPtr params) final;
  
  void DidStartScrollingViewport() final;
  
  void ImeCancelComposition() final;
  
  void ImeCompositionRangeChanged(const ::gfx::Range& range, const WTF::Vector<::gfx::Rect>& bounds) final;
  
  void SetMouseCapture(bool capture) final;
  
  void RequestMouseLock(bool from_user_gesture, bool privileged, bool unadjusted_movement, RequestMouseLockCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT FrameWidgetInputHandlerProxy
    : public FrameWidgetInputHandler {
 public:
  using InterfaceType = FrameWidgetInputHandler;

  explicit FrameWidgetInputHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddImeTextSpansToExistingText(uint32_t start, uint32_t end, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans) final;
  
  void ClearImeTextSpansByType(uint32_t start, uint32_t end, ::ui::ImeTextSpan::Type type) final;
  
  void SetCompositionFromExistingText(int32_t start, int32_t end, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans) final;
  
  void ExtendSelectionAndDelete(int32_t before, int32_t after) final;
  
  void DeleteSurroundingText(int32_t before, int32_t after) final;
  
  void DeleteSurroundingTextInCodePoints(int32_t before, int32_t after) final;
  
  void SetEditableSelectionOffsets(int32_t start, int32_t end) final;
  
  void ExecuteEditCommand(const WTF::String& command, const ::WTF::String& value) final;
  
  void Undo() final;
  
  void Redo() final;
  
  void Cut() final;
  
  void Copy() final;
  
  void CopyToFindPboard() final;
  
  void Paste() final;
  
  void PasteAndMatchStyle() final;
  
  void Delete() final;
  
  void SelectAll() final;
  
  void CollapseSelection() final;
  
  void Replace(const ::WTF::String& word) final;
  
  void ReplaceMisspelling(const ::WTF::String& word) final;
  
  void SelectRange(const ::gfx::Point& base, const ::gfx::Point& extent) final;
  
  void AdjustSelectionByCharacterOffset(int32_t start, int32_t end, ::blink::mojom::blink::SelectionMenuBehavior behavior) final;
  
  void MoveRangeSelectionExtent(const ::gfx::Point& extent) final;
  
  void ScrollFocusedEditableNodeIntoRect(const ::gfx::Rect& rect) final;
  
  void MoveCaret(const ::gfx::Point& point) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT WidgetInputHandlerProxy
    : public WidgetInputHandler {
 public:
  using InterfaceType = WidgetInputHandler;

  explicit WidgetInputHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetFocus(bool focused) final;
  
  void MouseCaptureLost() final;
  
  void SetEditCommandsForNextKeyEvent(WTF::Vector<EditCommandPtr> commands) final;
  
  void CursorVisibilityChanged(bool visible) final;
  
  void ImeSetComposition(const ::WTF::String& text, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t start, int32_t end) final;
  
  void ImeCommitText(const ::WTF::String& text, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t relative_cursor_position, ImeCommitTextCallback callback) final;
  
  void ImeFinishComposingText(bool keep_selection) final;
  
  void RequestTextInputStateUpdate() final;
  
  void RequestCompositionUpdates(bool immediate_request, bool monitor_request) final;
  
  void DispatchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, DispatchEventCallback callback) final;
  
  void DispatchNonBlockingEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) final;
  
  void WaitForInputProcessed(WaitForInputProcessedCallback callback) final;
  
  void AttachSynchronousCompositor(::mojo::PendingRemote<::blink::mojom::blink::SynchronousCompositorControlHost> control_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::SynchronousCompositorHost> host, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::SynchronousCompositor> compositor_request) final;
  
  void GetFrameWidgetInputHandler(::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> interface_request) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT WidgetInputHandlerHostStubDispatch {
 public:
  static bool Accept(WidgetInputHandlerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WidgetInputHandlerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WidgetInputHandlerHost>>
class WidgetInputHandlerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WidgetInputHandlerHostStub() {}
  ~WidgetInputHandlerHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetInputHandlerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetInputHandlerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FrameWidgetInputHandlerStubDispatch {
 public:
  static bool Accept(FrameWidgetInputHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameWidgetInputHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameWidgetInputHandler>>
class FrameWidgetInputHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameWidgetInputHandlerStub() {}
  ~FrameWidgetInputHandlerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetInputHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetInputHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT WidgetInputHandlerStubDispatch {
 public:
  static bool Accept(WidgetInputHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WidgetInputHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WidgetInputHandler>>
class WidgetInputHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WidgetInputHandlerStub() {}
  ~WidgetInputHandlerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetInputHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetInputHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT WidgetInputHandlerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FrameWidgetInputHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WidgetInputHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WidgetInputHandlerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WidgetInputHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class PLATFORM_EXPORT ScrollUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollUpdate, T>::value>;
  using DataView = ScrollUpdateDataView;
  using Data_ = internal::ScrollUpdate_Data;

  template <typename... Args>
  static ScrollUpdatePtr New(Args&&... args) {
    return ScrollUpdatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollUpdatePtr From(const U& u) {
    return mojo::TypeConverter<ScrollUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollUpdate>::Convert(*this);
  }


  ScrollUpdate();

  ScrollUpdate(
      float velocity_x,
      float velocity_y);

  ~ScrollUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollUpdatePtr>
  ScrollUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollUpdate::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollUpdate_UnserializedMessageContext<
            UserType, ScrollUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ScrollUpdate::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ScrollUpdate::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollUpdate_UnserializedMessageContext<
            UserType, ScrollUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollUpdate::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float velocity_x;
  
  float velocity_y;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT PinchBeginData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinchBeginData, T>::value>;
  using DataView = PinchBeginDataDataView;
  using Data_ = internal::PinchBeginData_Data;

  template <typename... Args>
  static PinchBeginDataPtr New(Args&&... args) {
    return PinchBeginDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinchBeginDataPtr From(const U& u) {
    return mojo::TypeConverter<PinchBeginDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinchBeginData>::Convert(*this);
  }


  PinchBeginData();

  explicit PinchBeginData(
      bool needs_wheel_event);

  ~PinchBeginData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinchBeginDataPtr>
  PinchBeginDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinchBeginData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinchBeginData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinchBeginData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinchBeginData_UnserializedMessageContext<
            UserType, PinchBeginData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PinchBeginData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PinchBeginData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinchBeginData_UnserializedMessageContext<
            UserType, PinchBeginData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinchBeginData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool needs_wheel_event;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinchBeginData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinchBeginData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinchBeginData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinchBeginData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PinchUpdateData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinchUpdateData, T>::value>;
  using DataView = PinchUpdateDataDataView;
  using Data_ = internal::PinchUpdateData_Data;

  template <typename... Args>
  static PinchUpdateDataPtr New(Args&&... args) {
    return PinchUpdateDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinchUpdateDataPtr From(const U& u) {
    return mojo::TypeConverter<PinchUpdateDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinchUpdateData>::Convert(*this);
  }


  PinchUpdateData();

  PinchUpdateData(
      float scale,
      bool zoom_disabled,
      bool needs_wheel_event);

  ~PinchUpdateData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinchUpdateDataPtr>
  PinchUpdateDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinchUpdateData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinchUpdateData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinchUpdateData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinchUpdateData_UnserializedMessageContext<
            UserType, PinchUpdateData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PinchUpdateData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PinchUpdateData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinchUpdateData_UnserializedMessageContext<
            UserType, PinchUpdateData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinchUpdateData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float scale;
  
  bool zoom_disabled;
  
  bool needs_wheel_event;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinchUpdateData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinchUpdateData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinchUpdateData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinchUpdateData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PinchEndData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinchEndData, T>::value>;
  using DataView = PinchEndDataDataView;
  using Data_ = internal::PinchEndData_Data;

  template <typename... Args>
  static PinchEndDataPtr New(Args&&... args) {
    return PinchEndDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinchEndDataPtr From(const U& u) {
    return mojo::TypeConverter<PinchEndDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinchEndData>::Convert(*this);
  }


  PinchEndData();

  explicit PinchEndData(
      bool needs_wheel_event);

  ~PinchEndData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinchEndDataPtr>
  PinchEndDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinchEndData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinchEndData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinchEndData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinchEndData_UnserializedMessageContext<
            UserType, PinchEndData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PinchEndData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PinchEndData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinchEndData_UnserializedMessageContext<
            UserType, PinchEndData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinchEndData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool needs_wheel_event;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinchEndData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinchEndData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinchEndData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinchEndData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FlingData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FlingData, T>::value>;
  using DataView = FlingDataDataView;
  using Data_ = internal::FlingData_Data;

  template <typename... Args>
  static FlingDataPtr New(Args&&... args) {
    return FlingDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FlingDataPtr From(const U& u) {
    return mojo::TypeConverter<FlingDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FlingData>::Convert(*this);
  }


  FlingData();

  FlingData(
      float velocity_x,
      float velocity_y,
      bool target_viewport,
      bool prevent_boosting);

  ~FlingData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FlingDataPtr>
  FlingDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FlingData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FlingData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FlingData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FlingData_UnserializedMessageContext<
            UserType, FlingData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FlingData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return FlingData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FlingData_UnserializedMessageContext<
            UserType, FlingData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FlingData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float velocity_x;
  
  float velocity_y;
  
  bool target_viewport;
  
  bool prevent_boosting;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FlingData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FlingData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FlingData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FlingData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT TapData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TapData, T>::value>;
  using DataView = TapDataDataView;
  using Data_ = internal::TapData_Data;

  template <typename... Args>
  static TapDataPtr New(Args&&... args) {
    return TapDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TapDataPtr From(const U& u) {
    return mojo::TypeConverter<TapDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TapData>::Convert(*this);
  }


  TapData();

  TapData(
      int32_t tap_count,
      bool needs_wheel_event);

  ~TapData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TapDataPtr>
  TapDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TapData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TapData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TapData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TapData_UnserializedMessageContext<
            UserType, TapData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TapData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TapData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TapData_UnserializedMessageContext<
            UserType, TapData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TapData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t tap_count;
  
  bool needs_wheel_event;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TapData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TapData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TapData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TapData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT TouchActionOptional {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TouchActionOptional, T>::value>;
  using DataView = TouchActionOptionalDataView;
  using Data_ = internal::TouchActionOptional_Data;

  template <typename... Args>
  static TouchActionOptionalPtr New(Args&&... args) {
    return TouchActionOptionalPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TouchActionOptionalPtr From(const U& u) {
    return mojo::TypeConverter<TouchActionOptionalPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TouchActionOptional>::Convert(*this);
  }


  TouchActionOptional();

  explicit TouchActionOptional(
      ::cc::TouchAction touch_action);

  ~TouchActionOptional();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TouchActionOptionalPtr>
  TouchActionOptionalPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TouchActionOptional::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchActionOptional::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TouchActionOptional::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TouchActionOptional_UnserializedMessageContext<
            UserType, TouchActionOptional::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TouchActionOptional::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TouchActionOptional::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TouchActionOptional_UnserializedMessageContext<
            UserType, TouchActionOptional::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TouchActionOptional::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::cc::TouchAction touch_action;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TouchActionOptional::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TouchActionOptional::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TouchActionOptional::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TouchActionOptional::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT EditCommand {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EditCommand, T>::value>;
  using DataView = EditCommandDataView;
  using Data_ = internal::EditCommand_Data;

  template <typename... Args>
  static EditCommandPtr New(Args&&... args) {
    return EditCommandPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EditCommandPtr From(const U& u) {
    return mojo::TypeConverter<EditCommandPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EditCommand>::Convert(*this);
  }


  EditCommand();

  EditCommand(
      const WTF::String& name,
      const WTF::String& value);

  ~EditCommand();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EditCommandPtr>
  EditCommandPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EditCommand::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EditCommand::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EditCommand::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EditCommand_UnserializedMessageContext<
            UserType, EditCommand::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<EditCommand::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return EditCommand::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EditCommand_UnserializedMessageContext<
            UserType, EditCommand::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EditCommand::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String name;
  
  WTF::String value;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EditCommand::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EditCommand::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EditCommand::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EditCommand::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT KeyData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<KeyData, T>::value>;
  using DataView = KeyDataDataView;
  using Data_ = internal::KeyData_Data;

  template <typename... Args>
  static KeyDataPtr New(Args&&... args) {
    return KeyDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KeyDataPtr From(const U& u) {
    return mojo::TypeConverter<KeyDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KeyData>::Convert(*this);
  }


  KeyData();

  KeyData(
      int32_t dom_key,
      int32_t dom_code,
      int32_t windows_key_code,
      int32_t native_key_code,
      bool is_system_key,
      bool is_browser_shortcut,
      const ::WTF::String& text,
      const ::WTF::String& unmodified_text);

  ~KeyData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KeyDataPtr>
  KeyDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, KeyData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KeyData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::KeyData_UnserializedMessageContext<
            UserType, KeyData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<KeyData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return KeyData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::KeyData_UnserializedMessageContext<
            UserType, KeyData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<KeyData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t dom_key;
  
  int32_t dom_code;
  
  int32_t windows_key_code;
  
  int32_t native_key_code;
  
  bool is_system_key;
  
  bool is_browser_shortcut;
  
  ::WTF::String text;
  
  ::WTF::String unmodified_text;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, KeyData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, KeyData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, KeyData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, KeyData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PointerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PointerData, T>::value>;
  using DataView = PointerDataDataView;
  using Data_ = internal::PointerData_Data;

  template <typename... Args>
  static PointerDataPtr New(Args&&... args) {
    return PointerDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PointerDataPtr From(const U& u) {
    return mojo::TypeConverter<PointerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PointerData>::Convert(*this);
  }


  PointerData();

  PointerData(
      int32_t pointer_id,
      float force,
      int32_t tilt_x,
      int32_t tilt_y,
      float tangential_pressure,
      int32_t twist,
      ::blink::mojom::blink::Button button,
      ::ui::EventPointerType pointer_type,
      int32_t movement_x,
      int32_t movement_y,
      bool is_raw_movement_event,
      const ::gfx::PointF& widget_position,
      const ::gfx::PointF& screen_position,
      MouseDataPtr mouse_data);

  ~PointerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PointerDataPtr>
  PointerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PointerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PointerData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PointerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PointerData_UnserializedMessageContext<
            UserType, PointerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PointerData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PointerData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PointerData_UnserializedMessageContext<
            UserType, PointerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PointerData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t pointer_id;
  
  float force;
  
  int32_t tilt_x;
  
  int32_t tilt_y;
  
  float tangential_pressure;
  
  int32_t twist;
  
  ::blink::mojom::blink::Button button;
  
  ::ui::EventPointerType pointer_type;
  
  int32_t movement_x;
  
  int32_t movement_y;
  
  bool is_raw_movement_event;
  
  ::gfx::PointF widget_position;
  
  ::gfx::PointF screen_position;
  
  MouseDataPtr mouse_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PointerData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PointerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PointerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PointerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PointerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT WheelData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WheelData, T>::value>;
  using DataView = WheelDataDataView;
  using Data_ = internal::WheelData_Data;

  template <typename... Args>
  static WheelDataPtr New(Args&&... args) {
    return WheelDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WheelDataPtr From(const U& u) {
    return mojo::TypeConverter<WheelDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WheelData>::Convert(*this);
  }


  WheelData();

  WheelData(
      float delta_x,
      float delta_y,
      float wheel_ticks_x,
      float wheel_ticks_y,
      float acceleration_ratio_x,
      float acceleration_ratio_y,
      uint8_t phase,
      uint8_t momentum_phase,
      ::blink::mojom::blink::DispatchType cancelable,
      uint8_t event_action,
      uint8_t delta_units);

  ~WheelData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WheelDataPtr>
  WheelDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WheelData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WheelData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WheelData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WheelData_UnserializedMessageContext<
            UserType, WheelData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WheelData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WheelData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WheelData_UnserializedMessageContext<
            UserType, WheelData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WheelData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float delta_x;
  
  float delta_y;
  
  float wheel_ticks_x;
  
  float wheel_ticks_y;
  
  float acceleration_ratio_x;
  
  float acceleration_ratio_y;
  
  uint8_t phase;
  
  uint8_t momentum_phase;
  
  ::blink::mojom::blink::DispatchType cancelable;
  
  uint8_t event_action;
  
  uint8_t delta_units;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WheelData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WheelData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WheelData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WheelData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT MouseData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MouseData, T>::value>;
  using DataView = MouseDataDataView;
  using Data_ = internal::MouseData_Data;

  template <typename... Args>
  static MouseDataPtr New(Args&&... args) {
    return MouseDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MouseDataPtr From(const U& u) {
    return mojo::TypeConverter<MouseDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MouseData>::Convert(*this);
  }


  MouseData();

  MouseData(
      int32_t click_count,
      WheelDataPtr wheel_data);

  ~MouseData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MouseDataPtr>
  MouseDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MouseData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MouseData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MouseData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MouseData_UnserializedMessageContext<
            UserType, MouseData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MouseData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return MouseData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MouseData_UnserializedMessageContext<
            UserType, MouseData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MouseData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t click_count;
  
  WheelDataPtr wheel_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(MouseData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MouseData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MouseData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MouseData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MouseData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT ScrollData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollData, T>::value>;
  using DataView = ScrollDataDataView;
  using Data_ = internal::ScrollData_Data;

  template <typename... Args>
  static ScrollDataPtr New(Args&&... args) {
    return ScrollDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollDataPtr From(const U& u) {
    return mojo::TypeConverter<ScrollDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollData>::Convert(*this);
  }


  ScrollData();

  ScrollData(
      float delta_x,
      float delta_y,
      ::ui::ScrollGranularity delta_units,
      bool target_viewport,
      ::blink::mojom::blink::InertialPhaseState inertial_phase,
      bool synthetic,
      int32_t pointer_count,
      ScrollUpdatePtr update_details);

  ~ScrollData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollDataPtr>
  ScrollDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollData_UnserializedMessageContext<
            UserType, ScrollData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ScrollData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ScrollData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollData_UnserializedMessageContext<
            UserType, ScrollData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float delta_x;
  
  float delta_y;
  
  ::ui::ScrollGranularity delta_units;
  
  bool target_viewport;
  
  ::blink::mojom::blink::InertialPhaseState inertial_phase;
  
  bool synthetic;
  
  int32_t pointer_count;
  
  ScrollUpdatePtr update_details;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ScrollData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT GestureData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GestureData, T>::value>;
  using DataView = GestureDataDataView;
  using Data_ = internal::GestureData_Data;

  template <typename... Args>
  static GestureDataPtr New(Args&&... args) {
    return GestureDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GestureDataPtr From(const U& u) {
    return mojo::TypeConverter<GestureDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GestureData>::Convert(*this);
  }


  GestureData();

  GestureData(
      const ::gfx::PointF& screen_position,
      const ::gfx::PointF& widget_position,
      ::blink::mojom::blink::GestureDevice source_device,
      bool is_source_touch_event_set_non_blocking,
      ::ui::EventPointerType primary_pointer_type,
      int32_t unique_touch_event_id,
      const base::Optional<::gfx::Size>& contact_size,
      ScrollDataPtr scroll_data,
      PinchBeginDataPtr pinch_begin_data,
      PinchUpdateDataPtr pinch_update_data,
      PinchEndDataPtr pinch_end_data,
      TapDataPtr tap_data,
      FlingDataPtr fling_data);

  ~GestureData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GestureDataPtr>
  GestureDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GestureData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GestureData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GestureData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GestureData_UnserializedMessageContext<
            UserType, GestureData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<GestureData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return GestureData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GestureData_UnserializedMessageContext<
            UserType, GestureData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GestureData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::PointF screen_position;
  
  ::gfx::PointF widget_position;
  
  ::blink::mojom::blink::GestureDevice source_device;
  
  bool is_source_touch_event_set_non_blocking;
  
  ::ui::EventPointerType primary_pointer_type;
  
  int32_t unique_touch_event_id;
  
  base::Optional<::gfx::Size> contact_size;
  
  ScrollDataPtr scroll_data;
  
  PinchBeginDataPtr pinch_begin_data;
  
  PinchUpdateDataPtr pinch_update_data;
  
  PinchEndDataPtr pinch_end_data;
  
  TapDataPtr tap_data;
  
  FlingDataPtr fling_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(GestureData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GestureData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GestureData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GestureData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GestureData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT TouchPoint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TouchPoint, T>::value>;
  using DataView = TouchPointDataView;
  using Data_ = internal::TouchPoint_Data;

  template <typename... Args>
  static TouchPointPtr New(Args&&... args) {
    return TouchPointPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TouchPointPtr From(const U& u) {
    return mojo::TypeConverter<TouchPointPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TouchPoint>::Convert(*this);
  }


  TouchPoint();

  TouchPoint(
      ::blink::mojom::blink::TouchState state,
      float radius_x,
      float radius_y,
      float rotation_angle,
      PointerDataPtr pointer_data);

  ~TouchPoint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TouchPointPtr>
  TouchPointPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TouchPoint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchPoint::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TouchPoint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TouchPoint_UnserializedMessageContext<
            UserType, TouchPoint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TouchPoint::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TouchPoint::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TouchPoint_UnserializedMessageContext<
            UserType, TouchPoint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TouchPoint::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::mojom::blink::TouchState state;
  
  float radius_x;
  
  float radius_y;
  
  float rotation_angle;
  
  PointerDataPtr pointer_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(TouchPoint);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TouchPoint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TouchPoint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TouchPoint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TouchPoint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT TouchData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TouchData, T>::value>;
  using DataView = TouchDataDataView;
  using Data_ = internal::TouchData_Data;

  template <typename... Args>
  static TouchDataPtr New(Args&&... args) {
    return TouchDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TouchDataPtr From(const U& u) {
    return mojo::TypeConverter<TouchDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TouchData>::Convert(*this);
  }


  TouchData();

  TouchData(
      ::blink::mojom::blink::DispatchType cancelable,
      bool moved_beyond_slop_region,
      bool touch_start_or_first_move,
      bool hovering,
      uint32_t unique_touch_event_id,
      WTF::Vector<TouchPointPtr> touches);

  ~TouchData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TouchDataPtr>
  TouchDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TouchData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TouchData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TouchData_UnserializedMessageContext<
            UserType, TouchData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TouchData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TouchData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TouchData_UnserializedMessageContext<
            UserType, TouchData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TouchData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::mojom::blink::DispatchType cancelable;
  
  bool moved_beyond_slop_region;
  
  bool touch_start_or_first_move;
  
  bool hovering;
  
  uint32_t unique_touch_event_id;
  
  WTF::Vector<TouchPointPtr> touches;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(TouchData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TouchData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TouchData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TouchData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TouchData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT Event {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Event, T>::value>;
  using DataView = EventDataView;
  using Data_ = internal::Event_Data;

  template <typename... Args>
  static EventPtr New(Args&&... args) {
    return EventPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventPtr From(const U& u) {
    return mojo::TypeConverter<EventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Event>::Convert(*this);
  }


  Event();

  Event(
      ::blink::mojom::blink::EventType type,
      int32_t modifiers,
      ::base::TimeTicks timestamp,
      const ::ui::LatencyInfo& latency,
      KeyDataPtr key_data,
      PointerDataPtr pointer_data,
      GestureDataPtr gesture_data,
      TouchDataPtr touch_data);

  ~Event();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventPtr>
  EventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Event::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Event::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Event::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Event_UnserializedMessageContext<
            UserType, Event::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Event::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return Event::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Event_UnserializedMessageContext<
            UserType, Event::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Event::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::mojom::blink::EventType type;
  
  int32_t modifiers;
  
  ::base::TimeTicks timestamp;
  
  ::ui::LatencyInfo latency;
  
  KeyDataPtr key_data;
  
  PointerDataPtr pointer_data;
  
  GestureDataPtr gesture_data;
  
  TouchDataPtr touch_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(Event);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DidOverscrollParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidOverscrollParams, T>::value>;
  using DataView = DidOverscrollParamsDataView;
  using Data_ = internal::DidOverscrollParams_Data;

  template <typename... Args>
  static DidOverscrollParamsPtr New(Args&&... args) {
    return DidOverscrollParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidOverscrollParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidOverscrollParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidOverscrollParams>::Convert(*this);
  }


  DidOverscrollParams();

  DidOverscrollParams(
      const ::gfx::Vector2dF& accumulated_overscroll,
      const ::gfx::Vector2dF& latest_overscroll_delta,
      const ::gfx::Vector2dF& current_fling_velocity,
      const ::gfx::PointF& causal_event_viewport_point,
      const ::cc::OverscrollBehavior& overscroll_behavior);

  ~DidOverscrollParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidOverscrollParamsPtr>
  DidOverscrollParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidOverscrollParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidOverscrollParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidOverscrollParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidOverscrollParams_UnserializedMessageContext<
            UserType, DidOverscrollParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DidOverscrollParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DidOverscrollParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidOverscrollParams_UnserializedMessageContext<
            UserType, DidOverscrollParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidOverscrollParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Vector2dF accumulated_overscroll;
  
  ::gfx::Vector2dF latest_overscroll_delta;
  
  ::gfx::Vector2dF current_fling_velocity;
  
  ::gfx::PointF causal_event_viewport_point;
  
  ::cc::OverscrollBehavior overscroll_behavior;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidOverscrollParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidOverscrollParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidOverscrollParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidOverscrollParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}



template <typename StructPtrType>
KeyDataPtr KeyData::Clone() const {
  return New(
      mojo::Clone(dom_key),
      mojo::Clone(dom_code),
      mojo::Clone(windows_key_code),
      mojo::Clone(native_key_code),
      mojo::Clone(is_system_key),
      mojo::Clone(is_browser_shortcut),
      mojo::Clone(text),
      mojo::Clone(unmodified_text)
  );
}

template <typename T, KeyData::EnableIfSame<T>*>
bool KeyData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dom_key, other_struct.dom_key))
    return false;
  if (!mojo::Equals(this->dom_code, other_struct.dom_code))
    return false;
  if (!mojo::Equals(this->windows_key_code, other_struct.windows_key_code))
    return false;
  if (!mojo::Equals(this->native_key_code, other_struct.native_key_code))
    return false;
  if (!mojo::Equals(this->is_system_key, other_struct.is_system_key))
    return false;
  if (!mojo::Equals(this->is_browser_shortcut, other_struct.is_browser_shortcut))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->unmodified_text, other_struct.unmodified_text))
    return false;
  return true;
}

template <typename T, KeyData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.dom_key, rhs.dom_key))
    return true;
  if (std::less<>{}(rhs.dom_key, lhs.dom_key))
    return false;
  if (std::less<>{}(lhs.dom_code, rhs.dom_code))
    return true;
  if (std::less<>{}(rhs.dom_code, lhs.dom_code))
    return false;
  if (std::less<>{}(lhs.windows_key_code, rhs.windows_key_code))
    return true;
  if (std::less<>{}(rhs.windows_key_code, lhs.windows_key_code))
    return false;
  if (std::less<>{}(lhs.native_key_code, rhs.native_key_code))
    return true;
  if (std::less<>{}(rhs.native_key_code, lhs.native_key_code))
    return false;
  if (std::less<>{}(lhs.is_system_key, rhs.is_system_key))
    return true;
  if (std::less<>{}(rhs.is_system_key, lhs.is_system_key))
    return false;
  if (std::less<>{}(lhs.is_browser_shortcut, rhs.is_browser_shortcut))
    return true;
  if (std::less<>{}(rhs.is_browser_shortcut, lhs.is_browser_shortcut))
    return false;
  if (std::less<>{}(lhs.text, rhs.text))
    return true;
  if (std::less<>{}(rhs.text, lhs.text))
    return false;
  if (std::less<>{}(lhs.unmodified_text, rhs.unmodified_text))
    return true;
  if (std::less<>{}(rhs.unmodified_text, lhs.unmodified_text))
    return false;
  return false;
}
template <typename StructPtrType>
PointerDataPtr PointerData::Clone() const {
  return New(
      mojo::Clone(pointer_id),
      mojo::Clone(force),
      mojo::Clone(tilt_x),
      mojo::Clone(tilt_y),
      mojo::Clone(tangential_pressure),
      mojo::Clone(twist),
      mojo::Clone(button),
      mojo::Clone(pointer_type),
      mojo::Clone(movement_x),
      mojo::Clone(movement_y),
      mojo::Clone(is_raw_movement_event),
      mojo::Clone(widget_position),
      mojo::Clone(screen_position),
      mojo::Clone(mouse_data)
  );
}

template <typename T, PointerData::EnableIfSame<T>*>
bool PointerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pointer_id, other_struct.pointer_id))
    return false;
  if (!mojo::Equals(this->force, other_struct.force))
    return false;
  if (!mojo::Equals(this->tilt_x, other_struct.tilt_x))
    return false;
  if (!mojo::Equals(this->tilt_y, other_struct.tilt_y))
    return false;
  if (!mojo::Equals(this->tangential_pressure, other_struct.tangential_pressure))
    return false;
  if (!mojo::Equals(this->twist, other_struct.twist))
    return false;
  if (!mojo::Equals(this->button, other_struct.button))
    return false;
  if (!mojo::Equals(this->pointer_type, other_struct.pointer_type))
    return false;
  if (!mojo::Equals(this->movement_x, other_struct.movement_x))
    return false;
  if (!mojo::Equals(this->movement_y, other_struct.movement_y))
    return false;
  if (!mojo::Equals(this->is_raw_movement_event, other_struct.is_raw_movement_event))
    return false;
  if (!mojo::Equals(this->widget_position, other_struct.widget_position))
    return false;
  if (!mojo::Equals(this->screen_position, other_struct.screen_position))
    return false;
  if (!mojo::Equals(this->mouse_data, other_struct.mouse_data))
    return false;
  return true;
}

template <typename T, PointerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.pointer_id, rhs.pointer_id))
    return true;
  if (std::less<>{}(rhs.pointer_id, lhs.pointer_id))
    return false;
  if (std::less<>{}(lhs.force, rhs.force))
    return true;
  if (std::less<>{}(rhs.force, lhs.force))
    return false;
  if (std::less<>{}(lhs.tilt_x, rhs.tilt_x))
    return true;
  if (std::less<>{}(rhs.tilt_x, lhs.tilt_x))
    return false;
  if (std::less<>{}(lhs.tilt_y, rhs.tilt_y))
    return true;
  if (std::less<>{}(rhs.tilt_y, lhs.tilt_y))
    return false;
  if (std::less<>{}(lhs.tangential_pressure, rhs.tangential_pressure))
    return true;
  if (std::less<>{}(rhs.tangential_pressure, lhs.tangential_pressure))
    return false;
  if (std::less<>{}(lhs.twist, rhs.twist))
    return true;
  if (std::less<>{}(rhs.twist, lhs.twist))
    return false;
  if (std::less<>{}(lhs.button, rhs.button))
    return true;
  if (std::less<>{}(rhs.button, lhs.button))
    return false;
  if (std::less<>{}(lhs.pointer_type, rhs.pointer_type))
    return true;
  if (std::less<>{}(rhs.pointer_type, lhs.pointer_type))
    return false;
  if (std::less<>{}(lhs.movement_x, rhs.movement_x))
    return true;
  if (std::less<>{}(rhs.movement_x, lhs.movement_x))
    return false;
  if (std::less<>{}(lhs.movement_y, rhs.movement_y))
    return true;
  if (std::less<>{}(rhs.movement_y, lhs.movement_y))
    return false;
  if (std::less<>{}(lhs.is_raw_movement_event, rhs.is_raw_movement_event))
    return true;
  if (std::less<>{}(rhs.is_raw_movement_event, lhs.is_raw_movement_event))
    return false;
  if (std::less<>{}(lhs.widget_position, rhs.widget_position))
    return true;
  if (std::less<>{}(rhs.widget_position, lhs.widget_position))
    return false;
  if (std::less<>{}(lhs.screen_position, rhs.screen_position))
    return true;
  if (std::less<>{}(rhs.screen_position, lhs.screen_position))
    return false;
  if (std::less<>{}(lhs.mouse_data, rhs.mouse_data))
    return true;
  if (std::less<>{}(rhs.mouse_data, lhs.mouse_data))
    return false;
  return false;
}
template <typename StructPtrType>
WheelDataPtr WheelData::Clone() const {
  return New(
      mojo::Clone(delta_x),
      mojo::Clone(delta_y),
      mojo::Clone(wheel_ticks_x),
      mojo::Clone(wheel_ticks_y),
      mojo::Clone(acceleration_ratio_x),
      mojo::Clone(acceleration_ratio_y),
      mojo::Clone(phase),
      mojo::Clone(momentum_phase),
      mojo::Clone(cancelable),
      mojo::Clone(event_action),
      mojo::Clone(delta_units)
  );
}

template <typename T, WheelData::EnableIfSame<T>*>
bool WheelData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->delta_x, other_struct.delta_x))
    return false;
  if (!mojo::Equals(this->delta_y, other_struct.delta_y))
    return false;
  if (!mojo::Equals(this->wheel_ticks_x, other_struct.wheel_ticks_x))
    return false;
  if (!mojo::Equals(this->wheel_ticks_y, other_struct.wheel_ticks_y))
    return false;
  if (!mojo::Equals(this->acceleration_ratio_x, other_struct.acceleration_ratio_x))
    return false;
  if (!mojo::Equals(this->acceleration_ratio_y, other_struct.acceleration_ratio_y))
    return false;
  if (!mojo::Equals(this->phase, other_struct.phase))
    return false;
  if (!mojo::Equals(this->momentum_phase, other_struct.momentum_phase))
    return false;
  if (!mojo::Equals(this->cancelable, other_struct.cancelable))
    return false;
  if (!mojo::Equals(this->event_action, other_struct.event_action))
    return false;
  if (!mojo::Equals(this->delta_units, other_struct.delta_units))
    return false;
  return true;
}

template <typename T, WheelData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.delta_x, rhs.delta_x))
    return true;
  if (std::less<>{}(rhs.delta_x, lhs.delta_x))
    return false;
  if (std::less<>{}(lhs.delta_y, rhs.delta_y))
    return true;
  if (std::less<>{}(rhs.delta_y, lhs.delta_y))
    return false;
  if (std::less<>{}(lhs.wheel_ticks_x, rhs.wheel_ticks_x))
    return true;
  if (std::less<>{}(rhs.wheel_ticks_x, lhs.wheel_ticks_x))
    return false;
  if (std::less<>{}(lhs.wheel_ticks_y, rhs.wheel_ticks_y))
    return true;
  if (std::less<>{}(rhs.wheel_ticks_y, lhs.wheel_ticks_y))
    return false;
  if (std::less<>{}(lhs.acceleration_ratio_x, rhs.acceleration_ratio_x))
    return true;
  if (std::less<>{}(rhs.acceleration_ratio_x, lhs.acceleration_ratio_x))
    return false;
  if (std::less<>{}(lhs.acceleration_ratio_y, rhs.acceleration_ratio_y))
    return true;
  if (std::less<>{}(rhs.acceleration_ratio_y, lhs.acceleration_ratio_y))
    return false;
  if (std::less<>{}(lhs.phase, rhs.phase))
    return true;
  if (std::less<>{}(rhs.phase, lhs.phase))
    return false;
  if (std::less<>{}(lhs.momentum_phase, rhs.momentum_phase))
    return true;
  if (std::less<>{}(rhs.momentum_phase, lhs.momentum_phase))
    return false;
  if (std::less<>{}(lhs.cancelable, rhs.cancelable))
    return true;
  if (std::less<>{}(rhs.cancelable, lhs.cancelable))
    return false;
  if (std::less<>{}(lhs.event_action, rhs.event_action))
    return true;
  if (std::less<>{}(rhs.event_action, lhs.event_action))
    return false;
  if (std::less<>{}(lhs.delta_units, rhs.delta_units))
    return true;
  if (std::less<>{}(rhs.delta_units, lhs.delta_units))
    return false;
  return false;
}
template <typename StructPtrType>
MouseDataPtr MouseData::Clone() const {
  return New(
      mojo::Clone(click_count),
      mojo::Clone(wheel_data)
  );
}

template <typename T, MouseData::EnableIfSame<T>*>
bool MouseData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->click_count, other_struct.click_count))
    return false;
  if (!mojo::Equals(this->wheel_data, other_struct.wheel_data))
    return false;
  return true;
}

template <typename T, MouseData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.click_count, rhs.click_count))
    return true;
  if (std::less<>{}(rhs.click_count, lhs.click_count))
    return false;
  if (std::less<>{}(lhs.wheel_data, rhs.wheel_data))
    return true;
  if (std::less<>{}(rhs.wheel_data, lhs.wheel_data))
    return false;
  return false;
}
template <typename StructPtrType>
ScrollUpdatePtr ScrollUpdate::Clone() const {
  return New(
      mojo::Clone(velocity_x),
      mojo::Clone(velocity_y)
  );
}

template <typename T, ScrollUpdate::EnableIfSame<T>*>
bool ScrollUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->velocity_x, other_struct.velocity_x))
    return false;
  if (!mojo::Equals(this->velocity_y, other_struct.velocity_y))
    return false;
  return true;
}

template <typename T, ScrollUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.velocity_x, rhs.velocity_x))
    return true;
  if (std::less<>{}(rhs.velocity_x, lhs.velocity_x))
    return false;
  if (std::less<>{}(lhs.velocity_y, rhs.velocity_y))
    return true;
  if (std::less<>{}(rhs.velocity_y, lhs.velocity_y))
    return false;
  return false;
}
template <typename StructPtrType>
ScrollDataPtr ScrollData::Clone() const {
  return New(
      mojo::Clone(delta_x),
      mojo::Clone(delta_y),
      mojo::Clone(delta_units),
      mojo::Clone(target_viewport),
      mojo::Clone(inertial_phase),
      mojo::Clone(synthetic),
      mojo::Clone(pointer_count),
      mojo::Clone(update_details)
  );
}

template <typename T, ScrollData::EnableIfSame<T>*>
bool ScrollData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->delta_x, other_struct.delta_x))
    return false;
  if (!mojo::Equals(this->delta_y, other_struct.delta_y))
    return false;
  if (!mojo::Equals(this->delta_units, other_struct.delta_units))
    return false;
  if (!mojo::Equals(this->target_viewport, other_struct.target_viewport))
    return false;
  if (!mojo::Equals(this->inertial_phase, other_struct.inertial_phase))
    return false;
  if (!mojo::Equals(this->synthetic, other_struct.synthetic))
    return false;
  if (!mojo::Equals(this->pointer_count, other_struct.pointer_count))
    return false;
  if (!mojo::Equals(this->update_details, other_struct.update_details))
    return false;
  return true;
}

template <typename T, ScrollData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.delta_x, rhs.delta_x))
    return true;
  if (std::less<>{}(rhs.delta_x, lhs.delta_x))
    return false;
  if (std::less<>{}(lhs.delta_y, rhs.delta_y))
    return true;
  if (std::less<>{}(rhs.delta_y, lhs.delta_y))
    return false;
  if (std::less<>{}(lhs.delta_units, rhs.delta_units))
    return true;
  if (std::less<>{}(rhs.delta_units, lhs.delta_units))
    return false;
  if (std::less<>{}(lhs.target_viewport, rhs.target_viewport))
    return true;
  if (std::less<>{}(rhs.target_viewport, lhs.target_viewport))
    return false;
  if (std::less<>{}(lhs.inertial_phase, rhs.inertial_phase))
    return true;
  if (std::less<>{}(rhs.inertial_phase, lhs.inertial_phase))
    return false;
  if (std::less<>{}(lhs.synthetic, rhs.synthetic))
    return true;
  if (std::less<>{}(rhs.synthetic, lhs.synthetic))
    return false;
  if (std::less<>{}(lhs.pointer_count, rhs.pointer_count))
    return true;
  if (std::less<>{}(rhs.pointer_count, lhs.pointer_count))
    return false;
  if (std::less<>{}(lhs.update_details, rhs.update_details))
    return true;
  if (std::less<>{}(rhs.update_details, lhs.update_details))
    return false;
  return false;
}
template <typename StructPtrType>
PinchBeginDataPtr PinchBeginData::Clone() const {
  return New(
      mojo::Clone(needs_wheel_event)
  );
}

template <typename T, PinchBeginData::EnableIfSame<T>*>
bool PinchBeginData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->needs_wheel_event, other_struct.needs_wheel_event))
    return false;
  return true;
}

template <typename T, PinchBeginData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.needs_wheel_event, rhs.needs_wheel_event))
    return true;
  if (std::less<>{}(rhs.needs_wheel_event, lhs.needs_wheel_event))
    return false;
  return false;
}
template <typename StructPtrType>
PinchUpdateDataPtr PinchUpdateData::Clone() const {
  return New(
      mojo::Clone(scale),
      mojo::Clone(zoom_disabled),
      mojo::Clone(needs_wheel_event)
  );
}

template <typename T, PinchUpdateData::EnableIfSame<T>*>
bool PinchUpdateData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scale, other_struct.scale))
    return false;
  if (!mojo::Equals(this->zoom_disabled, other_struct.zoom_disabled))
    return false;
  if (!mojo::Equals(this->needs_wheel_event, other_struct.needs_wheel_event))
    return false;
  return true;
}

template <typename T, PinchUpdateData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.scale, rhs.scale))
    return true;
  if (std::less<>{}(rhs.scale, lhs.scale))
    return false;
  if (std::less<>{}(lhs.zoom_disabled, rhs.zoom_disabled))
    return true;
  if (std::less<>{}(rhs.zoom_disabled, lhs.zoom_disabled))
    return false;
  if (std::less<>{}(lhs.needs_wheel_event, rhs.needs_wheel_event))
    return true;
  if (std::less<>{}(rhs.needs_wheel_event, lhs.needs_wheel_event))
    return false;
  return false;
}
template <typename StructPtrType>
PinchEndDataPtr PinchEndData::Clone() const {
  return New(
      mojo::Clone(needs_wheel_event)
  );
}

template <typename T, PinchEndData::EnableIfSame<T>*>
bool PinchEndData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->needs_wheel_event, other_struct.needs_wheel_event))
    return false;
  return true;
}

template <typename T, PinchEndData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.needs_wheel_event, rhs.needs_wheel_event))
    return true;
  if (std::less<>{}(rhs.needs_wheel_event, lhs.needs_wheel_event))
    return false;
  return false;
}
template <typename StructPtrType>
FlingDataPtr FlingData::Clone() const {
  return New(
      mojo::Clone(velocity_x),
      mojo::Clone(velocity_y),
      mojo::Clone(target_viewport),
      mojo::Clone(prevent_boosting)
  );
}

template <typename T, FlingData::EnableIfSame<T>*>
bool FlingData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->velocity_x, other_struct.velocity_x))
    return false;
  if (!mojo::Equals(this->velocity_y, other_struct.velocity_y))
    return false;
  if (!mojo::Equals(this->target_viewport, other_struct.target_viewport))
    return false;
  if (!mojo::Equals(this->prevent_boosting, other_struct.prevent_boosting))
    return false;
  return true;
}

template <typename T, FlingData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.velocity_x, rhs.velocity_x))
    return true;
  if (std::less<>{}(rhs.velocity_x, lhs.velocity_x))
    return false;
  if (std::less<>{}(lhs.velocity_y, rhs.velocity_y))
    return true;
  if (std::less<>{}(rhs.velocity_y, lhs.velocity_y))
    return false;
  if (std::less<>{}(lhs.target_viewport, rhs.target_viewport))
    return true;
  if (std::less<>{}(rhs.target_viewport, lhs.target_viewport))
    return false;
  if (std::less<>{}(lhs.prevent_boosting, rhs.prevent_boosting))
    return true;
  if (std::less<>{}(rhs.prevent_boosting, lhs.prevent_boosting))
    return false;
  return false;
}
template <typename StructPtrType>
TapDataPtr TapData::Clone() const {
  return New(
      mojo::Clone(tap_count),
      mojo::Clone(needs_wheel_event)
  );
}

template <typename T, TapData::EnableIfSame<T>*>
bool TapData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tap_count, other_struct.tap_count))
    return false;
  if (!mojo::Equals(this->needs_wheel_event, other_struct.needs_wheel_event))
    return false;
  return true;
}

template <typename T, TapData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.tap_count, rhs.tap_count))
    return true;
  if (std::less<>{}(rhs.tap_count, lhs.tap_count))
    return false;
  if (std::less<>{}(lhs.needs_wheel_event, rhs.needs_wheel_event))
    return true;
  if (std::less<>{}(rhs.needs_wheel_event, lhs.needs_wheel_event))
    return false;
  return false;
}
template <typename StructPtrType>
GestureDataPtr GestureData::Clone() const {
  return New(
      mojo::Clone(screen_position),
      mojo::Clone(widget_position),
      mojo::Clone(source_device),
      mojo::Clone(is_source_touch_event_set_non_blocking),
      mojo::Clone(primary_pointer_type),
      mojo::Clone(unique_touch_event_id),
      mojo::Clone(contact_size),
      mojo::Clone(scroll_data),
      mojo::Clone(pinch_begin_data),
      mojo::Clone(pinch_update_data),
      mojo::Clone(pinch_end_data),
      mojo::Clone(tap_data),
      mojo::Clone(fling_data)
  );
}

template <typename T, GestureData::EnableIfSame<T>*>
bool GestureData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->screen_position, other_struct.screen_position))
    return false;
  if (!mojo::Equals(this->widget_position, other_struct.widget_position))
    return false;
  if (!mojo::Equals(this->source_device, other_struct.source_device))
    return false;
  if (!mojo::Equals(this->is_source_touch_event_set_non_blocking, other_struct.is_source_touch_event_set_non_blocking))
    return false;
  if (!mojo::Equals(this->primary_pointer_type, other_struct.primary_pointer_type))
    return false;
  if (!mojo::Equals(this->unique_touch_event_id, other_struct.unique_touch_event_id))
    return false;
  if (!mojo::Equals(this->contact_size, other_struct.contact_size))
    return false;
  if (!mojo::Equals(this->scroll_data, other_struct.scroll_data))
    return false;
  if (!mojo::Equals(this->pinch_begin_data, other_struct.pinch_begin_data))
    return false;
  if (!mojo::Equals(this->pinch_update_data, other_struct.pinch_update_data))
    return false;
  if (!mojo::Equals(this->pinch_end_data, other_struct.pinch_end_data))
    return false;
  if (!mojo::Equals(this->tap_data, other_struct.tap_data))
    return false;
  if (!mojo::Equals(this->fling_data, other_struct.fling_data))
    return false;
  return true;
}

template <typename T, GestureData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.screen_position, rhs.screen_position))
    return true;
  if (std::less<>{}(rhs.screen_position, lhs.screen_position))
    return false;
  if (std::less<>{}(lhs.widget_position, rhs.widget_position))
    return true;
  if (std::less<>{}(rhs.widget_position, lhs.widget_position))
    return false;
  if (std::less<>{}(lhs.source_device, rhs.source_device))
    return true;
  if (std::less<>{}(rhs.source_device, lhs.source_device))
    return false;
  if (std::less<>{}(lhs.is_source_touch_event_set_non_blocking, rhs.is_source_touch_event_set_non_blocking))
    return true;
  if (std::less<>{}(rhs.is_source_touch_event_set_non_blocking, lhs.is_source_touch_event_set_non_blocking))
    return false;
  if (std::less<>{}(lhs.primary_pointer_type, rhs.primary_pointer_type))
    return true;
  if (std::less<>{}(rhs.primary_pointer_type, lhs.primary_pointer_type))
    return false;
  if (std::less<>{}(lhs.unique_touch_event_id, rhs.unique_touch_event_id))
    return true;
  if (std::less<>{}(rhs.unique_touch_event_id, lhs.unique_touch_event_id))
    return false;
  if (std::less<>{}(lhs.contact_size, rhs.contact_size))
    return true;
  if (std::less<>{}(rhs.contact_size, lhs.contact_size))
    return false;
  if (std::less<>{}(lhs.scroll_data, rhs.scroll_data))
    return true;
  if (std::less<>{}(rhs.scroll_data, lhs.scroll_data))
    return false;
  if (std::less<>{}(lhs.pinch_begin_data, rhs.pinch_begin_data))
    return true;
  if (std::less<>{}(rhs.pinch_begin_data, lhs.pinch_begin_data))
    return false;
  if (std::less<>{}(lhs.pinch_update_data, rhs.pinch_update_data))
    return true;
  if (std::less<>{}(rhs.pinch_update_data, lhs.pinch_update_data))
    return false;
  if (std::less<>{}(lhs.pinch_end_data, rhs.pinch_end_data))
    return true;
  if (std::less<>{}(rhs.pinch_end_data, lhs.pinch_end_data))
    return false;
  if (std::less<>{}(lhs.tap_data, rhs.tap_data))
    return true;
  if (std::less<>{}(rhs.tap_data, lhs.tap_data))
    return false;
  if (std::less<>{}(lhs.fling_data, rhs.fling_data))
    return true;
  if (std::less<>{}(rhs.fling_data, lhs.fling_data))
    return false;
  return false;
}
template <typename StructPtrType>
TouchPointPtr TouchPoint::Clone() const {
  return New(
      mojo::Clone(state),
      mojo::Clone(radius_x),
      mojo::Clone(radius_y),
      mojo::Clone(rotation_angle),
      mojo::Clone(pointer_data)
  );
}

template <typename T, TouchPoint::EnableIfSame<T>*>
bool TouchPoint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->radius_x, other_struct.radius_x))
    return false;
  if (!mojo::Equals(this->radius_y, other_struct.radius_y))
    return false;
  if (!mojo::Equals(this->rotation_angle, other_struct.rotation_angle))
    return false;
  if (!mojo::Equals(this->pointer_data, other_struct.pointer_data))
    return false;
  return true;
}

template <typename T, TouchPoint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.state, rhs.state))
    return true;
  if (std::less<>{}(rhs.state, lhs.state))
    return false;
  if (std::less<>{}(lhs.radius_x, rhs.radius_x))
    return true;
  if (std::less<>{}(rhs.radius_x, lhs.radius_x))
    return false;
  if (std::less<>{}(lhs.radius_y, rhs.radius_y))
    return true;
  if (std::less<>{}(rhs.radius_y, lhs.radius_y))
    return false;
  if (std::less<>{}(lhs.rotation_angle, rhs.rotation_angle))
    return true;
  if (std::less<>{}(rhs.rotation_angle, lhs.rotation_angle))
    return false;
  if (std::less<>{}(lhs.pointer_data, rhs.pointer_data))
    return true;
  if (std::less<>{}(rhs.pointer_data, lhs.pointer_data))
    return false;
  return false;
}
template <typename StructPtrType>
TouchDataPtr TouchData::Clone() const {
  return New(
      mojo::Clone(cancelable),
      mojo::Clone(moved_beyond_slop_region),
      mojo::Clone(touch_start_or_first_move),
      mojo::Clone(hovering),
      mojo::Clone(unique_touch_event_id),
      mojo::Clone(touches)
  );
}

template <typename T, TouchData::EnableIfSame<T>*>
bool TouchData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cancelable, other_struct.cancelable))
    return false;
  if (!mojo::Equals(this->moved_beyond_slop_region, other_struct.moved_beyond_slop_region))
    return false;
  if (!mojo::Equals(this->touch_start_or_first_move, other_struct.touch_start_or_first_move))
    return false;
  if (!mojo::Equals(this->hovering, other_struct.hovering))
    return false;
  if (!mojo::Equals(this->unique_touch_event_id, other_struct.unique_touch_event_id))
    return false;
  if (!mojo::Equals(this->touches, other_struct.touches))
    return false;
  return true;
}

template <typename T, TouchData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cancelable, rhs.cancelable))
    return true;
  if (std::less<>{}(rhs.cancelable, lhs.cancelable))
    return false;
  if (std::less<>{}(lhs.moved_beyond_slop_region, rhs.moved_beyond_slop_region))
    return true;
  if (std::less<>{}(rhs.moved_beyond_slop_region, lhs.moved_beyond_slop_region))
    return false;
  if (std::less<>{}(lhs.touch_start_or_first_move, rhs.touch_start_or_first_move))
    return true;
  if (std::less<>{}(rhs.touch_start_or_first_move, lhs.touch_start_or_first_move))
    return false;
  if (std::less<>{}(lhs.hovering, rhs.hovering))
    return true;
  if (std::less<>{}(rhs.hovering, lhs.hovering))
    return false;
  if (std::less<>{}(lhs.unique_touch_event_id, rhs.unique_touch_event_id))
    return true;
  if (std::less<>{}(rhs.unique_touch_event_id, lhs.unique_touch_event_id))
    return false;
  if (std::less<>{}(lhs.touches, rhs.touches))
    return true;
  if (std::less<>{}(rhs.touches, lhs.touches))
    return false;
  return false;
}
template <typename StructPtrType>
EventPtr Event::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(modifiers),
      mojo::Clone(timestamp),
      mojo::Clone(latency),
      mojo::Clone(key_data),
      mojo::Clone(pointer_data),
      mojo::Clone(gesture_data),
      mojo::Clone(touch_data)
  );
}

template <typename T, Event::EnableIfSame<T>*>
bool Event::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->latency, other_struct.latency))
    return false;
  if (!mojo::Equals(this->key_data, other_struct.key_data))
    return false;
  if (!mojo::Equals(this->pointer_data, other_struct.pointer_data))
    return false;
  if (!mojo::Equals(this->gesture_data, other_struct.gesture_data))
    return false;
  if (!mojo::Equals(this->touch_data, other_struct.touch_data))
    return false;
  return true;
}

template <typename T, Event::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.modifiers, rhs.modifiers))
    return true;
  if (std::less<>{}(rhs.modifiers, lhs.modifiers))
    return false;
  if (std::less<>{}(lhs.timestamp, rhs.timestamp))
    return true;
  if (std::less<>{}(rhs.timestamp, lhs.timestamp))
    return false;
  if (std::less<>{}(lhs.latency, rhs.latency))
    return true;
  if (std::less<>{}(rhs.latency, lhs.latency))
    return false;
  if (std::less<>{}(lhs.key_data, rhs.key_data))
    return true;
  if (std::less<>{}(rhs.key_data, lhs.key_data))
    return false;
  if (std::less<>{}(lhs.pointer_data, rhs.pointer_data))
    return true;
  if (std::less<>{}(rhs.pointer_data, lhs.pointer_data))
    return false;
  if (std::less<>{}(lhs.gesture_data, rhs.gesture_data))
    return true;
  if (std::less<>{}(rhs.gesture_data, lhs.gesture_data))
    return false;
  if (std::less<>{}(lhs.touch_data, rhs.touch_data))
    return true;
  if (std::less<>{}(rhs.touch_data, lhs.touch_data))
    return false;
  return false;
}
template <typename StructPtrType>
DidOverscrollParamsPtr DidOverscrollParams::Clone() const {
  return New(
      mojo::Clone(accumulated_overscroll),
      mojo::Clone(latest_overscroll_delta),
      mojo::Clone(current_fling_velocity),
      mojo::Clone(causal_event_viewport_point),
      mojo::Clone(overscroll_behavior)
  );
}

template <typename T, DidOverscrollParams::EnableIfSame<T>*>
bool DidOverscrollParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->accumulated_overscroll, other_struct.accumulated_overscroll))
    return false;
  if (!mojo::Equals(this->latest_overscroll_delta, other_struct.latest_overscroll_delta))
    return false;
  if (!mojo::Equals(this->current_fling_velocity, other_struct.current_fling_velocity))
    return false;
  if (!mojo::Equals(this->causal_event_viewport_point, other_struct.causal_event_viewport_point))
    return false;
  if (!mojo::Equals(this->overscroll_behavior, other_struct.overscroll_behavior))
    return false;
  return true;
}

template <typename T, DidOverscrollParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.accumulated_overscroll, rhs.accumulated_overscroll))
    return true;
  if (std::less<>{}(rhs.accumulated_overscroll, lhs.accumulated_overscroll))
    return false;
  if (std::less<>{}(lhs.latest_overscroll_delta, rhs.latest_overscroll_delta))
    return true;
  if (std::less<>{}(rhs.latest_overscroll_delta, lhs.latest_overscroll_delta))
    return false;
  if (std::less<>{}(lhs.current_fling_velocity, rhs.current_fling_velocity))
    return true;
  if (std::less<>{}(rhs.current_fling_velocity, lhs.current_fling_velocity))
    return false;
  if (std::less<>{}(lhs.causal_event_viewport_point, rhs.causal_event_viewport_point))
    return true;
  if (std::less<>{}(rhs.causal_event_viewport_point, lhs.causal_event_viewport_point))
    return false;
  if (std::less<>{}(lhs.overscroll_behavior, rhs.overscroll_behavior))
    return true;
  if (std::less<>{}(rhs.overscroll_behavior, lhs.overscroll_behavior))
    return false;
  return false;
}
template <typename StructPtrType>
TouchActionOptionalPtr TouchActionOptional::Clone() const {
  return New(
      mojo::Clone(touch_action)
  );
}

template <typename T, TouchActionOptional::EnableIfSame<T>*>
bool TouchActionOptional::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->touch_action, other_struct.touch_action))
    return false;
  return true;
}

template <typename T, TouchActionOptional::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.touch_action, rhs.touch_action))
    return true;
  if (std::less<>{}(rhs.touch_action, lhs.touch_action))
    return false;
  return false;
}
template <typename StructPtrType>
EditCommandPtr EditCommand::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, EditCommand::EnableIfSame<T>*>
bool EditCommand::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, EditCommand::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::KeyData::DataView,
                                         ::blink::mojom::blink::KeyDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::KeyDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::KeyDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::KeyData::dom_key) dom_key(
      const ::blink::mojom::blink::KeyDataPtr& input) {
    return input->dom_key;
  }

  static decltype(::blink::mojom::blink::KeyData::dom_code) dom_code(
      const ::blink::mojom::blink::KeyDataPtr& input) {
    return input->dom_code;
  }

  static decltype(::blink::mojom::blink::KeyData::windows_key_code) windows_key_code(
      const ::blink::mojom::blink::KeyDataPtr& input) {
    return input->windows_key_code;
  }

  static decltype(::blink::mojom::blink::KeyData::native_key_code) native_key_code(
      const ::blink::mojom::blink::KeyDataPtr& input) {
    return input->native_key_code;
  }

  static decltype(::blink::mojom::blink::KeyData::is_system_key) is_system_key(
      const ::blink::mojom::blink::KeyDataPtr& input) {
    return input->is_system_key;
  }

  static decltype(::blink::mojom::blink::KeyData::is_browser_shortcut) is_browser_shortcut(
      const ::blink::mojom::blink::KeyDataPtr& input) {
    return input->is_browser_shortcut;
  }

  static const decltype(::blink::mojom::blink::KeyData::text)& text(
      const ::blink::mojom::blink::KeyDataPtr& input) {
    return input->text;
  }

  static const decltype(::blink::mojom::blink::KeyData::unmodified_text)& unmodified_text(
      const ::blink::mojom::blink::KeyDataPtr& input) {
    return input->unmodified_text;
  }

  static bool Read(::blink::mojom::blink::KeyData::DataView input, ::blink::mojom::blink::KeyDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PointerData::DataView,
                                         ::blink::mojom::blink::PointerDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::PointerDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PointerDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PointerData::pointer_id) pointer_id(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->pointer_id;
  }

  static decltype(::blink::mojom::blink::PointerData::force) force(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->force;
  }

  static decltype(::blink::mojom::blink::PointerData::tilt_x) tilt_x(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->tilt_x;
  }

  static decltype(::blink::mojom::blink::PointerData::tilt_y) tilt_y(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->tilt_y;
  }

  static decltype(::blink::mojom::blink::PointerData::tangential_pressure) tangential_pressure(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->tangential_pressure;
  }

  static decltype(::blink::mojom::blink::PointerData::twist) twist(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->twist;
  }

  static decltype(::blink::mojom::blink::PointerData::button) button(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->button;
  }

  static decltype(::blink::mojom::blink::PointerData::pointer_type) pointer_type(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->pointer_type;
  }

  static decltype(::blink::mojom::blink::PointerData::movement_x) movement_x(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->movement_x;
  }

  static decltype(::blink::mojom::blink::PointerData::movement_y) movement_y(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->movement_y;
  }

  static decltype(::blink::mojom::blink::PointerData::is_raw_movement_event) is_raw_movement_event(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->is_raw_movement_event;
  }

  static const decltype(::blink::mojom::blink::PointerData::widget_position)& widget_position(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->widget_position;
  }

  static const decltype(::blink::mojom::blink::PointerData::screen_position)& screen_position(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->screen_position;
  }

  static const decltype(::blink::mojom::blink::PointerData::mouse_data)& mouse_data(
      const ::blink::mojom::blink::PointerDataPtr& input) {
    return input->mouse_data;
  }

  static bool Read(::blink::mojom::blink::PointerData::DataView input, ::blink::mojom::blink::PointerDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WheelData::DataView,
                                         ::blink::mojom::blink::WheelDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::WheelDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WheelDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::WheelData::delta_x) delta_x(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->delta_x;
  }

  static decltype(::blink::mojom::blink::WheelData::delta_y) delta_y(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->delta_y;
  }

  static decltype(::blink::mojom::blink::WheelData::wheel_ticks_x) wheel_ticks_x(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->wheel_ticks_x;
  }

  static decltype(::blink::mojom::blink::WheelData::wheel_ticks_y) wheel_ticks_y(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->wheel_ticks_y;
  }

  static decltype(::blink::mojom::blink::WheelData::acceleration_ratio_x) acceleration_ratio_x(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->acceleration_ratio_x;
  }

  static decltype(::blink::mojom::blink::WheelData::acceleration_ratio_y) acceleration_ratio_y(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->acceleration_ratio_y;
  }

  static decltype(::blink::mojom::blink::WheelData::phase) phase(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->phase;
  }

  static decltype(::blink::mojom::blink::WheelData::momentum_phase) momentum_phase(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->momentum_phase;
  }

  static decltype(::blink::mojom::blink::WheelData::cancelable) cancelable(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->cancelable;
  }

  static decltype(::blink::mojom::blink::WheelData::event_action) event_action(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->event_action;
  }

  static decltype(::blink::mojom::blink::WheelData::delta_units) delta_units(
      const ::blink::mojom::blink::WheelDataPtr& input) {
    return input->delta_units;
  }

  static bool Read(::blink::mojom::blink::WheelData::DataView input, ::blink::mojom::blink::WheelDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MouseData::DataView,
                                         ::blink::mojom::blink::MouseDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::MouseDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MouseDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::MouseData::click_count) click_count(
      const ::blink::mojom::blink::MouseDataPtr& input) {
    return input->click_count;
  }

  static const decltype(::blink::mojom::blink::MouseData::wheel_data)& wheel_data(
      const ::blink::mojom::blink::MouseDataPtr& input) {
    return input->wheel_data;
  }

  static bool Read(::blink::mojom::blink::MouseData::DataView input, ::blink::mojom::blink::MouseDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ScrollUpdate::DataView,
                                         ::blink::mojom::blink::ScrollUpdatePtr> {
  static bool IsNull(const ::blink::mojom::blink::ScrollUpdatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ScrollUpdatePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ScrollUpdate::velocity_x) velocity_x(
      const ::blink::mojom::blink::ScrollUpdatePtr& input) {
    return input->velocity_x;
  }

  static decltype(::blink::mojom::blink::ScrollUpdate::velocity_y) velocity_y(
      const ::blink::mojom::blink::ScrollUpdatePtr& input) {
    return input->velocity_y;
  }

  static bool Read(::blink::mojom::blink::ScrollUpdate::DataView input, ::blink::mojom::blink::ScrollUpdatePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ScrollData::DataView,
                                         ::blink::mojom::blink::ScrollDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::ScrollDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ScrollDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ScrollData::delta_x) delta_x(
      const ::blink::mojom::blink::ScrollDataPtr& input) {
    return input->delta_x;
  }

  static decltype(::blink::mojom::blink::ScrollData::delta_y) delta_y(
      const ::blink::mojom::blink::ScrollDataPtr& input) {
    return input->delta_y;
  }

  static decltype(::blink::mojom::blink::ScrollData::delta_units) delta_units(
      const ::blink::mojom::blink::ScrollDataPtr& input) {
    return input->delta_units;
  }

  static decltype(::blink::mojom::blink::ScrollData::target_viewport) target_viewport(
      const ::blink::mojom::blink::ScrollDataPtr& input) {
    return input->target_viewport;
  }

  static decltype(::blink::mojom::blink::ScrollData::inertial_phase) inertial_phase(
      const ::blink::mojom::blink::ScrollDataPtr& input) {
    return input->inertial_phase;
  }

  static decltype(::blink::mojom::blink::ScrollData::synthetic) synthetic(
      const ::blink::mojom::blink::ScrollDataPtr& input) {
    return input->synthetic;
  }

  static decltype(::blink::mojom::blink::ScrollData::pointer_count) pointer_count(
      const ::blink::mojom::blink::ScrollDataPtr& input) {
    return input->pointer_count;
  }

  static const decltype(::blink::mojom::blink::ScrollData::update_details)& update_details(
      const ::blink::mojom::blink::ScrollDataPtr& input) {
    return input->update_details;
  }

  static bool Read(::blink::mojom::blink::ScrollData::DataView input, ::blink::mojom::blink::ScrollDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PinchBeginData::DataView,
                                         ::blink::mojom::blink::PinchBeginDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::PinchBeginDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PinchBeginDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PinchBeginData::needs_wheel_event) needs_wheel_event(
      const ::blink::mojom::blink::PinchBeginDataPtr& input) {
    return input->needs_wheel_event;
  }

  static bool Read(::blink::mojom::blink::PinchBeginData::DataView input, ::blink::mojom::blink::PinchBeginDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PinchUpdateData::DataView,
                                         ::blink::mojom::blink::PinchUpdateDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::PinchUpdateDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PinchUpdateDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PinchUpdateData::scale) scale(
      const ::blink::mojom::blink::PinchUpdateDataPtr& input) {
    return input->scale;
  }

  static decltype(::blink::mojom::blink::PinchUpdateData::zoom_disabled) zoom_disabled(
      const ::blink::mojom::blink::PinchUpdateDataPtr& input) {
    return input->zoom_disabled;
  }

  static decltype(::blink::mojom::blink::PinchUpdateData::needs_wheel_event) needs_wheel_event(
      const ::blink::mojom::blink::PinchUpdateDataPtr& input) {
    return input->needs_wheel_event;
  }

  static bool Read(::blink::mojom::blink::PinchUpdateData::DataView input, ::blink::mojom::blink::PinchUpdateDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PinchEndData::DataView,
                                         ::blink::mojom::blink::PinchEndDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::PinchEndDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PinchEndDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PinchEndData::needs_wheel_event) needs_wheel_event(
      const ::blink::mojom::blink::PinchEndDataPtr& input) {
    return input->needs_wheel_event;
  }

  static bool Read(::blink::mojom::blink::PinchEndData::DataView input, ::blink::mojom::blink::PinchEndDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FlingData::DataView,
                                         ::blink::mojom::blink::FlingDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::FlingDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FlingDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FlingData::velocity_x) velocity_x(
      const ::blink::mojom::blink::FlingDataPtr& input) {
    return input->velocity_x;
  }

  static decltype(::blink::mojom::blink::FlingData::velocity_y) velocity_y(
      const ::blink::mojom::blink::FlingDataPtr& input) {
    return input->velocity_y;
  }

  static decltype(::blink::mojom::blink::FlingData::target_viewport) target_viewport(
      const ::blink::mojom::blink::FlingDataPtr& input) {
    return input->target_viewport;
  }

  static decltype(::blink::mojom::blink::FlingData::prevent_boosting) prevent_boosting(
      const ::blink::mojom::blink::FlingDataPtr& input) {
    return input->prevent_boosting;
  }

  static bool Read(::blink::mojom::blink::FlingData::DataView input, ::blink::mojom::blink::FlingDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TapData::DataView,
                                         ::blink::mojom::blink::TapDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::TapDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TapDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::TapData::tap_count) tap_count(
      const ::blink::mojom::blink::TapDataPtr& input) {
    return input->tap_count;
  }

  static decltype(::blink::mojom::blink::TapData::needs_wheel_event) needs_wheel_event(
      const ::blink::mojom::blink::TapDataPtr& input) {
    return input->needs_wheel_event;
  }

  static bool Read(::blink::mojom::blink::TapData::DataView input, ::blink::mojom::blink::TapDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::GestureData::DataView,
                                         ::blink::mojom::blink::GestureDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::GestureDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::GestureDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::GestureData::screen_position)& screen_position(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->screen_position;
  }

  static const decltype(::blink::mojom::blink::GestureData::widget_position)& widget_position(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->widget_position;
  }

  static decltype(::blink::mojom::blink::GestureData::source_device) source_device(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->source_device;
  }

  static decltype(::blink::mojom::blink::GestureData::is_source_touch_event_set_non_blocking) is_source_touch_event_set_non_blocking(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->is_source_touch_event_set_non_blocking;
  }

  static decltype(::blink::mojom::blink::GestureData::primary_pointer_type) primary_pointer_type(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->primary_pointer_type;
  }

  static decltype(::blink::mojom::blink::GestureData::unique_touch_event_id) unique_touch_event_id(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->unique_touch_event_id;
  }

  static const decltype(::blink::mojom::blink::GestureData::contact_size)& contact_size(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->contact_size;
  }

  static const decltype(::blink::mojom::blink::GestureData::scroll_data)& scroll_data(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->scroll_data;
  }

  static const decltype(::blink::mojom::blink::GestureData::pinch_begin_data)& pinch_begin_data(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->pinch_begin_data;
  }

  static const decltype(::blink::mojom::blink::GestureData::pinch_update_data)& pinch_update_data(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->pinch_update_data;
  }

  static const decltype(::blink::mojom::blink::GestureData::pinch_end_data)& pinch_end_data(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->pinch_end_data;
  }

  static const decltype(::blink::mojom::blink::GestureData::tap_data)& tap_data(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->tap_data;
  }

  static const decltype(::blink::mojom::blink::GestureData::fling_data)& fling_data(
      const ::blink::mojom::blink::GestureDataPtr& input) {
    return input->fling_data;
  }

  static bool Read(::blink::mojom::blink::GestureData::DataView input, ::blink::mojom::blink::GestureDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TouchPoint::DataView,
                                         ::blink::mojom::blink::TouchPointPtr> {
  static bool IsNull(const ::blink::mojom::blink::TouchPointPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TouchPointPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::TouchPoint::state) state(
      const ::blink::mojom::blink::TouchPointPtr& input) {
    return input->state;
  }

  static decltype(::blink::mojom::blink::TouchPoint::radius_x) radius_x(
      const ::blink::mojom::blink::TouchPointPtr& input) {
    return input->radius_x;
  }

  static decltype(::blink::mojom::blink::TouchPoint::radius_y) radius_y(
      const ::blink::mojom::blink::TouchPointPtr& input) {
    return input->radius_y;
  }

  static decltype(::blink::mojom::blink::TouchPoint::rotation_angle) rotation_angle(
      const ::blink::mojom::blink::TouchPointPtr& input) {
    return input->rotation_angle;
  }

  static const decltype(::blink::mojom::blink::TouchPoint::pointer_data)& pointer_data(
      const ::blink::mojom::blink::TouchPointPtr& input) {
    return input->pointer_data;
  }

  static bool Read(::blink::mojom::blink::TouchPoint::DataView input, ::blink::mojom::blink::TouchPointPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TouchData::DataView,
                                         ::blink::mojom::blink::TouchDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::TouchDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TouchDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::TouchData::cancelable) cancelable(
      const ::blink::mojom::blink::TouchDataPtr& input) {
    return input->cancelable;
  }

  static decltype(::blink::mojom::blink::TouchData::moved_beyond_slop_region) moved_beyond_slop_region(
      const ::blink::mojom::blink::TouchDataPtr& input) {
    return input->moved_beyond_slop_region;
  }

  static decltype(::blink::mojom::blink::TouchData::touch_start_or_first_move) touch_start_or_first_move(
      const ::blink::mojom::blink::TouchDataPtr& input) {
    return input->touch_start_or_first_move;
  }

  static decltype(::blink::mojom::blink::TouchData::hovering) hovering(
      const ::blink::mojom::blink::TouchDataPtr& input) {
    return input->hovering;
  }

  static decltype(::blink::mojom::blink::TouchData::unique_touch_event_id) unique_touch_event_id(
      const ::blink::mojom::blink::TouchDataPtr& input) {
    return input->unique_touch_event_id;
  }

  static const decltype(::blink::mojom::blink::TouchData::touches)& touches(
      const ::blink::mojom::blink::TouchDataPtr& input) {
    return input->touches;
  }

  static bool Read(::blink::mojom::blink::TouchData::DataView input, ::blink::mojom::blink::TouchDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::Event::DataView,
                                         ::blink::mojom::blink::EventPtr> {
  static bool IsNull(const ::blink::mojom::blink::EventPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::EventPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::Event::type) type(
      const ::blink::mojom::blink::EventPtr& input) {
    return input->type;
  }

  static decltype(::blink::mojom::blink::Event::modifiers) modifiers(
      const ::blink::mojom::blink::EventPtr& input) {
    return input->modifiers;
  }

  static const decltype(::blink::mojom::blink::Event::timestamp)& timestamp(
      const ::blink::mojom::blink::EventPtr& input) {
    return input->timestamp;
  }

  static const decltype(::blink::mojom::blink::Event::latency)& latency(
      const ::blink::mojom::blink::EventPtr& input) {
    return input->latency;
  }

  static const decltype(::blink::mojom::blink::Event::key_data)& key_data(
      const ::blink::mojom::blink::EventPtr& input) {
    return input->key_data;
  }

  static const decltype(::blink::mojom::blink::Event::pointer_data)& pointer_data(
      const ::blink::mojom::blink::EventPtr& input) {
    return input->pointer_data;
  }

  static const decltype(::blink::mojom::blink::Event::gesture_data)& gesture_data(
      const ::blink::mojom::blink::EventPtr& input) {
    return input->gesture_data;
  }

  static const decltype(::blink::mojom::blink::Event::touch_data)& touch_data(
      const ::blink::mojom::blink::EventPtr& input) {
    return input->touch_data;
  }

  static bool Read(::blink::mojom::blink::Event::DataView input, ::blink::mojom::blink::EventPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DidOverscrollParams::DataView,
                                         ::blink::mojom::blink::DidOverscrollParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DidOverscrollParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DidOverscrollParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DidOverscrollParams::accumulated_overscroll)& accumulated_overscroll(
      const ::blink::mojom::blink::DidOverscrollParamsPtr& input) {
    return input->accumulated_overscroll;
  }

  static const decltype(::blink::mojom::blink::DidOverscrollParams::latest_overscroll_delta)& latest_overscroll_delta(
      const ::blink::mojom::blink::DidOverscrollParamsPtr& input) {
    return input->latest_overscroll_delta;
  }

  static const decltype(::blink::mojom::blink::DidOverscrollParams::current_fling_velocity)& current_fling_velocity(
      const ::blink::mojom::blink::DidOverscrollParamsPtr& input) {
    return input->current_fling_velocity;
  }

  static const decltype(::blink::mojom::blink::DidOverscrollParams::causal_event_viewport_point)& causal_event_viewport_point(
      const ::blink::mojom::blink::DidOverscrollParamsPtr& input) {
    return input->causal_event_viewport_point;
  }

  static const decltype(::blink::mojom::blink::DidOverscrollParams::overscroll_behavior)& overscroll_behavior(
      const ::blink::mojom::blink::DidOverscrollParamsPtr& input) {
    return input->overscroll_behavior;
  }

  static bool Read(::blink::mojom::blink::DidOverscrollParams::DataView input, ::blink::mojom::blink::DidOverscrollParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TouchActionOptional::DataView,
                                         ::blink::mojom::blink::TouchActionOptionalPtr> {
  static bool IsNull(const ::blink::mojom::blink::TouchActionOptionalPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TouchActionOptionalPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::TouchActionOptional::touch_action) touch_action(
      const ::blink::mojom::blink::TouchActionOptionalPtr& input) {
    return input->touch_action;
  }

  static bool Read(::blink::mojom::blink::TouchActionOptional::DataView input, ::blink::mojom::blink::TouchActionOptionalPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::EditCommand::DataView,
                                         ::blink::mojom::blink::EditCommandPtr> {
  static bool IsNull(const ::blink::mojom::blink::EditCommandPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::EditCommandPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::EditCommand::name)& name(
      const ::blink::mojom::blink::EditCommandPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::EditCommand::value)& value(
      const ::blink::mojom::blink::EditCommandPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::blink::EditCommand::DataView input, ::blink::mojom::blink::EditCommandPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_BLINK_H_