// third_party/blink/public/mojom/hid/hid.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/hid/hid.mojom-shared.h"
#include "third_party/blink/public/mojom/hid/hid.mojom-blink-forward.h"
#include "services/device/public/mojom/hid.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class HidServiceProxy;

template <typename ImplRefTraits>
class HidServiceStub;

class HidServiceRequestValidator;
class HidServiceResponseValidator;


class PLATFORM_EXPORT HidService
    : public HidServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HidServiceInterfaceBase;
  using Proxy_ = HidServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidServiceStub<ImplRefTraits>;

  using RequestValidator_ = HidServiceRequestValidator;
  using ResponseValidator_ = HidServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterClientMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kRequestDeviceMinVersion = 0,
    kConnectMinVersion = 0,
  };
  virtual ~HidService() {}

  
  virtual void RegisterClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::HidManagerClient> client) = 0;


  using GetDevicesCallback = base::OnceCallback<void(WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr>)>;
  
  virtual void GetDevices(GetDevicesCallback callback) = 0;


  using RequestDeviceCallback = base::OnceCallback<void(WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr>)>;
  
  virtual void RequestDevice(WTF::Vector<HidDeviceFilterPtr> filters, RequestDeviceCallback callback) = 0;


  using ConnectCallback = base::OnceCallback<void(::mojo::PendingRemote<::device::mojom::blink::HidConnection>)>;
  
  virtual void Connect(const WTF::String& device_guid, ::mojo::PendingRemote<::device::mojom::blink::HidConnectionClient> client, ConnectCallback callback) = 0;
};



class PLATFORM_EXPORT HidServiceProxy
    : public HidService {
 public:
  using InterfaceType = HidService;

  explicit HidServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::HidManagerClient> client) final;
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void RequestDevice(WTF::Vector<HidDeviceFilterPtr> filters, RequestDeviceCallback callback) final;
  
  void Connect(const WTF::String& device_guid, ::mojo::PendingRemote<::device::mojom::blink::HidConnectionClient> client, ConnectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT HidServiceStubDispatch {
 public:
  static bool Accept(HidService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidService>>
class HidServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidServiceStub() {}
  ~HidServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT HidServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT HidServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT VendorAndProduct {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VendorAndProduct, T>::value>;
  using DataView = VendorAndProductDataView;
  using Data_ = internal::VendorAndProduct_Data;

  template <typename... Args>
  static VendorAndProductPtr New(Args&&... args) {
    return VendorAndProductPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VendorAndProductPtr From(const U& u) {
    return mojo::TypeConverter<VendorAndProductPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VendorAndProduct>::Convert(*this);
  }


  VendorAndProduct();

  VendorAndProduct(
      uint16_t vendor,
      uint16_t product);

  ~VendorAndProduct();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VendorAndProductPtr>
  VendorAndProductPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VendorAndProduct::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VendorAndProduct::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VendorAndProduct_UnserializedMessageContext<
            UserType, VendorAndProduct::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VendorAndProduct::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VendorAndProduct::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VendorAndProduct_UnserializedMessageContext<
            UserType, VendorAndProduct::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VendorAndProduct::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint16_t vendor;
  
  uint16_t product;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT DeviceIdFilter {
 public:
  using DataView = DeviceIdFilterDataView;
  using Data_ = internal::DeviceIdFilter_Data;
  using Tag = Data_::DeviceIdFilter_Tag;

  static DeviceIdFilterPtr New() {
    return DeviceIdFilterPtr(base::in_place);
  }
  // Construct an instance holding |vendor|.
  static DeviceIdFilterPtr
  NewVendor(
      uint16_t vendor) {
    auto result = DeviceIdFilterPtr(base::in_place);
    result->set_vendor(std::move(vendor));
    return result;
  }
  // Construct an instance holding |vendor_and_product|.
  static DeviceIdFilterPtr
  NewVendorAndProduct(
      VendorAndProductPtr vendor_and_product) {
    auto result = DeviceIdFilterPtr(base::in_place);
    result->set_vendor_and_product(std::move(vendor_and_product));
    return result;
  }

  template <typename U>
  static DeviceIdFilterPtr From(const U& u) {
    return mojo::TypeConverter<DeviceIdFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceIdFilter>::Convert(*this);
  }

  DeviceIdFilter();
  ~DeviceIdFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DeviceIdFilterPtr>
  DeviceIdFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeviceIdFilter>::value>::type* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_vendor() const { return tag_ == Tag::VENDOR; }

  
  uint16_t get_vendor() const {
    DCHECK(tag_ == Tag::VENDOR);
    return data_.vendor;
  }

  
  void set_vendor(
      uint16_t vendor);
  
  bool is_vendor_and_product() const { return tag_ == Tag::VENDOR_AND_PRODUCT; }

  
  VendorAndProductPtr& get_vendor_and_product() const {
    DCHECK(tag_ == Tag::VENDOR_AND_PRODUCT);
    return *(data_.vendor_and_product);
  }

  
  void set_vendor_and_product(
      VendorAndProductPtr vendor_and_product);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceIdFilter::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DeviceIdFilter::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    uint16_t vendor;
    VendorAndProductPtr* vendor_and_product;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT UsageFilter {
 public:
  using DataView = UsageFilterDataView;
  using Data_ = internal::UsageFilter_Data;
  using Tag = Data_::UsageFilter_Tag;

  static UsageFilterPtr New() {
    return UsageFilterPtr(base::in_place);
  }
  // Construct an instance holding |page|.
  static UsageFilterPtr
  NewPage(
      uint16_t page) {
    auto result = UsageFilterPtr(base::in_place);
    result->set_page(std::move(page));
    return result;
  }
  // Construct an instance holding |usage_and_page|.
  static UsageFilterPtr
  NewUsageAndPage(
      ::device::mojom::blink::HidUsageAndPagePtr usage_and_page) {
    auto result = UsageFilterPtr(base::in_place);
    result->set_usage_and_page(std::move(usage_and_page));
    return result;
  }

  template <typename U>
  static UsageFilterPtr From(const U& u) {
    return mojo::TypeConverter<UsageFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsageFilter>::Convert(*this);
  }

  UsageFilter();
  ~UsageFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UsageFilterPtr>
  UsageFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UsageFilter>::value>::type* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_page() const { return tag_ == Tag::PAGE; }

  
  uint16_t get_page() const {
    DCHECK(tag_ == Tag::PAGE);
    return data_.page;
  }

  
  void set_page(
      uint16_t page);
  
  bool is_usage_and_page() const { return tag_ == Tag::USAGE_AND_PAGE; }

  
  ::device::mojom::blink::HidUsageAndPagePtr& get_usage_and_page() const {
    DCHECK(tag_ == Tag::USAGE_AND_PAGE);
    return *(data_.usage_and_page);
  }

  
  void set_usage_and_page(
      ::device::mojom::blink::HidUsageAndPagePtr usage_and_page);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsageFilter::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UsageFilter::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    uint16_t page;
    ::device::mojom::blink::HidUsageAndPagePtr* usage_and_page;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class PLATFORM_EXPORT HidDeviceFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidDeviceFilter, T>::value>;
  using DataView = HidDeviceFilterDataView;
  using Data_ = internal::HidDeviceFilter_Data;

  template <typename... Args>
  static HidDeviceFilterPtr New(Args&&... args) {
    return HidDeviceFilterPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidDeviceFilterPtr From(const U& u) {
    return mojo::TypeConverter<HidDeviceFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidDeviceFilter>::Convert(*this);
  }


  HidDeviceFilter();

  HidDeviceFilter(
      DeviceIdFilterPtr device_ids,
      UsageFilterPtr usage);

  ~HidDeviceFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidDeviceFilterPtr>
  HidDeviceFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidDeviceFilter::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidDeviceFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidDeviceFilter_UnserializedMessageContext<
            UserType, HidDeviceFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HidDeviceFilter::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return HidDeviceFilter::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidDeviceFilter_UnserializedMessageContext<
            UserType, HidDeviceFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidDeviceFilter::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  DeviceIdFilterPtr device_ids;
  
  UsageFilterPtr usage;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(HidDeviceFilter);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DeviceIdFilterPtr DeviceIdFilter::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::VENDOR:
      rv->set_vendor(mojo::Clone(data_.vendor));
      break;
    case Tag::VENDOR_AND_PRODUCT:
      rv->set_vendor_and_product(mojo::Clone(*data_.vendor_and_product));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DeviceIdFilter>::value>::type*>
bool DeviceIdFilter::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::VENDOR:
      return mojo::Equals(data_.vendor, other.data_.vendor);
    case Tag::VENDOR_AND_PRODUCT:
      return mojo::Equals(*(data_.vendor_and_product), *(other.data_.vendor_and_product));
  }

  return false;
}
template <typename UnionPtrType>
UsageFilterPtr UsageFilter::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::PAGE:
      rv->set_page(mojo::Clone(data_.page));
      break;
    case Tag::USAGE_AND_PAGE:
      rv->set_usage_and_page(mojo::Clone(*data_.usage_and_page));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UsageFilter>::value>::type*>
bool UsageFilter::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::PAGE:
      return mojo::Equals(data_.page, other.data_.page);
    case Tag::USAGE_AND_PAGE:
      return mojo::Equals(*(data_.usage_and_page), *(other.data_.usage_and_page));
  }

  return false;
}
template <typename StructPtrType>
VendorAndProductPtr VendorAndProduct::Clone() const {
  return New(
      mojo::Clone(vendor),
      mojo::Clone(product)
  );
}

template <typename T, VendorAndProduct::EnableIfSame<T>*>
bool VendorAndProduct::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->vendor, other_struct.vendor))
    return false;
  if (!mojo::Equals(this->product, other_struct.product))
    return false;
  return true;
}

template <typename T, VendorAndProduct::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.vendor, rhs.vendor))
    return true;
  if (std::less<>{}(rhs.vendor, lhs.vendor))
    return false;
  if (std::less<>{}(lhs.product, rhs.product))
    return true;
  if (std::less<>{}(rhs.product, lhs.product))
    return false;
  return false;
}
template <typename StructPtrType>
HidDeviceFilterPtr HidDeviceFilter::Clone() const {
  return New(
      mojo::Clone(device_ids),
      mojo::Clone(usage)
  );
}

template <typename T, HidDeviceFilter::EnableIfSame<T>*>
bool HidDeviceFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_ids, other_struct.device_ids))
    return false;
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  return true;
}

template <typename T, HidDeviceFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.device_ids, rhs.device_ids))
    return true;
  if (std::less<>{}(rhs.device_ids, lhs.device_ids))
    return false;
  if (std::less<>{}(lhs.usage, rhs.usage))
    return true;
  if (std::less<>{}(rhs.usage, lhs.usage))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::VendorAndProduct::DataView,
                                         ::blink::mojom::blink::VendorAndProductPtr> {
  static bool IsNull(const ::blink::mojom::blink::VendorAndProductPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::VendorAndProductPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::VendorAndProduct::vendor) vendor(
      const ::blink::mojom::blink::VendorAndProductPtr& input) {
    return input->vendor;
  }

  static decltype(::blink::mojom::blink::VendorAndProduct::product) product(
      const ::blink::mojom::blink::VendorAndProductPtr& input) {
    return input->product;
  }

  static bool Read(::blink::mojom::blink::VendorAndProduct::DataView input, ::blink::mojom::blink::VendorAndProductPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::HidDeviceFilter::DataView,
                                         ::blink::mojom::blink::HidDeviceFilterPtr> {
  static bool IsNull(const ::blink::mojom::blink::HidDeviceFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::HidDeviceFilterPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::HidDeviceFilter::device_ids)& device_ids(
      const ::blink::mojom::blink::HidDeviceFilterPtr& input) {
    return input->device_ids;
  }

  static const decltype(::blink::mojom::blink::HidDeviceFilter::usage)& usage(
      const ::blink::mojom::blink::HidDeviceFilterPtr& input) {
    return input->usage;
  }

  static bool Read(::blink::mojom::blink::HidDeviceFilter::DataView input, ::blink::mojom::blink::HidDeviceFilterPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::DeviceIdFilter::DataView,
                                        ::blink::mojom::blink::DeviceIdFilterPtr> {
  static bool IsNull(const ::blink::mojom::blink::DeviceIdFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DeviceIdFilterPtr* output) { output->reset(); }

  static ::blink::mojom::blink::DeviceIdFilter::Tag GetTag(const ::blink::mojom::blink::DeviceIdFilterPtr& input) {
    return input->which();
  }

  static  uint16_t vendor(const ::blink::mojom::blink::DeviceIdFilterPtr& input) {
    return input->get_vendor();
  }

  static const ::blink::mojom::blink::VendorAndProductPtr& vendor_and_product(const ::blink::mojom::blink::DeviceIdFilterPtr& input) {
    return input->get_vendor_and_product();
  }

  static bool Read(::blink::mojom::blink::DeviceIdFilter::DataView input, ::blink::mojom::blink::DeviceIdFilterPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::UsageFilter::DataView,
                                        ::blink::mojom::blink::UsageFilterPtr> {
  static bool IsNull(const ::blink::mojom::blink::UsageFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::UsageFilterPtr* output) { output->reset(); }

  static ::blink::mojom::blink::UsageFilter::Tag GetTag(const ::blink::mojom::blink::UsageFilterPtr& input) {
    return input->which();
  }

  static  uint16_t page(const ::blink::mojom::blink::UsageFilterPtr& input) {
    return input->get_page();
  }

  static const ::device::mojom::blink::HidUsageAndPagePtr& usage_and_page(const ::blink::mojom::blink::UsageFilterPtr& input) {
    return input->get_usage_and_page();
  }

  static bool Read(::blink::mojom::blink::UsageFilter::DataView input, ::blink::mojom::blink::UsageFilterPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_BLINK_H_