// third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_WRITER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_WRITER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-blink.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_error.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class NativeFileSystemFileWriterProxy;

template <typename ImplRefTraits>
class NativeFileSystemFileWriterStub;

class NativeFileSystemFileWriterRequestValidator;
class NativeFileSystemFileWriterResponseValidator;


class PLATFORM_EXPORT NativeFileSystemFileWriter
    : public NativeFileSystemFileWriterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NativeFileSystemFileWriterInterfaceBase;
  using Proxy_ = NativeFileSystemFileWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeFileSystemFileWriterStub<ImplRefTraits>;

  using RequestValidator_ = NativeFileSystemFileWriterRequestValidator;
  using ResponseValidator_ = NativeFileSystemFileWriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWriteMinVersion = 0,
    kWriteStreamMinVersion = 0,
    kTruncateMinVersion = 0,
    kCloseMinVersion = 0,
  };
  virtual ~NativeFileSystemFileWriter() {}


  using WriteCallback = base::OnceCallback<void(::blink::mojom::blink::NativeFileSystemErrorPtr, uint64_t)>;
  
  virtual void Write(uint64_t offset, ::mojo::PendingRemote<::blink::mojom::blink::Blob> data, WriteCallback callback) = 0;


  using WriteStreamCallback = base::OnceCallback<void(::blink::mojom::blink::NativeFileSystemErrorPtr, uint64_t)>;
  
  virtual void WriteStream(uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle stream, WriteStreamCallback callback) = 0;


  using TruncateCallback = base::OnceCallback<void(::blink::mojom::blink::NativeFileSystemErrorPtr)>;
  
  virtual void Truncate(uint64_t length, TruncateCallback callback) = 0;


  using CloseCallback = base::OnceCallback<void(::blink::mojom::blink::NativeFileSystemErrorPtr)>;
  
  virtual void Close(CloseCallback callback) = 0;
};



class PLATFORM_EXPORT NativeFileSystemFileWriterProxy
    : public NativeFileSystemFileWriter {
 public:
  using InterfaceType = NativeFileSystemFileWriter;

  explicit NativeFileSystemFileWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Write(uint64_t offset, ::mojo::PendingRemote<::blink::mojom::blink::Blob> data, WriteCallback callback) final;
  
  void WriteStream(uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle stream, WriteStreamCallback callback) final;
  
  void Truncate(uint64_t length, TruncateCallback callback) final;
  
  void Close(CloseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT NativeFileSystemFileWriterStubDispatch {
 public:
  static bool Accept(NativeFileSystemFileWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeFileSystemFileWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeFileSystemFileWriter>>
class NativeFileSystemFileWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeFileSystemFileWriterStub() {}
  ~NativeFileSystemFileWriterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemFileWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemFileWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT NativeFileSystemFileWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT NativeFileSystemFileWriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_WRITER_MOJOM_BLINK_H_