// services/viz/public/mojom/compositing/delegated_ink_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_METADATA_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/viz/public/mojom/compositing/delegated_ink_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace viz {
namespace mojom {
class DelegatedInkMetadataDataView;



}  // namespace mojom
}  // namespace viz

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::DelegatedInkMetadataDataView> {
  using Data = ::viz::mojom::internal::DelegatedInkMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz {
namespace mojom {


class DelegatedInkMetadataDataView {
 public:
  DelegatedInkMetadataDataView() {}

  DelegatedInkMetadataDataView(
      internal::DelegatedInkMetadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPointDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPoint(UserType* output) {
    
    auto* pointer = data_->point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  double diameter() const {
    return data_->diameter;
  }
  inline void GetColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadColor(UserType* output) {
    
    auto* pointer = data_->color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, context_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetPresentationAreaDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPresentationArea(UserType* output) {
    
    auto* pointer = data_->presentation_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, context_);
  }
 private:
  internal::DelegatedInkMetadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace viz

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::DelegatedInkMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::DelegatedInkMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::DelegatedInkMetadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::point(input)) in_point = Traits::point(input);
    typename decltype((*output)->point)::BaseType::BufferWriter
        point_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_point, buffer, &point_writer, context);
    (*output)->point.Set(
        point_writer.is_null() ? nullptr : point_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->point.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null point in DelegatedInkMetadata struct");
    (*output)->diameter = Traits::diameter(input);
    decltype(Traits::color(input)) in_color = Traits::color(input);
    typename decltype((*output)->color)::BaseType::BufferWriter
        color_writer;
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
        in_color, buffer, &color_writer, context);
    (*output)->color.Set(
        color_writer.is_null() ? nullptr : color_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color in DelegatedInkMetadata struct");
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    typename decltype((*output)->timestamp)::BaseType::BufferWriter
        timestamp_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_timestamp, buffer, &timestamp_writer, context);
    (*output)->timestamp.Set(
        timestamp_writer.is_null() ? nullptr : timestamp_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in DelegatedInkMetadata struct");
    decltype(Traits::presentation_area(input)) in_presentation_area = Traits::presentation_area(input);
    typename decltype((*output)->presentation_area)::BaseType::BufferWriter
        presentation_area_writer;
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_presentation_area, buffer, &presentation_area_writer, context);
    (*output)->presentation_area.Set(
        presentation_area_writer.is_null() ? nullptr : presentation_area_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->presentation_area.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null presentation_area in DelegatedInkMetadata struct");
  }

  static bool Deserialize(::viz::mojom::internal::DelegatedInkMetadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::DelegatedInkMetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz {
namespace mojom {

inline void DelegatedInkMetadataDataView::GetPointDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->point.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void DelegatedInkMetadataDataView::GetColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, context_);
}
inline void DelegatedInkMetadataDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void DelegatedInkMetadataDataView::GetPresentationAreaDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->presentation_area.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace viz

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_METADATA_MOJOM_SHARED_H_