// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_SHARED_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared-internal.h"
#include "gpu/ipc/common/surface_handle.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_info.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "services/viz/public/mojom/compositing/video_detector_observer.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace viz {
namespace mojom {
class RootCompositorFrameSinkParamsDataView;



}  // namespace mojom
}  // namespace viz

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::RootCompositorFrameSinkParamsDataView> {
  using Data = ::viz::mojom::internal::RootCompositorFrameSinkParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz {
namespace mojom {
// Interface base classes. They are used for type safety check.
class FrameSinkManagerInterfaceBase {};

using FrameSinkManagerPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkManagerInterfaceBase>;
using FrameSinkManagerRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkManagerInterfaceBase>;
using FrameSinkManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkManagerInterfaceBase>;
using FrameSinkManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkManagerInterfaceBase>;
class FrameSinkManagerClientInterfaceBase {};

using FrameSinkManagerClientPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkManagerClientInterfaceBase>;
using FrameSinkManagerClientRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkManagerClientInterfaceBase>;
using FrameSinkManagerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkManagerClientInterfaceBase>;
using FrameSinkManagerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkManagerClientInterfaceBase>;


class RootCompositorFrameSinkParamsDataView {
 public:
  RootCompositorFrameSinkParamsDataView() {}

  RootCompositorFrameSinkParamsDataView(
      internal::RootCompositorFrameSinkParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameSinkId(UserType* output) {
    
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, context_);
  }
  inline void GetWidgetDataView(
      ::gpu::mojom::SurfaceHandleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWidget(UserType* output) {
    
    auto* pointer = data_->widget.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SurfaceHandleDataView>(
        pointer, output, context_);
  }
  bool gpu_compositing() const {
    return data_->gpu_compositing;
  }
  inline void GetRendererSettingsDataView(
      ::viz::mojom::RendererSettingsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRendererSettings(UserType* output) {
    
    auto* pointer = data_->renderer_settings.Get();
    return mojo::internal::Deserialize<::viz::mojom::RendererSettingsDataView>(
        pointer, output, context_);
  }
  bool send_swap_size_notifications() const {
    return data_->send_swap_size_notifications;
  }
  bool disable_frame_rate_limit() const {
    return data_->disable_frame_rate_limit;
  }
  bool use_preferred_interval_for_video() const {
    return data_->use_preferred_interval_for_video;
  }
  uint32_t num_of_frames_to_toggle_interval() const {
    return data_->num_of_frames_to_toggle_interval;
  }
  template <typename UserType>
  UserType TakeCompositorFrameSink() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::CompositorFrameSinkAssociatedRequestDataView>(
            &data_->compositor_frame_sink, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCompositorFrameSinkClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
            &data_->compositor_frame_sink_client, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDisplayPrivate() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::DisplayPrivateAssociatedRequestDataView>(
            &data_->display_private, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDisplayClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::DisplayClientInterfaceBase>>(
            &data_->display_client, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeExternalBeginFrameController() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::ExternalBeginFrameControllerAssociatedRequestDataView>(
            &data_->external_begin_frame_controller, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RootCompositorFrameSinkParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace viz

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::RootCompositorFrameSinkParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::RootCompositorFrameSinkParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::RootCompositorFrameSinkParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
    typename decltype((*output)->frame_sink_id)::BaseType::BufferWriter
        frame_sink_id_writer;
    mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
        in_frame_sink_id, buffer, &frame_sink_id_writer, context);
    (*output)->frame_sink_id.Set(
        frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->frame_sink_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_sink_id in RootCompositorFrameSinkParams struct");
    decltype(Traits::widget(input)) in_widget = Traits::widget(input);
    typename decltype((*output)->widget)::BaseType::BufferWriter
        widget_writer;
    mojo::internal::Serialize<::gpu::mojom::SurfaceHandleDataView>(
        in_widget, buffer, &widget_writer, context);
    (*output)->widget.Set(
        widget_writer.is_null() ? nullptr : widget_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->widget.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null widget in RootCompositorFrameSinkParams struct");
    (*output)->gpu_compositing = Traits::gpu_compositing(input);
    decltype(Traits::renderer_settings(input)) in_renderer_settings = Traits::renderer_settings(input);
    typename decltype((*output)->renderer_settings)::BaseType::BufferWriter
        renderer_settings_writer;
    mojo::internal::Serialize<::viz::mojom::RendererSettingsDataView>(
        in_renderer_settings, buffer, &renderer_settings_writer, context);
    (*output)->renderer_settings.Set(
        renderer_settings_writer.is_null() ? nullptr : renderer_settings_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->renderer_settings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_settings in RootCompositorFrameSinkParams struct");
    (*output)->send_swap_size_notifications = Traits::send_swap_size_notifications(input);
    (*output)->disable_frame_rate_limit = Traits::disable_frame_rate_limit(input);
    (*output)->use_preferred_interval_for_video = Traits::use_preferred_interval_for_video(input);
    (*output)->num_of_frames_to_toggle_interval = Traits::num_of_frames_to_toggle_interval(input);
    decltype(Traits::compositor_frame_sink(input)) in_compositor_frame_sink = Traits::compositor_frame_sink(input);
    mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkAssociatedRequestDataView>(
        in_compositor_frame_sink, &(*output)->compositor_frame_sink, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->compositor_frame_sink),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid compositor_frame_sink in RootCompositorFrameSinkParams struct");
    decltype(Traits::compositor_frame_sink_client(input)) in_compositor_frame_sink_client = Traits::compositor_frame_sink_client(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
        in_compositor_frame_sink_client, &(*output)->compositor_frame_sink_client, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->compositor_frame_sink_client),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid compositor_frame_sink_client in RootCompositorFrameSinkParams struct");
    decltype(Traits::display_private(input)) in_display_private = Traits::display_private(input);
    mojo::internal::Serialize<::viz::mojom::DisplayPrivateAssociatedRequestDataView>(
        in_display_private, &(*output)->display_private, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->display_private),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid display_private in RootCompositorFrameSinkParams struct");
    decltype(Traits::display_client(input)) in_display_client = Traits::display_client(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::DisplayClientInterfaceBase>>(
        in_display_client, &(*output)->display_client, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->display_client),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid display_client in RootCompositorFrameSinkParams struct");
    decltype(Traits::external_begin_frame_controller(input)) in_external_begin_frame_controller = Traits::external_begin_frame_controller(input);
    mojo::internal::Serialize<::viz::mojom::ExternalBeginFrameControllerAssociatedRequestDataView>(
        in_external_begin_frame_controller, &(*output)->external_begin_frame_controller, context);
  }

  static bool Deserialize(::viz::mojom::internal::RootCompositorFrameSinkParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::RootCompositorFrameSinkParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz {
namespace mojom {

inline void RootCompositorFrameSinkParamsDataView::GetFrameSinkIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->frame_sink_id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, context_);
}
inline void RootCompositorFrameSinkParamsDataView::GetWidgetDataView(
    ::gpu::mojom::SurfaceHandleDataView* output) {
  auto pointer = data_->widget.Get();
  *output = ::gpu::mojom::SurfaceHandleDataView(pointer, context_);
}
inline void RootCompositorFrameSinkParamsDataView::GetRendererSettingsDataView(
    ::viz::mojom::RendererSettingsDataView* output) {
  auto pointer = data_->renderer_settings.Get();
  *output = ::viz::mojom::RendererSettingsDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace viz

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_SHARED_H_