// services/video_capture/public/mojom/video_capture_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_CAPTURE_SERVICE_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_CAPTURE_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/video_capture/public/mojom/video_capture_service.mojom-shared.h"
#include "services/video_capture/public/mojom/video_capture_service.mojom-forward.h"
#include "services/video_capture/public/mojom/device_factory.mojom.h"
#include "services/video_capture/public/mojom/testing_controls.mojom.h"
#include "services/video_capture/public/mojom/video_source_provider.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace video_capture {
namespace mojom {

class VideoCaptureServiceProxy;

template <typename ImplRefTraits>
class VideoCaptureServiceStub;

class VideoCaptureServiceRequestValidator;


class  VideoCaptureService
    : public VideoCaptureServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VideoCaptureServiceInterfaceBase;
  using Proxy_ = VideoCaptureServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoCaptureServiceStub<ImplRefTraits>;

  using RequestValidator_ = VideoCaptureServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kConnectToDeviceFactoryMinVersion = 0,
    kConnectToVideoSourceProviderMinVersion = 0,
    kSetRetryCountMinVersion = 0,
    kBindControlsForTestingMinVersion = 0,
  };
  virtual ~VideoCaptureService() {}

  
  virtual void ConnectToDeviceFactory(::mojo::PendingReceiver<::video_capture::mojom::DeviceFactory> receiver) = 0;

  
  virtual void ConnectToVideoSourceProvider(::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> receiver) = 0;

  
  virtual void SetRetryCount(int32_t count) = 0;

  
  virtual void BindControlsForTesting(::mojo::PendingReceiver<::video_capture::mojom::TestingControls> receiver) = 0;
};



class  VideoCaptureServiceProxy
    : public VideoCaptureService {
 public:
  using InterfaceType = VideoCaptureService;

  explicit VideoCaptureServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ConnectToDeviceFactory(::mojo::PendingReceiver<::video_capture::mojom::DeviceFactory> receiver) final;
  
  void ConnectToVideoSourceProvider(::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> receiver) final;
  
  void SetRetryCount(int32_t count) final;
  
  void BindControlsForTesting(::mojo::PendingReceiver<::video_capture::mojom::TestingControls> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoCaptureServiceStubDispatch {
 public:
  static bool Accept(VideoCaptureService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoCaptureService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoCaptureService>>
class VideoCaptureServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoCaptureServiceStub() {}
  ~VideoCaptureServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoCaptureServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoCaptureServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoCaptureServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_CAPTURE_SERVICE_MOJOM_H_