// services/resource_coordinator/public/mojom/resource_coordinator_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/resource_coordinator/public/mojom/resource_coordinator_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/resource_coordinator/public/mojom/resource_coordinator_service.mojom-params-data.h"
#include "services/resource_coordinator/public/mojom/resource_coordinator_service.mojom-shared-message-ids.h"

#include "services/resource_coordinator/public/mojom/resource_coordinator_service.mojom-import-headers.h"


#ifndef SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_RESOURCE_COORDINATOR_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_RESOURCE_COORDINATOR_SERVICE_MOJOM_JUMBO_H_
#endif
namespace resource_coordinator {
namespace mojom {
const char ResourceCoordinatorService::Name_[] = "resource_coordinator.mojom.ResourceCoordinatorService";

ResourceCoordinatorServiceProxy::ResourceCoordinatorServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResourceCoordinatorServiceProxy::BindMemoryInstrumentationCoordinatorController(
    ::mojo::PendingReceiver<::memory_instrumentation::mojom::CoordinatorController> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "resource_coordinator::mojom::ResourceCoordinatorService::BindMemoryInstrumentationCoordinatorController", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::resource_coordinator::mojom::internal::ResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::memory_instrumentation::mojom::CoordinatorControllerInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ResourceCoordinatorService.BindMemoryInstrumentationCoordinatorController request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceCoordinatorService::Name_);
  message.set_method_name("BindMemoryInstrumentationCoordinatorController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceCoordinatorServiceProxy::RegisterHeapProfiler(
    ::mojo::PendingRemote<::memory_instrumentation::mojom::HeapProfiler> in_profiler, ::mojo::PendingReceiver<::memory_instrumentation::mojom::HeapProfilerHelper> in_helper_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "resource_coordinator::mojom::ResourceCoordinatorService::RegisterHeapProfiler", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("profiler", in_profiler.is_valid());
      raw_value->SetBoolean("helper_receiver", in_helper_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResourceCoordinatorService_RegisterHeapProfiler_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::resource_coordinator::mojom::internal::ResourceCoordinatorService_RegisterHeapProfiler_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::memory_instrumentation::mojom::HeapProfilerInterfaceBase>>(
      in_profiler, &params->profiler, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->profiler),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid profiler in ResourceCoordinatorService.RegisterHeapProfiler request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::memory_instrumentation::mojom::HeapProfilerHelperInterfaceBase>>(
      in_helper_receiver, &params->helper_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->helper_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid helper_receiver in ResourceCoordinatorService.RegisterHeapProfiler request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceCoordinatorService::Name_);
  message.set_method_name("RegisterHeapProfiler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ResourceCoordinatorServiceStubDispatch::Accept(
    ResourceCoordinatorService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)resource_coordinator::mojom::ResourceCoordinatorService::BindMemoryInstrumentationCoordinatorController",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)resource_coordinator::mojom::ResourceCoordinatorService::BindMemoryInstrumentationCoordinatorController");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_Params_Data* params =
          reinterpret_cast<internal::ResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::memory_instrumentation::mojom::CoordinatorController> p_receiver{};
      ResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceCoordinatorService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMemoryInstrumentationCoordinatorController(
std::move(p_receiver));
      return true;
    }
    case internal::kResourceCoordinatorService_RegisterHeapProfiler_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)resource_coordinator::mojom::ResourceCoordinatorService::RegisterHeapProfiler",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)resource_coordinator::mojom::ResourceCoordinatorService::RegisterHeapProfiler");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceCoordinatorService_RegisterHeapProfiler_Params_Data* params =
          reinterpret_cast<internal::ResourceCoordinatorService_RegisterHeapProfiler_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::memory_instrumentation::mojom::HeapProfiler> p_profiler{};
      ::mojo::PendingReceiver<::memory_instrumentation::mojom::HeapProfilerHelper> p_helper_receiver{};
      ResourceCoordinatorService_RegisterHeapProfiler_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_profiler =
            input_data_view.TakeProfiler<decltype(p_profiler)>();
      }
      if (success) {
        p_helper_receiver =
            input_data_view.TakeHelperReceiver<decltype(p_helper_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceCoordinatorService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterHeapProfiler(
std::move(p_profiler), 
std::move(p_helper_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ResourceCoordinatorServiceStubDispatch::AcceptWithResponder(
    ResourceCoordinatorService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_Name: {
      break;
    }
    case internal::kResourceCoordinatorService_RegisterHeapProfiler_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kResourceCoordinatorServiceValidationInfo[] = {
    {internal::kResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_Name,
     {&internal::ResourceCoordinatorService_BindMemoryInstrumentationCoordinatorController_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kResourceCoordinatorService_RegisterHeapProfiler_Name,
     {&internal::ResourceCoordinatorService_RegisterHeapProfiler_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ResourceCoordinatorServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::resource_coordinator::mojom::ResourceCoordinatorService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kResourceCoordinatorServiceValidationInfo);
}

}  // namespace mojom
}  // namespace resource_coordinator

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif