// services/network/public/mojom/url_response_head.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/url_response_head.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/http_raw_request_response_info.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "services/network/public/mojom/origin_policy_manager.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"



#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace network {
namespace mojom {
class URLResponseHeadDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::URLResponseHeadDataView> {
  using Data = ::network::mojom::internal::URLResponseHead_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


class URLResponseHeadDataView {
 public:
  URLResponseHeadDataView() {}

  URLResponseHeadDataView(
      internal::URLResponseHead_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRequestTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestTime(UserType* output) {
    
    auto* pointer = data_->request_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseTime(UserType* output) {
    
    auto* pointer = data_->response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, context_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetCharsetDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCharset(UserType* output) {
    
    auto* pointer = data_->charset.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCtPolicyCompliance(UserType* output) const {
    auto data_value = data_->ct_policy_compliance;
    return mojo::internal::Deserialize<::network::mojom::CTPolicyCompliance>(
        data_value, output);
  }

  ::network::mojom::CTPolicyCompliance ct_policy_compliance() const {
    return static_cast<::network::mojom::CTPolicyCompliance>(data_->ct_policy_compliance);
  }
  int64_t content_length() const {
    return data_->content_length;
  }
  int64_t encoded_data_length() const {
    return data_->encoded_data_length;
  }
  int64_t encoded_body_length() const {
    return data_->encoded_body_length;
  }
  bool network_accessed() const {
    return data_->network_accessed;
  }
  int64_t appcache_id() const {
    return data_->appcache_id;
  }
  inline void GetAppcacheManifestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAppcacheManifestUrl(UserType* output) {
    
    auto* pointer = data_->appcache_manifest_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetLoadTimingDataView(
      ::network::mojom::LoadTimingInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLoadTiming(UserType* output) {
    
    auto* pointer = data_->load_timing.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInfoDataView>(
        pointer, output, context_);
  }
  inline void GetRawRequestResponseInfoDataView(
      ::network::mojom::HttpRawRequestResponseInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRawRequestResponseInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::HttpRawRequestResponseInfoDataView, UserType>(),
    "Attempting to read the optional `raw_request_response_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRawRequestResponseInfo` instead "
    "of `ReadRawRequestResponseInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->raw_request_response_info.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRawRequestResponseInfoDataView>(
        pointer, output, context_);
  }
  bool was_fetched_via_spdy() const {
    return data_->was_fetched_via_spdy;
  }
  bool was_alpn_negotiated() const {
    return data_->was_alpn_negotiated;
  }
  bool was_alternate_protocol_available() const {
    return data_->was_alternate_protocol_available;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConnectionInfo(UserType* output) const {
    auto data_value = data_->connection_info;
    return mojo::internal::Deserialize<::network::mojom::ConnectionInfo>(
        data_value, output);
  }

  ::network::mojom::ConnectionInfo connection_info() const {
    return static_cast<::network::mojom::ConnectionInfo>(data_->connection_info);
  }
  inline void GetAlpnNegotiatedProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAlpnNegotiatedProtocol(UserType* output) {
    
    auto* pointer = data_->alpn_negotiated_protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRemoteEndpoint(UserType* output) {
    
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, context_);
  }
  bool was_fetched_via_cache() const {
    return data_->was_fetched_via_cache;
  }
  inline void GetProxyServerDataView(
      ::proxy_resolver::mojom::ProxyServerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProxyServer(UserType* output) {
    
    auto* pointer = data_->proxy_server.Get();
    return mojo::internal::Deserialize<::proxy_resolver::mojom::ProxyServerDataView>(
        pointer, output, context_);
  }
  bool was_fetched_via_service_worker() const {
    return data_->was_fetched_via_service_worker;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadServiceWorkerResponseSource(UserType* output) const {
    auto data_value = data_->service_worker_response_source;
    return mojo::internal::Deserialize<::network::mojom::FetchResponseSource>(
        data_value, output);
  }

  ::network::mojom::FetchResponseSource service_worker_response_source() const {
    return static_cast<::network::mojom::FetchResponseSource>(data_->service_worker_response_source);
  }
  bool was_fallback_required_by_service_worker() const {
    return data_->was_fallback_required_by_service_worker;
  }
  inline void GetUrlListViaServiceWorkerDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrlListViaServiceWorker(UserType* output) {
    
    auto* pointer = data_->url_list_via_service_worker.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseType(UserType* output) const {
    auto data_value = data_->response_type;
    return mojo::internal::Deserialize<::network::mojom::FetchResponseType>(
        data_value, output);
  }

  ::network::mojom::FetchResponseType response_type() const {
    return static_cast<::network::mojom::FetchResponseType>(data_->response_type);
  }
  int64_t padding() const {
    return data_->padding;
  }
  inline void GetCacheStorageCacheNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCacheStorageCacheName(UserType* output) {
    
    auto* pointer = data_->cache_storage_cache_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  uint32_t cert_status() const {
    return data_->cert_status;
  }
  inline void GetSslInfoDataView(
      ::network::mojom::SSLInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSslInfo(UserType* output) {
    
    auto* pointer = data_->ssl_info.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLInfoDataView>(
        pointer, output, context_);
  }
  inline void GetCorsExposedHeaderNamesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCorsExposedHeaderNames(UserType* output) {
    
    auto* pointer = data_->cors_exposed_header_names.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  bool did_service_worker_navigation_preload() const {
    return data_->did_service_worker_navigation_preload;
  }
  bool should_report_corb_blocking() const {
    return data_->should_report_corb_blocking;
  }
  bool async_revalidation_requested() const {
    return data_->async_revalidation_requested;
  }
  bool did_mime_sniff() const {
    return data_->did_mime_sniff;
  }
  bool is_signed_exchange_inner_response() const {
    return data_->is_signed_exchange_inner_response;
  }
  bool was_in_prefetch_cache() const {
    return data_->was_in_prefetch_cache;
  }
  bool was_cookie_in_request() const {
    return data_->was_cookie_in_request;
  }
  bool intercepted_by_plugin() const {
    return data_->intercepted_by_plugin;
  }
  bool is_legacy_tls_version() const {
    return data_->is_legacy_tls_version;
  }
  bool has_range_requested() const {
    return data_->has_range_requested;
  }
  bool timing_allow_passed() const {
    return data_->timing_allow_passed;
  }
  inline void GetAuthChallengeInfoDataView(
      ::network::mojom::AuthChallengeInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAuthChallengeInfo(UserType* output) {
    
    auto* pointer = data_->auth_challenge_info.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthChallengeInfoDataView>(
        pointer, output, context_);
  }
  inline void GetRequestStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestStart(UserType* output) {
    
    auto* pointer = data_->request_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetResponseStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseStart(UserType* output) {
    
    auto* pointer = data_->response_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetParsedHeadersDataView(
      ::network::mojom::ParsedHeadersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParsedHeaders(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ParsedHeadersDataView, UserType>(),
    "Attempting to read the optional `parsed_headers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParsedHeaders` instead "
    "of `ReadParsedHeaders if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parsed_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::ParsedHeadersDataView>(
        pointer, output, context_);
  }
  inline void GetOriginPolicyDataView(
      ::network::mojom::OriginPolicyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginPolicy(UserType* output) {
    
    auto* pointer = data_->origin_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::OriginPolicyDataView>(
        pointer, output, context_);
  }
  inline void GetRecursivePrefetchTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRecursivePrefetchToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `recursive_prefetch_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecursivePrefetchToken` instead "
    "of `ReadRecursivePrefetchToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recursive_prefetch_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::URLResponseHead_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLResponseHeadDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLResponseHeadDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::URLResponseHead_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::request_time(input)) in_request_time = Traits::request_time(input);
    typename decltype((*output)->request_time)::BaseType::BufferWriter
        request_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_request_time, buffer, &request_time_writer, context);
    (*output)->request_time.Set(
        request_time_writer.is_null() ? nullptr : request_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->request_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_time in URLResponseHead struct");
    decltype(Traits::response_time(input)) in_response_time = Traits::response_time(input);
    typename decltype((*output)->response_time)::BaseType::BufferWriter
        response_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_response_time, buffer, &response_time_writer, context);
    (*output)->response_time.Set(
        response_time_writer.is_null() ? nullptr : response_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->response_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_time in URLResponseHead struct");
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    typename decltype((*output)->headers)::BaseType::BufferWriter
        headers_writer;
    mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
        in_headers, buffer, &headers_writer, context);
    (*output)->headers.Set(
        headers_writer.is_null() ? nullptr : headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in URLResponseHead struct");
    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    typename decltype((*output)->mime_type)::BaseType::BufferWriter
        mime_type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mime_type, buffer, &mime_type_writer, context);
    (*output)->mime_type.Set(
        mime_type_writer.is_null() ? nullptr : mime_type_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mime_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in URLResponseHead struct");
    decltype(Traits::charset(input)) in_charset = Traits::charset(input);
    typename decltype((*output)->charset)::BaseType::BufferWriter
        charset_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_charset, buffer, &charset_writer, context);
    (*output)->charset.Set(
        charset_writer.is_null() ? nullptr : charset_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->charset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null charset in URLResponseHead struct");
    mojo::internal::Serialize<::network::mojom::CTPolicyCompliance>(
        Traits::ct_policy_compliance(input), &(*output)->ct_policy_compliance);
    (*output)->content_length = Traits::content_length(input);
    (*output)->encoded_data_length = Traits::encoded_data_length(input);
    (*output)->encoded_body_length = Traits::encoded_body_length(input);
    (*output)->network_accessed = Traits::network_accessed(input);
    (*output)->appcache_id = Traits::appcache_id(input);
    decltype(Traits::appcache_manifest_url(input)) in_appcache_manifest_url = Traits::appcache_manifest_url(input);
    typename decltype((*output)->appcache_manifest_url)::BaseType::BufferWriter
        appcache_manifest_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_appcache_manifest_url, buffer, &appcache_manifest_url_writer, context);
    (*output)->appcache_manifest_url.Set(
        appcache_manifest_url_writer.is_null() ? nullptr : appcache_manifest_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->appcache_manifest_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null appcache_manifest_url in URLResponseHead struct");
    decltype(Traits::load_timing(input)) in_load_timing = Traits::load_timing(input);
    typename decltype((*output)->load_timing)::BaseType::BufferWriter
        load_timing_writer;
    mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView>(
        in_load_timing, buffer, &load_timing_writer, context);
    (*output)->load_timing.Set(
        load_timing_writer.is_null() ? nullptr : load_timing_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->load_timing.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null load_timing in URLResponseHead struct");
    decltype(Traits::raw_request_response_info(input)) in_raw_request_response_info = Traits::raw_request_response_info(input);
    typename decltype((*output)->raw_request_response_info)::BaseType::BufferWriter
        raw_request_response_info_writer;
    mojo::internal::Serialize<::network::mojom::HttpRawRequestResponseInfoDataView>(
        in_raw_request_response_info, buffer, &raw_request_response_info_writer, context);
    (*output)->raw_request_response_info.Set(
        raw_request_response_info_writer.is_null() ? nullptr : raw_request_response_info_writer.data());
    (*output)->was_fetched_via_spdy = Traits::was_fetched_via_spdy(input);
    (*output)->was_alpn_negotiated = Traits::was_alpn_negotiated(input);
    (*output)->was_alternate_protocol_available = Traits::was_alternate_protocol_available(input);
    mojo::internal::Serialize<::network::mojom::ConnectionInfo>(
        Traits::connection_info(input), &(*output)->connection_info);
    decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
    typename decltype((*output)->alpn_negotiated_protocol)::BaseType::BufferWriter
        alpn_negotiated_protocol_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_alpn_negotiated_protocol, buffer, &alpn_negotiated_protocol_writer, context);
    (*output)->alpn_negotiated_protocol.Set(
        alpn_negotiated_protocol_writer.is_null() ? nullptr : alpn_negotiated_protocol_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->alpn_negotiated_protocol.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alpn_negotiated_protocol in URLResponseHead struct");
    decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
    typename decltype((*output)->remote_endpoint)::BaseType::BufferWriter
        remote_endpoint_writer;
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
        in_remote_endpoint, buffer, &remote_endpoint_writer, context);
    (*output)->remote_endpoint.Set(
        remote_endpoint_writer.is_null() ? nullptr : remote_endpoint_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->remote_endpoint.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null remote_endpoint in URLResponseHead struct");
    (*output)->was_fetched_via_cache = Traits::was_fetched_via_cache(input);
    decltype(Traits::proxy_server(input)) in_proxy_server = Traits::proxy_server(input);
    typename decltype((*output)->proxy_server)::BaseType::BufferWriter
        proxy_server_writer;
    mojo::internal::Serialize<::proxy_resolver::mojom::ProxyServerDataView>(
        in_proxy_server, buffer, &proxy_server_writer, context);
    (*output)->proxy_server.Set(
        proxy_server_writer.is_null() ? nullptr : proxy_server_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->proxy_server.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxy_server in URLResponseHead struct");
    (*output)->was_fetched_via_service_worker = Traits::was_fetched_via_service_worker(input);
    mojo::internal::Serialize<::network::mojom::FetchResponseSource>(
        Traits::service_worker_response_source(input), &(*output)->service_worker_response_source);
    (*output)->was_fallback_required_by_service_worker = Traits::was_fallback_required_by_service_worker(input);
    decltype(Traits::url_list_via_service_worker(input)) in_url_list_via_service_worker = Traits::url_list_via_service_worker(input);
    typename decltype((*output)->url_list_via_service_worker)::BaseType::BufferWriter
        url_list_via_service_worker_writer;
    const mojo::internal::ContainerValidateParams url_list_via_service_worker_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_url_list_via_service_worker, buffer, &url_list_via_service_worker_writer, &url_list_via_service_worker_validate_params,
        context);
    (*output)->url_list_via_service_worker.Set(
        url_list_via_service_worker_writer.is_null() ? nullptr : url_list_via_service_worker_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url_list_via_service_worker.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url_list_via_service_worker in URLResponseHead struct");
    mojo::internal::Serialize<::network::mojom::FetchResponseType>(
        Traits::response_type(input), &(*output)->response_type);
    (*output)->padding = Traits::padding(input);
    decltype(Traits::cache_storage_cache_name(input)) in_cache_storage_cache_name = Traits::cache_storage_cache_name(input);
    typename decltype((*output)->cache_storage_cache_name)::BaseType::BufferWriter
        cache_storage_cache_name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_cache_storage_cache_name, buffer, &cache_storage_cache_name_writer, context);
    (*output)->cache_storage_cache_name.Set(
        cache_storage_cache_name_writer.is_null() ? nullptr : cache_storage_cache_name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cache_storage_cache_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cache_storage_cache_name in URLResponseHead struct");
    (*output)->cert_status = Traits::cert_status(input);
    decltype(Traits::ssl_info(input)) in_ssl_info = Traits::ssl_info(input);
    typename decltype((*output)->ssl_info)::BaseType::BufferWriter
        ssl_info_writer;
    mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
        in_ssl_info, buffer, &ssl_info_writer, context);
    (*output)->ssl_info.Set(
        ssl_info_writer.is_null() ? nullptr : ssl_info_writer.data());
    decltype(Traits::cors_exposed_header_names(input)) in_cors_exposed_header_names = Traits::cors_exposed_header_names(input);
    typename decltype((*output)->cors_exposed_header_names)::BaseType::BufferWriter
        cors_exposed_header_names_writer;
    const mojo::internal::ContainerValidateParams cors_exposed_header_names_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_cors_exposed_header_names, buffer, &cors_exposed_header_names_writer, &cors_exposed_header_names_validate_params,
        context);
    (*output)->cors_exposed_header_names.Set(
        cors_exposed_header_names_writer.is_null() ? nullptr : cors_exposed_header_names_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cors_exposed_header_names.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cors_exposed_header_names in URLResponseHead struct");
    (*output)->did_service_worker_navigation_preload = Traits::did_service_worker_navigation_preload(input);
    (*output)->should_report_corb_blocking = Traits::should_report_corb_blocking(input);
    (*output)->async_revalidation_requested = Traits::async_revalidation_requested(input);
    (*output)->did_mime_sniff = Traits::did_mime_sniff(input);
    (*output)->is_signed_exchange_inner_response = Traits::is_signed_exchange_inner_response(input);
    (*output)->was_in_prefetch_cache = Traits::was_in_prefetch_cache(input);
    (*output)->was_cookie_in_request = Traits::was_cookie_in_request(input);
    (*output)->intercepted_by_plugin = Traits::intercepted_by_plugin(input);
    (*output)->is_legacy_tls_version = Traits::is_legacy_tls_version(input);
    (*output)->has_range_requested = Traits::has_range_requested(input);
    (*output)->timing_allow_passed = Traits::timing_allow_passed(input);
    decltype(Traits::auth_challenge_info(input)) in_auth_challenge_info = Traits::auth_challenge_info(input);
    typename decltype((*output)->auth_challenge_info)::BaseType::BufferWriter
        auth_challenge_info_writer;
    mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
        in_auth_challenge_info, buffer, &auth_challenge_info_writer, context);
    (*output)->auth_challenge_info.Set(
        auth_challenge_info_writer.is_null() ? nullptr : auth_challenge_info_writer.data());
    decltype(Traits::request_start(input)) in_request_start = Traits::request_start(input);
    typename decltype((*output)->request_start)::BaseType::BufferWriter
        request_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_request_start, buffer, &request_start_writer, context);
    (*output)->request_start.Set(
        request_start_writer.is_null() ? nullptr : request_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->request_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_start in URLResponseHead struct");
    decltype(Traits::response_start(input)) in_response_start = Traits::response_start(input);
    typename decltype((*output)->response_start)::BaseType::BufferWriter
        response_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_response_start, buffer, &response_start_writer, context);
    (*output)->response_start.Set(
        response_start_writer.is_null() ? nullptr : response_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->response_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_start in URLResponseHead struct");
    decltype(Traits::parsed_headers(input)) in_parsed_headers = Traits::parsed_headers(input);
    typename decltype((*output)->parsed_headers)::BaseType::BufferWriter
        parsed_headers_writer;
    mojo::internal::Serialize<::network::mojom::ParsedHeadersDataView>(
        in_parsed_headers, buffer, &parsed_headers_writer, context);
    (*output)->parsed_headers.Set(
        parsed_headers_writer.is_null() ? nullptr : parsed_headers_writer.data());
    decltype(Traits::origin_policy(input)) in_origin_policy = Traits::origin_policy(input);
    typename decltype((*output)->origin_policy)::BaseType::BufferWriter
        origin_policy_writer;
    mojo::internal::Serialize<::network::mojom::OriginPolicyDataView>(
        in_origin_policy, buffer, &origin_policy_writer, context);
    (*output)->origin_policy.Set(
        origin_policy_writer.is_null() ? nullptr : origin_policy_writer.data());
    decltype(Traits::recursive_prefetch_token(input)) in_recursive_prefetch_token = Traits::recursive_prefetch_token(input);
    typename decltype((*output)->recursive_prefetch_token)::BaseType::BufferWriter
        recursive_prefetch_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_recursive_prefetch_token, buffer, &recursive_prefetch_token_writer, context);
    (*output)->recursive_prefetch_token.Set(
        recursive_prefetch_token_writer.is_null() ? nullptr : recursive_prefetch_token_writer.data());
  }

  static bool Deserialize(::network::mojom::internal::URLResponseHead_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLResponseHeadDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void URLResponseHeadDataView::GetRequestTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->request_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetResponseTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->response_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetCharsetDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->charset.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetAppcacheManifestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->appcache_manifest_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetLoadTimingDataView(
    ::network::mojom::LoadTimingInfoDataView* output) {
  auto pointer = data_->load_timing.Get();
  *output = ::network::mojom::LoadTimingInfoDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetRawRequestResponseInfoDataView(
    ::network::mojom::HttpRawRequestResponseInfoDataView* output) {
  auto pointer = data_->raw_request_response_info.Get();
  *output = ::network::mojom::HttpRawRequestResponseInfoDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetAlpnNegotiatedProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->alpn_negotiated_protocol.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetRemoteEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetProxyServerDataView(
    ::proxy_resolver::mojom::ProxyServerDataView* output) {
  auto pointer = data_->proxy_server.Get();
  *output = ::proxy_resolver::mojom::ProxyServerDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetUrlListViaServiceWorkerDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->url_list_via_service_worker.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, context_);
}
inline void URLResponseHeadDataView::GetCacheStorageCacheNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cache_storage_cache_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetSslInfoDataView(
    ::network::mojom::SSLInfoDataView* output) {
  auto pointer = data_->ssl_info.Get();
  *output = ::network::mojom::SSLInfoDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetCorsExposedHeaderNamesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cors_exposed_header_names.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void URLResponseHeadDataView::GetAuthChallengeInfoDataView(
    ::network::mojom::AuthChallengeInfoDataView* output) {
  auto pointer = data_->auth_challenge_info.Get();
  *output = ::network::mojom::AuthChallengeInfoDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetRequestStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->request_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetResponseStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->response_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetParsedHeadersDataView(
    ::network::mojom::ParsedHeadersDataView* output) {
  auto pointer = data_->parsed_headers.Get();
  *output = ::network::mojom::ParsedHeadersDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetOriginPolicyDataView(
    ::network::mojom::OriginPolicyDataView* output) {
  auto pointer = data_->origin_policy.Get();
  *output = ::network::mojom::OriginPolicyDataView(pointer, context_);
}
inline void URLResponseHeadDataView::GetRecursivePrefetchTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->recursive_prefetch_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_H_