// services/network/public/mojom/parsed_headers.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-forward.h"
#include <string>
#include <vector>







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {








class  ParsedHeaders {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ParsedHeaders, T>::value>;
  using DataView = ParsedHeadersDataView;
  using Data_ = internal::ParsedHeaders_Data;

  template <typename... Args>
  static ParsedHeadersPtr New(Args&&... args) {
    return ParsedHeadersPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParsedHeadersPtr From(const U& u) {
    return mojo::TypeConverter<ParsedHeadersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParsedHeaders>::Convert(*this);
  }


  ParsedHeaders();

  ParsedHeaders(
      std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policy,
      ::network::mojom::AllowCSPFromHeaderValuePtr allow_csp_from,
      const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy,
      const ::network::CrossOriginOpenerPolicy& cross_origin_opener_policy,
      bool origin_isolation,
      base::Optional<std::vector<::network::mojom::WebClientHintsType>> accept_ch,
      ::base::TimeDelta accept_ch_lifetime);

  ~ParsedHeaders();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParsedHeadersPtr>
  ParsedHeadersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsedHeaders::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParsedHeaders::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ParsedHeaders_UnserializedMessageContext<
            UserType, ParsedHeaders::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ParsedHeaders::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ParsedHeaders::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ParsedHeaders_UnserializedMessageContext<
            UserType, ParsedHeaders::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ParsedHeaders::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policy;
  
  ::network::mojom::AllowCSPFromHeaderValuePtr allow_csp_from;
  
  ::network::CrossOriginEmbedderPolicy cross_origin_embedder_policy;
  
  ::network::CrossOriginOpenerPolicy cross_origin_opener_policy;
  
  bool origin_isolation;
  
  base::Optional<std::vector<::network::mojom::WebClientHintsType>> accept_ch;
  
  ::base::TimeDelta accept_ch_lifetime;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ParsedHeaders);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ParsedHeadersPtr ParsedHeaders::Clone() const {
  return New(
      mojo::Clone(content_security_policy),
      mojo::Clone(allow_csp_from),
      mojo::Clone(cross_origin_embedder_policy),
      mojo::Clone(cross_origin_opener_policy),
      mojo::Clone(origin_isolation),
      mojo::Clone(accept_ch),
      mojo::Clone(accept_ch_lifetime)
  );
}

template <typename T, ParsedHeaders::EnableIfSame<T>*>
bool ParsedHeaders::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content_security_policy, other_struct.content_security_policy))
    return false;
  if (!mojo::Equals(this->allow_csp_from, other_struct.allow_csp_from))
    return false;
  if (!mojo::Equals(this->cross_origin_embedder_policy, other_struct.cross_origin_embedder_policy))
    return false;
  if (!mojo::Equals(this->cross_origin_opener_policy, other_struct.cross_origin_opener_policy))
    return false;
  if (!mojo::Equals(this->origin_isolation, other_struct.origin_isolation))
    return false;
  if (!mojo::Equals(this->accept_ch, other_struct.accept_ch))
    return false;
  if (!mojo::Equals(this->accept_ch_lifetime, other_struct.accept_ch_lifetime))
    return false;
  return true;
}

template <typename T, ParsedHeaders::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.content_security_policy, rhs.content_security_policy))
    return true;
  if (std::less<>{}(rhs.content_security_policy, lhs.content_security_policy))
    return false;
  if (std::less<>{}(lhs.allow_csp_from, rhs.allow_csp_from))
    return true;
  if (std::less<>{}(rhs.allow_csp_from, lhs.allow_csp_from))
    return false;
  if (std::less<>{}(lhs.cross_origin_embedder_policy, rhs.cross_origin_embedder_policy))
    return true;
  if (std::less<>{}(rhs.cross_origin_embedder_policy, lhs.cross_origin_embedder_policy))
    return false;
  if (std::less<>{}(lhs.cross_origin_opener_policy, rhs.cross_origin_opener_policy))
    return true;
  if (std::less<>{}(rhs.cross_origin_opener_policy, lhs.cross_origin_opener_policy))
    return false;
  if (std::less<>{}(lhs.origin_isolation, rhs.origin_isolation))
    return true;
  if (std::less<>{}(rhs.origin_isolation, lhs.origin_isolation))
    return false;
  if (std::less<>{}(lhs.accept_ch, rhs.accept_ch))
    return true;
  if (std::less<>{}(rhs.accept_ch, lhs.accept_ch))
    return false;
  if (std::less<>{}(lhs.accept_ch_lifetime, rhs.accept_ch_lifetime))
    return true;
  if (std::less<>{}(rhs.accept_ch_lifetime, lhs.accept_ch_lifetime))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ParsedHeaders::DataView,
                                         ::network::mojom::ParsedHeadersPtr> {
  static bool IsNull(const ::network::mojom::ParsedHeadersPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ParsedHeadersPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ParsedHeaders::content_security_policy)& content_security_policy(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->content_security_policy;
  }

  static const decltype(::network::mojom::ParsedHeaders::allow_csp_from)& allow_csp_from(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->allow_csp_from;
  }

  static const decltype(::network::mojom::ParsedHeaders::cross_origin_embedder_policy)& cross_origin_embedder_policy(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->cross_origin_embedder_policy;
  }

  static const decltype(::network::mojom::ParsedHeaders::cross_origin_opener_policy)& cross_origin_opener_policy(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->cross_origin_opener_policy;
  }

  static decltype(::network::mojom::ParsedHeaders::origin_isolation) origin_isolation(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->origin_isolation;
  }

  static const decltype(::network::mojom::ParsedHeaders::accept_ch)& accept_ch(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->accept_ch;
  }

  static const decltype(::network::mojom::ParsedHeaders::accept_ch_lifetime)& accept_ch_lifetime(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->accept_ch_lifetime;
  }

  static bool Read(::network::mojom::ParsedHeaders::DataView input, ::network::mojom::ParsedHeadersPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_H_