// services/network/public/mojom/http_raw_request_response_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/http_raw_request_response_info.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/http_raw_request_response_info.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool HttpRawRequestResponseInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HttpRawRequestResponseInfo_Data* object = static_cast<const HttpRawRequestResponseInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 56 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_status_text, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams http_status_text_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->http_status_text, validation_context,
                                         &http_status_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_headers, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams request_headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->request_headers, validation_context,
                                         &request_headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_headers, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams response_headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->response_headers, validation_context,
                                         &response_headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_headers_text, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams request_headers_text_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->request_headers_text, validation_context,
                                         &request_headers_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_headers_text, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams response_headers_text_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->response_headers_text, validation_context,
                                         &response_headers_text_validate_params)) {
    return false;
  }

  return true;
}

HttpRawRequestResponseInfo_Data::HttpRawRequestResponseInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network