// services/network/public/mojom/cookie_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace network {
namespace mojom {
class CookieManagerParamsDataView;

class CookieSameSiteContextDataView;

class CookieOptionsDataView;

class CanonicalCookieDataView;

class CookieInclusionStatusDataView;

class CookieAndLineWithAccessResultDataView;

class CookieAccessResultDataView;

class CookieWithAccessResultDataView;

class CookieChangeInfoDataView;

class CookieDeletionFilterDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CookieManagerParamsDataView> {
  using Data = ::network::mojom::internal::CookieManagerParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieSameSiteContextDataView> {
  using Data = ::network::mojom::internal::CookieSameSiteContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieOptionsDataView> {
  using Data = ::network::mojom::internal::CookieOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CanonicalCookieDataView> {
  using Data = ::network::mojom::internal::CanonicalCookie_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieInclusionStatusDataView> {
  using Data = ::network::mojom::internal::CookieInclusionStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieAndLineWithAccessResultDataView> {
  using Data = ::network::mojom::internal::CookieAndLineWithAccessResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieAccessResultDataView> {
  using Data = ::network::mojom::internal::CookieAccessResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieWithAccessResultDataView> {
  using Data = ::network::mojom::internal::CookieWithAccessResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieChangeInfoDataView> {
  using Data = ::network::mojom::internal::CookieChangeInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookieDeletionFilterDataView> {
  using Data = ::network::mojom::internal::CookieDeletionFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


enum class CookieAccessDelegateType : int32_t {
  
  USE_CONTENT_SETTINGS = 0,
  
  ALWAYS_LEGACY = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CookieAccessDelegateType value);
inline bool IsKnownEnumValue(CookieAccessDelegateType value) {
  return internal::CookieAccessDelegateType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookiePriority : int32_t {
  
  LOW = 0,
  
  MEDIUM = 1,
  
  HIGH = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookiePriority value);
inline bool IsKnownEnumValue(CookiePriority value) {
  return internal::CookiePriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieSourceScheme : int32_t {
  
  kUnset = 0,
  
  kNonSecure = 1,
  
  kSecure = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookieSourceScheme value);
inline bool IsKnownEnumValue(CookieSourceScheme value) {
  return internal::CookieSourceScheme_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieSameSite : int32_t {
  
  UNSPECIFIED = -1,
  
  NO_RESTRICTION = 0,
  
  LAX_MODE = 1,
  
  STRICT_MODE = 2,
  kMinValue = -1,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookieSameSite value);
inline bool IsKnownEnumValue(CookieSameSite value) {
  return internal::CookieSameSite_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieEffectiveSameSite : int32_t {
  
  kNoRestriction = 0,
  
  kLaxMode = 1,
  
  kStrictMode = 2,
  
  kLaxModeAllowUnsafe = 3,
  
  kUndefined = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, CookieEffectiveSameSite value);
inline bool IsKnownEnumValue(CookieEffectiveSameSite value) {
  return internal::CookieEffectiveSameSite_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContextType : int32_t {
  
  CROSS_SITE = 0,
  
  SAME_SITE_LAX_METHOD_UNSAFE = 1,
  
  SAME_SITE_LAX = 2,
  
  SAME_SITE_STRICT = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ContextType value);
inline bool IsKnownEnumValue(ContextType value) {
  return internal::ContextType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieAccessSemantics : int32_t {
  
  UNKNOWN = -1,
  
  NONLEGACY = 0,
  
  LEGACY = 1,
  kMinValue = -1,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CookieAccessSemantics value);
inline bool IsKnownEnumValue(CookieAccessSemantics value) {
  return internal::CookieAccessSemantics_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieChangeCause : int32_t {
  
  INSERTED = 0,
  
  EXPLICIT = 1,
  
  UNKNOWN_DELETION = 2,
  
  OVERWRITE = 3,
  
  EXPIRED = 4,
  
  EVICTED = 5,
  
  EXPIRED_OVERWRITE = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, CookieChangeCause value);
inline bool IsKnownEnumValue(CookieChangeCause value) {
  return internal::CookieChangeCause_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieDeletionSessionControl : int32_t {
  
  IGNORE_CONTROL = 0,
  
  SESSION_COOKIES = 1,
  
  PERSISTENT_COOKIES = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CookieDeletionSessionControl value);
inline bool IsKnownEnumValue(CookieDeletionSessionControl value) {
  return internal::CookieDeletionSessionControl_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CookieChangeListenerInterfaceBase {};

using CookieChangeListenerPtrDataView =
    mojo::InterfacePtrDataView<CookieChangeListenerInterfaceBase>;
using CookieChangeListenerRequestDataView =
    mojo::InterfaceRequestDataView<CookieChangeListenerInterfaceBase>;
using CookieChangeListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CookieChangeListenerInterfaceBase>;
using CookieChangeListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CookieChangeListenerInterfaceBase>;
class CookieRemoteAccessFilterInterfaceBase {};

using CookieRemoteAccessFilterPtrDataView =
    mojo::InterfacePtrDataView<CookieRemoteAccessFilterInterfaceBase>;
using CookieRemoteAccessFilterRequestDataView =
    mojo::InterfaceRequestDataView<CookieRemoteAccessFilterInterfaceBase>;
using CookieRemoteAccessFilterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CookieRemoteAccessFilterInterfaceBase>;
using CookieRemoteAccessFilterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CookieRemoteAccessFilterInterfaceBase>;
class CookieManagerInterfaceBase {};

using CookieManagerPtrDataView =
    mojo::InterfacePtrDataView<CookieManagerInterfaceBase>;
using CookieManagerRequestDataView =
    mojo::InterfaceRequestDataView<CookieManagerInterfaceBase>;
using CookieManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CookieManagerInterfaceBase>;
using CookieManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CookieManagerInterfaceBase>;


class CookieManagerParamsDataView {
 public:
  CookieManagerParamsDataView() {}

  CookieManagerParamsDataView(
      internal::CookieManagerParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool block_third_party_cookies() const {
    return data_->block_third_party_cookies;
  }
  inline void GetSettingsDataView(
      mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        pointer, output, context_);
  }
  inline void GetSecureOriginCookiesAllowedSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSecureOriginCookiesAllowedSchemes(UserType* output) {
    
    auto* pointer = data_->secure_origin_cookies_allowed_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetMatchingSchemeCookiesAllowedSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMatchingSchemeCookiesAllowedSchemes(UserType* output) {
    
    auto* pointer = data_->matching_scheme_cookies_allowed_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetThirdPartyCookiesAllowedSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadThirdPartyCookiesAllowedSchemes(UserType* output) {
    
    auto* pointer = data_->third_party_cookies_allowed_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  bool allow_file_scheme_cookies() const {
    return data_->allow_file_scheme_cookies;
  }
  inline void GetSettingsForLegacyCookieAccessDataView(
      mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSettingsForLegacyCookieAccess(UserType* output) {
    
    auto* pointer = data_->settings_for_legacy_cookie_access.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        pointer, output, context_);
  }
  inline void GetSettingsForStorageAccessDataView(
      mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSettingsForStorageAccess(UserType* output) {
    
    auto* pointer = data_->settings_for_storage_access.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookieAccessDelegateType(UserType* output) const {
    auto data_value = data_->cookie_access_delegate_type;
    return mojo::internal::Deserialize<::network::mojom::CookieAccessDelegateType>(
        data_value, output);
  }

  CookieAccessDelegateType cookie_access_delegate_type() const {
    return static_cast<CookieAccessDelegateType>(data_->cookie_access_delegate_type);
  }
 private:
  internal::CookieManagerParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CookieSameSiteContextDataView {
 public:
  CookieSameSiteContextDataView() {}

  CookieSameSiteContextDataView(
      internal::CookieSameSiteContext_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContext(UserType* output) const {
    auto data_value = data_->context;
    return mojo::internal::Deserialize<::network::mojom::ContextType>(
        data_value, output);
  }

  ContextType context() const {
    return static_cast<ContextType>(data_->context);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSchemefulContext(UserType* output) const {
    auto data_value = data_->schemeful_context;
    return mojo::internal::Deserialize<::network::mojom::ContextType>(
        data_value, output);
  }

  ContextType schemeful_context() const {
    return static_cast<ContextType>(data_->schemeful_context);
  }
 private:
  internal::CookieSameSiteContext_Data* data_ = nullptr;
};



class CookieOptionsDataView {
 public:
  CookieOptionsDataView() {}

  CookieOptionsDataView(
      internal::CookieOptions_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool exclude_httponly() const {
    return data_->exclude_httponly;
  }
  inline void GetSameSiteCookieContextDataView(
      CookieSameSiteContextDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSameSiteCookieContext(UserType* output) {
    
    auto* pointer = data_->same_site_cookie_context.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSameSiteContextDataView>(
        pointer, output, context_);
  }
  bool update_access_time() const {
    return data_->update_access_time;
  }
  bool return_excluded_cookies() const {
    return data_->return_excluded_cookies;
  }
 private:
  internal::CookieOptions_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CanonicalCookieDataView {
 public:
  CanonicalCookieDataView() {}

  CanonicalCookieDataView(
      internal::CanonicalCookie_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetCreationDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCreation(UserType* output) {
    
    auto* pointer = data_->creation.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetExpiryDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExpiry(UserType* output) {
    
    auto* pointer = data_->expiry.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetLastAccessDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLastAccess(UserType* output) {
    
    auto* pointer = data_->last_access.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  bool secure() const {
    return data_->secure;
  }
  bool httponly() const {
    return data_->httponly;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSiteRestrictions(UserType* output) const {
    auto data_value = data_->site_restrictions;
    return mojo::internal::Deserialize<::network::mojom::CookieSameSite>(
        data_value, output);
  }

  CookieSameSite site_restrictions() const {
    return static_cast<CookieSameSite>(data_->site_restrictions);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::CookiePriority>(
        data_value, output);
  }

  CookiePriority priority() const {
    return static_cast<CookiePriority>(data_->priority);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceScheme(UserType* output) const {
    auto data_value = data_->source_scheme;
    return mojo::internal::Deserialize<::network::mojom::CookieSourceScheme>(
        data_value, output);
  }

  CookieSourceScheme source_scheme() const {
    return static_cast<CookieSourceScheme>(data_->source_scheme);
  }
 private:
  internal::CanonicalCookie_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CookieInclusionStatusDataView {
 public:
  CookieInclusionStatusDataView() {}

  CookieInclusionStatusDataView(
      internal::CookieInclusionStatus_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t exclusion_reasons() const {
    return data_->exclusion_reasons;
  }
  uint32_t warning_reasons() const {
    return data_->warning_reasons;
  }
 private:
  internal::CookieInclusionStatus_Data* data_ = nullptr;
};



class CookieAndLineWithAccessResultDataView {
 public:
  CookieAndLineWithAccessResultDataView() {}

  CookieAndLineWithAccessResultDataView(
      internal::CookieAndLineWithAccessResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookie(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CanonicalCookieDataView, UserType>(),
    "Attempting to read the optional `cookie` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookie` instead "
    "of `ReadCookie if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, context_);
  }
  inline void GetCookieStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookieString(UserType* output) {
    
    auto* pointer = data_->cookie_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetAccessResultDataView(
      CookieAccessResultDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAccessResult(UserType* output) {
    
    auto* pointer = data_->access_result.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieAccessResultDataView>(
        pointer, output, context_);
  }
 private:
  internal::CookieAndLineWithAccessResult_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CookieAccessResultDataView {
 public:
  CookieAccessResultDataView() {}

  CookieAccessResultDataView(
      internal::CookieAccessResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEffectiveSameSite(UserType* output) const {
    auto data_value = data_->effective_same_site;
    return mojo::internal::Deserialize<::network::mojom::CookieEffectiveSameSite>(
        data_value, output);
  }

  CookieEffectiveSameSite effective_same_site() const {
    return static_cast<CookieEffectiveSameSite>(data_->effective_same_site);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAccessSemantics(UserType* output) const {
    auto data_value = data_->access_semantics;
    return mojo::internal::Deserialize<::network::mojom::CookieAccessSemantics>(
        data_value, output);
  }

  CookieAccessSemantics access_semantics() const {
    return static_cast<CookieAccessSemantics>(data_->access_semantics);
  }
  inline void GetStatusDataView(
      CookieInclusionStatusDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieInclusionStatusDataView>(
        pointer, output, context_);
  }
 private:
  internal::CookieAccessResult_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CookieWithAccessResultDataView {
 public:
  CookieWithAccessResultDataView() {}

  CookieWithAccessResultDataView(
      internal::CookieWithAccessResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, context_);
  }
  inline void GetAccessResultDataView(
      CookieAccessResultDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAccessResult(UserType* output) {
    
    auto* pointer = data_->access_result.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieAccessResultDataView>(
        pointer, output, context_);
  }
 private:
  internal::CookieWithAccessResult_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CookieChangeInfoDataView {
 public:
  CookieChangeInfoDataView() {}

  CookieChangeInfoDataView(
      internal::CookieChangeInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, context_);
  }
  inline void GetAccessResultDataView(
      CookieAccessResultDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAccessResult(UserType* output) {
    
    auto* pointer = data_->access_result.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieAccessResultDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCause(UserType* output) const {
    auto data_value = data_->cause;
    return mojo::internal::Deserialize<::network::mojom::CookieChangeCause>(
        data_value, output);
  }

  CookieChangeCause cause() const {
    return static_cast<CookieChangeCause>(data_->cause);
  }
 private:
  internal::CookieChangeInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CookieDeletionFilterDataView {
 public:
  CookieDeletionFilterDataView() {}

  CookieDeletionFilterDataView(
      internal::CookieDeletionFilter_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCreatedAfterTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCreatedAfterTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `created_after_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCreatedAfterTime` instead "
    "of `ReadCreatedAfterTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->created_after_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetCreatedBeforeTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCreatedBeforeTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `created_before_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCreatedBeforeTime` instead "
    "of `ReadCreatedBeforeTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->created_before_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetExcludingDomainsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExcludingDomains(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `excluding_domains` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExcludingDomains` instead "
    "of `ReadExcludingDomains if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->excluding_domains.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetIncludingDomainsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIncludingDomains(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `including_domains` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIncludingDomains` instead "
    "of `ReadIncludingDomains if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->including_domains.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetCookieNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookieName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cookie_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieName` instead "
    "of `ReadCookieName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetHostNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHostName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `host_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHostName` instead "
    "of `ReadHostName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->host_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSessionControl(UserType* output) const {
    auto data_value = data_->session_control;
    return mojo::internal::Deserialize<::network::mojom::CookieDeletionSessionControl>(
        data_value, output);
  }

  CookieDeletionSessionControl session_control() const {
    return static_cast<CookieDeletionSessionControl>(data_->session_control);
  }
 private:
  internal::CookieDeletionFilter_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

template <>
struct hash<::network::mojom::CookieAccessDelegateType>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieAccessDelegateType> {};

template <>
struct hash<::network::mojom::CookiePriority>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookiePriority> {};

template <>
struct hash<::network::mojom::CookieSourceScheme>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieSourceScheme> {};

template <>
struct hash<::network::mojom::CookieSameSite>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieSameSite> {};

template <>
struct hash<::network::mojom::CookieEffectiveSameSite>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieEffectiveSameSite> {};

template <>
struct hash<::network::mojom::ContextType>
    : public mojo::internal::EnumHashImpl<::network::mojom::ContextType> {};

template <>
struct hash<::network::mojom::CookieAccessSemantics>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieAccessSemantics> {};

template <>
struct hash<::network::mojom::CookieChangeCause>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieChangeCause> {};

template <>
struct hash<::network::mojom::CookieDeletionSessionControl>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieDeletionSessionControl> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::network::mojom::CookieAccessDelegateType, ::network::mojom::CookieAccessDelegateType> {
  static ::network::mojom::CookieAccessDelegateType ToMojom(::network::mojom::CookieAccessDelegateType input) { return input; }
  static bool FromMojom(::network::mojom::CookieAccessDelegateType input, ::network::mojom::CookieAccessDelegateType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessDelegateType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieAccessDelegateType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookieAccessDelegateType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CookiePriority, ::network::mojom::CookiePriority> {
  static ::network::mojom::CookiePriority ToMojom(::network::mojom::CookiePriority input) { return input; }
  static bool FromMojom(::network::mojom::CookiePriority input, ::network::mojom::CookiePriority* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookiePriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookiePriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookiePriority>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CookieSourceScheme, ::network::mojom::CookieSourceScheme> {
  static ::network::mojom::CookieSourceScheme ToMojom(::network::mojom::CookieSourceScheme input) { return input; }
  static bool FromMojom(::network::mojom::CookieSourceScheme input, ::network::mojom::CookieSourceScheme* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSourceScheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieSourceScheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookieSourceScheme>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CookieSameSite, ::network::mojom::CookieSameSite> {
  static ::network::mojom::CookieSameSite ToMojom(::network::mojom::CookieSameSite input) { return input; }
  static bool FromMojom(::network::mojom::CookieSameSite input, ::network::mojom::CookieSameSite* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSameSite, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieSameSite, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookieSameSite>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CookieEffectiveSameSite, ::network::mojom::CookieEffectiveSameSite> {
  static ::network::mojom::CookieEffectiveSameSite ToMojom(::network::mojom::CookieEffectiveSameSite input) { return input; }
  static bool FromMojom(::network::mojom::CookieEffectiveSameSite input, ::network::mojom::CookieEffectiveSameSite* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieEffectiveSameSite, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieEffectiveSameSite, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookieEffectiveSameSite>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::ContextType, ::network::mojom::ContextType> {
  static ::network::mojom::ContextType ToMojom(::network::mojom::ContextType input) { return input; }
  static bool FromMojom(::network::mojom::ContextType input, ::network::mojom::ContextType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContextType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ContextType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::ContextType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CookieAccessSemantics, ::network::mojom::CookieAccessSemantics> {
  static ::network::mojom::CookieAccessSemantics ToMojom(::network::mojom::CookieAccessSemantics input) { return input; }
  static bool FromMojom(::network::mojom::CookieAccessSemantics input, ::network::mojom::CookieAccessSemantics* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessSemantics, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieAccessSemantics, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookieAccessSemantics>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CookieChangeCause, ::network::mojom::CookieChangeCause> {
  static ::network::mojom::CookieChangeCause ToMojom(::network::mojom::CookieChangeCause input) { return input; }
  static bool FromMojom(::network::mojom::CookieChangeCause input, ::network::mojom::CookieChangeCause* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieChangeCause, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieChangeCause, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookieChangeCause>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CookieDeletionSessionControl, ::network::mojom::CookieDeletionSessionControl> {
  static ::network::mojom::CookieDeletionSessionControl ToMojom(::network::mojom::CookieDeletionSessionControl input) { return input; }
  static bool FromMojom(::network::mojom::CookieDeletionSessionControl input, ::network::mojom::CookieDeletionSessionControl* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieDeletionSessionControl, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieDeletionSessionControl, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookieDeletionSessionControl>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieManagerParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieManagerParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieManagerParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->block_third_party_cookies = Traits::block_third_party_cookies(input);
    decltype(Traits::settings(input)) in_settings = Traits::settings(input);
    typename decltype((*output)->settings)::BaseType::BufferWriter
        settings_writer;
    const mojo::internal::ContainerValidateParams settings_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        in_settings, buffer, &settings_writer, &settings_validate_params,
        context);
    (*output)->settings.Set(
        settings_writer.is_null() ? nullptr : settings_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->settings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null settings in CookieManagerParams struct");
    decltype(Traits::secure_origin_cookies_allowed_schemes(input)) in_secure_origin_cookies_allowed_schemes = Traits::secure_origin_cookies_allowed_schemes(input);
    typename decltype((*output)->secure_origin_cookies_allowed_schemes)::BaseType::BufferWriter
        secure_origin_cookies_allowed_schemes_writer;
    const mojo::internal::ContainerValidateParams secure_origin_cookies_allowed_schemes_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_secure_origin_cookies_allowed_schemes, buffer, &secure_origin_cookies_allowed_schemes_writer, &secure_origin_cookies_allowed_schemes_validate_params,
        context);
    (*output)->secure_origin_cookies_allowed_schemes.Set(
        secure_origin_cookies_allowed_schemes_writer.is_null() ? nullptr : secure_origin_cookies_allowed_schemes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->secure_origin_cookies_allowed_schemes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null secure_origin_cookies_allowed_schemes in CookieManagerParams struct");
    decltype(Traits::matching_scheme_cookies_allowed_schemes(input)) in_matching_scheme_cookies_allowed_schemes = Traits::matching_scheme_cookies_allowed_schemes(input);
    typename decltype((*output)->matching_scheme_cookies_allowed_schemes)::BaseType::BufferWriter
        matching_scheme_cookies_allowed_schemes_writer;
    const mojo::internal::ContainerValidateParams matching_scheme_cookies_allowed_schemes_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_matching_scheme_cookies_allowed_schemes, buffer, &matching_scheme_cookies_allowed_schemes_writer, &matching_scheme_cookies_allowed_schemes_validate_params,
        context);
    (*output)->matching_scheme_cookies_allowed_schemes.Set(
        matching_scheme_cookies_allowed_schemes_writer.is_null() ? nullptr : matching_scheme_cookies_allowed_schemes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->matching_scheme_cookies_allowed_schemes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null matching_scheme_cookies_allowed_schemes in CookieManagerParams struct");
    decltype(Traits::third_party_cookies_allowed_schemes(input)) in_third_party_cookies_allowed_schemes = Traits::third_party_cookies_allowed_schemes(input);
    typename decltype((*output)->third_party_cookies_allowed_schemes)::BaseType::BufferWriter
        third_party_cookies_allowed_schemes_writer;
    const mojo::internal::ContainerValidateParams third_party_cookies_allowed_schemes_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_third_party_cookies_allowed_schemes, buffer, &third_party_cookies_allowed_schemes_writer, &third_party_cookies_allowed_schemes_validate_params,
        context);
    (*output)->third_party_cookies_allowed_schemes.Set(
        third_party_cookies_allowed_schemes_writer.is_null() ? nullptr : third_party_cookies_allowed_schemes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->third_party_cookies_allowed_schemes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null third_party_cookies_allowed_schemes in CookieManagerParams struct");
    (*output)->allow_file_scheme_cookies = Traits::allow_file_scheme_cookies(input);
    decltype(Traits::settings_for_legacy_cookie_access(input)) in_settings_for_legacy_cookie_access = Traits::settings_for_legacy_cookie_access(input);
    typename decltype((*output)->settings_for_legacy_cookie_access)::BaseType::BufferWriter
        settings_for_legacy_cookie_access_writer;
    const mojo::internal::ContainerValidateParams settings_for_legacy_cookie_access_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        in_settings_for_legacy_cookie_access, buffer, &settings_for_legacy_cookie_access_writer, &settings_for_legacy_cookie_access_validate_params,
        context);
    (*output)->settings_for_legacy_cookie_access.Set(
        settings_for_legacy_cookie_access_writer.is_null() ? nullptr : settings_for_legacy_cookie_access_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->settings_for_legacy_cookie_access.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null settings_for_legacy_cookie_access in CookieManagerParams struct");
    decltype(Traits::settings_for_storage_access(input)) in_settings_for_storage_access = Traits::settings_for_storage_access(input);
    typename decltype((*output)->settings_for_storage_access)::BaseType::BufferWriter
        settings_for_storage_access_writer;
    const mojo::internal::ContainerValidateParams settings_for_storage_access_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        in_settings_for_storage_access, buffer, &settings_for_storage_access_writer, &settings_for_storage_access_validate_params,
        context);
    (*output)->settings_for_storage_access.Set(
        settings_for_storage_access_writer.is_null() ? nullptr : settings_for_storage_access_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->settings_for_storage_access.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null settings_for_storage_access in CookieManagerParams struct");
    mojo::internal::Serialize<::network::mojom::CookieAccessDelegateType>(
        Traits::cookie_access_delegate_type(input), &(*output)->cookie_access_delegate_type);
  }

  static bool Deserialize(::network::mojom::internal::CookieManagerParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieManagerParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSameSiteContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieSameSiteContextDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieSameSiteContext_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::ContextType>(
        Traits::context(input), &(*output)->context);
    mojo::internal::Serialize<::network::mojom::ContextType>(
        Traits::schemeful_context(input), &(*output)->schemeful_context);
  }

  static bool Deserialize(::network::mojom::internal::CookieSameSiteContext_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieSameSiteContextDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieOptionsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieOptions_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->exclude_httponly = Traits::exclude_httponly(input);
    decltype(Traits::same_site_cookie_context(input)) in_same_site_cookie_context = Traits::same_site_cookie_context(input);
    typename decltype((*output)->same_site_cookie_context)::BaseType::BufferWriter
        same_site_cookie_context_writer;
    mojo::internal::Serialize<::network::mojom::CookieSameSiteContextDataView>(
        in_same_site_cookie_context, buffer, &same_site_cookie_context_writer, context);
    (*output)->same_site_cookie_context.Set(
        same_site_cookie_context_writer.is_null() ? nullptr : same_site_cookie_context_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->same_site_cookie_context.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null same_site_cookie_context in CookieOptions struct");
    (*output)->update_access_time = Traits::update_access_time(input);
    (*output)->return_excluded_cookies = Traits::return_excluded_cookies(input);
  }

  static bool Deserialize(::network::mojom::internal::CookieOptions_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieOptionsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CanonicalCookieDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CanonicalCookieDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CanonicalCookie_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in CanonicalCookie struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in CanonicalCookie struct");
    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    typename decltype((*output)->domain)::BaseType::BufferWriter
        domain_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_domain, buffer, &domain_writer, context);
    (*output)->domain.Set(
        domain_writer.is_null() ? nullptr : domain_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->domain.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain in CanonicalCookie struct");
    decltype(Traits::path(input)) in_path = Traits::path(input);
    typename decltype((*output)->path)::BaseType::BufferWriter
        path_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_path, buffer, &path_writer, context);
    (*output)->path.Set(
        path_writer.is_null() ? nullptr : path_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in CanonicalCookie struct");
    decltype(Traits::creation(input)) in_creation = Traits::creation(input);
    typename decltype((*output)->creation)::BaseType::BufferWriter
        creation_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_creation, buffer, &creation_writer, context);
    (*output)->creation.Set(
        creation_writer.is_null() ? nullptr : creation_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->creation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null creation in CanonicalCookie struct");
    decltype(Traits::expiry(input)) in_expiry = Traits::expiry(input);
    typename decltype((*output)->expiry)::BaseType::BufferWriter
        expiry_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expiry, buffer, &expiry_writer, context);
    (*output)->expiry.Set(
        expiry_writer.is_null() ? nullptr : expiry_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->expiry.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiry in CanonicalCookie struct");
    decltype(Traits::last_access(input)) in_last_access = Traits::last_access(input);
    typename decltype((*output)->last_access)::BaseType::BufferWriter
        last_access_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_access, buffer, &last_access_writer, context);
    (*output)->last_access.Set(
        last_access_writer.is_null() ? nullptr : last_access_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->last_access.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_access in CanonicalCookie struct");
    (*output)->secure = Traits::secure(input);
    (*output)->httponly = Traits::httponly(input);
    mojo::internal::Serialize<::network::mojom::CookieSameSite>(
        Traits::site_restrictions(input), &(*output)->site_restrictions);
    mojo::internal::Serialize<::network::mojom::CookiePriority>(
        Traits::priority(input), &(*output)->priority);
    mojo::internal::Serialize<::network::mojom::CookieSourceScheme>(
        Traits::source_scheme(input), &(*output)->source_scheme);
  }

  static bool Deserialize(::network::mojom::internal::CanonicalCookie_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CanonicalCookieDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieInclusionStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieInclusionStatusDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieInclusionStatus_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->exclusion_reasons = Traits::exclusion_reasons(input);
    (*output)->warning_reasons = Traits::warning_reasons(input);
  }

  static bool Deserialize(::network::mojom::internal::CookieInclusionStatus_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieInclusionStatusDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAndLineWithAccessResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAndLineWithAccessResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieAndLineWithAccessResult_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
    typename decltype((*output)->cookie)::BaseType::BufferWriter
        cookie_writer;
    mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
        in_cookie, buffer, &cookie_writer, context);
    (*output)->cookie.Set(
        cookie_writer.is_null() ? nullptr : cookie_writer.data());
    decltype(Traits::cookie_string(input)) in_cookie_string = Traits::cookie_string(input);
    typename decltype((*output)->cookie_string)::BaseType::BufferWriter
        cookie_string_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_cookie_string, buffer, &cookie_string_writer, context);
    (*output)->cookie_string.Set(
        cookie_string_writer.is_null() ? nullptr : cookie_string_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cookie_string.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_string in CookieAndLineWithAccessResult struct");
    decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
    typename decltype((*output)->access_result)::BaseType::BufferWriter
        access_result_writer;
    mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
        in_access_result, buffer, &access_result_writer, context);
    (*output)->access_result.Set(
        access_result_writer.is_null() ? nullptr : access_result_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->access_result.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_result in CookieAndLineWithAccessResult struct");
  }

  static bool Deserialize(::network::mojom::internal::CookieAndLineWithAccessResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieAndLineWithAccessResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAccessResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieAccessResult_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::CookieEffectiveSameSite>(
        Traits::effective_same_site(input), &(*output)->effective_same_site);
    mojo::internal::Serialize<::network::mojom::CookieAccessSemantics>(
        Traits::access_semantics(input), &(*output)->access_semantics);
    decltype(Traits::status(input)) in_status = Traits::status(input);
    typename decltype((*output)->status)::BaseType::BufferWriter
        status_writer;
    mojo::internal::Serialize<::network::mojom::CookieInclusionStatusDataView>(
        in_status, buffer, &status_writer, context);
    (*output)->status.Set(
        status_writer.is_null() ? nullptr : status_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->status.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null status in CookieAccessResult struct");
  }

  static bool Deserialize(::network::mojom::internal::CookieAccessResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieAccessResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieWithAccessResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieWithAccessResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieWithAccessResult_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
    typename decltype((*output)->cookie)::BaseType::BufferWriter
        cookie_writer;
    mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
        in_cookie, buffer, &cookie_writer, context);
    (*output)->cookie.Set(
        cookie_writer.is_null() ? nullptr : cookie_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cookie.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie in CookieWithAccessResult struct");
    decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
    typename decltype((*output)->access_result)::BaseType::BufferWriter
        access_result_writer;
    mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
        in_access_result, buffer, &access_result_writer, context);
    (*output)->access_result.Set(
        access_result_writer.is_null() ? nullptr : access_result_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->access_result.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_result in CookieWithAccessResult struct");
  }

  static bool Deserialize(::network::mojom::internal::CookieWithAccessResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieWithAccessResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieChangeInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieChangeInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieChangeInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
    typename decltype((*output)->cookie)::BaseType::BufferWriter
        cookie_writer;
    mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
        in_cookie, buffer, &cookie_writer, context);
    (*output)->cookie.Set(
        cookie_writer.is_null() ? nullptr : cookie_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cookie.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie in CookieChangeInfo struct");
    decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
    typename decltype((*output)->access_result)::BaseType::BufferWriter
        access_result_writer;
    mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
        in_access_result, buffer, &access_result_writer, context);
    (*output)->access_result.Set(
        access_result_writer.is_null() ? nullptr : access_result_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->access_result.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_result in CookieChangeInfo struct");
    mojo::internal::Serialize<::network::mojom::CookieChangeCause>(
        Traits::cause(input), &(*output)->cause);
  }

  static bool Deserialize(::network::mojom::internal::CookieChangeInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieChangeInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieDeletionFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieDeletionFilterDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieDeletionFilter_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::created_after_time(input)) in_created_after_time = Traits::created_after_time(input);
    typename decltype((*output)->created_after_time)::BaseType::BufferWriter
        created_after_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_created_after_time, buffer, &created_after_time_writer, context);
    (*output)->created_after_time.Set(
        created_after_time_writer.is_null() ? nullptr : created_after_time_writer.data());
    decltype(Traits::created_before_time(input)) in_created_before_time = Traits::created_before_time(input);
    typename decltype((*output)->created_before_time)::BaseType::BufferWriter
        created_before_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_created_before_time, buffer, &created_before_time_writer, context);
    (*output)->created_before_time.Set(
        created_before_time_writer.is_null() ? nullptr : created_before_time_writer.data());
    decltype(Traits::excluding_domains(input)) in_excluding_domains = Traits::excluding_domains(input);
    typename decltype((*output)->excluding_domains)::BaseType::BufferWriter
        excluding_domains_writer;
    const mojo::internal::ContainerValidateParams excluding_domains_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_excluding_domains, buffer, &excluding_domains_writer, &excluding_domains_validate_params,
        context);
    (*output)->excluding_domains.Set(
        excluding_domains_writer.is_null() ? nullptr : excluding_domains_writer.data());
    decltype(Traits::including_domains(input)) in_including_domains = Traits::including_domains(input);
    typename decltype((*output)->including_domains)::BaseType::BufferWriter
        including_domains_writer;
    const mojo::internal::ContainerValidateParams including_domains_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_including_domains, buffer, &including_domains_writer, &including_domains_validate_params,
        context);
    (*output)->including_domains.Set(
        including_domains_writer.is_null() ? nullptr : including_domains_writer.data());
    decltype(Traits::cookie_name(input)) in_cookie_name = Traits::cookie_name(input);
    typename decltype((*output)->cookie_name)::BaseType::BufferWriter
        cookie_name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_cookie_name, buffer, &cookie_name_writer, context);
    (*output)->cookie_name.Set(
        cookie_name_writer.is_null() ? nullptr : cookie_name_writer.data());
    decltype(Traits::host_name(input)) in_host_name = Traits::host_name(input);
    typename decltype((*output)->host_name)::BaseType::BufferWriter
        host_name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_host_name, buffer, &host_name_writer, context);
    (*output)->host_name.Set(
        host_name_writer.is_null() ? nullptr : host_name_writer.data());
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    mojo::internal::Serialize<::network::mojom::CookieDeletionSessionControl>(
        Traits::session_control(input), &(*output)->session_control);
  }

  static bool Deserialize(::network::mojom::internal::CookieDeletionFilter_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieDeletionFilterDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void CookieManagerParamsDataView::GetSettingsDataView(
    mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output) {
  auto pointer = data_->settings.Get();
  *output = mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>(pointer, context_);
}
inline void CookieManagerParamsDataView::GetSecureOriginCookiesAllowedSchemesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->secure_origin_cookies_allowed_schemes.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CookieManagerParamsDataView::GetMatchingSchemeCookiesAllowedSchemesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->matching_scheme_cookies_allowed_schemes.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CookieManagerParamsDataView::GetThirdPartyCookiesAllowedSchemesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->third_party_cookies_allowed_schemes.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CookieManagerParamsDataView::GetSettingsForLegacyCookieAccessDataView(
    mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output) {
  auto pointer = data_->settings_for_legacy_cookie_access.Get();
  *output = mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>(pointer, context_);
}
inline void CookieManagerParamsDataView::GetSettingsForStorageAccessDataView(
    mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output) {
  auto pointer = data_->settings_for_storage_access.Get();
  *output = mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>(pointer, context_);
}




inline void CookieOptionsDataView::GetSameSiteCookieContextDataView(
    CookieSameSiteContextDataView* output) {
  auto pointer = data_->same_site_cookie_context.Get();
  *output = CookieSameSiteContextDataView(pointer, context_);
}


inline void CanonicalCookieDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CanonicalCookieDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CanonicalCookieDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CanonicalCookieDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CanonicalCookieDataView::GetCreationDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->creation.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void CanonicalCookieDataView::GetExpiryDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiry.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void CanonicalCookieDataView::GetLastAccessDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_access.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}




inline void CookieAndLineWithAccessResultDataView::GetCookieDataView(
    CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = CanonicalCookieDataView(pointer, context_);
}
inline void CookieAndLineWithAccessResultDataView::GetCookieStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cookie_string.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CookieAndLineWithAccessResultDataView::GetAccessResultDataView(
    CookieAccessResultDataView* output) {
  auto pointer = data_->access_result.Get();
  *output = CookieAccessResultDataView(pointer, context_);
}


inline void CookieAccessResultDataView::GetStatusDataView(
    CookieInclusionStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = CookieInclusionStatusDataView(pointer, context_);
}


inline void CookieWithAccessResultDataView::GetCookieDataView(
    CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = CanonicalCookieDataView(pointer, context_);
}
inline void CookieWithAccessResultDataView::GetAccessResultDataView(
    CookieAccessResultDataView* output) {
  auto pointer = data_->access_result.Get();
  *output = CookieAccessResultDataView(pointer, context_);
}


inline void CookieChangeInfoDataView::GetCookieDataView(
    CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = CanonicalCookieDataView(pointer, context_);
}
inline void CookieChangeInfoDataView::GetAccessResultDataView(
    CookieAccessResultDataView* output) {
  auto pointer = data_->access_result.Get();
  *output = CookieAccessResultDataView(pointer, context_);
}


inline void CookieDeletionFilterDataView::GetCreatedAfterTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->created_after_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void CookieDeletionFilterDataView::GetCreatedBeforeTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->created_before_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void CookieDeletionFilterDataView::GetExcludingDomainsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->excluding_domains.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CookieDeletionFilterDataView::GetIncludingDomainsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->including_domains.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CookieDeletionFilterDataView::GetCookieNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cookie_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CookieDeletionFilterDataView::GetHostNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CookieDeletionFilterDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SHARED_H_