// qtwebengine/browser/qtwebchannel.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_BROWSER_QTWEBCHANNEL_MOJOM_H_
#define QTWEBENGINE_BROWSER_QTWEBCHANNEL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "qtwebengine/browser/qtwebchannel.mojom-shared.h"
#include "qtwebengine/browser/qtwebchannel.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace qtwebchannel {
namespace mojom {

class WebChannelTransportRenderProxy;

template <typename ImplRefTraits>
class WebChannelTransportRenderStub;

class WebChannelTransportRenderRequestValidator;


class  WebChannelTransportRender
    : public WebChannelTransportRenderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebChannelTransportRenderInterfaceBase;
  using Proxy_ = WebChannelTransportRenderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebChannelTransportRenderStub<ImplRefTraits>;

  using RequestValidator_ = WebChannelTransportRenderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetWorldIdMinVersion = 0,
    kResetWorldIdMinVersion = 0,
    kDispatchWebChannelMessageMinVersion = 0,
  };
  virtual ~WebChannelTransportRender() {}

  
  virtual void SetWorldId(uint32_t worldId) = 0;

  
  virtual void ResetWorldId() = 0;

  
  virtual void DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson, uint32_t worldId) = 0;
};

class WebChannelTransportHostProxy;

template <typename ImplRefTraits>
class WebChannelTransportHostStub;

class WebChannelTransportHostRequestValidator;


class  WebChannelTransportHost
    : public WebChannelTransportHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebChannelTransportHostInterfaceBase;
  using Proxy_ = WebChannelTransportHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebChannelTransportHostStub<ImplRefTraits>;

  using RequestValidator_ = WebChannelTransportHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDispatchWebChannelMessageMinVersion = 0,
  };
  virtual ~WebChannelTransportHost() {}

  
  virtual void DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson) = 0;
};



class  WebChannelTransportRenderProxy
    : public WebChannelTransportRender {
 public:
  using InterfaceType = WebChannelTransportRender;

  explicit WebChannelTransportRenderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetWorldId(uint32_t worldId) final;
  
  void ResetWorldId() final;
  
  void DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson, uint32_t worldId) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebChannelTransportHostProxy
    : public WebChannelTransportHost {
 public:
  using InterfaceType = WebChannelTransportHost;

  explicit WebChannelTransportHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebChannelTransportRenderStubDispatch {
 public:
  static bool Accept(WebChannelTransportRender* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebChannelTransportRender* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebChannelTransportRender>>
class WebChannelTransportRenderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebChannelTransportRenderStub() {}
  ~WebChannelTransportRenderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebChannelTransportRenderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebChannelTransportRenderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebChannelTransportHostStubDispatch {
 public:
  static bool Accept(WebChannelTransportHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebChannelTransportHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebChannelTransportHost>>
class WebChannelTransportHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebChannelTransportHostStub() {}
  ~WebChannelTransportHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebChannelTransportHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebChannelTransportHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebChannelTransportRenderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebChannelTransportHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace qtwebchannel

namespace mojo {

}  // namespace mojo

#endif  // QTWEBENGINE_BROWSER_QTWEBCHANNEL_MOJOM_H_