// media/mojo/mojom/watch_time_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/watch_time_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-params-data.h"
#include "media/mojo/mojom/watch_time_recorder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
PlaybackProperties::PlaybackProperties()
    : has_audio(),
      has_video(),
      is_background(),
      is_muted(),
      is_mse(),
      is_eme(),
      is_embedded_media_experience() {}

PlaybackProperties::PlaybackProperties(
    bool has_audio_in,
    bool has_video_in,
    bool is_background_in,
    bool is_muted_in,
    bool is_mse_in,
    bool is_eme_in,
    bool is_embedded_media_experience_in)
    : has_audio(std::move(has_audio_in)),
      has_video(std::move(has_video_in)),
      is_background(std::move(is_background_in)),
      is_muted(std::move(is_muted_in)),
      is_mse(std::move(is_mse_in)),
      is_eme(std::move(is_eme_in)),
      is_embedded_media_experience(std::move(is_embedded_media_experience_in)) {}

PlaybackProperties::~PlaybackProperties() = default;
size_t PlaybackProperties::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->has_audio);
  seed = mojo::internal::Hash(seed, this->has_video);
  seed = mojo::internal::Hash(seed, this->is_background);
  seed = mojo::internal::Hash(seed, this->is_muted);
  seed = mojo::internal::Hash(seed, this->is_mse);
  seed = mojo::internal::Hash(seed, this->is_eme);
  seed = mojo::internal::Hash(seed, this->is_embedded_media_experience);
  return seed;
}

void PlaybackProperties::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("has_audio", this->has_audio);
  value->SetBoolean("has_video", this->has_video);
  value->SetBoolean("is_background", this->is_background);
  value->SetBoolean("is_muted", this->is_muted);
  value->SetBoolean("is_mse", this->is_mse);
  value->SetBoolean("is_eme", this->is_eme);
  value->SetBoolean("is_embedded_media_experience", this->is_embedded_media_experience);
}

bool PlaybackProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SecondaryPlaybackProperties::SecondaryPlaybackProperties()
    : audio_codec(),
      video_codec(),
      audio_codec_profile(),
      video_codec_profile(),
      audio_decoder_name(),
      video_decoder_name(),
      audio_encryption_scheme(),
      video_encryption_scheme(),
      natural_size() {}

SecondaryPlaybackProperties::SecondaryPlaybackProperties(
    ::media::AudioCodec audio_codec_in,
    ::media::VideoCodec video_codec_in,
    ::media::AudioCodecProfile audio_codec_profile_in,
    ::media::VideoCodecProfile video_codec_profile_in,
    const std::string& audio_decoder_name_in,
    const std::string& video_decoder_name_in,
    ::media::EncryptionScheme audio_encryption_scheme_in,
    ::media::EncryptionScheme video_encryption_scheme_in,
    const ::gfx::Size& natural_size_in)
    : audio_codec(std::move(audio_codec_in)),
      video_codec(std::move(video_codec_in)),
      audio_codec_profile(std::move(audio_codec_profile_in)),
      video_codec_profile(std::move(video_codec_profile_in)),
      audio_decoder_name(std::move(audio_decoder_name_in)),
      video_decoder_name(std::move(video_decoder_name_in)),
      audio_encryption_scheme(std::move(audio_encryption_scheme_in)),
      video_encryption_scheme(std::move(video_encryption_scheme_in)),
      natural_size(std::move(natural_size_in)) {}

SecondaryPlaybackProperties::~SecondaryPlaybackProperties() = default;

void SecondaryPlaybackProperties::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("audio_codec", static_cast<int>(this->audio_codec));
  value->SetInteger("video_codec", static_cast<int>(this->video_codec));
  value->SetInteger("audio_codec_profile", static_cast<int>(this->audio_codec_profile));
  value->SetInteger("video_codec_profile", static_cast<int>(this->video_codec_profile));
  value->SetString("audio_decoder_name", this->audio_decoder_name);
  value->SetString("video_decoder_name", this->video_decoder_name);
  value->SetInteger("audio_encryption_scheme", static_cast<int>(this->audio_encryption_scheme));
  value->SetInteger("video_encryption_scheme", static_cast<int>(this->video_encryption_scheme));
  value->SetString("natural_size", base::trace_event::ValueToString(this->natural_size, "<value of type const ::gfx::Size&>"));
}

bool SecondaryPlaybackProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char WatchTimeRecorder::Name_[] = "media.mojom.WatchTimeRecorder";

WatchTimeRecorderProxy::WatchTimeRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WatchTimeRecorderProxy::RecordWatchTime(
    ::media::WatchTimeKey in_key, ::base::TimeDelta in_watch_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::RecordWatchTime", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("key", static_cast<int>(in_key));
      raw_value->SetString("watch_time", base::trace_event::ValueToString(in_watch_time, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_RecordWatchTime_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_RecordWatchTime_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::WatchTimeKey>(
      in_key, &params->key);
  typename decltype(params->watch_time)::BaseType::BufferWriter
      watch_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_watch_time, buffer, &watch_time_writer, &serialization_context);
  params->watch_time.Set(
      watch_time_writer.is_null() ? nullptr : watch_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->watch_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null watch_time in WatchTimeRecorder.RecordWatchTime request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("RecordWatchTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::FinalizeWatchTime(
    const std::vector<::media::WatchTimeKey>& in_watch_time_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::FinalizeWatchTime", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("watch_time_keys");
      for (const auto& item0 : in_watch_time_keys) {
        raw_value->AppendInteger(static_cast<int>(item0));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_FinalizeWatchTime_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->watch_time_keys)::BaseType::BufferWriter
      watch_time_keys_writer;
  const mojo::internal::ContainerValidateParams watch_time_keys_validate_params(
      0, ::media::mojom::internal::WatchTimeKey_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::WatchTimeKey>>(
      in_watch_time_keys, buffer, &watch_time_keys_writer, &watch_time_keys_validate_params,
      &serialization_context);
  params->watch_time_keys.Set(
      watch_time_keys_writer.is_null() ? nullptr : watch_time_keys_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->watch_time_keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null watch_time_keys in WatchTimeRecorder.FinalizeWatchTime request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("FinalizeWatchTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::OnError(
    ::media::PipelineStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::OnError", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("status", static_cast<int>(in_status));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_OnError_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_OnError_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::PipelineStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::UpdateSecondaryProperties(
    SecondaryPlaybackPropertiesPtr in_secondary_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::UpdateSecondaryProperties", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_secondary_properties.is_null()) {
        raw_value->SetString("secondary_properties", "nullptr");
      } else {
        raw_value->BeginDictionary("secondary_properties");
        in_secondary_properties->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_UpdateSecondaryProperties_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->secondary_properties)::BaseType::BufferWriter
      secondary_properties_writer;
  mojo::internal::Serialize<::media::mojom::SecondaryPlaybackPropertiesDataView>(
      in_secondary_properties, buffer, &secondary_properties_writer, &serialization_context);
  params->secondary_properties.Set(
      secondary_properties_writer.is_null() ? nullptr : secondary_properties_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->secondary_properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null secondary_properties in WatchTimeRecorder.UpdateSecondaryProperties request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateSecondaryProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::SetAutoplayInitiated(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::SetAutoplayInitiated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("value", in_value);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_SetAutoplayInitiated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->value = in_value;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("SetAutoplayInitiated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::OnDurationChanged(
    ::base::TimeDelta in_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::OnDurationChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("duration", base::trace_event::ValueToString(in_duration, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_OnDurationChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_OnDurationChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->duration)::BaseType::BufferWriter
      duration_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration, buffer, &duration_writer, &serialization_context);
  params->duration.Set(
      duration_writer.is_null() ? nullptr : duration_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->duration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in WatchTimeRecorder.OnDurationChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("OnDurationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::UpdateVideoDecodeStats(
    uint32_t in_frames_decoded, uint32_t in_frames_dropped) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frames_decoded", base::NumberToString(in_frames_decoded));
      raw_value->SetString("frames_dropped", base::NumberToString(in_frames_dropped));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_UpdateVideoDecodeStats_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->frames_decoded = in_frames_decoded;
  params->frames_dropped = in_frames_dropped;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateVideoDecodeStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::UpdateUnderflowCount(
    int32_t in_total_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::UpdateUnderflowCount", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("total_count", in_total_count);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_UpdateUnderflowCount_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->total_count = in_total_count;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateUnderflowCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::UpdateUnderflowDuration(
    int32_t in_total_completed_count, ::base::TimeDelta in_total_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::UpdateUnderflowDuration", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("total_completed_count", in_total_completed_count);
      raw_value->SetString("total_duration", base::trace_event::ValueToString(in_total_duration, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_UpdateUnderflowDuration_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->total_completed_count = in_total_completed_count;
  typename decltype(params->total_duration)::BaseType::BufferWriter
      total_duration_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_total_duration, buffer, &total_duration_writer, &serialization_context);
  params->total_duration.Set(
      total_duration_writer.is_null() ? nullptr : total_duration_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->total_duration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null total_duration in WatchTimeRecorder.UpdateUnderflowDuration request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateUnderflowDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::OnCurrentTimestampChanged(
    ::base::TimeDelta in_last_timestamp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::OnCurrentTimestampChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("last_timestamp", base::trace_event::ValueToString(in_last_timestamp, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_OnCurrentTimestampChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->last_timestamp)::BaseType::BufferWriter
      last_timestamp_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_last_timestamp, buffer, &last_timestamp_writer, &serialization_context);
  params->last_timestamp.Set(
      last_timestamp_writer.is_null() ? nullptr : last_timestamp_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->last_timestamp.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_timestamp in WatchTimeRecorder.OnCurrentTimestampChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("OnCurrentTimestampChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WatchTimeRecorderStubDispatch::Accept(
    WatchTimeRecorder* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWatchTimeRecorder_RecordWatchTime_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::RecordWatchTime",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::RecordWatchTime");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_RecordWatchTime_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_RecordWatchTime_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::WatchTimeKey p_key{};
      ::base::TimeDelta p_watch_time{};
      WatchTimeRecorder_RecordWatchTime_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadWatchTime(&p_watch_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordWatchTime(
std::move(p_key), 
std::move(p_watch_time));
      return true;
    }
    case internal::kWatchTimeRecorder_FinalizeWatchTime_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::FinalizeWatchTime",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::FinalizeWatchTime");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::media::WatchTimeKey> p_watch_time_keys{};
      WatchTimeRecorder_FinalizeWatchTime_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadWatchTimeKeys(&p_watch_time_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FinalizeWatchTime(
std::move(p_watch_time_keys));
      return true;
    }
    case internal::kWatchTimeRecorder_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_OnError_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::PipelineStatus p_status{};
      WatchTimeRecorder_OnError_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_status));
      return true;
    }
    case internal::kWatchTimeRecorder_UpdateSecondaryProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::UpdateSecondaryProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::UpdateSecondaryProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SecondaryPlaybackPropertiesPtr p_secondary_properties{};
      WatchTimeRecorder_UpdateSecondaryProperties_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSecondaryProperties(&p_secondary_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSecondaryProperties(
std::move(p_secondary_properties));
      return true;
    }
    case internal::kWatchTimeRecorder_SetAutoplayInitiated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::SetAutoplayInitiated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::SetAutoplayInitiated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_value{};
      WatchTimeRecorder_SetAutoplayInitiated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAutoplayInitiated(
std::move(p_value));
      return true;
    }
    case internal::kWatchTimeRecorder_OnDurationChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::OnDurationChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::OnDurationChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_OnDurationChanged_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_OnDurationChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_duration{};
      WatchTimeRecorder_OnDurationChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDurationChanged(
std::move(p_duration));
      return true;
    }
    case internal::kWatchTimeRecorder_UpdateVideoDecodeStats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_frames_decoded{};
      uint32_t p_frames_dropped{};
      WatchTimeRecorder_UpdateVideoDecodeStats_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_frames_decoded = input_data_view.frames_decoded();
      if (success)
        p_frames_dropped = input_data_view.frames_dropped();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVideoDecodeStats(
std::move(p_frames_decoded), 
std::move(p_frames_dropped));
      return true;
    }
    case internal::kWatchTimeRecorder_UpdateUnderflowCount_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::UpdateUnderflowCount",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::UpdateUnderflowCount");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_total_count{};
      WatchTimeRecorder_UpdateUnderflowCount_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_total_count = input_data_view.total_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUnderflowCount(
std::move(p_total_count));
      return true;
    }
    case internal::kWatchTimeRecorder_UpdateUnderflowDuration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::UpdateUnderflowDuration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::UpdateUnderflowDuration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_total_completed_count{};
      ::base::TimeDelta p_total_duration{};
      WatchTimeRecorder_UpdateUnderflowDuration_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_total_completed_count = input_data_view.total_completed_count();
      if (success && !input_data_view.ReadTotalDuration(&p_total_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUnderflowDuration(
std::move(p_total_completed_count), 
std::move(p_total_duration));
      return true;
    }
    case internal::kWatchTimeRecorder_OnCurrentTimestampChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::OnCurrentTimestampChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::OnCurrentTimestampChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_last_timestamp{};
      WatchTimeRecorder_OnCurrentTimestampChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLastTimestamp(&p_last_timestamp))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCurrentTimestampChanged(
std::move(p_last_timestamp));
      return true;
    }
  }
  return false;
}

// static
bool WatchTimeRecorderStubDispatch::AcceptWithResponder(
    WatchTimeRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWatchTimeRecorder_RecordWatchTime_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_FinalizeWatchTime_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_OnError_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_UpdateSecondaryProperties_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_SetAutoplayInitiated_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_OnDurationChanged_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_UpdateVideoDecodeStats_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_UpdateUnderflowCount_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_UpdateUnderflowDuration_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_OnCurrentTimestampChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWatchTimeRecorderValidationInfo[] = {
    {internal::kWatchTimeRecorder_RecordWatchTime_Name,
     {&internal::WatchTimeRecorder_RecordWatchTime_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_FinalizeWatchTime_Name,
     {&internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_OnError_Name,
     {&internal::WatchTimeRecorder_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_UpdateSecondaryProperties_Name,
     {&internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_SetAutoplayInitiated_Name,
     {&internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_OnDurationChanged_Name,
     {&internal::WatchTimeRecorder_OnDurationChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_UpdateVideoDecodeStats_Name,
     {&internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_UpdateUnderflowCount_Name,
     {&internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_UpdateUnderflowDuration_Name,
     {&internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_OnCurrentTimestampChanged_Name,
     {&internal::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WatchTimeRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::WatchTimeRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWatchTimeRecorderValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::PlaybackProperties::DataView, ::media::mojom::PlaybackPropertiesPtr>::Read(
    ::media::mojom::PlaybackProperties::DataView input,
    ::media::mojom::PlaybackPropertiesPtr* output) {
  bool success = true;
  ::media::mojom::PlaybackPropertiesPtr result(::media::mojom::PlaybackProperties::New());
  
      if (success)
        result->has_audio = input.has_audio();
      if (success)
        result->has_video = input.has_video();
      if (success)
        result->is_background = input.is_background();
      if (success)
        result->is_muted = input.is_muted();
      if (success)
        result->is_mse = input.is_mse();
      if (success)
        result->is_eme = input.is_eme();
      if (success)
        result->is_embedded_media_experience = input.is_embedded_media_experience();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SecondaryPlaybackProperties::DataView, ::media::mojom::SecondaryPlaybackPropertiesPtr>::Read(
    ::media::mojom::SecondaryPlaybackProperties::DataView input,
    ::media::mojom::SecondaryPlaybackPropertiesPtr* output) {
  bool success = true;
  ::media::mojom::SecondaryPlaybackPropertiesPtr result(::media::mojom::SecondaryPlaybackProperties::New());
  
      if (success && !input.ReadAudioCodec(&result->audio_codec))
        success = false;
      if (success && !input.ReadVideoCodec(&result->video_codec))
        success = false;
      if (success && !input.ReadAudioCodecProfile(&result->audio_codec_profile))
        success = false;
      if (success && !input.ReadVideoCodecProfile(&result->video_codec_profile))
        success = false;
      if (success && !input.ReadAudioDecoderName(&result->audio_decoder_name))
        success = false;
      if (success && !input.ReadVideoDecoderName(&result->video_decoder_name))
        success = false;
      if (success && !input.ReadAudioEncryptionScheme(&result->audio_encryption_scheme))
        success = false;
      if (success && !input.ReadVideoEncryptionScheme(&result->video_encryption_scheme))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif