// media/mojo/mojom/video_encoder_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared.h"
#include "media/mojo/mojom/video_encoder_info.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "media/mojo/mojom/video_encoder_info_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {





class  ScalingSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScalingSettings, T>::value>;
  using DataView = ScalingSettingsDataView;
  using Data_ = internal::ScalingSettings_Data;

  template <typename... Args>
  static ScalingSettingsPtr New(Args&&... args) {
    return ScalingSettingsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScalingSettingsPtr From(const U& u) {
    return mojo::TypeConverter<ScalingSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScalingSettings>::Convert(*this);
  }


  ScalingSettings();

  ScalingSettings(
      uint8_t min_qp,
      uint8_t max_qp);

  ~ScalingSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScalingSettingsPtr>
  ScalingSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScalingSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScalingSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScalingSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScalingSettings_UnserializedMessageContext<
            UserType, ScalingSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ScalingSettings::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ScalingSettings::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScalingSettings_UnserializedMessageContext<
            UserType, ScalingSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScalingSettings::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint8_t min_qp;
  
  uint8_t max_qp;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScalingSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScalingSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScalingSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScalingSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  ResolutionBitrateLimit {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResolutionBitrateLimit, T>::value>;
  using DataView = ResolutionBitrateLimitDataView;
  using Data_ = internal::ResolutionBitrateLimit_Data;

  template <typename... Args>
  static ResolutionBitrateLimitPtr New(Args&&... args) {
    return ResolutionBitrateLimitPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResolutionBitrateLimitPtr From(const U& u) {
    return mojo::TypeConverter<ResolutionBitrateLimitPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResolutionBitrateLimit>::Convert(*this);
  }


  ResolutionBitrateLimit();

  ResolutionBitrateLimit(
      const ::gfx::Size& frame_size,
      int32_t min_start_bitrate_bps,
      int32_t min_bitrate_bps,
      int32_t max_bitrate_bps);

  ~ResolutionBitrateLimit();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResolutionBitrateLimitPtr>
  ResolutionBitrateLimitPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResolutionBitrateLimit::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResolutionBitrateLimit::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResolutionBitrateLimit::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResolutionBitrateLimit_UnserializedMessageContext<
            UserType, ResolutionBitrateLimit::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ResolutionBitrateLimit::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ResolutionBitrateLimit::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResolutionBitrateLimit_UnserializedMessageContext<
            UserType, ResolutionBitrateLimit::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResolutionBitrateLimit::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Size frame_size;
  
  int32_t min_start_bitrate_bps;
  
  int32_t min_bitrate_bps;
  
  int32_t max_bitrate_bps;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResolutionBitrateLimit::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResolutionBitrateLimit::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResolutionBitrateLimit::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResolutionBitrateLimit::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoEncoderInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoEncoderInfo, T>::value>;
  using DataView = VideoEncoderInfoDataView;
  using Data_ = internal::VideoEncoderInfo_Data;

  template <typename... Args>
  static VideoEncoderInfoPtr New(Args&&... args) {
    return VideoEncoderInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoEncoderInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoEncoderInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoEncoderInfo>::Convert(*this);
  }


  VideoEncoderInfo();

  VideoEncoderInfo(
      const std::string& implementation_name,
      bool supports_native_handle,
      bool has_trusted_rate_controller,
      bool is_hardware_accelerated,
      bool supports_simulcast,
      const base::Optional<::media::ScalingSettings>& scaling_settings,
      std::vector<std::vector<uint8_t>> fps_allocation,
      std::vector<::media::ResolutionBitrateLimit> resolution_bitrate_limits);

  ~VideoEncoderInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoEncoderInfoPtr>
  VideoEncoderInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEncoderInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoEncoderInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoEncoderInfo_UnserializedMessageContext<
            UserType, VideoEncoderInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoEncoderInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoEncoderInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoEncoderInfo_UnserializedMessageContext<
            UserType, VideoEncoderInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoEncoderInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string implementation_name;
  
  bool supports_native_handle;
  
  bool has_trusted_rate_controller;
  
  bool is_hardware_accelerated;
  
  bool supports_simulcast;
  
  base::Optional<::media::ScalingSettings> scaling_settings;
  
  std::vector<std::vector<uint8_t>> fps_allocation;
  
  std::vector<::media::ResolutionBitrateLimit> resolution_bitrate_limits;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ScalingSettingsPtr ScalingSettings::Clone() const {
  return New(
      mojo::Clone(min_qp),
      mojo::Clone(max_qp)
  );
}

template <typename T, ScalingSettings::EnableIfSame<T>*>
bool ScalingSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->min_qp, other_struct.min_qp))
    return false;
  if (!mojo::Equals(this->max_qp, other_struct.max_qp))
    return false;
  return true;
}

template <typename T, ScalingSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.min_qp, rhs.min_qp))
    return true;
  if (std::less<>{}(rhs.min_qp, lhs.min_qp))
    return false;
  if (std::less<>{}(lhs.max_qp, rhs.max_qp))
    return true;
  if (std::less<>{}(rhs.max_qp, lhs.max_qp))
    return false;
  return false;
}
template <typename StructPtrType>
ResolutionBitrateLimitPtr ResolutionBitrateLimit::Clone() const {
  return New(
      mojo::Clone(frame_size),
      mojo::Clone(min_start_bitrate_bps),
      mojo::Clone(min_bitrate_bps),
      mojo::Clone(max_bitrate_bps)
  );
}

template <typename T, ResolutionBitrateLimit::EnableIfSame<T>*>
bool ResolutionBitrateLimit::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_size, other_struct.frame_size))
    return false;
  if (!mojo::Equals(this->min_start_bitrate_bps, other_struct.min_start_bitrate_bps))
    return false;
  if (!mojo::Equals(this->min_bitrate_bps, other_struct.min_bitrate_bps))
    return false;
  if (!mojo::Equals(this->max_bitrate_bps, other_struct.max_bitrate_bps))
    return false;
  return true;
}

template <typename T, ResolutionBitrateLimit::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.frame_size, rhs.frame_size))
    return true;
  if (std::less<>{}(rhs.frame_size, lhs.frame_size))
    return false;
  if (std::less<>{}(lhs.min_start_bitrate_bps, rhs.min_start_bitrate_bps))
    return true;
  if (std::less<>{}(rhs.min_start_bitrate_bps, lhs.min_start_bitrate_bps))
    return false;
  if (std::less<>{}(lhs.min_bitrate_bps, rhs.min_bitrate_bps))
    return true;
  if (std::less<>{}(rhs.min_bitrate_bps, lhs.min_bitrate_bps))
    return false;
  if (std::less<>{}(lhs.max_bitrate_bps, rhs.max_bitrate_bps))
    return true;
  if (std::less<>{}(rhs.max_bitrate_bps, lhs.max_bitrate_bps))
    return false;
  return false;
}
template <typename StructPtrType>
VideoEncoderInfoPtr VideoEncoderInfo::Clone() const {
  return New(
      mojo::Clone(implementation_name),
      mojo::Clone(supports_native_handle),
      mojo::Clone(has_trusted_rate_controller),
      mojo::Clone(is_hardware_accelerated),
      mojo::Clone(supports_simulcast),
      mojo::Clone(scaling_settings),
      mojo::Clone(fps_allocation),
      mojo::Clone(resolution_bitrate_limits)
  );
}

template <typename T, VideoEncoderInfo::EnableIfSame<T>*>
bool VideoEncoderInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->implementation_name, other_struct.implementation_name))
    return false;
  if (!mojo::Equals(this->supports_native_handle, other_struct.supports_native_handle))
    return false;
  if (!mojo::Equals(this->has_trusted_rate_controller, other_struct.has_trusted_rate_controller))
    return false;
  if (!mojo::Equals(this->is_hardware_accelerated, other_struct.is_hardware_accelerated))
    return false;
  if (!mojo::Equals(this->supports_simulcast, other_struct.supports_simulcast))
    return false;
  if (!mojo::Equals(this->scaling_settings, other_struct.scaling_settings))
    return false;
  if (!mojo::Equals(this->fps_allocation, other_struct.fps_allocation))
    return false;
  if (!mojo::Equals(this->resolution_bitrate_limits, other_struct.resolution_bitrate_limits))
    return false;
  return true;
}

template <typename T, VideoEncoderInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.implementation_name, rhs.implementation_name))
    return true;
  if (std::less<>{}(rhs.implementation_name, lhs.implementation_name))
    return false;
  if (std::less<>{}(lhs.supports_native_handle, rhs.supports_native_handle))
    return true;
  if (std::less<>{}(rhs.supports_native_handle, lhs.supports_native_handle))
    return false;
  if (std::less<>{}(lhs.has_trusted_rate_controller, rhs.has_trusted_rate_controller))
    return true;
  if (std::less<>{}(rhs.has_trusted_rate_controller, lhs.has_trusted_rate_controller))
    return false;
  if (std::less<>{}(lhs.is_hardware_accelerated, rhs.is_hardware_accelerated))
    return true;
  if (std::less<>{}(rhs.is_hardware_accelerated, lhs.is_hardware_accelerated))
    return false;
  if (std::less<>{}(lhs.supports_simulcast, rhs.supports_simulcast))
    return true;
  if (std::less<>{}(rhs.supports_simulcast, lhs.supports_simulcast))
    return false;
  if (std::less<>{}(lhs.scaling_settings, rhs.scaling_settings))
    return true;
  if (std::less<>{}(rhs.scaling_settings, lhs.scaling_settings))
    return false;
  if (std::less<>{}(lhs.fps_allocation, rhs.fps_allocation))
    return true;
  if (std::less<>{}(rhs.fps_allocation, lhs.fps_allocation))
    return false;
  if (std::less<>{}(lhs.resolution_bitrate_limits, rhs.resolution_bitrate_limits))
    return true;
  if (std::less<>{}(rhs.resolution_bitrate_limits, lhs.resolution_bitrate_limits))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::ScalingSettings::DataView,
                                         ::media::mojom::ScalingSettingsPtr> {
  static bool IsNull(const ::media::mojom::ScalingSettingsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::ScalingSettingsPtr* output) { output->reset(); }

  static decltype(::media::mojom::ScalingSettings::min_qp) min_qp(
      const ::media::mojom::ScalingSettingsPtr& input) {
    return input->min_qp;
  }

  static decltype(::media::mojom::ScalingSettings::max_qp) max_qp(
      const ::media::mojom::ScalingSettingsPtr& input) {
    return input->max_qp;
  }

  static bool Read(::media::mojom::ScalingSettings::DataView input, ::media::mojom::ScalingSettingsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::ResolutionBitrateLimit::DataView,
                                         ::media::mojom::ResolutionBitrateLimitPtr> {
  static bool IsNull(const ::media::mojom::ResolutionBitrateLimitPtr& input) { return !input; }
  static void SetToNull(::media::mojom::ResolutionBitrateLimitPtr* output) { output->reset(); }

  static const decltype(::media::mojom::ResolutionBitrateLimit::frame_size)& frame_size(
      const ::media::mojom::ResolutionBitrateLimitPtr& input) {
    return input->frame_size;
  }

  static decltype(::media::mojom::ResolutionBitrateLimit::min_start_bitrate_bps) min_start_bitrate_bps(
      const ::media::mojom::ResolutionBitrateLimitPtr& input) {
    return input->min_start_bitrate_bps;
  }

  static decltype(::media::mojom::ResolutionBitrateLimit::min_bitrate_bps) min_bitrate_bps(
      const ::media::mojom::ResolutionBitrateLimitPtr& input) {
    return input->min_bitrate_bps;
  }

  static decltype(::media::mojom::ResolutionBitrateLimit::max_bitrate_bps) max_bitrate_bps(
      const ::media::mojom::ResolutionBitrateLimitPtr& input) {
    return input->max_bitrate_bps;
  }

  static bool Read(::media::mojom::ResolutionBitrateLimit::DataView input, ::media::mojom::ResolutionBitrateLimitPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoEncoderInfo::DataView,
                                         ::media::mojom::VideoEncoderInfoPtr> {
  static bool IsNull(const ::media::mojom::VideoEncoderInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoEncoderInfoPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoEncoderInfo::implementation_name)& implementation_name(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->implementation_name;
  }

  static decltype(::media::mojom::VideoEncoderInfo::supports_native_handle) supports_native_handle(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->supports_native_handle;
  }

  static decltype(::media::mojom::VideoEncoderInfo::has_trusted_rate_controller) has_trusted_rate_controller(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->has_trusted_rate_controller;
  }

  static decltype(::media::mojom::VideoEncoderInfo::is_hardware_accelerated) is_hardware_accelerated(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->is_hardware_accelerated;
  }

  static decltype(::media::mojom::VideoEncoderInfo::supports_simulcast) supports_simulcast(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->supports_simulcast;
  }

  static const decltype(::media::mojom::VideoEncoderInfo::scaling_settings)& scaling_settings(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->scaling_settings;
  }

  static const decltype(::media::mojom::VideoEncoderInfo::fps_allocation)& fps_allocation(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->fps_allocation;
  }

  static const decltype(::media::mojom::VideoEncoderInfo::resolution_bitrate_limits)& resolution_bitrate_limits(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->resolution_bitrate_limits;
  }

  static bool Read(::media::mojom::VideoEncoderInfo::DataView input, ::media::mojom::VideoEncoderInfoPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_H_