// media/mojo/mojom/speech_recognition_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/speech_recognition_service.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_service.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {

class SpeechRecognitionContextProxy;

template <typename ImplRefTraits>
class SpeechRecognitionContextStub;

class SpeechRecognitionContextRequestValidator;
class SpeechRecognitionContextResponseValidator;


class  SpeechRecognitionContext
    : public SpeechRecognitionContextInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpeechRecognitionContextInterfaceBase;
  using Proxy_ = SpeechRecognitionContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionContextStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionContextRequestValidator;
  using ResponseValidator_ = SpeechRecognitionContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindRecognizerMinVersion = 0,
  };
  virtual ~SpeechRecognitionContext() {}


  using BindRecognizerCallback = base::OnceCallback<void(bool)>;
  
  virtual void BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, BindRecognizerCallback callback) = 0;
};

class SpeechRecognitionServiceProxy;

template <typename ImplRefTraits>
class SpeechRecognitionServiceStub;

class SpeechRecognitionServiceRequestValidator;


class  SpeechRecognitionService
    : public SpeechRecognitionServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpeechRecognitionServiceInterfaceBase;
  using Proxy_ = SpeechRecognitionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionServiceStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindContextMinVersion = 0,
    kSetUrlLoaderFactoryMinVersion = 0,
    kSetSodaPathMinVersion = 0,
    kBindSpeechRecognitionServiceClientMinVersion = 0,
  };
  virtual ~SpeechRecognitionService() {}

  
  virtual void BindContext(::mojo::PendingReceiver<SpeechRecognitionContext> context) = 0;

  
  virtual void SetUrlLoaderFactory(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory) = 0;

  
  virtual void SetSodaPath(const ::base::FilePath& binary_path, const ::base::FilePath& config_path) = 0;

  
  virtual void BindSpeechRecognitionServiceClient(::mojo::PendingRemote<SpeechRecognitionServiceClient> client) = 0;
};

class SpeechRecognitionServiceClientProxy;

template <typename ImplRefTraits>
class SpeechRecognitionServiceClientStub;

class SpeechRecognitionServiceClientRequestValidator;


class  SpeechRecognitionServiceClient
    : public SpeechRecognitionServiceClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpeechRecognitionServiceClientInterfaceBase;
  using Proxy_ = SpeechRecognitionServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNetworkServiceDisconnectMinVersion = 0,
  };
  virtual ~SpeechRecognitionServiceClient() {}

  
  virtual void OnNetworkServiceDisconnect() = 0;
};

class SpeechRecognitionRecognizerProxy;

template <typename ImplRefTraits>
class SpeechRecognitionRecognizerStub;

class SpeechRecognitionRecognizerRequestValidator;


class  SpeechRecognitionRecognizer
    : public SpeechRecognitionRecognizerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpeechRecognitionRecognizerInterfaceBase;
  using Proxy_ = SpeechRecognitionRecognizerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionRecognizerStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionRecognizerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendAudioToSpeechRecognitionServiceMinVersion = 0,
  };
  virtual ~SpeechRecognitionRecognizer() {}

  
  virtual void SendAudioToSpeechRecognitionService(::media::mojom::AudioDataS16Ptr buffer) = 0;
};

class SpeechRecognitionRecognizerClientProxy;

template <typename ImplRefTraits>
class SpeechRecognitionRecognizerClientStub;

class SpeechRecognitionRecognizerClientRequestValidator;


class  SpeechRecognitionRecognizerClient
    : public SpeechRecognitionRecognizerClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpeechRecognitionRecognizerClientInterfaceBase;
  using Proxy_ = SpeechRecognitionRecognizerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionRecognizerClientStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionRecognizerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSpeechRecognitionRecognitionEventMinVersion = 0,
  };
  virtual ~SpeechRecognitionRecognizerClient() {}

  
  virtual void OnSpeechRecognitionRecognitionEvent(SpeechRecognitionResultPtr result) = 0;
};



class  SpeechRecognitionContextProxy
    : public SpeechRecognitionContext {
 public:
  using InterfaceType = SpeechRecognitionContext;

  explicit SpeechRecognitionContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, BindRecognizerCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionServiceProxy
    : public SpeechRecognitionService {
 public:
  using InterfaceType = SpeechRecognitionService;

  explicit SpeechRecognitionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindContext(::mojo::PendingReceiver<SpeechRecognitionContext> context) final;
  
  void SetUrlLoaderFactory(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory) final;
  
  void SetSodaPath(const ::base::FilePath& binary_path, const ::base::FilePath& config_path) final;
  
  void BindSpeechRecognitionServiceClient(::mojo::PendingRemote<SpeechRecognitionServiceClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionServiceClientProxy
    : public SpeechRecognitionServiceClient {
 public:
  using InterfaceType = SpeechRecognitionServiceClient;

  explicit SpeechRecognitionServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNetworkServiceDisconnect() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionRecognizerProxy
    : public SpeechRecognitionRecognizer {
 public:
  using InterfaceType = SpeechRecognitionRecognizer;

  explicit SpeechRecognitionRecognizerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendAudioToSpeechRecognitionService(::media::mojom::AudioDataS16Ptr buffer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionRecognizerClientProxy
    : public SpeechRecognitionRecognizerClient {
 public:
  using InterfaceType = SpeechRecognitionRecognizerClient;

  explicit SpeechRecognitionRecognizerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSpeechRecognitionRecognitionEvent(SpeechRecognitionResultPtr result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SpeechRecognitionContextStubDispatch {
 public:
  static bool Accept(SpeechRecognitionContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionContext>>
class SpeechRecognitionContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionContextStub() {}
  ~SpeechRecognitionContextStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionServiceStubDispatch {
 public:
  static bool Accept(SpeechRecognitionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionService>>
class SpeechRecognitionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionServiceStub() {}
  ~SpeechRecognitionServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionServiceClientStubDispatch {
 public:
  static bool Accept(SpeechRecognitionServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionServiceClient>>
class SpeechRecognitionServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionServiceClientStub() {}
  ~SpeechRecognitionServiceClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionRecognizerStubDispatch {
 public:
  static bool Accept(SpeechRecognitionRecognizer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionRecognizer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionRecognizer>>
class SpeechRecognitionRecognizerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionRecognizerStub() {}
  ~SpeechRecognitionRecognizerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionRecognizerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionRecognizerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionRecognizerClientStubDispatch {
 public:
  static bool Accept(SpeechRecognitionRecognizerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionRecognizerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionRecognizerClient>>
class SpeechRecognitionRecognizerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionRecognizerClientStub() {}
  ~SpeechRecognitionRecognizerClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionRecognizerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionRecognizerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionRecognizerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionRecognizerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  SpeechRecognitionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionResult, T>::value>;
  using DataView = SpeechRecognitionResultDataView;
  using Data_ = internal::SpeechRecognitionResult_Data;

  template <typename... Args>
  static SpeechRecognitionResultPtr New(Args&&... args) {
    return SpeechRecognitionResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionResultPtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionResult>::Convert(*this);
  }


  SpeechRecognitionResult();

  SpeechRecognitionResult(
      const std::string& transcription,
      bool is_final);

  ~SpeechRecognitionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionResultPtr>
  SpeechRecognitionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionResult_UnserializedMessageContext<
            UserType, SpeechRecognitionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SpeechRecognitionResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SpeechRecognitionResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionResult_UnserializedMessageContext<
            UserType, SpeechRecognitionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string transcription;
  
  bool is_final;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SpeechRecognitionResultPtr SpeechRecognitionResult::Clone() const {
  return New(
      mojo::Clone(transcription),
      mojo::Clone(is_final)
  );
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>*>
bool SpeechRecognitionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transcription, other_struct.transcription))
    return false;
  if (!mojo::Equals(this->is_final, other_struct.is_final))
    return false;
  return true;
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.transcription, rhs.transcription))
    return true;
  if (std::less<>{}(rhs.transcription, lhs.transcription))
    return false;
  if (std::less<>{}(lhs.is_final, rhs.is_final))
    return true;
  if (std::less<>{}(rhs.is_final, lhs.is_final))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::SpeechRecognitionResult::DataView,
                                         ::media::mojom::SpeechRecognitionResultPtr> {
  static bool IsNull(const ::media::mojom::SpeechRecognitionResultPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SpeechRecognitionResultPtr* output) { output->reset(); }

  static const decltype(::media::mojom::SpeechRecognitionResult::transcription)& transcription(
      const ::media::mojom::SpeechRecognitionResultPtr& input) {
    return input->transcription;
  }

  static decltype(::media::mojom::SpeechRecognitionResult::is_final) is_final(
      const ::media::mojom::SpeechRecognitionResultPtr& input) {
    return input->is_final;
  }

  static bool Read(::media::mojom::SpeechRecognitionResult::DataView input, ::media::mojom::SpeechRecognitionResultPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_H_