// media/mojo/mojom/frame_interface_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_FRAME_INTERFACE_FACTORY_MOJOM_H_
#define MEDIA_MOJO_MOJOM_FRAME_INTERFACE_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/frame_interface_factory.mojom-shared.h"
#include "media/mojo/mojom/frame_interface_factory.mojom-forward.h"
#include "media/mojo/mojom/cdm_storage.mojom.h"
#include "media/mojo/mojom/provision_fetcher.mojom.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {

class FrameInterfaceFactoryProxy;

template <typename ImplRefTraits>
class FrameInterfaceFactoryStub;

class FrameInterfaceFactoryRequestValidator;
class FrameInterfaceFactoryResponseValidator;


class  FrameInterfaceFactory
    : public FrameInterfaceFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = FrameInterfaceFactoryInterfaceBase;
  using Proxy_ = FrameInterfaceFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameInterfaceFactoryStub<ImplRefTraits>;

  using RequestValidator_ = FrameInterfaceFactoryRequestValidator;
  using ResponseValidator_ = FrameInterfaceFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateProvisionFetcherMinVersion = 0,
    kCreateCdmStorageMinVersion = 0,
    kGetCdmOriginMinVersion = 0,
    kBindEmbedderReceiverMinVersion = 0,
  };
  virtual ~FrameInterfaceFactory() {}

  
  virtual void CreateProvisionFetcher(::mojo::PendingReceiver<::media::mojom::ProvisionFetcher> provision_fetcher) = 0;

  
  virtual void CreateCdmStorage(::mojo::PendingReceiver<::media::mojom::CdmStorage> cdm_storage) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetCdmOrigin(::url::Origin* out_cdm_origin);

  using GetCdmOriginCallback = base::OnceCallback<void(const ::url::Origin&)>;
  
  virtual void GetCdmOrigin(GetCdmOriginCallback callback) = 0;

  
  virtual void BindEmbedderReceiver(::mojo::GenericPendingReceiver receiver) = 0;
};



class  FrameInterfaceFactoryProxy
    : public FrameInterfaceFactory {
 public:
  using InterfaceType = FrameInterfaceFactory;

  explicit FrameInterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateProvisionFetcher(::mojo::PendingReceiver<::media::mojom::ProvisionFetcher> provision_fetcher) final;
  
  void CreateCdmStorage(::mojo::PendingReceiver<::media::mojom::CdmStorage> cdm_storage) final;
  
  bool GetCdmOrigin(::url::Origin* out_cdm_origin) final;
  
  void GetCdmOrigin(GetCdmOriginCallback callback) final;
  
  void BindEmbedderReceiver(::mojo::GenericPendingReceiver receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameInterfaceFactoryStubDispatch {
 public:
  static bool Accept(FrameInterfaceFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameInterfaceFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameInterfaceFactory>>
class FrameInterfaceFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameInterfaceFactoryStub() {}
  ~FrameInterfaceFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameInterfaceFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameInterfaceFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameInterfaceFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameInterfaceFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_FRAME_INTERFACE_FACTORY_MOJOM_H_