// media/midi/midi_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MIDI_MIDI_SERVICE_MOJOM_BLINK_H_
#define MEDIA_MIDI_MIDI_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/midi/midi_service.mojom-shared.h"
#include "media/midi/midi_service.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"






namespace WTF {
struct midi_mojom_internal_Result_DataHashFn {
  static unsigned GetHash(const ::midi::mojom::Result& value) {
    using utype = std::underlying_type<::midi::mojom::Result>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::midi::mojom::Result& left, const ::midi::mojom::Result& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::midi::mojom::Result>
    : public GenericHashTraits<::midi::mojom::Result> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::midi::mojom::Result& value) {
    return value == static_cast<::midi::mojom::Result>(-1000000);
  }
  static void ConstructDeletedValue(::midi::mojom::Result& slot, bool) {
    slot = static_cast<::midi::mojom::Result>(-1000001);
  }
  static bool IsDeletedValue(const ::midi::mojom::Result& value) {
    return value == static_cast<::midi::mojom::Result>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct midi_mojom_internal_PortState_DataHashFn {
  static unsigned GetHash(const ::midi::mojom::PortState& value) {
    using utype = std::underlying_type<::midi::mojom::PortState>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::midi::mojom::PortState& left, const ::midi::mojom::PortState& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::midi::mojom::PortState>
    : public GenericHashTraits<::midi::mojom::PortState> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::midi::mojom::PortState& value) {
    return value == static_cast<::midi::mojom::PortState>(-1000000);
  }
  static void ConstructDeletedValue(::midi::mojom::PortState& slot, bool) {
    slot = static_cast<::midi::mojom::PortState>(-1000001);
  }
  static bool IsDeletedValue(const ::midi::mojom::PortState& value) {
    return value == static_cast<::midi::mojom::PortState>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace midi {
namespace mojom {
namespace blink {

class MidiSessionClientProxy;

template <typename ImplRefTraits>
class MidiSessionClientStub;

class MidiSessionClientRequestValidator;


class  MidiSessionClient
    : public MidiSessionClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MidiSessionClientInterfaceBase;
  using Proxy_ = MidiSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = MidiSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = MidiSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddInputPortMinVersion = 0,
    kAddOutputPortMinVersion = 0,
    kSetInputPortStateMinVersion = 0,
    kSetOutputPortStateMinVersion = 0,
    kSessionStartedMinVersion = 0,
    kAcknowledgeSentDataMinVersion = 0,
    kDataReceivedMinVersion = 0,
  };
  virtual ~MidiSessionClient() {}

  
  virtual void AddInputPort(PortInfoPtr info) = 0;

  
  virtual void AddOutputPort(PortInfoPtr info) = 0;

  
  virtual void SetInputPortState(uint32_t port, PortState state) = 0;

  
  virtual void SetOutputPortState(uint32_t port, PortState state) = 0;

  
  virtual void SessionStarted(Result result) = 0;

  
  virtual void AcknowledgeSentData(uint32_t bytes) = 0;

  
  virtual void DataReceived(uint32_t port, const WTF::Vector<uint8_t>& data, ::base::TimeTicks timestamp) = 0;
};

class MidiSessionProviderProxy;

template <typename ImplRefTraits>
class MidiSessionProviderStub;

class MidiSessionProviderRequestValidator;


class  MidiSessionProvider
    : public MidiSessionProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MidiSessionProviderInterfaceBase;
  using Proxy_ = MidiSessionProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = MidiSessionProviderStub<ImplRefTraits>;

  using RequestValidator_ = MidiSessionProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartSessionMinVersion = 0,
  };
  virtual ~MidiSessionProvider() {}

  
  virtual void StartSession(::mojo::PendingReceiver<MidiSession> receiver, ::mojo::PendingRemote<MidiSessionClient> client) = 0;
};

class MidiSessionProxy;

template <typename ImplRefTraits>
class MidiSessionStub;

class MidiSessionRequestValidator;


class  MidiSession
    : public MidiSessionInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MidiSessionInterfaceBase;
  using Proxy_ = MidiSessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = MidiSessionStub<ImplRefTraits>;

  using RequestValidator_ = MidiSessionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendDataMinVersion = 0,
  };
  virtual ~MidiSession() {}

  
  virtual void SendData(uint32_t port, const WTF::Vector<uint8_t>& data, ::base::TimeTicks timestamp) = 0;
};



class  MidiSessionClientProxy
    : public MidiSessionClient {
 public:
  using InterfaceType = MidiSessionClient;

  explicit MidiSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddInputPort(PortInfoPtr info) final;
  
  void AddOutputPort(PortInfoPtr info) final;
  
  void SetInputPortState(uint32_t port, PortState state) final;
  
  void SetOutputPortState(uint32_t port, PortState state) final;
  
  void SessionStarted(Result result) final;
  
  void AcknowledgeSentData(uint32_t bytes) final;
  
  void DataReceived(uint32_t port, const WTF::Vector<uint8_t>& data, ::base::TimeTicks timestamp) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MidiSessionProviderProxy
    : public MidiSessionProvider {
 public:
  using InterfaceType = MidiSessionProvider;

  explicit MidiSessionProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartSession(::mojo::PendingReceiver<MidiSession> receiver, ::mojo::PendingRemote<MidiSessionClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MidiSessionProxy
    : public MidiSession {
 public:
  using InterfaceType = MidiSession;

  explicit MidiSessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendData(uint32_t port, const WTF::Vector<uint8_t>& data, ::base::TimeTicks timestamp) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MidiSessionClientStubDispatch {
 public:
  static bool Accept(MidiSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MidiSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MidiSessionClient>>
class MidiSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MidiSessionClientStub() {}
  ~MidiSessionClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MidiSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MidiSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MidiSessionProviderStubDispatch {
 public:
  static bool Accept(MidiSessionProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MidiSessionProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MidiSessionProvider>>
class MidiSessionProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MidiSessionProviderStub() {}
  ~MidiSessionProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MidiSessionProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MidiSessionProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MidiSessionStubDispatch {
 public:
  static bool Accept(MidiSession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MidiSession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MidiSession>>
class MidiSessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MidiSessionStub() {}
  ~MidiSessionStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MidiSessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MidiSessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MidiSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MidiSessionProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MidiSessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  PortInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PortInfo, T>::value>;
  using DataView = PortInfoDataView;
  using Data_ = internal::PortInfo_Data;

  template <typename... Args>
  static PortInfoPtr New(Args&&... args) {
    return PortInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PortInfoPtr From(const U& u) {
    return mojo::TypeConverter<PortInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PortInfo>::Convert(*this);
  }


  PortInfo();

  PortInfo(
      const WTF::String& id,
      const WTF::String& manufacturer,
      const WTF::String& name,
      const WTF::String& version,
      PortState state);

  ~PortInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PortInfoPtr>
  PortInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PortInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PortInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PortInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PortInfo_UnserializedMessageContext<
            UserType, PortInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PortInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PortInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PortInfo_UnserializedMessageContext<
            UserType, PortInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PortInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String id;
  
  WTF::String manufacturer;
  
  WTF::String name;
  
  WTF::String version;
  
  PortState state;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PortInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PortInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PortInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PortInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PortInfoPtr PortInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(manufacturer),
      mojo::Clone(name),
      mojo::Clone(version),
      mojo::Clone(state)
  );
}

template <typename T, PortInfo::EnableIfSame<T>*>
bool PortInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->manufacturer, other_struct.manufacturer))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  return true;
}

template <typename T, PortInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.manufacturer, rhs.manufacturer))
    return true;
  if (std::less<>{}(rhs.manufacturer, lhs.manufacturer))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.version, rhs.version))
    return true;
  if (std::less<>{}(rhs.version, lhs.version))
    return false;
  if (std::less<>{}(lhs.state, rhs.state))
    return true;
  if (std::less<>{}(rhs.state, lhs.state))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace midi

namespace mojo {


template <>
struct  StructTraits<::midi::mojom::blink::PortInfo::DataView,
                                         ::midi::mojom::blink::PortInfoPtr> {
  static bool IsNull(const ::midi::mojom::blink::PortInfoPtr& input) { return !input; }
  static void SetToNull(::midi::mojom::blink::PortInfoPtr* output) { output->reset(); }

  static const decltype(::midi::mojom::blink::PortInfo::id)& id(
      const ::midi::mojom::blink::PortInfoPtr& input) {
    return input->id;
  }

  static const decltype(::midi::mojom::blink::PortInfo::manufacturer)& manufacturer(
      const ::midi::mojom::blink::PortInfoPtr& input) {
    return input->manufacturer;
  }

  static const decltype(::midi::mojom::blink::PortInfo::name)& name(
      const ::midi::mojom::blink::PortInfoPtr& input) {
    return input->name;
  }

  static const decltype(::midi::mojom::blink::PortInfo::version)& version(
      const ::midi::mojom::blink::PortInfoPtr& input) {
    return input->version;
  }

  static decltype(::midi::mojom::blink::PortInfo::state) state(
      const ::midi::mojom::blink::PortInfoPtr& input) {
    return input->state;
  }

  static bool Read(::midi::mojom::blink::PortInfo::DataView input, ::midi::mojom::blink::PortInfoPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MIDI_MIDI_SERVICE_MOJOM_BLINK_H_