// Copyright (c) 2024 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/incognito.json
// DO NOT EDIT.

#ifndef EXTENSIONS_COMMON_API_INCOGNITO_H__
#define EXTENSIONS_COMMON_API_INCOGNITO_H__

#include <stdint.h>

#include <map>
#include <memory>
#include <string>
#include <vector>

#include "base/values.h"
#include "base/strings/string_piece.h"


namespace extensions {
namespace api {
namespace incognito {

//
// Types
//

enum IncognitoMode {
  INCOGNITO_MODE_NONE,
  INCOGNITO_MODE_SPLIT,
  INCOGNITO_MODE_SPANNING,
  INCOGNITO_MODE_NOT_ALLOWED,
  INCOGNITO_MODE_LAST = INCOGNITO_MODE_NOT_ALLOWED,
};


const char* ToString(IncognitoMode as_enum);
IncognitoMode ParseIncognitoMode(const std::string& as_string);


//
// Manifest Keys
//

struct ManifestKeys {
  ManifestKeys();
  ~ManifestKeys();
  ManifestKeys(ManifestKeys&& rhs);
  ManifestKeys& operator=(ManifestKeys&& rhs);

  // Manifest key constants.
  static constexpr char kIncognito[] = "incognito";

  // Parses manifest keys for this namespace. Any keys not available to the
  // manifest will be ignored. On a parsing error, false is returned and |error|
  // is populated.
  static bool ParseFromDictionary(const base::DictionaryValue& root_dict, ManifestKeys* out, base::string16* error);


  // Configures whether and how the extension runs in incognito mode. Default mode
  // is <code>spanning</code>.
  IncognitoMode incognito;


 private:
  DISALLOW_COPY_AND_ASSIGN(ManifestKeys);
};

}  // namespace incognito
}  // namespace api
}  // namespace extensions
#endif  // EXTENSIONS_COMMON_API_INCOGNITO_H__
