// Copyright (c) 2024 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/incognito.json
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/incognito.h"
#include <set>
#include <utility>
#include "tools/json_schema_compiler/manifest_parse_util.h"

#include "base/strings/string_piece.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace incognito {
//
// Types
//

const char* ToString(IncognitoMode enum_param) {
  switch (enum_param) {
    case INCOGNITO_MODE_SPLIT:
      return "split";
    case INCOGNITO_MODE_SPANNING:
      return "spanning";
    case INCOGNITO_MODE_NOT_ALLOWED:
      return "not_allowed";
    case INCOGNITO_MODE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

IncognitoMode ParseIncognitoMode(const std::string& enum_string) {
  if (enum_string == "split")
    return INCOGNITO_MODE_SPLIT;
  if (enum_string == "spanning")
    return INCOGNITO_MODE_SPANNING;
  if (enum_string == "not_allowed")
    return INCOGNITO_MODE_NOT_ALLOWED;
  return INCOGNITO_MODE_NONE;
}



//
// Manifest Keys
//

ManifestKeys::ManifestKeys()
: incognito(INCOGNITO_MODE_NONE) {}

ManifestKeys::~ManifestKeys() {}
ManifestKeys::ManifestKeys(ManifestKeys&& rhs)

#if !defined(__GNUC__) || __GNUC__ > 5
: incognito(rhs.incognito)
{
}
#else
: incognito(rhs.incognito)
{
}
#endif

ManifestKeys& ManifestKeys::operator=(ManifestKeys&& rhs)

#if !defined(__GNUC__) || __GNUC__ > 5
{incognito = rhs.incognito;
return *this;
}
#else
{incognito = rhs.incognito;
return *this;
}
#endif

// static
constexpr char ManifestKeys::kIncognito[];

//static
bool ManifestKeys::ParseFromDictionary(
const base::DictionaryValue& root_dict, ManifestKeys* out, base::string16* error) {
  DCHECK(out);
  DCHECK(error);

  std::vector<base::StringPiece> error_path_reversed_vec;
  auto* error_path_reversed = &error_path_reversed_vec;
  const base::DictionaryValue& dict = root_dict;
  out->incognito = INCOGNITO_MODE_NONE;
  if (!::json_schema_compiler::manifest_parse_util::ParseEnumFromDictionary(dict, kIncognito, &ParseIncognitoMode, true, INCOGNITO_MODE_NONE, &out->incognito, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  return true;
}


}  // namespace incognito
}  // namespace api
}  // namespace extensions

