// device/vr/public/mojom/isolated_xr_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/vr/public/mojom/isolated_xr_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "device/vr/public/mojom/isolated_xr_service.mojom-params-data.h"
#include "device/vr/public/mojom/isolated_xr_service.mojom-shared-message-ids.h"

#include "device/vr/public/mojom/isolated_xr_service.mojom-import-headers.h"


#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_JUMBO_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
XRRuntimeSessionOptions::XRRuntimeSessionOptions()
    : mode(),
      enabled_features(),
      render_process_id(),
      render_frame_id() {}

XRRuntimeSessionOptions::XRRuntimeSessionOptions(
    ::device::mojom::XRSessionMode mode_in,
    std::vector<::device::mojom::XRSessionFeature> enabled_features_in,
    int32_t render_process_id_in,
    int32_t render_frame_id_in)
    : mode(std::move(mode_in)),
      enabled_features(std::move(enabled_features_in)),
      render_process_id(std::move(render_process_id_in)),
      render_frame_id(std::move(render_frame_id_in)) {}

XRRuntimeSessionOptions::~XRRuntimeSessionOptions() = default;

void XRRuntimeSessionOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("mode", base::trace_event::ValueToString(this->mode));
  value->BeginArray("enabled_features");
  for (const auto& item0 : this->enabled_features) {
    value->AppendString(base::trace_event::ValueToString(item0));
  }
  value->EndArray();
  value->SetInteger("render_process_id", this->render_process_id);
  value->SetInteger("render_frame_id", this->render_frame_id);
}

bool XRRuntimeSessionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRRenderInfo::XRRenderInfo()
    : frame_id(),
      pose() {}

XRRenderInfo::XRRenderInfo(
    int16_t frame_id_in,
    ::device::mojom::VRPosePtr pose_in)
    : frame_id(std::move(frame_id_in)),
      pose(std::move(pose_in)) {}

XRRenderInfo::~XRRenderInfo() = default;

void XRRenderInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("frame_id", this->frame_id);
  if (this->pose.is_null()) {
    value->SetString("pose", "nullptr");
  } else {
    value->BeginDictionary("pose");
    this->pose->AsValueInto(value);
    value->EndDictionary();
  }
}

bool XRRenderInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDeviceData::XRDeviceData() {}

XRDeviceData::~XRDeviceData() = default;
size_t XRDeviceData::Hash(size_t seed) const {
  return seed;
}

void XRDeviceData::AsValueInto(base::trace_event::TracedValue* value) const {
}

bool XRDeviceData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char XRSessionController::Name_[] = "device.mojom.XRSessionController";

XRSessionControllerProxy::XRSessionControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRSessionControllerProxy::SetFrameDataRestricted(
    bool in_restricted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRSessionController::SetFrameDataRestricted", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("restricted", in_restricted);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRSessionController_SetFrameDataRestricted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRSessionController_SetFrameDataRestricted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->restricted = in_restricted;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionController::Name_);
  message.set_method_name("SetFrameDataRestricted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRSessionControllerStubDispatch::Accept(
    XRSessionController* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kXRSessionController_SetFrameDataRestricted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRSessionController::SetFrameDataRestricted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRSessionController::SetFrameDataRestricted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRSessionController_SetFrameDataRestricted_Params_Data* params =
          reinterpret_cast<internal::XRSessionController_SetFrameDataRestricted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_restricted{};
      XRSessionController_SetFrameDataRestricted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_restricted = input_data_view.restricted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameDataRestricted(
std::move(p_restricted));
      return true;
    }
  }
  return false;
}

// static
bool XRSessionControllerStubDispatch::AcceptWithResponder(
    XRSessionController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRSessionController_SetFrameDataRestricted_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRSessionControllerValidationInfo[] = {
    {internal::kXRSessionController_SetFrameDataRestricted_Name,
     {&internal::XRSessionController_SetFrameDataRestricted_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRSessionControllerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRSessionController::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRSessionControllerValidationInfo);
}

const char XRRuntimeEventListener::Name_[] = "device.mojom.XRRuntimeEventListener";

XRRuntimeEventListenerProxy::XRRuntimeEventListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRRuntimeEventListenerProxy::OnDisplayInfoChanged(
    ::device::mojom::VRDisplayInfoPtr in_display_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRRuntimeEventListener::OnDisplayInfoChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_display_info.is_null()) {
        raw_value->SetString("display_info", "nullptr");
      } else {
        raw_value->BeginDictionary("display_info");
        in_display_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntimeEventListener_OnDisplayInfoChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->display_info)::BaseType::BufferWriter
      display_info_writer;
  mojo::internal::Serialize<::device::mojom::VRDisplayInfoDataView>(
      in_display_info, buffer, &display_info_writer, &serialization_context);
  params->display_info.Set(
      display_info_writer.is_null() ? nullptr : display_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->display_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_info in XRRuntimeEventListener.OnDisplayInfoChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntimeEventListener::Name_);
  message.set_method_name("OnDisplayInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRRuntimeEventListenerProxy::OnVisibilityStateChanged(
    ::device::mojom::XRVisibilityState in_visibility_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRRuntimeEventListener::OnVisibilityStateChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("visibility_state", base::trace_event::ValueToString(in_visibility_state));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntimeEventListener_OnVisibilityStateChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::device::mojom::XRVisibilityState>(
      in_visibility_state, &params->visibility_state);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntimeEventListener::Name_);
  message.set_method_name("OnVisibilityStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRRuntimeEventListenerProxy::OnExitPresent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::XRRuntimeEventListener::OnExitPresent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntimeEventListener_OnExitPresent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntimeEventListener_OnExitPresent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntimeEventListener::Name_);
  message.set_method_name("OnExitPresent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRRuntimeEventListenerStubDispatch::Accept(
    XRRuntimeEventListener* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kXRRuntimeEventListener_OnDisplayInfoChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRRuntimeEventListener::OnDisplayInfoChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRRuntimeEventListener::OnDisplayInfoChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data* params =
          reinterpret_cast<internal::XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::VRDisplayInfoPtr p_display_info{};
      XRRuntimeEventListener_OnDisplayInfoChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDisplayInfo(&p_display_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntimeEventListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDisplayInfoChanged(
std::move(p_display_info));
      return true;
    }
    case internal::kXRRuntimeEventListener_OnVisibilityStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRRuntimeEventListener::OnVisibilityStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRRuntimeEventListener::OnVisibilityStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data* params =
          reinterpret_cast<internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::XRVisibilityState p_visibility_state{};
      XRRuntimeEventListener_OnVisibilityStateChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadVisibilityState(&p_visibility_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntimeEventListener::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVisibilityStateChanged(
std::move(p_visibility_state));
      return true;
    }
    case internal::kXRRuntimeEventListener_OnExitPresent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRRuntimeEventListener::OnExitPresent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRRuntimeEventListener::OnExitPresent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRRuntimeEventListener_OnExitPresent_Params_Data* params =
          reinterpret_cast<internal::XRRuntimeEventListener_OnExitPresent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      XRRuntimeEventListener_OnExitPresent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntimeEventListener::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExitPresent();
      return true;
    }
  }
  return false;
}

// static
bool XRRuntimeEventListenerStubDispatch::AcceptWithResponder(
    XRRuntimeEventListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRRuntimeEventListener_OnDisplayInfoChanged_Name: {
      break;
    }
    case internal::kXRRuntimeEventListener_OnVisibilityStateChanged_Name: {
      break;
    }
    case internal::kXRRuntimeEventListener_OnExitPresent_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRRuntimeEventListenerValidationInfo[] = {
    {internal::kXRRuntimeEventListener_OnDisplayInfoChanged_Name,
     {&internal::XRRuntimeEventListener_OnDisplayInfoChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRRuntimeEventListener_OnVisibilityStateChanged_Name,
     {&internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRRuntimeEventListener_OnExitPresent_Name,
     {&internal::XRRuntimeEventListener_OnExitPresent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRRuntimeEventListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRRuntimeEventListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRRuntimeEventListenerValidationInfo);
}

const char XRRuntime::Name_[] = "device.mojom.XRRuntime";

class XRRuntime_RequestSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRRuntime_RequestSession_ForwardToCallback(
      XRRuntime::RequestSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRRuntime::RequestSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRRuntime_RequestSession_ForwardToCallback);
};

class XRRuntime_ShutdownSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRRuntime_ShutdownSession_ForwardToCallback(
      XRRuntime::ShutdownSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRRuntime::ShutdownSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRRuntime_ShutdownSession_ForwardToCallback);
};

class XRRuntime_ListenToDeviceChanges_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRRuntime_ListenToDeviceChanges_ForwardToCallback(
      XRRuntime::ListenToDeviceChangesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRRuntime::ListenToDeviceChangesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRRuntime_ListenToDeviceChanges_ForwardToCallback);
};

XRRuntimeProxy::XRRuntimeProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRRuntimeProxy::RequestSession(
    XRRuntimeSessionOptionsPtr in_options, RequestSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRRuntime::RequestSession", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntime_RequestSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntime_RequestSession_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::device::mojom::XRRuntimeSessionOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in XRRuntime.RequestSession request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("RequestSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRRuntime_RequestSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void XRRuntimeProxy::ShutdownSession(
    ShutdownSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::XRRuntime::ShutdownSession");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntime_ShutdownSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntime_ShutdownSession_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("ShutdownSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRRuntime_ShutdownSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void XRRuntimeProxy::ListenToDeviceChanges(
    ::mojo::PendingAssociatedRemote<XRRuntimeEventListener> in_listener, ListenToDeviceChangesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRRuntime::ListenToDeviceChanges", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("listener", in_listener.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntime_ListenToDeviceChanges_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntime_ListenToDeviceChanges_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::device::mojom::XRRuntimeEventListenerAssociatedPtrInfoDataView>(
      in_listener, &params->listener, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid listener in XRRuntime.ListenToDeviceChanges request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("ListenToDeviceChanges");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRRuntime_ListenToDeviceChanges_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class XRRuntime_RequestSession_ProxyToResponder {
 public:
  static XRRuntime::RequestSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRRuntime_RequestSession_ProxyToResponder> proxy(
        new XRRuntime_RequestSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRRuntime_RequestSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRRuntime_RequestSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRRuntime_RequestSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRRuntime::RequestSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::XRSessionPtr in_session, ::mojo::PendingRemote<XRSessionController> in_controller);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRRuntime_RequestSession_ProxyToResponder);
};

bool XRRuntime_RequestSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::XRRuntime::RequestSessionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRRuntime_RequestSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRRuntime_RequestSession_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::device::mojom::XRSessionPtr p_session{};
  ::mojo::PendingRemote<XRSessionController> p_controller{};
  XRRuntime_RequestSession_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadSession(&p_session))
    success = false;
  if (success) {
    p_controller =
        input_data_view.TakeController<decltype(p_controller)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRRuntime::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_session), 
std::move(p_controller));
  return true;
}

void XRRuntime_RequestSession_ProxyToResponder::Run(
    ::device::mojom::XRSessionPtr in_session, ::mojo::PendingRemote<XRSessionController> in_controller) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::XRRuntime::RequestSessionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_session.is_null()) {
        raw_value->SetString("session", "nullptr");
      } else {
        raw_value->BeginDictionary("session");
        in_session->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("controller", in_controller.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntime_RequestSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntime_RequestSession_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->session)::BaseType::BufferWriter
      session_writer;
  mojo::internal::Serialize<::device::mojom::XRSessionDataView>(
      in_session, buffer, &session_writer, &serialization_context);
  params->session.Set(
      session_writer.is_null() ? nullptr : session_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionControllerInterfaceBase>>(
      in_controller, &params->controller, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::XRRuntime::RequestSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("RequestSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XRRuntime_ShutdownSession_ProxyToResponder {
 public:
  static XRRuntime::ShutdownSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRRuntime_ShutdownSession_ProxyToResponder> proxy(
        new XRRuntime_ShutdownSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRRuntime_ShutdownSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRRuntime_ShutdownSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRRuntime_ShutdownSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRRuntime::ShutdownSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRRuntime_ShutdownSession_ProxyToResponder);
};

bool XRRuntime_ShutdownSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::XRRuntime::ShutdownSessionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRRuntime_ShutdownSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRRuntime_ShutdownSession_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  XRRuntime_ShutdownSession_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRRuntime::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void XRRuntime_ShutdownSession_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::XRRuntime::ShutdownSessionCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntime_ShutdownSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntime_ShutdownSession_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::XRRuntime::ShutdownSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("ShutdownSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XRRuntime_ListenToDeviceChanges_ProxyToResponder {
 public:
  static XRRuntime::ListenToDeviceChangesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRRuntime_ListenToDeviceChanges_ProxyToResponder> proxy(
        new XRRuntime_ListenToDeviceChanges_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRRuntime_ListenToDeviceChanges_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRRuntime_ListenToDeviceChanges_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRRuntime_ListenToDeviceChanges_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRRuntime::ListenToDeviceChangesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::VRDisplayInfoPtr in_display_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRRuntime_ListenToDeviceChanges_ProxyToResponder);
};

bool XRRuntime_ListenToDeviceChanges_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::XRRuntime::ListenToDeviceChangesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XRRuntime_ListenToDeviceChanges_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRRuntime_ListenToDeviceChanges_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::device::mojom::VRDisplayInfoPtr p_display_info{};
  XRRuntime_ListenToDeviceChanges_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadDisplayInfo(&p_display_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRRuntime::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_display_info));
  return true;
}

void XRRuntime_ListenToDeviceChanges_ProxyToResponder::Run(
    ::device::mojom::VRDisplayInfoPtr in_display_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::XRRuntime::ListenToDeviceChangesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_display_info.is_null()) {
        raw_value->SetString("display_info", "nullptr");
      } else {
        raw_value->BeginDictionary("display_info");
        in_display_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRRuntime_ListenToDeviceChanges_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRRuntime_ListenToDeviceChanges_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->display_info)::BaseType::BufferWriter
      display_info_writer;
  mojo::internal::Serialize<::device::mojom::VRDisplayInfoDataView>(
      in_display_info, buffer, &display_info_writer, &serialization_context);
  params->display_info.Set(
      display_info_writer.is_null() ? nullptr : display_info_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::XRRuntime::ListenToDeviceChangesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("ListenToDeviceChanges");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XRRuntimeStubDispatch::Accept(
    XRRuntime* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kXRRuntime_RequestSession_Name: {
      break;
    }
    case internal::kXRRuntime_ShutdownSession_Name: {
      break;
    }
    case internal::kXRRuntime_ListenToDeviceChanges_Name: {
      break;
    }
  }
  return false;
}

// static
bool XRRuntimeStubDispatch::AcceptWithResponder(
    XRRuntime* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRRuntime_RequestSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRRuntime::RequestSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRRuntime::RequestSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRRuntime_RequestSession_Params_Data* params =
          reinterpret_cast<
              internal::XRRuntime_RequestSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRRuntimeSessionOptionsPtr p_options{};
      XRRuntime_RequestSession_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntime::Name_, 0, false);
        return false;
      }
      XRRuntime::RequestSessionCallback callback =
          XRRuntime_RequestSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSession(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kXRRuntime_ShutdownSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRRuntime::ShutdownSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRRuntime::ShutdownSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRRuntime_ShutdownSession_Params_Data* params =
          reinterpret_cast<
              internal::XRRuntime_ShutdownSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRRuntime_ShutdownSession_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntime::Name_, 1, false);
        return false;
      }
      XRRuntime::ShutdownSessionCallback callback =
          XRRuntime_ShutdownSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShutdownSession(std::move(callback));
      return true;
    }
    case internal::kXRRuntime_ListenToDeviceChanges_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRRuntime::ListenToDeviceChanges",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRRuntime::ListenToDeviceChanges");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRRuntime_ListenToDeviceChanges_Params_Data* params =
          reinterpret_cast<
              internal::XRRuntime_ListenToDeviceChanges_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<XRRuntimeEventListener> p_listener{};
      XRRuntime_ListenToDeviceChanges_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntime::Name_, 2, false);
        return false;
      }
      XRRuntime::ListenToDeviceChangesCallback callback =
          XRRuntime_ListenToDeviceChanges_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListenToDeviceChanges(
std::move(p_listener), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRRuntimeValidationInfo[] = {
    {internal::kXRRuntime_RequestSession_Name,
     {&internal::XRRuntime_RequestSession_Params_Data::Validate,
      &internal::XRRuntime_RequestSession_ResponseParams_Data::Validate}},
    {internal::kXRRuntime_ShutdownSession_Name,
     {&internal::XRRuntime_ShutdownSession_Params_Data::Validate,
      &internal::XRRuntime_ShutdownSession_ResponseParams_Data::Validate}},
    {internal::kXRRuntime_ListenToDeviceChanges_Name,
     {&internal::XRRuntime_ListenToDeviceChanges_Params_Data::Validate,
      &internal::XRRuntime_ListenToDeviceChanges_ResponseParams_Data::Validate}},
};

bool XRRuntimeRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRRuntime::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRRuntimeValidationInfo);
}

bool XRRuntimeResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRRuntime::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kXRRuntimeValidationInfo);

}
const char ImmersiveOverlay::Name_[] = "device.mojom.ImmersiveOverlay";

class ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback(
      ImmersiveOverlay::RequestNextOverlayPoseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ImmersiveOverlay::RequestNextOverlayPoseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback);
};

class ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback(
      ImmersiveOverlay::SubmitOverlayTextureCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ImmersiveOverlay::SubmitOverlayTextureCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback);
};

class ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback(
      ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback);
};

ImmersiveOverlayProxy::ImmersiveOverlayProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImmersiveOverlayProxy::RequestNextOverlayPose(
    RequestNextOverlayPoseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::ImmersiveOverlay::RequestNextOverlayPose");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImmersiveOverlay_RequestNextOverlayPose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("RequestNextOverlayPose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ImmersiveOverlayProxy::SubmitOverlayTexture(
    int16_t in_frame_id, ::mojo::PlatformHandle in_texture, const ::gfx::RectF& in_left_bounds, const ::gfx::RectF& in_right_bounds, SubmitOverlayTextureCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::ImmersiveOverlay::SubmitOverlayTexture", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("frame_id", in_frame_id);
      raw_value->SetBoolean("texture", in_texture.is_valid());
      raw_value->SetString("left_bounds", base::trace_event::ValueToString(in_left_bounds, "<value of type const ::gfx::RectF&>"));
      raw_value->SetString("right_bounds", base::trace_event::ValueToString(in_right_bounds, "<value of type const ::gfx::RectF&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImmersiveOverlay_SubmitOverlayTexture_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->frame_id = in_frame_id;
  mojo::internal::Serialize<mojo::PlatformHandle>(
      in_texture, &params->texture, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->texture),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid texture in ImmersiveOverlay.SubmitOverlayTexture request");
  typename decltype(params->left_bounds)::BaseType::BufferWriter
      left_bounds_writer;
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_left_bounds, buffer, &left_bounds_writer, &serialization_context);
  params->left_bounds.Set(
      left_bounds_writer.is_null() ? nullptr : left_bounds_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->left_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null left_bounds in ImmersiveOverlay.SubmitOverlayTexture request");
  typename decltype(params->right_bounds)::BaseType::BufferWriter
      right_bounds_writer;
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_right_bounds, buffer, &right_bounds_writer, &serialization_context);
  params->right_bounds.Set(
      right_bounds_writer.is_null() ? nullptr : right_bounds_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->right_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null right_bounds in ImmersiveOverlay.SubmitOverlayTexture request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("SubmitOverlayTexture");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ImmersiveOverlayProxy::SetOverlayAndWebXRVisibility(
    bool in_overlay_visible, bool in_webxr_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::ImmersiveOverlay::SetOverlayAndWebXRVisibility", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("overlay_visible", in_overlay_visible);
      raw_value->SetBoolean("webxr_visible", in_webxr_visible);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImmersiveOverlay_SetOverlayAndWebXRVisibility_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->overlay_visible = in_overlay_visible;
  params->webxr_visible = in_webxr_visible;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("SetOverlayAndWebXRVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ImmersiveOverlayProxy::RequestNotificationOnWebXrSubmitted(
    RequestNotificationOnWebXrSubmittedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmitted");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("RequestNotificationOnWebXrSubmitted");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder {
 public:
  static ImmersiveOverlay::RequestNextOverlayPoseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder> proxy(
        new ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ImmersiveOverlay::RequestNextOverlayPoseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      XRRenderInfoPtr in_render_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder);
};

bool ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::ImmersiveOverlay::RequestNextOverlayPoseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  XRRenderInfoPtr p_render_info{};
  ImmersiveOverlay_RequestNextOverlayPose_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadRenderInfo(&p_render_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImmersiveOverlay::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_render_info));
  return true;
}

void ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder::Run(
    XRRenderInfoPtr in_render_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::ImmersiveOverlay::RequestNextOverlayPoseCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_render_info.is_null()) {
        raw_value->SetString("render_info", "nullptr");
      } else {
        raw_value->BeginDictionary("render_info");
        in_render_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImmersiveOverlay_RequestNextOverlayPose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->render_info)::BaseType::BufferWriter
      render_info_writer;
  mojo::internal::Serialize<::device::mojom::XRRenderInfoDataView>(
      in_render_info, buffer, &render_info_writer, &serialization_context);
  params->render_info.Set(
      render_info_writer.is_null() ? nullptr : render_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->render_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null render_info in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::ImmersiveOverlay::RequestNextOverlayPoseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("RequestNextOverlayPose");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder {
 public:
  static ImmersiveOverlay::SubmitOverlayTextureCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder> proxy(
        new ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ImmersiveOverlay::SubmitOverlayTextureCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder);
};

bool ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::ImmersiveOverlay::SubmitOverlayTextureCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  ImmersiveOverlay_SubmitOverlayTexture_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImmersiveOverlay::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::ImmersiveOverlay::SubmitOverlayTextureCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImmersiveOverlay_SubmitOverlayTexture_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::ImmersiveOverlay::SubmitOverlayTextureCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("SubmitOverlayTexture");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder {
 public:
  static ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder> proxy(
        new ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder);
};

bool ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImmersiveOverlay::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("RequestNotificationOnWebXrSubmitted");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ImmersiveOverlayStubDispatch::Accept(
    ImmersiveOverlay* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kImmersiveOverlay_RequestNextOverlayPose_Name: {
      break;
    }
    case internal::kImmersiveOverlay_SubmitOverlayTexture_Name: {
      break;
    }
    case internal::kImmersiveOverlay_SetOverlayAndWebXRVisibility_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::ImmersiveOverlay::SetOverlayAndWebXRVisibility",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::ImmersiveOverlay::SetOverlayAndWebXRVisibility");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data* params =
          reinterpret_cast<internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_overlay_visible{};
      bool p_webxr_visible{};
      ImmersiveOverlay_SetOverlayAndWebXRVisibility_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_overlay_visible = input_data_view.overlay_visible();
      if (success)
        p_webxr_visible = input_data_view.webxr_visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImmersiveOverlay::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOverlayAndWebXRVisibility(
std::move(p_overlay_visible), 
std::move(p_webxr_visible));
      return true;
    }
    case internal::kImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Name: {
      break;
    }
  }
  return false;
}

// static
bool ImmersiveOverlayStubDispatch::AcceptWithResponder(
    ImmersiveOverlay* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kImmersiveOverlay_RequestNextOverlayPose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::ImmersiveOverlay::RequestNextOverlayPose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::ImmersiveOverlay::RequestNextOverlayPose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data* params =
          reinterpret_cast<
              internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ImmersiveOverlay_RequestNextOverlayPose_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImmersiveOverlay::Name_, 0, false);
        return false;
      }
      ImmersiveOverlay::RequestNextOverlayPoseCallback callback =
          ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNextOverlayPose(std::move(callback));
      return true;
    }
    case internal::kImmersiveOverlay_SubmitOverlayTexture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::ImmersiveOverlay::SubmitOverlayTexture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::ImmersiveOverlay::SubmitOverlayTexture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data* params =
          reinterpret_cast<
              internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int16_t p_frame_id{};
      ::mojo::PlatformHandle p_texture{};
      ::gfx::RectF p_left_bounds{};
      ::gfx::RectF p_right_bounds{};
      ImmersiveOverlay_SubmitOverlayTexture_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success)
        p_texture = input_data_view.TakeTexture();
      if (success && !input_data_view.ReadLeftBounds(&p_left_bounds))
        success = false;
      if (success && !input_data_view.ReadRightBounds(&p_right_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImmersiveOverlay::Name_, 1, false);
        return false;
      }
      ImmersiveOverlay::SubmitOverlayTextureCallback callback =
          ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitOverlayTexture(
std::move(p_frame_id), 
std::move(p_texture), 
std::move(p_left_bounds), 
std::move(p_right_bounds), std::move(callback));
      return true;
    }
    case internal::kImmersiveOverlay_SetOverlayAndWebXRVisibility_Name: {
      break;
    }
    case internal::kImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmitted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmitted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data* params =
          reinterpret_cast<
              internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImmersiveOverlay::Name_, 3, false);
        return false;
      }
      ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback callback =
          ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotificationOnWebXrSubmitted(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kImmersiveOverlayValidationInfo[] = {
    {internal::kImmersiveOverlay_RequestNextOverlayPose_Name,
     {&internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data::Validate,
      &internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data::Validate}},
    {internal::kImmersiveOverlay_SubmitOverlayTexture_Name,
     {&internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data::Validate,
      &internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data::Validate}},
    {internal::kImmersiveOverlay_SetOverlayAndWebXRVisibility_Name,
     {&internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Name,
     {&internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data::Validate,
      &internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data::Validate}},
};

bool ImmersiveOverlayRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::ImmersiveOverlay::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kImmersiveOverlayValidationInfo);
}

bool ImmersiveOverlayResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::ImmersiveOverlay::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kImmersiveOverlayValidationInfo);

}
const char XRCompositorHost::Name_[] = "device.mojom.XRCompositorHost";

XRCompositorHostProxy::XRCompositorHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRCompositorHostProxy::CreateImmersiveOverlay(
    ::mojo::PendingReceiver<ImmersiveOverlay> in_overlay) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRCompositorHost::CreateImmersiveOverlay", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("overlay", in_overlay.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRCompositorHost_CreateImmersiveOverlay_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRCompositorHost_CreateImmersiveOverlay_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::ImmersiveOverlayInterfaceBase>>(
      in_overlay, &params->overlay, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->overlay),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid overlay in XRCompositorHost.CreateImmersiveOverlay request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRCompositorHost::Name_);
  message.set_method_name("CreateImmersiveOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRCompositorHostStubDispatch::Accept(
    XRCompositorHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kXRCompositorHost_CreateImmersiveOverlay_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRCompositorHost::CreateImmersiveOverlay",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRCompositorHost::CreateImmersiveOverlay");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRCompositorHost_CreateImmersiveOverlay_Params_Data* params =
          reinterpret_cast<internal::XRCompositorHost_CreateImmersiveOverlay_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<ImmersiveOverlay> p_overlay{};
      XRCompositorHost_CreateImmersiveOverlay_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_overlay =
            input_data_view.TakeOverlay<decltype(p_overlay)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRCompositorHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateImmersiveOverlay(
std::move(p_overlay));
      return true;
    }
  }
  return false;
}

// static
bool XRCompositorHostStubDispatch::AcceptWithResponder(
    XRCompositorHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRCompositorHost_CreateImmersiveOverlay_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRCompositorHostValidationInfo[] = {
    {internal::kXRCompositorHost_CreateImmersiveOverlay_Name,
     {&internal::XRCompositorHost_CreateImmersiveOverlay_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRCompositorHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRCompositorHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRCompositorHostValidationInfo);
}

const char IsolatedXRRuntimeProviderClient::Name_[] = "device.mojom.IsolatedXRRuntimeProviderClient";

IsolatedXRRuntimeProviderClientProxy::IsolatedXRRuntimeProviderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IsolatedXRRuntimeProviderClientProxy::OnDeviceAdded(
    ::mojo::PendingRemote<XRRuntime> in_runtime, ::mojo::PendingRemote<XRCompositorHost> in_compositor_host, XRDeviceDataPtr in_device_data, ::device::mojom::XRDeviceId in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceAdded", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("runtime", in_runtime.is_valid());
      raw_value->SetBoolean("compositor_host", in_compositor_host.is_valid());
      if (in_device_data.is_null()) {
        raw_value->SetString("device_data", "nullptr");
      } else {
        raw_value->BeginDictionary("device_data");
        in_device_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("device_id", base::trace_event::ValueToString(in_device_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIsolatedXRRuntimeProviderClient_OnDeviceAdded_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRRuntimeInterfaceBase>>(
      in_runtime, &params->runtime, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->runtime),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid runtime in IsolatedXRRuntimeProviderClient.OnDeviceAdded request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRCompositorHostInterfaceBase>>(
      in_compositor_host, &params->compositor_host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->compositor_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid compositor_host in IsolatedXRRuntimeProviderClient.OnDeviceAdded request");
  typename decltype(params->device_data)::BaseType::BufferWriter
      device_data_writer;
  mojo::internal::Serialize<::device::mojom::XRDeviceDataDataView>(
      in_device_data, buffer, &device_data_writer, &serialization_context);
  params->device_data.Set(
      device_data_writer.is_null() ? nullptr : device_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_data in IsolatedXRRuntimeProviderClient.OnDeviceAdded request");
  mojo::internal::Serialize<::device::mojom::XRDeviceId>(
      in_device_id, &params->device_id);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IsolatedXRRuntimeProviderClient::Name_);
  message.set_method_name("OnDeviceAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IsolatedXRRuntimeProviderClientProxy::OnDeviceRemoved(
    ::device::mojom::XRDeviceId in_device_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceRemoved", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("device_index", base::trace_event::ValueToString(in_device_index));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIsolatedXRRuntimeProviderClient_OnDeviceRemoved_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::device::mojom::XRDeviceId>(
      in_device_index, &params->device_index);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IsolatedXRRuntimeProviderClient::Name_);
  message.set_method_name("OnDeviceRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IsolatedXRRuntimeProviderClientProxy::OnDevicesEnumerated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::IsolatedXRRuntimeProviderClient::OnDevicesEnumerated");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IsolatedXRRuntimeProviderClient::Name_);
  message.set_method_name("OnDevicesEnumerated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool IsolatedXRRuntimeProviderClientStubDispatch::Accept(
    IsolatedXRRuntimeProviderClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIsolatedXRRuntimeProviderClient_OnDeviceAdded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceAdded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceAdded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data* params =
          reinterpret_cast<internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<XRRuntime> p_runtime{};
      ::mojo::PendingRemote<XRCompositorHost> p_compositor_host{};
      XRDeviceDataPtr p_device_data{};
      ::device::mojom::XRDeviceId p_device_id{};
      IsolatedXRRuntimeProviderClient_OnDeviceAdded_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_runtime =
            input_data_view.TakeRuntime<decltype(p_runtime)>();
      }
      if (success) {
        p_compositor_host =
            input_data_view.TakeCompositorHost<decltype(p_compositor_host)>();
      }
      if (success && !input_data_view.ReadDeviceData(&p_device_data))
        success = false;
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IsolatedXRRuntimeProviderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceAdded(
std::move(p_runtime), 
std::move(p_compositor_host), 
std::move(p_device_data), 
std::move(p_device_id));
      return true;
    }
    case internal::kIsolatedXRRuntimeProviderClient_OnDeviceRemoved_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceRemoved",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceRemoved");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data* params =
          reinterpret_cast<internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::XRDeviceId p_device_index{};
      IsolatedXRRuntimeProviderClient_OnDeviceRemoved_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDeviceIndex(&p_device_index))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IsolatedXRRuntimeProviderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceRemoved(
std::move(p_device_index));
      return true;
    }
    case internal::kIsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::IsolatedXRRuntimeProviderClient::OnDevicesEnumerated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::IsolatedXRRuntimeProviderClient::OnDevicesEnumerated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data* params =
          reinterpret_cast<internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IsolatedXRRuntimeProviderClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDevicesEnumerated();
      return true;
    }
  }
  return false;
}

// static
bool IsolatedXRRuntimeProviderClientStubDispatch::AcceptWithResponder(
    IsolatedXRRuntimeProviderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIsolatedXRRuntimeProviderClient_OnDeviceAdded_Name: {
      break;
    }
    case internal::kIsolatedXRRuntimeProviderClient_OnDeviceRemoved_Name: {
      break;
    }
    case internal::kIsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIsolatedXRRuntimeProviderClientValidationInfo[] = {
    {internal::kIsolatedXRRuntimeProviderClient_OnDeviceAdded_Name,
     {&internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIsolatedXRRuntimeProviderClient_OnDeviceRemoved_Name,
     {&internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Name,
     {&internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IsolatedXRRuntimeProviderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::IsolatedXRRuntimeProviderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIsolatedXRRuntimeProviderClientValidationInfo);
}

const char IsolatedXRRuntimeProvider::Name_[] = "device.mojom.IsolatedXRRuntimeProvider";

IsolatedXRRuntimeProviderProxy::IsolatedXRRuntimeProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IsolatedXRRuntimeProviderProxy::RequestDevices(
    ::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::IsolatedXRRuntimeProvider::RequestDevices", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIsolatedXRRuntimeProvider_RequestDevices_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::IsolatedXRRuntimeProviderClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in IsolatedXRRuntimeProvider.RequestDevices request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IsolatedXRRuntimeProvider::Name_);
  message.set_method_name("RequestDevices");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool IsolatedXRRuntimeProviderStubDispatch::Accept(
    IsolatedXRRuntimeProvider* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIsolatedXRRuntimeProvider_RequestDevices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::IsolatedXRRuntimeProvider::RequestDevices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::IsolatedXRRuntimeProvider::RequestDevices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data* params =
          reinterpret_cast<internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> p_client{};
      IsolatedXRRuntimeProvider_RequestDevices_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IsolatedXRRuntimeProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDevices(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool IsolatedXRRuntimeProviderStubDispatch::AcceptWithResponder(
    IsolatedXRRuntimeProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIsolatedXRRuntimeProvider_RequestDevices_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIsolatedXRRuntimeProviderValidationInfo[] = {
    {internal::kIsolatedXRRuntimeProvider_RequestDevices_Name,
     {&internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IsolatedXRRuntimeProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::IsolatedXRRuntimeProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIsolatedXRRuntimeProviderValidationInfo);
}

const char XRDeviceService::Name_[] = "device.mojom.XRDeviceService";

XRDeviceServiceProxy::XRDeviceServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRDeviceServiceProxy::BindRuntimeProvider(
    ::mojo::PendingReceiver<IsolatedXRRuntimeProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRDeviceService::BindRuntimeProvider", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRDeviceService_BindRuntimeProvider_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRDeviceService_BindRuntimeProvider_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::IsolatedXRRuntimeProviderInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in XRDeviceService.BindRuntimeProvider request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRDeviceService::Name_);
  message.set_method_name("BindRuntimeProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRDeviceServiceProxy::BindTestHook(
    ::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRDeviceService::BindTestHook", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRDeviceService_BindTestHook_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::XRDeviceService_BindTestHook_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device_test::mojom::XRServiceTestHookInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in XRDeviceService.BindTestHook request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRDeviceService::Name_);
  message.set_method_name("BindTestHook");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRDeviceServiceStubDispatch::Accept(
    XRDeviceService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kXRDeviceService_BindRuntimeProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRDeviceService::BindRuntimeProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRDeviceService::BindRuntimeProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRDeviceService_BindRuntimeProvider_Params_Data* params =
          reinterpret_cast<internal::XRDeviceService_BindRuntimeProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<IsolatedXRRuntimeProvider> p_receiver{};
      XRDeviceService_BindRuntimeProvider_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRDeviceService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindRuntimeProvider(
std::move(p_receiver));
      return true;
    }
    case internal::kXRDeviceService_BindTestHook_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRDeviceService::BindTestHook",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRDeviceService::BindTestHook");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRDeviceService_BindTestHook_Params_Data* params =
          reinterpret_cast<internal::XRDeviceService_BindTestHook_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> p_receiver{};
      XRDeviceService_BindTestHook_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRDeviceService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestHook(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool XRDeviceServiceStubDispatch::AcceptWithResponder(
    XRDeviceService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRDeviceService_BindRuntimeProvider_Name: {
      break;
    }
    case internal::kXRDeviceService_BindTestHook_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRDeviceServiceValidationInfo[] = {
    {internal::kXRDeviceService_BindRuntimeProvider_Name,
     {&internal::XRDeviceService_BindRuntimeProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRDeviceService_BindTestHook_Name,
     {&internal::XRDeviceService_BindTestHook_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRDeviceServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRDeviceService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRDeviceServiceValidationInfo);
}

}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::XRRuntimeSessionOptions::DataView, ::device::mojom::XRRuntimeSessionOptionsPtr>::Read(
    ::device::mojom::XRRuntimeSessionOptions::DataView input,
    ::device::mojom::XRRuntimeSessionOptionsPtr* output) {
  bool success = true;
  ::device::mojom::XRRuntimeSessionOptionsPtr result(::device::mojom::XRRuntimeSessionOptions::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadEnabledFeatures(&result->enabled_features))
        success = false;
      if (success)
        result->render_process_id = input.render_process_id();
      if (success)
        result->render_frame_id = input.render_frame_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRRenderInfo::DataView, ::device::mojom::XRRenderInfoPtr>::Read(
    ::device::mojom::XRRenderInfo::DataView input,
    ::device::mojom::XRRenderInfoPtr* output) {
  bool success = true;
  ::device::mojom::XRRenderInfoPtr result(::device::mojom::XRRenderInfo::New());
  
      if (success)
        result->frame_id = input.frame_id();
      if (success && !input.ReadPose(&result->pose))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRDeviceData::DataView, ::device::mojom::XRDeviceDataPtr>::Read(
    ::device::mojom::XRDeviceData::DataView input,
    ::device::mojom::XRDeviceDataPtr* output) {
  bool success = true;
  ::device::mojom::XRDeviceDataPtr result(::device::mojom::XRDeviceData::New());
  
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif