// device/vr/public/mojom/isolated_xr_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "device/vr/public/mojom/isolated_xr_service.mojom-shared-internal.h"
#include "device/vr/public/mojom/browser_test_interfaces.mojom-shared.h"
#include "device/vr/public/mojom/vr_service.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace device {
namespace mojom {
class XRRuntimeSessionOptionsDataView;

class XRRenderInfoDataView;

class XRDeviceDataDataView;



}  // namespace mojom
}  // namespace device

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRRuntimeSessionOptionsDataView> {
  using Data = ::device::mojom::internal::XRRuntimeSessionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRRenderInfoDataView> {
  using Data = ::device::mojom::internal::XRRenderInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDeviceDataDataView> {
  using Data = ::device::mojom::internal::XRDeviceData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device {
namespace mojom {
// Interface base classes. They are used for type safety check.
class XRSessionControllerInterfaceBase {};

using XRSessionControllerPtrDataView =
    mojo::InterfacePtrDataView<XRSessionControllerInterfaceBase>;
using XRSessionControllerRequestDataView =
    mojo::InterfaceRequestDataView<XRSessionControllerInterfaceBase>;
using XRSessionControllerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRSessionControllerInterfaceBase>;
using XRSessionControllerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRSessionControllerInterfaceBase>;
class XRRuntimeEventListenerInterfaceBase {};

using XRRuntimeEventListenerPtrDataView =
    mojo::InterfacePtrDataView<XRRuntimeEventListenerInterfaceBase>;
using XRRuntimeEventListenerRequestDataView =
    mojo::InterfaceRequestDataView<XRRuntimeEventListenerInterfaceBase>;
using XRRuntimeEventListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRRuntimeEventListenerInterfaceBase>;
using XRRuntimeEventListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRRuntimeEventListenerInterfaceBase>;
class XRRuntimeInterfaceBase {};

using XRRuntimePtrDataView =
    mojo::InterfacePtrDataView<XRRuntimeInterfaceBase>;
using XRRuntimeRequestDataView =
    mojo::InterfaceRequestDataView<XRRuntimeInterfaceBase>;
using XRRuntimeAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRRuntimeInterfaceBase>;
using XRRuntimeAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRRuntimeInterfaceBase>;
class ImmersiveOverlayInterfaceBase {};

using ImmersiveOverlayPtrDataView =
    mojo::InterfacePtrDataView<ImmersiveOverlayInterfaceBase>;
using ImmersiveOverlayRequestDataView =
    mojo::InterfaceRequestDataView<ImmersiveOverlayInterfaceBase>;
using ImmersiveOverlayAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImmersiveOverlayInterfaceBase>;
using ImmersiveOverlayAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImmersiveOverlayInterfaceBase>;
class XRCompositorHostInterfaceBase {};

using XRCompositorHostPtrDataView =
    mojo::InterfacePtrDataView<XRCompositorHostInterfaceBase>;
using XRCompositorHostRequestDataView =
    mojo::InterfaceRequestDataView<XRCompositorHostInterfaceBase>;
using XRCompositorHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRCompositorHostInterfaceBase>;
using XRCompositorHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRCompositorHostInterfaceBase>;
class IsolatedXRRuntimeProviderClientInterfaceBase {};

using IsolatedXRRuntimeProviderClientPtrDataView =
    mojo::InterfacePtrDataView<IsolatedXRRuntimeProviderClientInterfaceBase>;
using IsolatedXRRuntimeProviderClientRequestDataView =
    mojo::InterfaceRequestDataView<IsolatedXRRuntimeProviderClientInterfaceBase>;
using IsolatedXRRuntimeProviderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IsolatedXRRuntimeProviderClientInterfaceBase>;
using IsolatedXRRuntimeProviderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IsolatedXRRuntimeProviderClientInterfaceBase>;
class IsolatedXRRuntimeProviderInterfaceBase {};

using IsolatedXRRuntimeProviderPtrDataView =
    mojo::InterfacePtrDataView<IsolatedXRRuntimeProviderInterfaceBase>;
using IsolatedXRRuntimeProviderRequestDataView =
    mojo::InterfaceRequestDataView<IsolatedXRRuntimeProviderInterfaceBase>;
using IsolatedXRRuntimeProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IsolatedXRRuntimeProviderInterfaceBase>;
using IsolatedXRRuntimeProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IsolatedXRRuntimeProviderInterfaceBase>;
class XRDeviceServiceInterfaceBase {};

using XRDeviceServicePtrDataView =
    mojo::InterfacePtrDataView<XRDeviceServiceInterfaceBase>;
using XRDeviceServiceRequestDataView =
    mojo::InterfaceRequestDataView<XRDeviceServiceInterfaceBase>;
using XRDeviceServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRDeviceServiceInterfaceBase>;
using XRDeviceServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRDeviceServiceInterfaceBase>;


class XRRuntimeSessionOptionsDataView {
 public:
  XRRuntimeSessionOptionsDataView() {}

  XRRuntimeSessionOptionsDataView(
      internal::XRRuntimeSessionOptions_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::device::mojom::XRSessionMode>(
        data_value, output);
  }

  ::device::mojom::XRSessionMode mode() const {
    return static_cast<::device::mojom::XRSessionMode>(data_->mode);
  }
  inline void GetEnabledFeaturesDataView(
      mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEnabledFeatures(UserType* output) {
    
    auto* pointer = data_->enabled_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, context_);
  }
  int32_t render_process_id() const {
    return data_->render_process_id;
  }
  int32_t render_frame_id() const {
    return data_->render_frame_id;
  }
 private:
  internal::XRRuntimeSessionOptions_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRRenderInfoDataView {
 public:
  XRRenderInfoDataView() {}

  XRRenderInfoDataView(
      internal::XRRenderInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int16_t frame_id() const {
    return data_->frame_id;
  }
  inline void GetPoseDataView(
      ::device::mojom::VRPoseDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPose(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRPoseDataView, UserType>(),
    "Attempting to read the optional `pose` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPose` instead "
    "of `ReadPose if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pose.Get();
    return mojo::internal::Deserialize<::device::mojom::VRPoseDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRRenderInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRDeviceDataDataView {
 public:
  XRDeviceDataDataView() {}

  XRDeviceDataDataView(
      internal::XRDeviceData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRDeviceData_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace device

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRRuntimeSessionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRuntimeSessionOptionsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRRuntimeSessionOptions_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::device::mojom::XRSessionMode>(
        Traits::mode(input), &(*output)->mode);
    decltype(Traits::enabled_features(input)) in_enabled_features = Traits::enabled_features(input);
    typename decltype((*output)->enabled_features)::BaseType::BufferWriter
        enabled_features_writer;
    const mojo::internal::ContainerValidateParams enabled_features_validate_params(
        0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        in_enabled_features, buffer, &enabled_features_writer, &enabled_features_validate_params,
        context);
    (*output)->enabled_features.Set(
        enabled_features_writer.is_null() ? nullptr : enabled_features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->enabled_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enabled_features in XRRuntimeSessionOptions struct");
    (*output)->render_process_id = Traits::render_process_id(input);
    (*output)->render_frame_id = Traits::render_frame_id(input);
  }

  static bool Deserialize(::device::mojom::internal::XRRuntimeSessionOptions_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRRuntimeSessionOptionsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRRenderInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRenderInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRRenderInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->frame_id = Traits::frame_id(input);
    decltype(Traits::pose(input)) in_pose = Traits::pose(input);
    typename decltype((*output)->pose)::BaseType::BufferWriter
        pose_writer;
    mojo::internal::Serialize<::device::mojom::VRPoseDataView>(
        in_pose, buffer, &pose_writer, context);
    (*output)->pose.Set(
        pose_writer.is_null() ? nullptr : pose_writer.data());
  }

  static bool Deserialize(::device::mojom::internal::XRRenderInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRRenderInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDeviceDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDeviceDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRDeviceData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
  }

  static bool Deserialize(::device::mojom::internal::XRDeviceData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDeviceDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device {
namespace mojom {

inline void XRRuntimeSessionOptionsDataView::GetEnabledFeaturesDataView(
    mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output) {
  auto pointer = data_->enabled_features.Get();
  *output = mojo::ArrayDataView<::device::mojom::XRSessionFeature>(pointer, context_);
}


inline void XRRenderInfoDataView::GetPoseDataView(
    ::device::mojom::VRPoseDataView* output) {
  auto pointer = data_->pose.Get();
  *output = ::device::mojom::VRPoseDataView(pointer, context_);
}





}  // namespace mojom
}  // namespace device

#endif  // DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SHARED_H_