// content/common/render_accessibility.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_PARAMS_DATA_H_
#define CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace content {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibilityHost_HandleAXEvents_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibilityHost_HandleAXEvents_Params_Data));
      new (data()) RenderAccessibilityHost_HandleAXEvents_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibilityHost_HandleAXEvents_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibilityHost_HandleAXEvents_Params_Data>(index_);
    }
    RenderAccessibilityHost_HandleAXEvents_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::ax::mojom::internal::AXTreeUpdate_Data>>> updates;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::ax::mojom::internal::AXEvent_Data>>> events;
  int32_t reset_token;
  uint8_t padfinal_[4];

 private:
  RenderAccessibilityHost_HandleAXEvents_Params_Data();
  ~RenderAccessibilityHost_HandleAXEvents_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibilityHost_HandleAXEvents_Params_Data) == 32,
              "Bad sizeof(RenderAccessibilityHost_HandleAXEvents_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data));
      new (data()) RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data>(index_);
    }
    RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data();
  ~RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data() = delete;
};
static_assert(sizeof(RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data) == 8,
              "Bad sizeof(RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibilityHost_HandleAXLocationChanges_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibilityHost_HandleAXLocationChanges_Params_Data));
      new (data()) RenderAccessibilityHost_HandleAXLocationChanges_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibilityHost_HandleAXLocationChanges_Params_Data>(index_);
    }
    RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::LocationChanges_Data>>> changes;

 private:
  RenderAccessibilityHost_HandleAXLocationChanges_Params_Data();
  ~RenderAccessibilityHost_HandleAXLocationChanges_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibilityHost_HandleAXLocationChanges_Params_Data) == 16,
              "Bad sizeof(RenderAccessibilityHost_HandleAXLocationChanges_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibility_SetMode_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibility_SetMode_Params_Data));
      new (data()) RenderAccessibility_SetMode_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibility_SetMode_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibility_SetMode_Params_Data>(index_);
    }
    RenderAccessibility_SetMode_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t ax_mode;
  uint8_t padfinal_[4];

 private:
  RenderAccessibility_SetMode_Params_Data();
  ~RenderAccessibility_SetMode_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_SetMode_Params_Data) == 16,
              "Bad sizeof(RenderAccessibility_SetMode_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibility_FatalError_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibility_FatalError_Params_Data));
      new (data()) RenderAccessibility_FatalError_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibility_FatalError_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibility_FatalError_Params_Data>(index_);
    }
    RenderAccessibility_FatalError_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  RenderAccessibility_FatalError_Params_Data();
  ~RenderAccessibility_FatalError_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_FatalError_Params_Data) == 8,
              "Bad sizeof(RenderAccessibility_FatalError_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibility_HitTest_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibility_HitTest_Params_Data));
      new (data()) RenderAccessibility_HitTest_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibility_HitTest_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibility_HitTest_Params_Data>(index_);
    }
    RenderAccessibility_HitTest_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Point_Data> point;
  int32_t event_to_fire;
  int32_t request_id;

 private:
  RenderAccessibility_HitTest_Params_Data();
  ~RenderAccessibility_HitTest_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_HitTest_Params_Data) == 24,
              "Bad sizeof(RenderAccessibility_HitTest_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibility_HitTest_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibility_HitTest_ResponseParams_Data));
      new (data()) RenderAccessibility_HitTest_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibility_HitTest_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibility_HitTest_ResponseParams_Data>(index_);
    }
    RenderAccessibility_HitTest_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::HitTestResponse_Data> hit_test_response;

 private:
  RenderAccessibility_HitTest_ResponseParams_Data();
  ~RenderAccessibility_HitTest_ResponseParams_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_HitTest_ResponseParams_Data) == 16,
              "Bad sizeof(RenderAccessibility_HitTest_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibility_PerformAction_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibility_PerformAction_Params_Data));
      new (data()) RenderAccessibility_PerformAction_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibility_PerformAction_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibility_PerformAction_Params_Data>(index_);
    }
    RenderAccessibility_PerformAction_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::ax::mojom::internal::AXActionData_Data> action_data;

 private:
  RenderAccessibility_PerformAction_Params_Data();
  ~RenderAccessibility_PerformAction_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_PerformAction_Params_Data) == 16,
              "Bad sizeof(RenderAccessibility_PerformAction_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderAccessibility_Reset_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderAccessibility_Reset_Params_Data));
      new (data()) RenderAccessibility_Reset_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderAccessibility_Reset_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderAccessibility_Reset_Params_Data>(index_);
    }
    RenderAccessibility_Reset_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reset_token;
  uint8_t padfinal_[4];

 private:
  RenderAccessibility_Reset_Params_Data();
  ~RenderAccessibility_Reset_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_Reset_Params_Data) == 16,
              "Bad sizeof(RenderAccessibility_Reset_Params_Data)");

}  // namespace internal


class RenderAccessibilityHost_HandleAXEvents_ParamsDataView {
 public:
  RenderAccessibilityHost_HandleAXEvents_ParamsDataView() {}

  RenderAccessibilityHost_HandleAXEvents_ParamsDataView(
      internal::RenderAccessibilityHost_HandleAXEvents_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUpdatesDataView(
      mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUpdates(UserType* output) {
    
    auto* pointer = data_->updates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>>(
        pointer, output, context_);
  }
  inline void GetEventsDataView(
      mojo::ArrayDataView<::ax::mojom::AXEventDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEvents(UserType* output) {
    
    auto* pointer = data_->events.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXEventDataView>>(
        pointer, output, context_);
  }
  int32_t reset_token() const {
    return data_->reset_token;
  }
 private:
  internal::RenderAccessibilityHost_HandleAXEvents_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RenderAccessibilityHost_HandleAXEvents_ResponseParamsDataView {
 public:
  RenderAccessibilityHost_HandleAXEvents_ResponseParamsDataView() {}

  RenderAccessibilityHost_HandleAXEvents_ResponseParamsDataView(
      internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* data_ = nullptr;
};



class RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView {
 public:
  RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView() {}

  RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView(
      internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetChangesDataView(
      mojo::ArrayDataView<LocationChangesDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadChanges(UserType* output) {
    
    auto* pointer = data_->changes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content::mojom::LocationChangesDataView>>(
        pointer, output, context_);
  }
 private:
  internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RenderAccessibility_SetMode_ParamsDataView {
 public:
  RenderAccessibility_SetMode_ParamsDataView() {}

  RenderAccessibility_SetMode_ParamsDataView(
      internal::RenderAccessibility_SetMode_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t ax_mode() const {
    return data_->ax_mode;
  }
 private:
  internal::RenderAccessibility_SetMode_Params_Data* data_ = nullptr;
};



class RenderAccessibility_FatalError_ParamsDataView {
 public:
  RenderAccessibility_FatalError_ParamsDataView() {}

  RenderAccessibility_FatalError_ParamsDataView(
      internal::RenderAccessibility_FatalError_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RenderAccessibility_FatalError_Params_Data* data_ = nullptr;
};



class RenderAccessibility_HitTest_ParamsDataView {
 public:
  RenderAccessibility_HitTest_ParamsDataView() {}

  RenderAccessibility_HitTest_ParamsDataView(
      internal::RenderAccessibility_HitTest_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPointDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPoint(UserType* output) {
    
    auto* pointer = data_->point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEventToFire(UserType* output) const {
    auto data_value = data_->event_to_fire;
    return mojo::internal::Deserialize<::ax::mojom::Event>(
        data_value, output);
  }

  ::ax::mojom::Event event_to_fire() const {
    return static_cast<::ax::mojom::Event>(data_->event_to_fire);
  }
  int32_t request_id() const {
    return data_->request_id;
  }
 private:
  internal::RenderAccessibility_HitTest_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RenderAccessibility_HitTest_ResponseParamsDataView {
 public:
  RenderAccessibility_HitTest_ResponseParamsDataView() {}

  RenderAccessibility_HitTest_ResponseParamsDataView(
      internal::RenderAccessibility_HitTest_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetHitTestResponseDataView(
      HitTestResponseDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHitTestResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::HitTestResponseDataView, UserType>(),
    "Attempting to read the optional `hit_test_response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHitTestResponse` instead "
    "of `ReadHitTestResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hit_test_response.Get();
    return mojo::internal::Deserialize<::content::mojom::HitTestResponseDataView>(
        pointer, output, context_);
  }
 private:
  internal::RenderAccessibility_HitTest_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RenderAccessibility_PerformAction_ParamsDataView {
 public:
  RenderAccessibility_PerformAction_ParamsDataView() {}

  RenderAccessibility_PerformAction_ParamsDataView(
      internal::RenderAccessibility_PerformAction_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataDataView(
      ::ax::mojom::AXActionDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadActionData(UserType* output) {
    
    auto* pointer = data_->action_data.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXActionDataDataView>(
        pointer, output, context_);
  }
 private:
  internal::RenderAccessibility_PerformAction_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RenderAccessibility_Reset_ParamsDataView {
 public:
  RenderAccessibility_Reset_ParamsDataView() {}

  RenderAccessibility_Reset_ParamsDataView(
      internal::RenderAccessibility_Reset_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t reset_token() const {
    return data_->reset_token;
  }
 private:
  internal::RenderAccessibility_Reset_Params_Data* data_ = nullptr;
};


inline void RenderAccessibilityHost_HandleAXEvents_ParamsDataView::GetUpdatesDataView(
    mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>* output) {
  auto pointer = data_->updates.Get();
  *output = mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>(pointer, context_);
}
inline void RenderAccessibilityHost_HandleAXEvents_ParamsDataView::GetEventsDataView(
    mojo::ArrayDataView<::ax::mojom::AXEventDataView>* output) {
  auto pointer = data_->events.Get();
  *output = mojo::ArrayDataView<::ax::mojom::AXEventDataView>(pointer, context_);
}




inline void RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView::GetChangesDataView(
    mojo::ArrayDataView<LocationChangesDataView>* output) {
  auto pointer = data_->changes.Get();
  *output = mojo::ArrayDataView<LocationChangesDataView>(pointer, context_);
}






inline void RenderAccessibility_HitTest_ParamsDataView::GetPointDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->point.Get();
  *output = ::gfx::mojom::PointDataView(pointer, context_);
}


inline void RenderAccessibility_HitTest_ResponseParamsDataView::GetHitTestResponseDataView(
    HitTestResponseDataView* output) {
  auto pointer = data_->hit_test_response.Get();
  *output = HitTestResponseDataView(pointer, context_);
}


inline void RenderAccessibility_PerformAction_ParamsDataView::GetActionDataDataView(
    ::ax::mojom::AXActionDataDataView* output) {
  auto pointer = data_->action_data.Get();
  *output = ::ax::mojom::AXActionDataDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_PARAMS_DATA_H_