// content/common/media/media_log_records.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/media/media_log_records.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/media/media_log_records.mojom-params-data.h"
#include "content/common/media/media_log_records.mojom-shared-message-ids.h"

#include "content/common/media/media_log_records.mojom-import-headers.h"


#ifndef CONTENT_COMMON_MEDIA_MEDIA_LOG_RECORDS_MOJOM_JUMBO_H_
#define CONTENT_COMMON_MEDIA_MEDIA_LOG_RECORDS_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char MediaInternalLogRecords::Name_[] = "content.mojom.MediaInternalLogRecords";

MediaInternalLogRecordsProxy::MediaInternalLogRecordsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaInternalLogRecordsProxy::Log(
    const std::vector<::media::MediaLogRecord>& in_events) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::MediaInternalLogRecords::Log", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("events");
      for (const auto& item0 : in_events) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::media::MediaLogRecord&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaInternalLogRecords_Log_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::MediaInternalLogRecords_Log_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->events)::BaseType::BufferWriter
      events_writer;
  const mojo::internal::ContainerValidateParams events_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MediaLogRecordDataView>>(
      in_events, buffer, &events_writer, &events_validate_params,
      &serialization_context);
  params->events.Set(
      events_writer.is_null() ? nullptr : events_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->events.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null events in MediaInternalLogRecords.Log request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaInternalLogRecords::Name_);
  message.set_method_name("Log");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaInternalLogRecordsStubDispatch::Accept(
    MediaInternalLogRecords* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kMediaInternalLogRecords_Log_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::MediaInternalLogRecords::Log",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::MediaInternalLogRecords::Log");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaInternalLogRecords_Log_Params_Data* params =
          reinterpret_cast<internal::MediaInternalLogRecords_Log_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::media::MediaLogRecord> p_events{};
      MediaInternalLogRecords_Log_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadEvents(&p_events))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaInternalLogRecords::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Log(
std::move(p_events));
      return true;
    }
  }
  return false;
}

// static
bool MediaInternalLogRecordsStubDispatch::AcceptWithResponder(
    MediaInternalLogRecords* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaInternalLogRecords_Log_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaInternalLogRecordsValidationInfo[] = {
    {internal::kMediaInternalLogRecords_Log_Name,
     {&internal::MediaInternalLogRecords_Log_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaInternalLogRecordsRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::MediaInternalLogRecords::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaInternalLogRecordsValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif