// content/browser/process_internals/process_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/browser/process_internals/process_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace mojom {
class SiteInstanceInfoDataView;

class FrameInfoDataView;

class WebContentsInfoDataView;

class IsolatedOriginInfoDataView;



}  // namespace mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojom::SiteInstanceInfoDataView> {
  using Data = ::mojom::internal::SiteInstanceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::FrameInfoDataView> {
  using Data = ::mojom::internal::FrameInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::WebContentsInfoDataView> {
  using Data = ::mojom::internal::WebContentsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::IsolatedOriginInfoDataView> {
  using Data = ::mojom::internal::IsolatedOriginInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojom {
// Interface base classes. They are used for type safety check.
class ProcessInternalsHandlerInterfaceBase {};

using ProcessInternalsHandlerPtrDataView =
    mojo::InterfacePtrDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProcessInternalsHandlerInterfaceBase>;
using ProcessInternalsHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProcessInternalsHandlerInterfaceBase>;


class SiteInstanceInfoDataView {
 public:
  SiteInstanceInfoDataView() {}

  SiteInstanceInfoDataView(
      internal::SiteInstanceInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  bool locked() const {
    return data_->locked;
  }
  inline void GetSiteUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSiteUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `site_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSiteUrl` instead "
    "of `ReadSiteUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->site_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetProcessLockUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProcessLockUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `process_lock_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProcessLockUrl` instead "
    "of `ReadProcessLockUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->process_lock_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  bool is_origin_keyed() const {
    return data_->is_origin_keyed;
  }
 private:
  internal::SiteInstanceInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameInfoDataView {
 public:
  FrameInfoDataView() {}

  FrameInfoDataView(
      internal::FrameInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  int32_t process_id() const {
    return data_->process_id;
  }
  inline void GetSiteInstanceDataView(
      SiteInstanceInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSiteInstance(UserType* output) {
    
    auto* pointer = data_->site_instance.Get();
    return mojo::internal::Deserialize<::mojom::SiteInstanceInfoDataView>(
        pointer, output, context_);
  }
  inline void GetLastCommittedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLastCommittedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `last_committed_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastCommittedUrl` instead "
    "of `ReadLastCommittedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_committed_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetSubframesDataView(
      mojo::ArrayDataView<FrameInfoDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubframes(UserType* output) {
    
    auto* pointer = data_->subframes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        pointer, output, context_);
  }
  bool is_bfcached() const {
    return data_->is_bfcached;
  }
 private:
  internal::FrameInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebContentsInfoDataView {
 public:
  WebContentsInfoDataView() {}

  WebContentsInfoDataView(
      internal::WebContentsInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetRootFrameDataView(
      FrameInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRootFrame(UserType* output) {
    
    auto* pointer = data_->root_frame.Get();
    return mojo::internal::Deserialize<::mojom::FrameInfoDataView>(
        pointer, output, context_);
  }
  inline void GetBfcachedRootFramesDataView(
      mojo::ArrayDataView<FrameInfoDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBfcachedRootFrames(UserType* output) {
    
    auto* pointer = data_->bfcached_root_frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        pointer, output, context_);
  }
 private:
  internal::WebContentsInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class IsolatedOriginInfoDataView {
 public:
  IsolatedOriginInfoDataView() {}

  IsolatedOriginInfoDataView(
      internal::IsolatedOriginInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSource(UserType* output) {
    
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::IsolatedOriginInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::SiteInstanceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::SiteInstanceInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::mojom::internal::SiteInstanceInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->id = Traits::id(input);
    (*output)->locked = Traits::locked(input);
    decltype(Traits::site_url(input)) in_site_url = Traits::site_url(input);
    typename decltype((*output)->site_url)::BaseType::BufferWriter
        site_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_site_url, buffer, &site_url_writer, context);
    (*output)->site_url.Set(
        site_url_writer.is_null() ? nullptr : site_url_writer.data());
    decltype(Traits::process_lock_url(input)) in_process_lock_url = Traits::process_lock_url(input);
    typename decltype((*output)->process_lock_url)::BaseType::BufferWriter
        process_lock_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_process_lock_url, buffer, &process_lock_url_writer, context);
    (*output)->process_lock_url.Set(
        process_lock_url_writer.is_null() ? nullptr : process_lock_url_writer.data());
    (*output)->is_origin_keyed = Traits::is_origin_keyed(input);
  }

  static bool Deserialize(::mojom::internal::SiteInstanceInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::SiteInstanceInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::FrameInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::FrameInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::mojom::internal::FrameInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->routing_id = Traits::routing_id(input);
    (*output)->process_id = Traits::process_id(input);
    decltype(Traits::site_instance(input)) in_site_instance = Traits::site_instance(input);
    typename decltype((*output)->site_instance)::BaseType::BufferWriter
        site_instance_writer;
    mojo::internal::Serialize<::mojom::SiteInstanceInfoDataView>(
        in_site_instance, buffer, &site_instance_writer, context);
    (*output)->site_instance.Set(
        site_instance_writer.is_null() ? nullptr : site_instance_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->site_instance.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_instance in FrameInfo struct");
    decltype(Traits::last_committed_url(input)) in_last_committed_url = Traits::last_committed_url(input);
    typename decltype((*output)->last_committed_url)::BaseType::BufferWriter
        last_committed_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_last_committed_url, buffer, &last_committed_url_writer, context);
    (*output)->last_committed_url.Set(
        last_committed_url_writer.is_null() ? nullptr : last_committed_url_writer.data());
    decltype(Traits::subframes(input)) in_subframes = Traits::subframes(input);
    typename decltype((*output)->subframes)::BaseType::BufferWriter
        subframes_writer;
    const mojo::internal::ContainerValidateParams subframes_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        in_subframes, buffer, &subframes_writer, &subframes_validate_params,
        context);
    (*output)->subframes.Set(
        subframes_writer.is_null() ? nullptr : subframes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->subframes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframes in FrameInfo struct");
    (*output)->is_bfcached = Traits::is_bfcached(input);
  }

  static bool Deserialize(::mojom::internal::FrameInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::FrameInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::WebContentsInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::WebContentsInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::mojom::internal::WebContentsInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::title(input)) in_title = Traits::title(input);
    typename decltype((*output)->title)::BaseType::BufferWriter
        title_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_title, buffer, &title_writer, context);
    (*output)->title.Set(
        title_writer.is_null() ? nullptr : title_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in WebContentsInfo struct");
    decltype(Traits::root_frame(input)) in_root_frame = Traits::root_frame(input);
    typename decltype((*output)->root_frame)::BaseType::BufferWriter
        root_frame_writer;
    mojo::internal::Serialize<::mojom::FrameInfoDataView>(
        in_root_frame, buffer, &root_frame_writer, context);
    (*output)->root_frame.Set(
        root_frame_writer.is_null() ? nullptr : root_frame_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->root_frame.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_frame in WebContentsInfo struct");
    decltype(Traits::bfcached_root_frames(input)) in_bfcached_root_frames = Traits::bfcached_root_frames(input);
    typename decltype((*output)->bfcached_root_frames)::BaseType::BufferWriter
        bfcached_root_frames_writer;
    const mojo::internal::ContainerValidateParams bfcached_root_frames_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::FrameInfoDataView>>(
        in_bfcached_root_frames, buffer, &bfcached_root_frames_writer, &bfcached_root_frames_validate_params,
        context);
    (*output)->bfcached_root_frames.Set(
        bfcached_root_frames_writer.is_null() ? nullptr : bfcached_root_frames_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->bfcached_root_frames.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bfcached_root_frames in WebContentsInfo struct");
  }

  static bool Deserialize(::mojom::internal::WebContentsInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::WebContentsInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::IsolatedOriginInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::IsolatedOriginInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::mojom::internal::IsolatedOriginInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    typename decltype((*output)->origin)::BaseType::BufferWriter
        origin_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_origin, buffer, &origin_writer, context);
    (*output)->origin.Set(
        origin_writer.is_null() ? nullptr : origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in IsolatedOriginInfo struct");
    decltype(Traits::source(input)) in_source = Traits::source(input);
    typename decltype((*output)->source)::BaseType::BufferWriter
        source_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_source, buffer, &source_writer, context);
    (*output)->source.Set(
        source_writer.is_null() ? nullptr : source_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->source.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source in IsolatedOriginInfo struct");
  }

  static bool Deserialize(::mojom::internal::IsolatedOriginInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::IsolatedOriginInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojom {

inline void SiteInstanceInfoDataView::GetSiteUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->site_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void SiteInstanceInfoDataView::GetProcessLockUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->process_lock_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}


inline void FrameInfoDataView::GetSiteInstanceDataView(
    SiteInstanceInfoDataView* output) {
  auto pointer = data_->site_instance.Get();
  *output = SiteInstanceInfoDataView(pointer, context_);
}
inline void FrameInfoDataView::GetLastCommittedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->last_committed_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void FrameInfoDataView::GetSubframesDataView(
    mojo::ArrayDataView<FrameInfoDataView>* output) {
  auto pointer = data_->subframes.Get();
  *output = mojo::ArrayDataView<FrameInfoDataView>(pointer, context_);
}


inline void WebContentsInfoDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebContentsInfoDataView::GetRootFrameDataView(
    FrameInfoDataView* output) {
  auto pointer = data_->root_frame.Get();
  *output = FrameInfoDataView(pointer, context_);
}
inline void WebContentsInfoDataView::GetBfcachedRootFramesDataView(
    mojo::ArrayDataView<FrameInfoDataView>* output) {
  auto pointer = data_->bfcached_root_frames.Get();
  *output = mojo::ArrayDataView<FrameInfoDataView>(pointer, context_);
}


inline void IsolatedOriginInfoDataView::GetOriginDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->origin.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void IsolatedOriginInfoDataView::GetSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom

#endif  // CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_SHARED_H_