// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Page_h
#define content_protocol_Page_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/dom.h"
#include "content/browser/devtools/protocol/io.h"
#include "content/browser/devtools/protocol/network.h"
#include "content/browser/devtools/protocol/runtime.h"

namespace content {
namespace protocol {
namespace Page {
using FrameId = String;
using TransitionType = String;
class NavigationEntry;
class ScreencastFrameMetadata;
using DialogType = String;
class AppManifestError;
class AppManifestParsedProperties;
class Viewport;
class InstallabilityErrorArgument;
class InstallabilityError;
using ReferrerPolicy = String;

// ------------- Forward and enum declarations.

namespace TransitionTypeEnum {
CONTENT_EXPORT extern const char Link[];
CONTENT_EXPORT extern const char Typed[];
CONTENT_EXPORT extern const char Address_bar[];
CONTENT_EXPORT extern const char Auto_bookmark[];
CONTENT_EXPORT extern const char Auto_subframe[];
CONTENT_EXPORT extern const char Manual_subframe[];
CONTENT_EXPORT extern const char Generated[];
CONTENT_EXPORT extern const char Auto_toplevel[];
CONTENT_EXPORT extern const char Form_submit[];
CONTENT_EXPORT extern const char Reload[];
CONTENT_EXPORT extern const char Keyword[];
CONTENT_EXPORT extern const char Keyword_generated[];
CONTENT_EXPORT extern const char Other[];
} // namespace TransitionTypeEnum

namespace DialogTypeEnum {
CONTENT_EXPORT extern const char Alert[];
CONTENT_EXPORT extern const char Confirm[];
CONTENT_EXPORT extern const char Prompt[];
CONTENT_EXPORT extern const char Beforeunload[];
} // namespace DialogTypeEnum

namespace ReferrerPolicyEnum {
CONTENT_EXPORT extern const char NoReferrer[];
CONTENT_EXPORT extern const char NoReferrerWhenDowngrade[];
CONTENT_EXPORT extern const char Origin[];
CONTENT_EXPORT extern const char OriginWhenCrossOrigin[];
CONTENT_EXPORT extern const char SameOrigin[];
CONTENT_EXPORT extern const char StrictOrigin[];
CONTENT_EXPORT extern const char StrictOriginWhenCrossOrigin[];
CONTENT_EXPORT extern const char UnsafeUrl[];
} // namespace ReferrerPolicyEnum

namespace CaptureScreenshot {
namespace FormatEnum {
CONTENT_EXPORT extern const char* Jpeg;
CONTENT_EXPORT extern const char* Png;
} // FormatEnum
} // CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
CONTENT_EXPORT extern const char* Mhtml;
} // FormatEnum
} // CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
CONTENT_EXPORT extern const char* ReturnAsBase64;
CONTENT_EXPORT extern const char* ReturnAsStream;
} // TransferModeEnum
} // PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
CONTENT_EXPORT extern const char* Deny;
CONTENT_EXPORT extern const char* Allow;
CONTENT_EXPORT extern const char* Default;
} // BehaviorEnum
} // SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
CONTENT_EXPORT extern const char* Mobile;
CONTENT_EXPORT extern const char* Desktop;
} // ConfigurationEnum
} // SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
CONTENT_EXPORT extern const char* Jpeg;
CONTENT_EXPORT extern const char* Png;
} // FormatEnum
} // StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
CONTENT_EXPORT extern const char* Frozen;
CONTENT_EXPORT extern const char* Active;
} // StateEnum
} // SetWebLifecycleState

namespace FileChooserOpened {
namespace ModeEnum {
CONTENT_EXPORT extern const char* SelectSingle;
CONTENT_EXPORT extern const char* SelectMultiple;
} // ModeEnum
} // FileChooserOpened

namespace DownloadProgress {
namespace StateEnum {
CONTENT_EXPORT extern const char* InProgress;
CONTENT_EXPORT extern const char* Completed;
CONTENT_EXPORT extern const char* Canceled;
} // StateEnum
} // DownloadProgress

// ------------- Type and builder declarations.

class CONTENT_EXPORT NavigationEntry : public ::crdtp::ProtocolObject<NavigationEntry> {
public:
    ~NavigationEntry() override { }

    int GetId() { return m_id; }
    void SetId(int value) { m_id = value; }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    String GetUserTypedURL() { return m_userTypedURL; }
    void SetUserTypedURL(const String& value) { m_userTypedURL = value; }

    String GetTitle() { return m_title; }
    void SetTitle(const String& value) { m_title = value; }

    String GetTransitionType() { return m_transitionType; }
    void SetTransitionType(const String& value) { m_transitionType = value; }

    template<int STATE>
    class NavigationEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            UrlSet = 1 << 2,
            UserTypedURLSet = 1 << 3,
            TitleSet = 1 << 4,
            TransitionTypeSet = 1 << 5,
            AllFieldsSet = (IdSet | UrlSet | UserTypedURLSet | TitleSet | TransitionTypeSet | 0)};


        NavigationEntryBuilder<STATE | IdSet>& SetId(int value)
        {
            static_assert(!(STATE & IdSet), "property id should not be set yet");
            m_result->SetId(value);
            return castState<IdSet>();
        }

        NavigationEntryBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        NavigationEntryBuilder<STATE | UserTypedURLSet>& SetUserTypedURL(const String& value)
        {
            static_assert(!(STATE & UserTypedURLSet), "property userTypedURL should not be set yet");
            m_result->SetUserTypedURL(value);
            return castState<UserTypedURLSet>();
        }

        NavigationEntryBuilder<STATE | TitleSet>& SetTitle(const String& value)
        {
            static_assert(!(STATE & TitleSet), "property title should not be set yet");
            m_result->SetTitle(value);
            return castState<TitleSet>();
        }

        NavigationEntryBuilder<STATE | TransitionTypeSet>& SetTransitionType(const String& value)
        {
            static_assert(!(STATE & TransitionTypeSet), "property transitionType should not be set yet");
            m_result->SetTransitionType(value);
            return castState<TransitionTypeSet>();
        }

        std::unique_ptr<NavigationEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NavigationEntry;
        NavigationEntryBuilder() : m_result(new NavigationEntry()) { }

        template<int STEP> NavigationEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NavigationEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::NavigationEntry> m_result;
    };

    static NavigationEntryBuilder<0> Create()
    {
        return NavigationEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NavigationEntry()
    {
          m_id = 0;
    }

    int m_id;
    String m_url;
    String m_userTypedURL;
    String m_title;
    String m_transitionType;
};


class CONTENT_EXPORT ScreencastFrameMetadata : public ::crdtp::ProtocolObject<ScreencastFrameMetadata> {
public:
    ~ScreencastFrameMetadata() override { }

    double GetOffsetTop() { return m_offsetTop; }
    void SetOffsetTop(double value) { m_offsetTop = value; }

    double GetPageScaleFactor() { return m_pageScaleFactor; }
    void SetPageScaleFactor(double value) { m_pageScaleFactor = value; }

    double GetDeviceWidth() { return m_deviceWidth; }
    void SetDeviceWidth(double value) { m_deviceWidth = value; }

    double GetDeviceHeight() { return m_deviceHeight; }
    void SetDeviceHeight(double value) { m_deviceHeight = value; }

    double GetScrollOffsetX() { return m_scrollOffsetX; }
    void SetScrollOffsetX(double value) { m_scrollOffsetX = value; }

    double GetScrollOffsetY() { return m_scrollOffsetY; }
    void SetScrollOffsetY(double value) { m_scrollOffsetY = value; }

    bool HasTimestamp() { return m_timestamp.isJust(); }
    double GetTimestamp(double defaultValue) { return m_timestamp.isJust() ? m_timestamp.fromJust() : defaultValue; }
    void SetTimestamp(double value) { m_timestamp = value; }

    template<int STATE>
    class ScreencastFrameMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OffsetTopSet = 1 << 1,
            PageScaleFactorSet = 1 << 2,
            DeviceWidthSet = 1 << 3,
            DeviceHeightSet = 1 << 4,
            ScrollOffsetXSet = 1 << 5,
            ScrollOffsetYSet = 1 << 6,
            AllFieldsSet = (OffsetTopSet | PageScaleFactorSet | DeviceWidthSet | DeviceHeightSet | ScrollOffsetXSet | ScrollOffsetYSet | 0)};


        ScreencastFrameMetadataBuilder<STATE | OffsetTopSet>& SetOffsetTop(double value)
        {
            static_assert(!(STATE & OffsetTopSet), "property offsetTop should not be set yet");
            m_result->SetOffsetTop(value);
            return castState<OffsetTopSet>();
        }

        ScreencastFrameMetadataBuilder<STATE | PageScaleFactorSet>& SetPageScaleFactor(double value)
        {
            static_assert(!(STATE & PageScaleFactorSet), "property pageScaleFactor should not be set yet");
            m_result->SetPageScaleFactor(value);
            return castState<PageScaleFactorSet>();
        }

        ScreencastFrameMetadataBuilder<STATE | DeviceWidthSet>& SetDeviceWidth(double value)
        {
            static_assert(!(STATE & DeviceWidthSet), "property deviceWidth should not be set yet");
            m_result->SetDeviceWidth(value);
            return castState<DeviceWidthSet>();
        }

        ScreencastFrameMetadataBuilder<STATE | DeviceHeightSet>& SetDeviceHeight(double value)
        {
            static_assert(!(STATE & DeviceHeightSet), "property deviceHeight should not be set yet");
            m_result->SetDeviceHeight(value);
            return castState<DeviceHeightSet>();
        }

        ScreencastFrameMetadataBuilder<STATE | ScrollOffsetXSet>& SetScrollOffsetX(double value)
        {
            static_assert(!(STATE & ScrollOffsetXSet), "property scrollOffsetX should not be set yet");
            m_result->SetScrollOffsetX(value);
            return castState<ScrollOffsetXSet>();
        }

        ScreencastFrameMetadataBuilder<STATE | ScrollOffsetYSet>& SetScrollOffsetY(double value)
        {
            static_assert(!(STATE & ScrollOffsetYSet), "property scrollOffsetY should not be set yet");
            m_result->SetScrollOffsetY(value);
            return castState<ScrollOffsetYSet>();
        }

        ScreencastFrameMetadataBuilder<STATE>& SetTimestamp(double value)
        {
            m_result->SetTimestamp(value);
            return *this;
        }

        std::unique_ptr<ScreencastFrameMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreencastFrameMetadata;
        ScreencastFrameMetadataBuilder() : m_result(new ScreencastFrameMetadata()) { }

        template<int STEP> ScreencastFrameMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreencastFrameMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::ScreencastFrameMetadata> m_result;
    };

    static ScreencastFrameMetadataBuilder<0> Create()
    {
        return ScreencastFrameMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreencastFrameMetadata()
    {
          m_offsetTop = 0;
          m_pageScaleFactor = 0;
          m_deviceWidth = 0;
          m_deviceHeight = 0;
          m_scrollOffsetX = 0;
          m_scrollOffsetY = 0;
    }

    double m_offsetTop;
    double m_pageScaleFactor;
    double m_deviceWidth;
    double m_deviceHeight;
    double m_scrollOffsetX;
    double m_scrollOffsetY;
    Maybe<double> m_timestamp;
};


class CONTENT_EXPORT AppManifestError : public ::crdtp::ProtocolObject<AppManifestError> {
public:
    ~AppManifestError() override { }

    String GetMessage() { return m_message; }
    void SetMessage(const String& value) { m_message = value; }

    int GetCritical() { return m_critical; }
    void SetCritical(int value) { m_critical = value; }

    int GetLine() { return m_line; }
    void SetLine(int value) { m_line = value; }

    int GetColumn() { return m_column; }
    void SetColumn(int value) { m_column = value; }

    template<int STATE>
    class AppManifestErrorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            MessageSet = 1 << 1,
            CriticalSet = 1 << 2,
            LineSet = 1 << 3,
            ColumnSet = 1 << 4,
            AllFieldsSet = (MessageSet | CriticalSet | LineSet | ColumnSet | 0)};


        AppManifestErrorBuilder<STATE | MessageSet>& SetMessage(const String& value)
        {
            static_assert(!(STATE & MessageSet), "property message should not be set yet");
            m_result->SetMessage(value);
            return castState<MessageSet>();
        }

        AppManifestErrorBuilder<STATE | CriticalSet>& SetCritical(int value)
        {
            static_assert(!(STATE & CriticalSet), "property critical should not be set yet");
            m_result->SetCritical(value);
            return castState<CriticalSet>();
        }

        AppManifestErrorBuilder<STATE | LineSet>& SetLine(int value)
        {
            static_assert(!(STATE & LineSet), "property line should not be set yet");
            m_result->SetLine(value);
            return castState<LineSet>();
        }

        AppManifestErrorBuilder<STATE | ColumnSet>& SetColumn(int value)
        {
            static_assert(!(STATE & ColumnSet), "property column should not be set yet");
            m_result->SetColumn(value);
            return castState<ColumnSet>();
        }

        std::unique_ptr<AppManifestError> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AppManifestError;
        AppManifestErrorBuilder() : m_result(new AppManifestError()) { }

        template<int STEP> AppManifestErrorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AppManifestErrorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::AppManifestError> m_result;
    };

    static AppManifestErrorBuilder<0> Create()
    {
        return AppManifestErrorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AppManifestError()
    {
          m_critical = 0;
          m_line = 0;
          m_column = 0;
    }

    String m_message;
    int m_critical;
    int m_line;
    int m_column;
};


class CONTENT_EXPORT AppManifestParsedProperties : public ::crdtp::ProtocolObject<AppManifestParsedProperties> {
public:
    ~AppManifestParsedProperties() override { }

    String GetScope() { return m_scope; }
    void SetScope(const String& value) { m_scope = value; }

    template<int STATE>
    class AppManifestParsedPropertiesBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScopeSet = 1 << 1,
            AllFieldsSet = (ScopeSet | 0)};


        AppManifestParsedPropertiesBuilder<STATE | ScopeSet>& SetScope(const String& value)
        {
            static_assert(!(STATE & ScopeSet), "property scope should not be set yet");
            m_result->SetScope(value);
            return castState<ScopeSet>();
        }

        std::unique_ptr<AppManifestParsedProperties> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AppManifestParsedProperties;
        AppManifestParsedPropertiesBuilder() : m_result(new AppManifestParsedProperties()) { }

        template<int STEP> AppManifestParsedPropertiesBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AppManifestParsedPropertiesBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::AppManifestParsedProperties> m_result;
    };

    static AppManifestParsedPropertiesBuilder<0> Create()
    {
        return AppManifestParsedPropertiesBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AppManifestParsedProperties()
    {
    }

    String m_scope;
};


class CONTENT_EXPORT Viewport : public ::crdtp::ProtocolObject<Viewport> {
public:
    ~Viewport() override { }

    double GetX() { return m_x; }
    void SetX(double value) { m_x = value; }

    double GetY() { return m_y; }
    void SetY(double value) { m_y = value; }

    double GetWidth() { return m_width; }
    void SetWidth(double value) { m_width = value; }

    double GetHeight() { return m_height; }
    void SetHeight(double value) { m_height = value; }

    double GetScale() { return m_scale; }
    void SetScale(double value) { m_scale = value; }

    template<int STATE>
    class ViewportBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            WidthSet = 1 << 3,
            HeightSet = 1 << 4,
            ScaleSet = 1 << 5,
            AllFieldsSet = (XSet | YSet | WidthSet | HeightSet | ScaleSet | 0)};


        ViewportBuilder<STATE | XSet>& SetX(double value)
        {
            static_assert(!(STATE & XSet), "property x should not be set yet");
            m_result->SetX(value);
            return castState<XSet>();
        }

        ViewportBuilder<STATE | YSet>& SetY(double value)
        {
            static_assert(!(STATE & YSet), "property y should not be set yet");
            m_result->SetY(value);
            return castState<YSet>();
        }

        ViewportBuilder<STATE | WidthSet>& SetWidth(double value)
        {
            static_assert(!(STATE & WidthSet), "property width should not be set yet");
            m_result->SetWidth(value);
            return castState<WidthSet>();
        }

        ViewportBuilder<STATE | HeightSet>& SetHeight(double value)
        {
            static_assert(!(STATE & HeightSet), "property height should not be set yet");
            m_result->SetHeight(value);
            return castState<HeightSet>();
        }

        ViewportBuilder<STATE | ScaleSet>& SetScale(double value)
        {
            static_assert(!(STATE & ScaleSet), "property scale should not be set yet");
            m_result->SetScale(value);
            return castState<ScaleSet>();
        }

        std::unique_ptr<Viewport> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Viewport;
        ViewportBuilder() : m_result(new Viewport()) { }

        template<int STEP> ViewportBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ViewportBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::Viewport> m_result;
    };

    static ViewportBuilder<0> Create()
    {
        return ViewportBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Viewport()
    {
          m_x = 0;
          m_y = 0;
          m_width = 0;
          m_height = 0;
          m_scale = 0;
    }

    double m_x;
    double m_y;
    double m_width;
    double m_height;
    double m_scale;
};


class CONTENT_EXPORT InstallabilityErrorArgument : public ::crdtp::ProtocolObject<InstallabilityErrorArgument> {
public:
    ~InstallabilityErrorArgument() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    template<int STATE>
    class InstallabilityErrorArgumentBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        InstallabilityErrorArgumentBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        InstallabilityErrorArgumentBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<InstallabilityErrorArgument> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InstallabilityErrorArgument;
        InstallabilityErrorArgumentBuilder() : m_result(new InstallabilityErrorArgument()) { }

        template<int STEP> InstallabilityErrorArgumentBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InstallabilityErrorArgumentBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::InstallabilityErrorArgument> m_result;
    };

    static InstallabilityErrorArgumentBuilder<0> Create()
    {
        return InstallabilityErrorArgumentBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InstallabilityErrorArgument()
    {
    }

    String m_name;
    String m_value;
};


class CONTENT_EXPORT InstallabilityError : public ::crdtp::ProtocolObject<InstallabilityError> {
public:
    ~InstallabilityError() override { }

    String GetErrorId() { return m_errorId; }
    void SetErrorId(const String& value) { m_errorId = value; }

    protocol::Array<protocol::Page::InstallabilityErrorArgument>* GetErrorArguments() { return m_errorArguments.get(); }
    void SetErrorArguments(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> value) { m_errorArguments = std::move(value); }

    template<int STATE>
    class InstallabilityErrorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorIdSet = 1 << 1,
            ErrorArgumentsSet = 1 << 2,
            AllFieldsSet = (ErrorIdSet | ErrorArgumentsSet | 0)};


        InstallabilityErrorBuilder<STATE | ErrorIdSet>& SetErrorId(const String& value)
        {
            static_assert(!(STATE & ErrorIdSet), "property errorId should not be set yet");
            m_result->SetErrorId(value);
            return castState<ErrorIdSet>();
        }

        InstallabilityErrorBuilder<STATE | ErrorArgumentsSet>& SetErrorArguments(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> value)
        {
            static_assert(!(STATE & ErrorArgumentsSet), "property errorArguments should not be set yet");
            m_result->SetErrorArguments(std::move(value));
            return castState<ErrorArgumentsSet>();
        }

        std::unique_ptr<InstallabilityError> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InstallabilityError;
        InstallabilityErrorBuilder() : m_result(new InstallabilityError()) { }

        template<int STEP> InstallabilityErrorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InstallabilityErrorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::InstallabilityError> m_result;
    };

    static InstallabilityErrorBuilder<0> Create()
    {
        return InstallabilityErrorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InstallabilityError()
    {
    }

    String m_errorId;
    std::unique_ptr<protocol::Array<protocol::Page::InstallabilityErrorArgument>> m_errorArguments;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse BringToFront() = 0;
    class CONTENT_EXPORT CaptureScreenshotCallback {
    public:
        virtual void sendSuccess(const Binary& data) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~CaptureScreenshotCallback() { }
    };
    virtual void CaptureScreenshot(Maybe<String> in_format, Maybe<int> in_quality, Maybe<protocol::Page::Viewport> in_clip, Maybe<bool> in_fromSurface, std::unique_ptr<CaptureScreenshotCallback> callback) = 0;
    class CONTENT_EXPORT CaptureSnapshotCallback {
    public:
        virtual void sendSuccess(const String& data) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~CaptureSnapshotCallback() { }
    };
    virtual void CaptureSnapshot(Maybe<String> in_format, std::unique_ptr<CaptureSnapshotCallback> callback) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;
    class CONTENT_EXPORT GetAppManifestCallback {
    public:
        virtual void sendSuccess(const String& url, std::unique_ptr<protocol::Array<protocol::Page::AppManifestError>> errors, Maybe<String> data, Maybe<protocol::Page::AppManifestParsedProperties> parsed) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetAppManifestCallback() { }
    };
    virtual void GetAppManifest(std::unique_ptr<GetAppManifestCallback> callback) = 0;
    class CONTENT_EXPORT GetInstallabilityErrorsCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Page::InstallabilityError>> installabilityErrors) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetInstallabilityErrorsCallback() { }
    };
    virtual void GetInstallabilityErrors(std::unique_ptr<GetInstallabilityErrorsCallback> callback) = 0;
    class CONTENT_EXPORT GetManifestIconsCallback {
    public:
        virtual void sendSuccess(Maybe<Binary> primaryIcon) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetManifestIconsCallback() { }
    };
    virtual void GetManifestIcons(std::unique_ptr<GetManifestIconsCallback> callback) = 0;
    virtual DispatchResponse GetNavigationHistory(int* out_currentIndex, std::unique_ptr<protocol::Array<protocol::Page::NavigationEntry>>* out_entries) = 0;
    virtual DispatchResponse ResetNavigationHistory() = 0;
    virtual DispatchResponse HandleJavaScriptDialog(bool in_accept, Maybe<String> in_promptText) = 0;
    class CONTENT_EXPORT NavigateCallback {
    public:
        virtual void sendSuccess(const String& frameId, Maybe<String> loaderId, Maybe<String> errorText) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~NavigateCallback() { }
    };
    virtual void Navigate(const String& in_url, Maybe<String> in_referrer, Maybe<String> in_transitionType, Maybe<String> in_frameId, Maybe<String> in_referrerPolicy, std::unique_ptr<NavigateCallback> callback) = 0;
    virtual DispatchResponse NavigateToHistoryEntry(int in_entryId) = 0;
    class CONTENT_EXPORT PrintToPDFCallback {
    public:
        virtual void sendSuccess(const Binary& data, Maybe<String> stream) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~PrintToPDFCallback() { }
    };
    virtual void PrintToPDF(Maybe<bool> in_landscape, Maybe<bool> in_displayHeaderFooter, Maybe<bool> in_printBackground, Maybe<double> in_scale, Maybe<double> in_paperWidth, Maybe<double> in_paperHeight, Maybe<double> in_marginTop, Maybe<double> in_marginBottom, Maybe<double> in_marginLeft, Maybe<double> in_marginRight, Maybe<String> in_pageRanges, Maybe<bool> in_ignoreInvalidPageRanges, Maybe<String> in_headerTemplate, Maybe<String> in_footerTemplate, Maybe<bool> in_preferCSSPageSize, Maybe<String> in_transferMode, std::unique_ptr<PrintToPDFCallback> callback) = 0;
    class CONTENT_EXPORT ReloadCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ReloadCallback() { }
    };
    virtual void Reload(Maybe<bool> in_ignoreCache, Maybe<String> in_scriptToEvaluateOnLoad, std::unique_ptr<ReloadCallback> callback) = 0;
    virtual DispatchResponse ScreencastFrameAck(int in_sessionId) = 0;
    virtual DispatchResponse SetDownloadBehavior(const String& in_behavior, Maybe<String> in_downloadPath) = 0;
    virtual DispatchResponse StartScreencast(Maybe<String> in_format, Maybe<int> in_quality, Maybe<int> in_maxWidth, Maybe<int> in_maxHeight, Maybe<int> in_everyNthFrame) = 0;
    virtual DispatchResponse StopLoading() = 0;
    virtual DispatchResponse Crash() = 0;
    virtual DispatchResponse Close() = 0;
    virtual DispatchResponse SetWebLifecycleState(const String& in_state) = 0;
    virtual DispatchResponse StopScreencast() = 0;
    virtual DispatchResponse AddCompilationCache(const String& in_url, const Binary& in_data) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void DownloadWillBegin(const String& frameId, const String& guid, const String& url, const String& suggestedFilename);
    void DownloadProgress(const String& guid, double totalBytes, double receivedBytes, const String& state);
    void InterstitialHidden();
    void InterstitialShown();
    void JavascriptDialogClosed(bool result, const String& userInput);
    void JavascriptDialogOpening(const String& url, const String& message, const String& type, bool hasBrowserHandler, Maybe<String> defaultPrompt = Maybe<String>());
    void ScreencastFrame(const Binary& data, std::unique_ptr<protocol::Page::ScreencastFrameMetadata> metadata, int sessionId);
    void ScreencastVisibilityChanged(bool visible);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Page
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Page_h)
