// components/spellcheck/common/spellcheck.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/spellcheck/common/spellcheck.mojom-shared.h"
#include "components/spellcheck/common/spellcheck.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "components/spellcheck/common/spellcheck_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace spellcheck {
namespace mojom {

class SpellCheckerProxy;

template <typename ImplRefTraits>
class SpellCheckerStub;

class SpellCheckerRequestValidator;


class  SpellChecker
    : public SpellCheckerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpellCheckerInterfaceBase;
  using Proxy_ = SpellCheckerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpellCheckerStub<ImplRefTraits>;

  using RequestValidator_ = SpellCheckerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kCustomDictionaryChangedMinVersion = 0,
  };
  virtual ~SpellChecker() {}

  
  virtual void Initialize(std::vector<SpellCheckBDictLanguagePtr> dictionaries, const std::vector<std::string>& custom_words, bool enable) = 0;

  
  virtual void CustomDictionaryChanged(const std::vector<std::string>& words_added, const std::vector<std::string>& words_removed) = 0;
};

class SpellCheckHostProxy;

template <typename ImplRefTraits>
class SpellCheckHostStub;

class SpellCheckHostRequestValidator;
class SpellCheckHostResponseValidator;


class  SpellCheckHost
    : public SpellCheckHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpellCheckHostInterfaceBase;
  using Proxy_ = SpellCheckHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpellCheckHostStub<ImplRefTraits>;

  using RequestValidator_ = SpellCheckHostRequestValidator;
  using ResponseValidator_ = SpellCheckHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestDictionaryMinVersion = 0,
    kNotifyCheckedMinVersion = 0,
    kCallSpellingServiceMinVersion = 0,
  };
  virtual ~SpellCheckHost() {}

  
  virtual void RequestDictionary() = 0;

  
  virtual void NotifyChecked(const ::base::string16& word, bool misspelled) = 0;


  using CallSpellingServiceCallback = base::OnceCallback<void(bool, const std::vector<::SpellCheckResult>&)>;
  
  virtual void CallSpellingService(const ::base::string16& text, CallSpellingServiceCallback callback) = 0;
};



class  SpellCheckerProxy
    : public SpellChecker {
 public:
  using InterfaceType = SpellChecker;

  explicit SpellCheckerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(std::vector<SpellCheckBDictLanguagePtr> dictionaries, const std::vector<std::string>& custom_words, bool enable) final;
  
  void CustomDictionaryChanged(const std::vector<std::string>& words_added, const std::vector<std::string>& words_removed) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpellCheckHostProxy
    : public SpellCheckHost {
 public:
  using InterfaceType = SpellCheckHost;

  explicit SpellCheckHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestDictionary() final;
  
  void NotifyChecked(const ::base::string16& word, bool misspelled) final;
  
  void CallSpellingService(const ::base::string16& text, CallSpellingServiceCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SpellCheckerStubDispatch {
 public:
  static bool Accept(SpellChecker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpellChecker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpellChecker>>
class SpellCheckerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpellCheckerStub() {}
  ~SpellCheckerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpellCheckHostStubDispatch {
 public:
  static bool Accept(SpellCheckHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpellCheckHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpellCheckHost>>
class SpellCheckHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpellCheckHostStub() {}
  ~SpellCheckHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpellCheckerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpellCheckHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpellCheckHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  SpellCheckBDictLanguage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpellCheckBDictLanguage, T>::value>;
  using DataView = SpellCheckBDictLanguageDataView;
  using Data_ = internal::SpellCheckBDictLanguage_Data;

  template <typename... Args>
  static SpellCheckBDictLanguagePtr New(Args&&... args) {
    return SpellCheckBDictLanguagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpellCheckBDictLanguagePtr From(const U& u) {
    return mojo::TypeConverter<SpellCheckBDictLanguagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpellCheckBDictLanguage>::Convert(*this);
  }


  SpellCheckBDictLanguage();

  SpellCheckBDictLanguage(
      ::base::File file,
      const std::string& language);

  ~SpellCheckBDictLanguage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpellCheckBDictLanguagePtr>
  SpellCheckBDictLanguagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpellCheckBDictLanguage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpellCheckBDictLanguage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpellCheckBDictLanguage_UnserializedMessageContext<
            UserType, SpellCheckBDictLanguage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SpellCheckBDictLanguage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SpellCheckBDictLanguage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpellCheckBDictLanguage_UnserializedMessageContext<
            UserType, SpellCheckBDictLanguage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpellCheckBDictLanguage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::File file;
  
  std::string language;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(SpellCheckBDictLanguage);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SpellCheckResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpellCheckResult, T>::value>;
  using DataView = SpellCheckResultDataView;
  using Data_ = internal::SpellCheckResult_Data;

  template <typename... Args>
  static SpellCheckResultPtr New(Args&&... args) {
    return SpellCheckResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpellCheckResultPtr From(const U& u) {
    return mojo::TypeConverter<SpellCheckResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpellCheckResult>::Convert(*this);
  }


  SpellCheckResult();

  SpellCheckResult(
      ::SpellCheckResult::Decoration decoration,
      int32_t location,
      int32_t length,
      std::vector<::base::string16> replacements);

  ~SpellCheckResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpellCheckResultPtr>
  SpellCheckResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpellCheckResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpellCheckResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpellCheckResult_UnserializedMessageContext<
            UserType, SpellCheckResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SpellCheckResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SpellCheckResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpellCheckResult_UnserializedMessageContext<
            UserType, SpellCheckResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpellCheckResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::SpellCheckResult::Decoration decoration;
  
  int32_t location;
  
  int32_t length;
  
  std::vector<::base::string16> replacements;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpellCheckBDictLanguagePtr SpellCheckBDictLanguage::Clone() const {
  return New(
      mojo::Clone(file),
      mojo::Clone(language)
  );
}

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>*>
bool SpellCheckBDictLanguage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file, other_struct.file))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  return true;
}

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.file, rhs.file))
    return true;
  if (std::less<>{}(rhs.file, lhs.file))
    return false;
  if (std::less<>{}(lhs.language, rhs.language))
    return true;
  if (std::less<>{}(rhs.language, lhs.language))
    return false;
  return false;
}
template <typename StructPtrType>
SpellCheckResultPtr SpellCheckResult::Clone() const {
  return New(
      mojo::Clone(decoration),
      mojo::Clone(location),
      mojo::Clone(length),
      mojo::Clone(replacements)
  );
}

template <typename T, SpellCheckResult::EnableIfSame<T>*>
bool SpellCheckResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->decoration, other_struct.decoration))
    return false;
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->replacements, other_struct.replacements))
    return false;
  return true;
}

template <typename T, SpellCheckResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.decoration, rhs.decoration))
    return true;
  if (std::less<>{}(rhs.decoration, lhs.decoration))
    return false;
  if (std::less<>{}(lhs.location, rhs.location))
    return true;
  if (std::less<>{}(rhs.location, lhs.location))
    return false;
  if (std::less<>{}(lhs.length, rhs.length))
    return true;
  if (std::less<>{}(rhs.length, lhs.length))
    return false;
  if (std::less<>{}(lhs.replacements, rhs.replacements))
    return true;
  if (std::less<>{}(rhs.replacements, lhs.replacements))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace spellcheck

namespace mojo {


template <>
struct  StructTraits<::spellcheck::mojom::SpellCheckBDictLanguage::DataView,
                                         ::spellcheck::mojom::SpellCheckBDictLanguagePtr> {
  static bool IsNull(const ::spellcheck::mojom::SpellCheckBDictLanguagePtr& input) { return !input; }
  static void SetToNull(::spellcheck::mojom::SpellCheckBDictLanguagePtr* output) { output->reset(); }

  static  decltype(::spellcheck::mojom::SpellCheckBDictLanguage::file)& file(
       ::spellcheck::mojom::SpellCheckBDictLanguagePtr& input) {
    return input->file;
  }

  static const decltype(::spellcheck::mojom::SpellCheckBDictLanguage::language)& language(
      const ::spellcheck::mojom::SpellCheckBDictLanguagePtr& input) {
    return input->language;
  }

  static bool Read(::spellcheck::mojom::SpellCheckBDictLanguage::DataView input, ::spellcheck::mojom::SpellCheckBDictLanguagePtr* output);
};


template <>
struct  StructTraits<::spellcheck::mojom::SpellCheckResult::DataView,
                                         ::spellcheck::mojom::SpellCheckResultPtr> {
  static bool IsNull(const ::spellcheck::mojom::SpellCheckResultPtr& input) { return !input; }
  static void SetToNull(::spellcheck::mojom::SpellCheckResultPtr* output) { output->reset(); }

  static decltype(::spellcheck::mojom::SpellCheckResult::decoration) decoration(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->decoration;
  }

  static decltype(::spellcheck::mojom::SpellCheckResult::location) location(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->location;
  }

  static decltype(::spellcheck::mojom::SpellCheckResult::length) length(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->length;
  }

  static const decltype(::spellcheck::mojom::SpellCheckResult::replacements)& replacements(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->replacements;
  }

  static bool Read(::spellcheck::mojom::SpellCheckResult::DataView input, ::spellcheck::mojom::SpellCheckResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_H_