// components/paint_preview/common/mojom/paint_preview_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-params-data.h"
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared-message-ids.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-import-headers.h"


#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_JUMBO_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_JUMBO_H_
#endif
namespace paint_preview {
namespace mojom {
PaintPreviewCaptureParams::PaintPreviewCaptureParams()
    : persistence(),
      guid(),
      clip_rect(),
      clip_rect_is_hint(),
      is_main_frame(),
      capture_links(),
      file(),
      max_capture_size() {}

PaintPreviewCaptureParams::PaintPreviewCaptureParams(
    ::paint_preview::RecordingPersistence persistence_in,
    const ::base::UnguessableToken& guid_in,
    const ::gfx::Rect& clip_rect_in,
    bool clip_rect_is_hint_in,
    bool is_main_frame_in,
    bool capture_links_in,
    ::base::File file_in,
    uint64_t max_capture_size_in)
    : persistence(std::move(persistence_in)),
      guid(std::move(guid_in)),
      clip_rect(std::move(clip_rect_in)),
      clip_rect_is_hint(std::move(clip_rect_is_hint_in)),
      is_main_frame(std::move(is_main_frame_in)),
      capture_links(std::move(capture_links_in)),
      file(std::move(file_in)),
      max_capture_size(std::move(max_capture_size_in)) {}

PaintPreviewCaptureParams::~PaintPreviewCaptureParams() = default;

void PaintPreviewCaptureParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("persistence", static_cast<int>(this->persistence));
  value->SetString("guid", base::trace_event::ValueToString(this->guid, "<value of type const ::base::UnguessableToken&>"));
  value->SetString("clip_rect", base::trace_event::ValueToString(this->clip_rect, "<value of type const ::gfx::Rect&>"));
  value->SetBoolean("clip_rect_is_hint", this->clip_rect_is_hint);
  value->SetBoolean("is_main_frame", this->is_main_frame);
  value->SetBoolean("capture_links", this->capture_links);
  value->SetString("file", base::trace_event::ValueToString(this->file, "<value of type ::base::File>"));
  value->SetString("max_capture_size", base::NumberToString(this->max_capture_size));
}

bool PaintPreviewCaptureParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LinkData::LinkData()
    : url(),
      rect() {}

LinkData::LinkData(
    const ::GURL& url_in,
    const ::gfx::Rect& rect_in)
    : url(std::move(url_in)),
      rect(std::move(rect_in)) {}

LinkData::~LinkData() = default;

void LinkData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::GURL&>"));
  value->SetString("rect", base::trace_event::ValueToString(this->rect, "<value of type const ::gfx::Rect&>"));
}

bool LinkData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaintPreviewCaptureResponse::PaintPreviewCaptureResponse()
    : embedding_token(),
      content_id_to_embedding_token(),
      links(),
      blink_recording_time(),
      serialized_size(),
      scroll_offsets(),
      skp() {}

PaintPreviewCaptureResponse::PaintPreviewCaptureResponse(
    const base::Optional<::base::UnguessableToken>& embedding_token_in,
    const base::flat_map<uint32_t, ::base::UnguessableToken>& content_id_to_embedding_token_in,
    std::vector<LinkDataPtr> links_in,
    ::base::TimeDelta blink_recording_time_in,
    uint64_t serialized_size_in,
    const ::gfx::Size& scroll_offsets_in,
    base::Optional<::mojo_base::BigBuffer> skp_in)
    : embedding_token(std::move(embedding_token_in)),
      content_id_to_embedding_token(std::move(content_id_to_embedding_token_in)),
      links(std::move(links_in)),
      blink_recording_time(std::move(blink_recording_time_in)),
      serialized_size(std::move(serialized_size_in)),
      scroll_offsets(std::move(scroll_offsets_in)),
      skp(std::move(skp_in)) {}

PaintPreviewCaptureResponse::~PaintPreviewCaptureResponse() = default;

void PaintPreviewCaptureResponse::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("embedding_token", base::trace_event::ValueToString(this->embedding_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  value->BeginDictionary("content_id_to_embedding_token");
  for (const auto& item0 : this->content_id_to_embedding_token) {
    value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type uint32_t>"), base::trace_event::ValueToString(item0.second, "<value of type const ::base::UnguessableToken&>"));
  }
  value->EndDictionary();
  value->BeginArray("links");
  for (const auto& item0 : this->links) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetString("blink_recording_time", base::trace_event::ValueToString(this->blink_recording_time, "<value of type ::base::TimeDelta>"));
  value->SetString("serialized_size", base::NumberToString(this->serialized_size));
  value->SetString("scroll_offsets", base::trace_event::ValueToString(this->scroll_offsets, "<value of type const ::gfx::Size&>"));
  value->SetString("skp", base::trace_event::ValueToString(this->skp, "<value of type base::Optional<::mojo_base::BigBuffer>>"));
}

bool PaintPreviewCaptureResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaintPreviewRecorder::Name_[] = "paint_preview.mojom.PaintPreviewRecorder";

class PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback(
      PaintPreviewRecorder::CapturePaintPreviewCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewRecorder::CapturePaintPreviewCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback);
};

PaintPreviewRecorderProxy::PaintPreviewRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaintPreviewRecorderProxy::CapturePaintPreview(
    PaintPreviewCaptureParamsPtr in_params, CapturePaintPreviewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaintPreviewRecorder_CapturePaintPreview_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::paint_preview::mojom::internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCaptureParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PaintPreviewRecorder.CapturePaintPreview request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewRecorder::Name_);
  message.set_method_name("CapturePaintPreview");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder {
 public:
  static PaintPreviewRecorder::CapturePaintPreviewCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder> proxy(
        new PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaintPreviewRecorder::CapturePaintPreviewCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaintPreviewStatus in_status, PaintPreviewCaptureResponsePtr in_response);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder);
};

bool PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreviewCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PaintPreviewStatus p_status{};
  PaintPreviewCaptureResponsePtr p_response{};
  PaintPreviewRecorder_CapturePaintPreview_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewRecorder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_response));
  return true;
}

void PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::Run(
    PaintPreviewStatus in_status, PaintPreviewCaptureResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreviewCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      if (in_response.is_null()) {
        raw_value->SetString("response", "nullptr");
      } else {
        raw_value->BeginDictionary("response");
        in_response->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaintPreviewRecorder_CapturePaintPreview_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::paint_preview::mojom::internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewStatus>(
      in_status, &params->status);
  typename decltype(params->response)::BaseType::BufferWriter
      response_writer;
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCaptureResponseDataView>(
      in_response, buffer, &response_writer, &serialization_context);
  params->response.Set(
      response_writer.is_null() ? nullptr : response_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreviewCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewRecorder::Name_);
  message.set_method_name("CapturePaintPreview");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaintPreviewRecorderStubDispatch::Accept(
    PaintPreviewRecorder* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPaintPreviewRecorder_CapturePaintPreview_Name: {
      break;
    }
  }
  return false;
}

// static
bool PaintPreviewRecorderStubDispatch::AcceptWithResponder(
    PaintPreviewRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaintPreviewRecorder_CapturePaintPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaintPreviewCaptureParamsPtr p_params{};
      PaintPreviewRecorder_CapturePaintPreview_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewRecorder::Name_, 0, false);
        return false;
      }
      PaintPreviewRecorder::CapturePaintPreviewCallback callback =
          PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreview(
std::move(p_params), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPaintPreviewRecorderValidationInfo[] = {
    {internal::kPaintPreviewRecorder_CapturePaintPreview_Name,
     {&internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data::Validate,
      &internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data::Validate}},
};

bool PaintPreviewRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::paint_preview::mojom::PaintPreviewRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPaintPreviewRecorderValidationInfo);
}

bool PaintPreviewRecorderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::paint_preview::mojom::PaintPreviewRecorder::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPaintPreviewRecorderValidationInfo);

}
}  // namespace mojom
}  // namespace paint_preview

namespace mojo {


// static
bool StructTraits<::paint_preview::mojom::PaintPreviewCaptureParams::DataView, ::paint_preview::mojom::PaintPreviewCaptureParamsPtr>::Read(
    ::paint_preview::mojom::PaintPreviewCaptureParams::DataView input,
    ::paint_preview::mojom::PaintPreviewCaptureParamsPtr* output) {
  bool success = true;
  ::paint_preview::mojom::PaintPreviewCaptureParamsPtr result(::paint_preview::mojom::PaintPreviewCaptureParams::New());
  
      if (success && !input.ReadPersistence(&result->persistence))
        success = false;
      if (success && !input.ReadGuid(&result->guid))
        success = false;
      if (success && !input.ReadClipRect(&result->clip_rect))
        success = false;
      if (success)
        result->clip_rect_is_hint = input.clip_rect_is_hint();
      if (success)
        result->is_main_frame = input.is_main_frame();
      if (success)
        result->capture_links = input.capture_links();
      if (success && !input.ReadFile(&result->file))
        success = false;
      if (success)
        result->max_capture_size = input.max_capture_size();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::LinkData::DataView, ::paint_preview::mojom::LinkDataPtr>::Read(
    ::paint_preview::mojom::LinkData::DataView input,
    ::paint_preview::mojom::LinkDataPtr* output) {
  bool success = true;
  ::paint_preview::mojom::LinkDataPtr result(::paint_preview::mojom::LinkData::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadRect(&result->rect))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::PaintPreviewCaptureResponse::DataView, ::paint_preview::mojom::PaintPreviewCaptureResponsePtr>::Read(
    ::paint_preview::mojom::PaintPreviewCaptureResponse::DataView input,
    ::paint_preview::mojom::PaintPreviewCaptureResponsePtr* output) {
  bool success = true;
  ::paint_preview::mojom::PaintPreviewCaptureResponsePtr result(::paint_preview::mojom::PaintPreviewCaptureResponse::New());
  
      if (success && !input.ReadEmbeddingToken(&result->embedding_token))
        success = false;
      if (success && !input.ReadContentIdToEmbeddingToken(&result->content_id_to_embedding_token))
        success = false;
      if (success && !input.ReadLinks(&result->links))
        success = false;
      if (success && !input.ReadBlinkRecordingTime(&result->blink_recording_time))
        success = false;
      if (success)
        result->serialized_size = input.serialized_size();
      if (success && !input.ReadScrollOffsets(&result->scroll_offsets))
        success = false;
      if (success && !input.ReadSkp(&result->skp))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif