// components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared-internal.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace paint_preview {
namespace mojom {
class PaintPreviewCaptureParamsDataView;

class LinkDataDataView;

class PaintPreviewCaptureResponseDataView;



}  // namespace mojom
}  // namespace paint_preview

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewCaptureParamsDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::LinkDataDataView> {
  using Data = ::paint_preview::mojom::internal::LinkData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewCaptureResponseDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace paint_preview {
namespace mojom {


enum class PaintPreviewStatus : int32_t {
  
  kOk = 0,
  
  kAlreadyCapturing = 1,
  
  kCaptureFailed = 2,
  
  kGuidCollision = 3,
  
  kFileCreationError = 4,
  
  kPartialSuccess = 5,
  
  kFailed = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, PaintPreviewStatus value);
inline bool IsKnownEnumValue(PaintPreviewStatus value) {
  return internal::PaintPreviewStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PaintPreviewRecorderInterfaceBase {};

using PaintPreviewRecorderPtrDataView =
    mojo::InterfacePtrDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderRequestDataView =
    mojo::InterfaceRequestDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaintPreviewRecorderInterfaceBase>;


class PaintPreviewCaptureParamsDataView {
 public:
  PaintPreviewCaptureParamsDataView() {}

  PaintPreviewCaptureParamsDataView(
      internal::PaintPreviewCaptureParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPersistence(UserType* output) const {
    auto data_value = data_->persistence;
    return mojo::internal::Deserialize<::paint_preview::mojom::RecordingPersistence>(
        data_value, output);
  }

  ::paint_preview::mojom::RecordingPersistence persistence() const {
    return static_cast<::paint_preview::mojom::RecordingPersistence>(data_->persistence);
  }
  inline void GetGuidDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGuid(UserType* output) {
    
    auto* pointer = data_->guid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetClipRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadClipRect(UserType* output) {
    
    auto* pointer = data_->clip_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  bool clip_rect_is_hint() const {
    return data_->clip_rect_is_hint;
  }
  bool is_main_frame() const {
    return data_->is_main_frame;
  }
  bool capture_links() const {
    return data_->capture_links;
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFile` instead "
    "of `ReadFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, context_);
  }
  uint64_t max_capture_size() const {
    return data_->max_capture_size;
  }
 private:
  internal::PaintPreviewCaptureParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class LinkDataDataView {
 public:
  LinkDataDataView() {}

  LinkDataDataView(
      internal::LinkData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
 private:
  internal::LinkData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PaintPreviewCaptureResponseDataView {
 public:
  PaintPreviewCaptureResponseDataView() {}

  PaintPreviewCaptureResponseDataView(
      internal::PaintPreviewCaptureResponse_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetEmbeddingTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEmbeddingToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `embedding_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEmbeddingToken` instead "
    "of `ReadEmbeddingToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->embedding_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetContentIdToEmbeddingTokenDataView(
      mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentIdToEmbeddingToken(UserType* output) {
    
    auto* pointer = data_->content_id_to_embedding_token.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        pointer, output, context_);
  }
  inline void GetLinksDataView(
      mojo::ArrayDataView<LinkDataDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLinks(UserType* output) {
    
    auto* pointer = data_->links.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::paint_preview::mojom::LinkDataDataView>>(
        pointer, output, context_);
  }
  inline void GetBlinkRecordingTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlinkRecordingTime(UserType* output) {
    
    auto* pointer = data_->blink_recording_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
  uint64_t serialized_size() const {
    return data_->serialized_size;
  }
  inline void GetScrollOffsetsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScrollOffsets(UserType* output) {
    
    auto* pointer = data_->scroll_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetSkpDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSkp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::BigBufferDataView, UserType>(),
    "Attempting to read the optional `skp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSkp` instead "
    "of `ReadSkp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->skp.is_null() ? &data_->skp : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, context_);
  }
 private:
  internal::PaintPreviewCaptureResponse_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace paint_preview

namespace std {

template <>
struct hash<::paint_preview::mojom::PaintPreviewStatus>
    : public mojo::internal::EnumHashImpl<::paint_preview::mojom::PaintPreviewStatus> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::paint_preview::mojom::PaintPreviewStatus, ::paint_preview::mojom::PaintPreviewStatus> {
  static ::paint_preview::mojom::PaintPreviewStatus ToMojom(::paint_preview::mojom::PaintPreviewStatus input) { return input; }
  static bool FromMojom(::paint_preview::mojom::PaintPreviewStatus input, ::paint_preview::mojom::PaintPreviewStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::paint_preview::mojom::PaintPreviewStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::paint_preview::mojom::PaintPreviewStatus>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewCaptureParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::PaintPreviewCaptureParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::paint_preview::mojom::RecordingPersistence>(
        Traits::persistence(input), &(*output)->persistence);
    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    typename decltype((*output)->guid)::BaseType::BufferWriter
        guid_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_guid, buffer, &guid_writer, context);
    (*output)->guid.Set(
        guid_writer.is_null() ? nullptr : guid_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->guid.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null guid in PaintPreviewCaptureParams struct");
    decltype(Traits::clip_rect(input)) in_clip_rect = Traits::clip_rect(input);
    typename decltype((*output)->clip_rect)::BaseType::BufferWriter
        clip_rect_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_clip_rect, buffer, &clip_rect_writer, context);
    (*output)->clip_rect.Set(
        clip_rect_writer.is_null() ? nullptr : clip_rect_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->clip_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clip_rect in PaintPreviewCaptureParams struct");
    (*output)->clip_rect_is_hint = Traits::clip_rect_is_hint(input);
    (*output)->is_main_frame = Traits::is_main_frame(input);
    (*output)->capture_links = Traits::capture_links(input);
    decltype(Traits::file(input)) in_file = Traits::file(input);
    typename decltype((*output)->file)::BaseType::BufferWriter
        file_writer;
    mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
        in_file, buffer, &file_writer, context);
    (*output)->file.Set(
        file_writer.is_null() ? nullptr : file_writer.data());
    (*output)->max_capture_size = Traits::max_capture_size(input);
  }

  static bool Deserialize(::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::PaintPreviewCaptureParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::LinkDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::LinkDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::paint_preview::mojom::internal::LinkData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in LinkData struct");
    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    typename decltype((*output)->rect)::BaseType::BufferWriter
        rect_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_rect, buffer, &rect_writer, context);
    (*output)->rect.Set(
        rect_writer.is_null() ? nullptr : rect_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in LinkData struct");
  }

  static bool Deserialize(::paint_preview::mojom::internal::LinkData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::LinkDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewCaptureResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::PaintPreviewCaptureResponseDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::embedding_token(input)) in_embedding_token = Traits::embedding_token(input);
    typename decltype((*output)->embedding_token)::BaseType::BufferWriter
        embedding_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_embedding_token, buffer, &embedding_token_writer, context);
    (*output)->embedding_token.Set(
        embedding_token_writer.is_null() ? nullptr : embedding_token_writer.data());
    decltype(Traits::content_id_to_embedding_token(input)) in_content_id_to_embedding_token = Traits::content_id_to_embedding_token(input);
    typename decltype((*output)->content_id_to_embedding_token)::BaseType::BufferWriter
        content_id_to_embedding_token_writer;
    const mojo::internal::ContainerValidateParams content_id_to_embedding_token_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        in_content_id_to_embedding_token, buffer, &content_id_to_embedding_token_writer, &content_id_to_embedding_token_validate_params,
        context);
    (*output)->content_id_to_embedding_token.Set(
        content_id_to_embedding_token_writer.is_null() ? nullptr : content_id_to_embedding_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content_id_to_embedding_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_id_to_embedding_token in PaintPreviewCaptureResponse struct");
    decltype(Traits::links(input)) in_links = Traits::links(input);
    typename decltype((*output)->links)::BaseType::BufferWriter
        links_writer;
    const mojo::internal::ContainerValidateParams links_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::paint_preview::mojom::LinkDataDataView>>(
        in_links, buffer, &links_writer, &links_validate_params,
        context);
    (*output)->links.Set(
        links_writer.is_null() ? nullptr : links_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->links.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null links in PaintPreviewCaptureResponse struct");
    decltype(Traits::blink_recording_time(input)) in_blink_recording_time = Traits::blink_recording_time(input);
    typename decltype((*output)->blink_recording_time)::BaseType::BufferWriter
        blink_recording_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_blink_recording_time, buffer, &blink_recording_time_writer, context);
    (*output)->blink_recording_time.Set(
        blink_recording_time_writer.is_null() ? nullptr : blink_recording_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->blink_recording_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null blink_recording_time in PaintPreviewCaptureResponse struct");
    (*output)->serialized_size = Traits::serialized_size(input);
    decltype(Traits::scroll_offsets(input)) in_scroll_offsets = Traits::scroll_offsets(input);
    typename decltype((*output)->scroll_offsets)::BaseType::BufferWriter
        scroll_offsets_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_scroll_offsets, buffer, &scroll_offsets_writer, context);
    (*output)->scroll_offsets.Set(
        scroll_offsets_writer.is_null() ? nullptr : scroll_offsets_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scroll_offsets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_offsets in PaintPreviewCaptureResponse struct");
    decltype(Traits::skp(input)) in_skp = Traits::skp(input);
    typename decltype((*output)->skp)::BufferWriter skp_writer;
    skp_writer.AllocateInline(buffer, &(*output)->skp);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_skp, buffer, &skp_writer, true, context);
  }

  static bool Deserialize(::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::PaintPreviewCaptureResponseDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace paint_preview {
namespace mojom {

inline void PaintPreviewCaptureParamsDataView::GetGuidDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->guid.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void PaintPreviewCaptureParamsDataView::GetClipRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->clip_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void PaintPreviewCaptureParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, context_);
}


inline void LinkDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void LinkDataDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}


inline void PaintPreviewCaptureResponseDataView::GetEmbeddingTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->embedding_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void PaintPreviewCaptureResponseDataView::GetContentIdToEmbeddingTokenDataView(
    mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output) {
  auto pointer = data_->content_id_to_embedding_token.Get();
  *output = mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>(pointer, context_);
}
inline void PaintPreviewCaptureResponseDataView::GetLinksDataView(
    mojo::ArrayDataView<LinkDataDataView>* output) {
  auto pointer = data_->links.Get();
  *output = mojo::ArrayDataView<LinkDataDataView>(pointer, context_);
}
inline void PaintPreviewCaptureResponseDataView::GetBlinkRecordingTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->blink_recording_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}
inline void PaintPreviewCaptureResponseDataView::GetScrollOffsetsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->scroll_offsets.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void PaintPreviewCaptureResponseDataView::GetSkpDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->skp;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace paint_preview

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_