#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


    #include <notcurses/direct.h>
    #include <notcurses/notcurses.h>
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(nccapabilities const *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 1652), // nccapabilities const *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(nccell const *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 1653), // nccell const *
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(ncinput const *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 1657), // ncinput const *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(ncinput const *, ncinput const *)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 11 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncdirect const *)
/* 14 */ _CFFI_OP(_CFFI_OP_POINTER, 1677), // struct ncdirect const *
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncmenu *, ncinput const *)
/* 17 */ _CFFI_OP(_CFFI_OP_POINTER, 1681), // struct ncmenu *
/* 18 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncmultiselector *, ncinput const *)
/* 21 */ _CFFI_OP(_CFFI_OP_POINTER, 1688), // struct ncmultiselector *
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncplane *, unsigned int)
/* 25 */ _CFFI_OP(_CFFI_OP_POINTER, 1655), // struct ncplane *
/* 26 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncplane const *)
/* 29 */ _CFFI_OP(_CFFI_OP_POINTER, 1655), // struct ncplane const *
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncplane const *, int *, int *)
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 33 */ _CFFI_OP(_CFFI_OP_POINTER, 76), // int *
/* 34 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncplane const *, nccell const *, struct ncplane const *, nccell const *)
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 40 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncreader *, ncinput const *)
/* 43 */ _CFFI_OP(_CFFI_OP_POINTER, 1690), // struct ncreader *
/* 44 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncreel *, ncinput const *)
/* 47 */ _CFFI_OP(_CFFI_OP_POINTER, 1691), // struct ncreel *
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct ncselector *, ncinput const *)
/* 51 */ _CFFI_OP(_CFFI_OP_POINTER, 1692), // struct ncselector *
/* 52 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct nctree *, ncinput const *)
/* 55 */ _CFFI_OP(_CFFI_OP_POINTER, 1698), // struct nctree *
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(struct notcurses const *)
/* 59 */ _CFFI_OP(_CFFI_OP_POINTER, 1703), // struct notcurses const *
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(uint32_t)
/* 62 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION, 369), // _Bool()(uint64_t)
/* 65 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncdirect *, char const *)
/* 68 */ _CFFI_OP(_CFFI_OP_POINTER, 1677), // struct ncdirect *
/* 69 */ _CFFI_OP(_CFFI_OP_POINTER, 418), // char const *
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncdirect const *)
/* 72 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncplane *, int, int, unsigned int, unsigned int)
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 76 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 77 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 79 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncplane const *)
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncplane const *, int, int, uint16_t *, uint64_t *)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 86 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 87 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 88 */ _CFFI_OP(_CFFI_OP_POINTER, 408), // uint16_t *
/* 89 */ _CFFI_OP(_CFFI_OP_POINTER, 65), // uint64_t *
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncplane const *, nccell const *)
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncplane const *, nccell const *, uint16_t *, uint64_t *)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncplane const *, uint16_t *, uint64_t *)
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 103 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct ncreader const *)
/* 107 */ _CFFI_OP(_CFFI_OP_POINTER, 1690), // struct ncreader const *
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct notcurses *, unsigned int, unsigned int, uint16_t *, uint64_t *)
/* 110 */ _CFFI_OP(_CFFI_OP_POINTER, 1703), // struct notcurses *
/* 111 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 116 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(struct notcurses const *)
/* 117 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 119 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(void)
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // char *()(wchar_t const *)
/* 122 */ _CFFI_OP(_CFFI_OP_POINTER, 564), // wchar_t const *
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(ncblitter_e)
/* 125 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // ncblitter_e
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(ncscale_e)
/* 128 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // ncscale_e
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(struct ncmenu const *, ncinput *)
/* 131 */ _CFFI_OP(_CFFI_OP_POINTER, 1681), // struct ncmenu const *
/* 132 */ _CFFI_OP(_CFFI_OP_POINTER, 1657), // ncinput *
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(struct ncmenu const *, ncinput const *, ncinput *)
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 131),
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 137 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(struct ncplane const *, nccell const *)
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(struct ncselector *)
/* 144 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 146 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(struct ncselector const *)
/* 147 */ _CFFI_OP(_CFFI_OP_POINTER, 1692), // struct ncselector const *
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(struct nctab *)
/* 150 */ _CFFI_OP(_CFFI_OP_POINTER, 1695), // struct nctab *
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(struct nctabbed *)
/* 153 */ _CFFI_OP(_CFFI_OP_POINTER, 1696), // struct nctabbed *
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(uintmax_t, size_t, uintmax_t, char *, int, uintmax_t, int)
/* 156 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 47), // uintmax_t
/* 157 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 47),
/* 159 */ _CFFI_OP(_CFFI_OP_POINTER, 418), // char *
/* 160 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 161 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 47),
/* 162 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(uintmax_t, uintmax_t, char *, int)
/* 165 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 47),
/* 166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 47),
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 168 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // char const *()(void)
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION, 338), // double()(struct ncprogbar const *)
/* 173 */ _CFFI_OP(_CFFI_OP_POINTER, 1689), // struct ncprogbar const *
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(char const *, int *, int *)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(char const *, ncblitter_e *)
/* 181 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 182 */ _CFFI_OP(_CFFI_OP_POINTER, 125), // ncblitter_e *
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(char const *, ncscale_e *)
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 186 */ _CFFI_OP(_CFFI_OP_POINTER, 128), // ncscale_e *
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(char const *, notcurses_options *)
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 190 */ _CFFI_OP(_CFFI_OP_POINTER, 1675), // notcurses_options *
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(int, ncalign_e, int)
/* 193 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 194 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // ncalign_e
/* 195 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(nccell *, uint32_t)
/* 198 */ _CFFI_OP(_CFFI_OP_POINTER, 1653), // nccell *
/* 199 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(nccell *, unsigned int)
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 203 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(nccell *, unsigned int, unsigned int, unsigned int)
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 207 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 208 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 209 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(ncpalette *, int, unsigned int)
/* 212 */ _CFFI_OP(_CFFI_OP_POINTER, 1662), // ncpalette *
/* 213 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 214 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(ncpalette *, int, unsigned int, unsigned int, unsigned int)
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 212),
/* 218 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 219 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 220 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 221 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(ncpalette const *, int, uint32_t *)
/* 224 */ _CFFI_OP(_CFFI_OP_POINTER, 1662), // ncpalette const *
/* 225 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 226 */ _CFFI_OP(_CFFI_OP_POINTER, 62), // uint32_t *
/* 227 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 228 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(ncpalette const *, int, unsigned int *, unsigned int *, unsigned int *)
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 224),
/* 230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 231 */ _CFFI_OP(_CFFI_OP_POINTER, 26), // unsigned int *
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 233 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *)
/* 236 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, char const *, int(*)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *), struct ncvisual_options *, void *)
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 240 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 241 */ _CFFI_OP(_CFFI_OP_POINTER, 902), // int(*)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *)
/* 242 */ _CFFI_OP(_CFFI_OP_POINTER, 1702), // struct ncvisual_options *
/* 243 */ _CFFI_OP(_CFFI_OP_POINTER, 1709), // void *
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, char const *, ncalign_e, ncblitter_e, ncscale_e)
/* 246 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 247 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 248 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 128),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, char const *, unsigned int, uint64_t, uint64_t)
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 254 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 255 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 256 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 257 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 258 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, int)
/* 260 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 261 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 262 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 263 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, int, int)
/* 264 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 265 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 266 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 267 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, int, ncalign_e, char const *, ...)
/* 269 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 270 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 271 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 272 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 274 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, ncdirectf *, struct ncvisual_options const *, ncvgeom *)
/* 275 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 276 */ _CFFI_OP(_CFFI_OP_POINTER, 1654), // struct ncvisual *
/* 277 */ _CFFI_OP(_CFFI_OP_POINTER, 1702), // struct ncvisual_options const *
/* 278 */ _CFFI_OP(_CFFI_OP_POINTER, 1674), // ncvgeom *
/* 279 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, ncdirectv *, ncalign_e)
/* 281 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 283 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, uint64_t, char const *)
/* 286 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 287 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 288 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 290 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, uint64_t, char const *, int *)
/* 291 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 292 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 293 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 295 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 296 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, uint64_t, uint64_t, uint64_t, uint64_t, unsigned int, unsigned int, unsigned int)
/* 297 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 298 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 299 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 300 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 301 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 302 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 303 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 304 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 305 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 306 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, uint64_t, uint64_t, uint64_t, uint64_t, wchar_t const *, unsigned int, unsigned int, unsigned int)
/* 307 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 308 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 309 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 310 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 311 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 312 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 313 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 314 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 315 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 316 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 317 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, unsigned int *, unsigned int *)
/* 318 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 320 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, unsigned int)
/* 323 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 324 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 325 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 326 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect *, unsigned int, unsigned int, unsigned int)
/* 327 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 328 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 329 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 330 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 331 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 332 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdirect const *)
/* 333 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 334 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 335 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdplot *, uint64_t, double)
/* 336 */ _CFFI_OP(_CFFI_OP_POINTER, 1678), // struct ncdplot *
/* 337 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 338 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 340 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncdplot const *, uint64_t, double *)
/* 341 */ _CFFI_OP(_CFFI_OP_POINTER, 1678), // struct ncdplot const *
/* 342 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 343 */ _CFFI_OP(_CFFI_OP_POINTER, 338), // double *
/* 344 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 345 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncfadectx const *)
/* 346 */ _CFFI_OP(_CFFI_OP_POINTER, 1679), // struct ncfadectx const *
/* 347 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 348 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncfdplane *)
/* 349 */ _CFFI_OP(_CFFI_OP_POINTER, 1680), // struct ncfdplane *
/* 350 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 351 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncfdplane *, int, void *)
/* 352 */ _CFFI_OP(_CFFI_OP_NOOP, 349),
/* 353 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 354 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 355 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 356 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncfdplane *, void const *, size_t, void *)
/* 357 */ _CFFI_OP(_CFFI_OP_NOOP, 349),
/* 358 */ _CFFI_OP(_CFFI_OP_POINTER, 1709), // void const *
/* 359 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 360 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 361 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 362 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncmenu *)
/* 363 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 364 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncmenu *, char const *, char const *, _Bool)
/* 366 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 367 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 368 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 369 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1), // _Bool
/* 370 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncmenu *, int)
/* 372 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 373 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 374 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 375 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncmultiselector *, _Bool *, unsigned int)
/* 376 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 377 */ _CFFI_OP(_CFFI_OP_POINTER, 369), // _Bool *
/* 378 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 379 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 380 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *)
/* 381 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 382 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 383 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, FILE *)
/* 384 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 385 */ _CFFI_OP(_CFFI_OP_POINTER, 1643), // FILE *
/* 386 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 387 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, char * *, size_t *)
/* 388 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 389 */ _CFFI_OP(_CFFI_OP_POINTER, 159), // char * *
/* 390 */ _CFFI_OP(_CFFI_OP_POINTER, 157), // size_t *
/* 391 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 392 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, char const *)
/* 393 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 394 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 395 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 396 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, char const *, ...)
/* 397 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 398 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 399 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 400 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, char const *, size_t *)
/* 401 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 402 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 403 */ _CFFI_OP(_CFFI_OP_NOOP, 390),
/* 404 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 405 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, char const *, uint16_t, uint64_t)
/* 406 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 407 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 408 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20), // uint16_t
/* 409 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 410 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 411 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, char const *, va_list)
/* 412 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 413 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 414 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // va_list
/* 415 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 416 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, char)
/* 417 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 418 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 419 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 420 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int)
/* 421 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 422 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 423 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 424 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int)
/* 425 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 426 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 427 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 428 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 429 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, char const *)
/* 430 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 431 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 432 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 433 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 434 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 435 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, char const *, ...)
/* 436 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 437 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 438 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 439 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 440 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 441 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, char const *, size_t *)
/* 442 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 443 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 444 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 445 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 446 */ _CFFI_OP(_CFFI_OP_NOOP, 390),
/* 447 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 448 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, char const *, va_list)
/* 449 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 450 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 451 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 452 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 453 */ _CFFI_OP(_CFFI_OP_NOOP, 414),
/* 454 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 455 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, char)
/* 456 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 457 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 458 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 459 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2),
/* 460 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 461 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, int, int)
/* 462 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 463 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 464 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 465 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 466 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 467 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 468 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, nccell *)
/* 469 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 470 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 471 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 472 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 473 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 474 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, nccell const *)
/* 475 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 476 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 477 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 478 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 479 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 480 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, size_t, char const *)
/* 481 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 482 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 483 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 484 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 485 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 486 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 487 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, uint32_t)
/* 488 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 489 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 490 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 491 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 492 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 493 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, unsigned int, unsigned int, char const *, uint16_t, uint64_t, uint64_t, uint64_t, uint64_t)
/* 494 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 495 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 496 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 497 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 498 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 499 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 500 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 501 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 502 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 503 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 504 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 505 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 506 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, unsigned int, unsigned int, int, int, unsigned int, unsigned int)
/* 507 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 508 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 509 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 510 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 511 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 512 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 513 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 514 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 515 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 516 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 517 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, unsigned int, unsigned int, uint16_t)
/* 518 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 519 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 520 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 521 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 522 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 523 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 524 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 525 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, unsigned int, unsigned int, uint32_t, uint32_t, uint32_t, uint32_t)
/* 526 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 527 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 528 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 529 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 530 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 531 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 532 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 533 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 534 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 535 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 536 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, unsigned int, unsigned int, uint64_t, uint64_t, uint64_t, uint64_t)
/* 537 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 538 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 539 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 540 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 541 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 542 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 543 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 544 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 545 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 546 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 547 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, wchar_t const *)
/* 548 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 549 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 550 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 551 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 552 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 553 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, wchar_t const *, size_t *)
/* 554 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 555 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 556 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 557 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 558 */ _CFFI_OP(_CFFI_OP_NOOP, 390),
/* 559 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 560 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, int, wchar_t)
/* 561 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 562 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 563 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 564 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 16), // wchar_t
/* 565 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 566 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, ncalign_e, char const *)
/* 567 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 568 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 569 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 570 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 571 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 572 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, ncalign_e, char const *, ...)
/* 573 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 574 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 575 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 576 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 577 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 578 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, ncalign_e, char const *, size_t *)
/* 579 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 580 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 581 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 582 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 583 */ _CFFI_OP(_CFFI_OP_NOOP, 390),
/* 584 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 585 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, ncalign_e, char const *, va_list)
/* 586 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 587 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 588 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 589 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 590 */ _CFFI_OP(_CFFI_OP_NOOP, 414),
/* 591 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 592 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, ncalign_e, size_t, char const *)
/* 593 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 594 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 595 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 596 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 597 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 598 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 599 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, int, ncalign_e, wchar_t const *)
/* 600 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 601 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 602 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 603 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 604 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 605 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell *)
/* 606 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 607 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 608 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 609 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell *, char const *)
/* 610 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 611 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 612 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 613 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 614 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell *, char const *, uint16_t, uint64_t)
/* 615 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 616 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 617 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 618 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 619 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 620 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 621 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell *, char)
/* 622 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 623 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 624 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2),
/* 625 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 626 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell *, nccell const *)
/* 627 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 628 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 629 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 630 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 631 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell *, uint32_t)
/* 632 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 633 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 634 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 635 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 636 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell const *)
/* 637 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 638 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 639 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 640 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell const *, nccell const *, nccell const *, nccell const *, nccell const *, nccell const *, unsigned int)
/* 641 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 642 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 643 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 644 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 645 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 646 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 647 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 648 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 649 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 650 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell const *, nccell const *, nccell const *, nccell const *, nccell const *, nccell const *, unsigned int, unsigned int, unsigned int)
/* 651 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 652 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 653 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 654 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 655 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 656 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 657 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 658 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 659 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 660 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 661 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 662 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell const *, unsigned int)
/* 663 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 664 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 665 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 666 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 667 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, nccell const *, unsigned int, uint64_t, uint64_t)
/* 668 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 669 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 670 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 671 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 672 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 673 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 674 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, size_t, char const *)
/* 675 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 676 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 677 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 678 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 679 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, struct ncfadectx *, int, int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *), void *)
/* 680 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 681 */ _CFFI_OP(_CFFI_OP_POINTER, 1679), // struct ncfadectx *
/* 682 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 683 */ _CFFI_OP(_CFFI_OP_POINTER, 938), // int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *)
/* 684 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 685 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 686 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, struct ncplane *)
/* 687 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 688 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 689 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 690 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, struct ncplane *, int, int, unsigned int, unsigned int, int, int)
/* 691 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 692 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 693 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 694 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 695 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 696 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 697 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 698 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 699 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 700 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, struct ncplane const *)
/* 701 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 702 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 703 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 704 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, struct timespec const *, int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *), void *)
/* 705 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 706 */ _CFFI_OP(_CFFI_OP_POINTER, 1704), // struct timespec const *
/* 707 */ _CFFI_OP(_CFFI_OP_NOOP, 683),
/* 708 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 709 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 710 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, uint16_t, uint64_t, nccell *, nccell *, nccell *, nccell *, nccell *, nccell *)
/* 711 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 712 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 713 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 714 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 715 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 716 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 717 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 718 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 719 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 720 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 721 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, uint16_t, uint64_t, nccell *, nccell *, nccell *, nccell *, nccell *, nccell *, char const *)
/* 722 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 723 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 724 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 725 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 726 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 727 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 728 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 729 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 730 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 731 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 732 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 733 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, uint16_t, uint64_t, unsigned int)
/* 734 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 735 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 736 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 737 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 738 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 739 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, uint16_t, uint64_t, unsigned int, unsigned int, unsigned int)
/* 740 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 741 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 742 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 743 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 744 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 745 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 746 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 747 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, uint32_t)
/* 748 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 749 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 750 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 751 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, unsigned int *, unsigned int *, void const *, size_t)
/* 752 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 753 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 754 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 755 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 756 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 757 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 758 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, unsigned int)
/* 759 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 760 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 761 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 762 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, unsigned int, unsigned int)
/* 763 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 764 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 765 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 766 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 767 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, unsigned int, unsigned int, unsigned int)
/* 768 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 769 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 770 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 771 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 772 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 773 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, void *, int)
/* 774 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 775 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 776 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 777 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 778 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, wchar_t const *)
/* 779 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 780 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 781 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 782 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, wchar_t const *, size_t *)
/* 783 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 784 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 785 */ _CFFI_OP(_CFFI_OP_NOOP, 390),
/* 786 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 787 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, wchar_t const *, unsigned int *)
/* 788 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 789 */ _CFFI_OP(_CFFI_OP_NOOP, 122),
/* 790 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 791 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 792 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane *, wchar_t)
/* 793 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 794 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 16),
/* 795 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 796 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane const *)
/* 797 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 798 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 799 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane const *, ncalign_e, int)
/* 800 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 801 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 802 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 803 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 804 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncplane const *, struct ncplane const *)
/* 805 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 806 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 807 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 808 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncprogbar *, double)
/* 809 */ _CFFI_OP(_CFFI_OP_POINTER, 1689), // struct ncprogbar *
/* 810 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 811 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 812 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncreader *)
/* 813 */ _CFFI_OP(_CFFI_OP_NOOP, 43),
/* 814 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 815 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncreader *, char const *)
/* 816 */ _CFFI_OP(_CFFI_OP_NOOP, 43),
/* 817 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 818 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 819 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncreel *)
/* 820 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 821 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 822 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncreel *, struct nctablet *)
/* 823 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 824 */ _CFFI_OP(_CFFI_OP_POINTER, 1697), // struct nctablet *
/* 825 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 826 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncreel const *)
/* 827 */ _CFFI_OP(_CFFI_OP_POINTER, 1691), // struct ncreel const *
/* 828 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 829 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncselector *, char const *)
/* 830 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 831 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 832 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 833 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncselector *, struct ncselector_item const *)
/* 834 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 835 */ _CFFI_OP(_CFFI_OP_POINTER, 1693), // struct ncselector_item const *
/* 836 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 837 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncsubproc *)
/* 838 */ _CFFI_OP(_CFFI_OP_POINTER, 1694), // struct ncsubproc *
/* 839 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 840 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctab *)
/* 841 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 842 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 843 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctab *, char const *)
/* 844 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 845 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 846 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 847 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctabbed *)
/* 848 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 849 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 850 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctabbed *, char const *)
/* 851 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 852 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 853 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 854 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctabbed *, struct nctab *)
/* 855 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 856 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 857 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 858 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctabbed *, struct nctab *, struct nctab *, struct nctab *)
/* 859 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 860 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 861 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 862 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 863 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 864 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctablet *, _Bool)
/* 865 */ _CFFI_OP(_CFFI_OP_NOOP, 824),
/* 866 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 867 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 868 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctree *)
/* 869 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 870 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 871 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctree *, unsigned int const *)
/* 872 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 873 */ _CFFI_OP(_CFFI_OP_POINTER, 26), // unsigned int const *
/* 874 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 875 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct nctree *, unsigned int const *, struct nctree_item const *)
/* 876 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 877 */ _CFFI_OP(_CFFI_OP_NOOP, 873),
/* 878 */ _CFFI_OP(_CFFI_OP_POINTER, 1700), // struct nctree_item const *
/* 879 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 880 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncuplot *, uint64_t, uint64_t)
/* 881 */ _CFFI_OP(_CFFI_OP_POINTER, 1701), // struct ncuplot *
/* 882 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 883 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 884 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 885 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncuplot const *, uint64_t, uint64_t *)
/* 886 */ _CFFI_OP(_CFFI_OP_POINTER, 1701), // struct ncuplot const *
/* 887 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 888 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 889 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 890 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncvisual *)
/* 891 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 892 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 893 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncvisual *, double)
/* 894 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 895 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 896 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 897 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncvisual *, int, int)
/* 898 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 899 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 900 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 901 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 902 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *)
/* 903 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 904 */ _CFFI_OP(_CFFI_OP_NOOP, 242),
/* 905 */ _CFFI_OP(_CFFI_OP_NOOP, 706),
/* 906 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 907 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 908 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncvisual *, unsigned int, unsigned int, uint32_t)
/* 909 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 910 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 911 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 912 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 913 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 914 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncvisual const *, unsigned int, unsigned int, uint32_t *)
/* 915 */ _CFFI_OP(_CFFI_OP_POINTER, 1654), // struct ncvisual const *
/* 916 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 917 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 918 */ _CFFI_OP(_CFFI_OP_NOOP, 226),
/* 919 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 920 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct ncvisual const *, unsigned int, unsigned int, uint32_t)
/* 921 */ _CFFI_OP(_CFFI_OP_NOOP, 915),
/* 922 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 923 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 924 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 925 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 926 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses *)
/* 927 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 928 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 929 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses *, int, int)
/* 930 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 931 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 932 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 933 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 934 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses *, ncpalette const *)
/* 935 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 936 */ _CFFI_OP(_CFFI_OP_NOOP, 224),
/* 937 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 938 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses *, struct ncplane *, struct timespec const *, void *)
/* 939 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 940 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 941 */ _CFFI_OP(_CFFI_OP_NOOP, 706),
/* 942 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 943 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 944 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses *, struct ncvisual *, float, int(*)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *), struct ncvisual_options const *, void *)
/* 945 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 946 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 947 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13), // float
/* 948 */ _CFFI_OP(_CFFI_OP_NOOP, 241),
/* 949 */ _CFFI_OP(_CFFI_OP_NOOP, 277),
/* 950 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 951 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 952 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses *, struct timespec const *, ncinput *, int)
/* 953 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 954 */ _CFFI_OP(_CFFI_OP_NOOP, 706),
/* 955 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 956 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 957 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 958 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses *, unsigned int *, unsigned int *)
/* 959 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 960 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 961 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 962 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 963 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses *, unsigned int)
/* 964 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 965 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 966 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 967 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses const *, int *, int *)
/* 968 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 969 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 970 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 971 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 972 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses const *, struct ncvisual const *, struct ncvisual_options const *, ncvgeom *)
/* 973 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 974 */ _CFFI_OP(_CFFI_OP_NOOP, 915),
/* 975 */ _CFFI_OP(_CFFI_OP_NOOP, 277),
/* 976 */ _CFFI_OP(_CFFI_OP_NOOP, 278),
/* 977 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 978 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(struct notcurses const *, uint32_t *)
/* 979 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 980 */ _CFFI_OP(_CFFI_OP_NOOP, 226),
/* 981 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 982 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(uint32_t *, uint32_t)
/* 983 */ _CFFI_OP(_CFFI_OP_NOOP, 226),
/* 984 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 985 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 986 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(uint32_t *, unsigned int)
/* 987 */ _CFFI_OP(_CFFI_OP_NOOP, 226),
/* 988 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 989 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 990 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(uint32_t *, unsigned int, unsigned int, unsigned int)
/* 991 */ _CFFI_OP(_CFFI_OP_NOOP, 226),
/* 992 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 993 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 994 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 995 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 996 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(uint32_t const *, unsigned int, unsigned char *, size_t)
/* 997 */ _CFFI_OP(_CFFI_OP_POINTER, 62), // uint32_t const *
/* 998 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 999 */ _CFFI_OP(_CFFI_OP_POINTER, 1708), // unsigned char *
/* 1000 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1001 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1002 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(uint64_t *, unsigned int)
/* 1003 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1004 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1005 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1006 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(uint64_t *, unsigned int, unsigned int, unsigned int)
/* 1007 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1008 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1009 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1010 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1011 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1012 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(void const *, int, struct ncvisual_options const *)
/* 1013 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 1014 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1015 */ _CFFI_OP(_CFFI_OP_NOOP, 277),
/* 1016 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1017 */ _CFFI_OP(_CFFI_OP_FUNCTION, 76), // int()(void const *, int, struct ncvisual_options const *, int)
/* 1018 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 1019 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1020 */ _CFFI_OP(_CFFI_OP_NOOP, 277),
/* 1021 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1022 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1023 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1517), // int(*()(struct ncplane const *))(struct ncplane *)
/* 1024 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1025 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1026 */ _CFFI_OP(_CFFI_OP_FUNCTION, 125), // ncblitter_e()(struct notcurses const *, ncscale_e)
/* 1027 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1028 */ _CFFI_OP(_CFFI_OP_NOOP, 128),
/* 1029 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1030 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // nccapabilities const *()(struct ncdirect const *)
/* 1031 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 1032 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1033 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // nccapabilities const *()(struct notcurses const *)
/* 1034 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1035 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1036 */ _CFFI_OP(_CFFI_OP_FUNCTION, 276), // ncdirectf *()(struct ncdirect *, char const *)
/* 1037 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 1038 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 1039 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1040 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // ncdirectv *()(struct ncdirect *, char const *, ncblitter_e, ncscale_e, int, int)
/* 1041 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 1042 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 1043 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 1044 */ _CFFI_OP(_CFFI_OP_NOOP, 128),
/* 1045 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1046 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1047 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1048 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // ncdirectv *()(struct ncdirect *, ncdirectf *, struct ncvisual_options const *)
/* 1049 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 1050 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 1051 */ _CFFI_OP(_CFFI_OP_NOOP, 277),
/* 1052 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1053 */ _CFFI_OP(_CFFI_OP_FUNCTION, 212), // ncpalette *()(struct notcurses *)
/* 1054 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1055 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1056 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1663), // ncpixelimpl_e()(struct notcurses const *)
/* 1057 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1058 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1059 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1613), // ncstats *()(struct notcurses const *)
/* 1060 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1061 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1062 */ _CFFI_OP(_CFFI_OP_FUNCTION, 68), // struct ncdirect *()(char const *, FILE *, uint64_t)
/* 1063 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 1064 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 1065 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1066 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1067 */ _CFFI_OP(_CFFI_OP_FUNCTION, 336), // struct ncdplot *()(struct ncplane *, ncplot_options const *, double, double)
/* 1068 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1069 */ _CFFI_OP(_CFFI_OP_POINTER, 1665), // ncplot_options const *
/* 1070 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1071 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1072 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1073 */ _CFFI_OP(_CFFI_OP_FUNCTION, 681), // struct ncfadectx *()(struct ncplane *)
/* 1074 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1075 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1076 */ _CFFI_OP(_CFFI_OP_FUNCTION, 349), // struct ncfdplane *()(struct ncplane *, ncfdplane_options const *, int, int(*)(struct ncfdplane *, void const *, size_t, void *), int(*)(struct ncfdplane *, int, void *))
/* 1077 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1078 */ _CFFI_OP(_CFFI_OP_POINTER, 1656), // ncfdplane_options const *
/* 1079 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1080 */ _CFFI_OP(_CFFI_OP_POINTER, 356), // int(*)(struct ncfdplane *, void const *, size_t, void *)
/* 1081 */ _CFFI_OP(_CFFI_OP_POINTER, 351), // int(*)(struct ncfdplane *, int, void *)
/* 1082 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1083 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // struct ncmenu *()(struct ncplane *, ncmenu_options const *)
/* 1084 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1085 */ _CFFI_OP(_CFFI_OP_POINTER, 1660), // ncmenu_options const *
/* 1086 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1087 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // struct ncmultiselector *()(struct ncplane *, ncmultiselector_options const *)
/* 1088 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1089 */ _CFFI_OP(_CFFI_OP_POINTER, 1661), // ncmultiselector_options const *
/* 1090 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1091 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncdplot *)
/* 1092 */ _CFFI_OP(_CFFI_OP_NOOP, 336),
/* 1093 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1094 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncfdplane *)
/* 1095 */ _CFFI_OP(_CFFI_OP_NOOP, 349),
/* 1096 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1097 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncmenu *)
/* 1098 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 1099 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncmultiselector *)
/* 1101 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 1102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncplane *)
/* 1104 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncplane *, ncplane_options const *)
/* 1107 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1108 */ _CFFI_OP(_CFFI_OP_POINTER, 1664), // ncplane_options const *
/* 1109 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1110 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncplane *, struct ncplane *)
/* 1111 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1112 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncplane *, struct ncvisual const *)
/* 1115 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1116 */ _CFFI_OP(_CFFI_OP_NOOP, 915),
/* 1117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncplane const *, void *)
/* 1119 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1120 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1121 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1122 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncprogbar *)
/* 1123 */ _CFFI_OP(_CFFI_OP_NOOP, 809),
/* 1124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncreader *)
/* 1126 */ _CFFI_OP(_CFFI_OP_NOOP, 43),
/* 1127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncreel *)
/* 1129 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 1130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncselector *)
/* 1132 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 1133 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1134 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncsubproc *)
/* 1135 */ _CFFI_OP(_CFFI_OP_NOOP, 838),
/* 1136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct nctabbed *)
/* 1138 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct nctablet *)
/* 1141 */ _CFFI_OP(_CFFI_OP_NOOP, 824),
/* 1142 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1143 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct nctree *)
/* 1144 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 1145 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1146 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct ncuplot *)
/* 1147 */ _CFFI_OP(_CFFI_OP_NOOP, 881),
/* 1148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct notcurses *)
/* 1150 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct notcurses *, ncplane_options const *)
/* 1153 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1154 */ _CFFI_OP(_CFFI_OP_NOOP, 1108),
/* 1155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct notcurses *, ncplane_options const *, struct ncvisual *, struct ncvisual_options *)
/* 1157 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1158 */ _CFFI_OP(_CFFI_OP_NOOP, 1108),
/* 1159 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 1160 */ _CFFI_OP(_CFFI_OP_NOOP, 242),
/* 1161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct notcurses *, struct ncvisual *, struct ncvisual_options const *)
/* 1163 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1164 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 1165 */ _CFFI_OP(_CFFI_OP_NOOP, 277),
/* 1166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // struct ncplane *()(struct notcurses *, unsigned int *, unsigned int *)
/* 1168 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1169 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1170 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1171 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1172 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // struct ncplane const *()(struct ncplane const *)
/* 1173 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // struct ncplane const *()(struct notcurses const *)
/* 1176 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1177 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1178 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // struct ncplane const *()(struct notcurses const *, unsigned int *, unsigned int *)
/* 1179 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1180 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1181 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1182 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1183 */ _CFFI_OP(_CFFI_OP_FUNCTION, 809), // struct ncprogbar *()(struct ncplane *, ncprogbar_options const *)
/* 1184 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1185 */ _CFFI_OP(_CFFI_OP_POINTER, 1666), // ncprogbar_options const *
/* 1186 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1187 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // struct ncreader *()(struct ncplane *, ncreader_options const *)
/* 1188 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1189 */ _CFFI_OP(_CFFI_OP_POINTER, 1667), // ncreader_options const *
/* 1190 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1191 */ _CFFI_OP(_CFFI_OP_FUNCTION, 47), // struct ncreel *()(struct ncplane *, ncreel_options const *)
/* 1192 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1193 */ _CFFI_OP(_CFFI_OP_POINTER, 1668), // ncreel_options const *
/* 1194 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1195 */ _CFFI_OP(_CFFI_OP_FUNCTION, 51), // struct ncselector *()(struct ncplane *, ncselector_options const *)
/* 1196 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1197 */ _CFFI_OP(_CFFI_OP_POINTER, 1669), // ncselector_options const *
/* 1198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 838), // struct ncsubproc *()(struct ncplane *, ncsubproc_options const *, char const *, char const * const *, char const * const *, int(*)(struct ncfdplane *, void const *, size_t, void *), int(*)(struct ncfdplane *, int, void *))
/* 1200 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1201 */ _CFFI_OP(_CFFI_OP_POINTER, 1671), // ncsubproc_options const *
/* 1202 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 1203 */ _CFFI_OP(_CFFI_OP_POINTER, 69), // char const * const *
/* 1204 */ _CFFI_OP(_CFFI_OP_NOOP, 1203),
/* 1205 */ _CFFI_OP(_CFFI_OP_NOOP, 1080),
/* 1206 */ _CFFI_OP(_CFFI_OP_NOOP, 1081),
/* 1207 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1208 */ _CFFI_OP(_CFFI_OP_FUNCTION, 838), // struct ncsubproc *()(struct ncplane *, ncsubproc_options const *, char const *, char const * const *, int(*)(struct ncfdplane *, void const *, size_t, void *), int(*)(struct ncfdplane *, int, void *))
/* 1209 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1210 */ _CFFI_OP(_CFFI_OP_NOOP, 1201),
/* 1211 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 1212 */ _CFFI_OP(_CFFI_OP_NOOP, 1203),
/* 1213 */ _CFFI_OP(_CFFI_OP_NOOP, 1080),
/* 1214 */ _CFFI_OP(_CFFI_OP_NOOP, 1081),
/* 1215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 150), // struct nctab *()(struct nctab *)
/* 1217 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1218 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1219 */ _CFFI_OP(_CFFI_OP_FUNCTION, 150), // struct nctab *()(struct nctabbed *)
/* 1220 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 150), // struct nctab *()(struct nctabbed *, struct nctab *)
/* 1223 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1224 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 150), // struct nctab *()(struct nctabbed *, struct nctab *, struct nctab *, void(*)(struct nctab *, struct ncplane *, void *), char const *, void *)
/* 1227 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1228 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1229 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1230 */ _CFFI_OP(_CFFI_OP_POINTER, 1576), // void(*)(struct nctab *, struct ncplane *, void *)
/* 1231 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 1232 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1233 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1234 */ _CFFI_OP(_CFFI_OP_FUNCTION, 153), // struct nctabbed *()(struct ncplane *, nctabbed_options const *)
/* 1235 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1236 */ _CFFI_OP(_CFFI_OP_POINTER, 1672), // nctabbed_options const *
/* 1237 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1238 */ _CFFI_OP(_CFFI_OP_FUNCTION, 824), // struct nctablet *()(struct ncreel *)
/* 1239 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 1240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 824), // struct nctablet *()(struct ncreel *, struct nctablet *, struct nctablet *, int(*)(struct nctablet *, _Bool), void *)
/* 1242 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 1243 */ _CFFI_OP(_CFFI_OP_NOOP, 824),
/* 1244 */ _CFFI_OP(_CFFI_OP_NOOP, 824),
/* 1245 */ _CFFI_OP(_CFFI_OP_POINTER, 864), // int(*)(struct nctablet *, _Bool)
/* 1246 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // struct nctree *()(struct ncplane *, nctree_options const *)
/* 1249 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1250 */ _CFFI_OP(_CFFI_OP_POINTER, 1673), // nctree_options const *
/* 1251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 881), // struct ncuplot *()(struct ncplane *, ncplot_options const *, uint64_t, uint64_t)
/* 1253 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1254 */ _CFFI_OP(_CFFI_OP_NOOP, 1069),
/* 1255 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1256 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1257 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1258 */ _CFFI_OP(_CFFI_OP_FUNCTION, 276), // struct ncvisual *()(char const *)
/* 1259 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 1260 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1261 */ _CFFI_OP(_CFFI_OP_FUNCTION, 276), // struct ncvisual *()(char const *, unsigned int, unsigned int)
/* 1262 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 1263 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1264 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1265 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1266 */ _CFFI_OP(_CFFI_OP_FUNCTION, 276), // struct ncvisual *()(struct ncplane const *, ncblitter_e, int, int, unsigned int, unsigned int)
/* 1267 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1268 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 1269 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1270 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1271 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1272 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1273 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1274 */ _CFFI_OP(_CFFI_OP_FUNCTION, 276), // struct ncvisual *()(void const *, int, int, int)
/* 1275 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 1276 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1277 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1278 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1279 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1280 */ _CFFI_OP(_CFFI_OP_FUNCTION, 276), // struct ncvisual *()(void const *, int, int, int, int)
/* 1281 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 1282 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1283 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1284 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1285 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1286 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1287 */ _CFFI_OP(_CFFI_OP_FUNCTION, 276), // struct ncvisual *()(void const *, int, int, int, int, int, uint32_t const *)
/* 1288 */ _CFFI_OP(_CFFI_OP_NOOP, 358),
/* 1289 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1290 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1291 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1292 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1293 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1294 */ _CFFI_OP(_CFFI_OP_NOOP, 997),
/* 1295 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1296 */ _CFFI_OP(_CFFI_OP_FUNCTION, 110), // struct notcurses *()(notcurses_options const *, FILE *)
/* 1297 */ _CFFI_OP(_CFFI_OP_POINTER, 1675), // notcurses_options const *
/* 1298 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 1299 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1300 */ _CFFI_OP(_CFFI_OP_FUNCTION, 110), // struct notcurses *()(struct ncplane const *)
/* 1301 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1302 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1303 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // struct notcurses const *()(struct ncplane const *)
/* 1304 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1305 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1306 */ _CFFI_OP(_CFFI_OP_FUNCTION, 408), // uint16_t()(nccell const *)
/* 1307 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 1308 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1309 */ _CFFI_OP(_CFFI_OP_FUNCTION, 408), // uint16_t()(struct ncdirect const *)
/* 1310 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 1311 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1312 */ _CFFI_OP(_CFFI_OP_FUNCTION, 408), // uint16_t()(struct ncplane const *)
/* 1313 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1314 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1315 */ _CFFI_OP(_CFFI_OP_FUNCTION, 408), // uint16_t()(struct notcurses const *)
/* 1316 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1317 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1318 */ _CFFI_OP(_CFFI_OP_FUNCTION, 226), // uint32_t *()(struct ncplane const *, ncblitter_e, int, int, unsigned int, unsigned int, unsigned int *, unsigned int *)
/* 1319 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1320 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 1321 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1322 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1323 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1324 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1325 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1326 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1327 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1328 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(nccell const *)
/* 1329 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 1330 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1331 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(nccell const *, unsigned int *, unsigned int *, unsigned int *)
/* 1332 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 1333 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1334 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1335 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1336 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1337 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(struct ncdirect *, ncinput *)
/* 1338 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 1339 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 1340 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1341 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(struct ncdirect *, struct timespec const *, ncinput *)
/* 1342 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 1343 */ _CFFI_OP(_CFFI_OP_NOOP, 706),
/* 1344 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 1345 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1346 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(struct ncplane const *)
/* 1347 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1348 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1349 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(struct ncplane const *, unsigned int *, unsigned int *, unsigned int *)
/* 1350 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1351 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1352 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1353 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1354 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1355 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(struct notcurses *, ncinput *)
/* 1356 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1357 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 1358 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1359 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(struct notcurses *, struct timespec const *, ncinput *)
/* 1360 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1361 */ _CFFI_OP(_CFFI_OP_NOOP, 706),
/* 1362 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 1363 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1364 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(uint32_t *)
/* 1365 */ _CFFI_OP(_CFFI_OP_NOOP, 226),
/* 1366 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1367 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(uint32_t)
/* 1368 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1369 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1370 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(uint32_t, unsigned int *, unsigned int *, unsigned int *)
/* 1371 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1372 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1373 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1374 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1375 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1376 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(uint64_t)
/* 1377 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1378 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1379 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(uint64_t, unsigned int *, unsigned int *, unsigned int *)
/* 1380 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1381 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1382 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1383 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1384 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1385 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // uint32_t()(unsigned int, unsigned int, unsigned int)
/* 1386 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1387 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1388 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1389 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1390 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(nccell *, uint32_t)
/* 1391 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 1392 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1393 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1394 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(nccell *, uint64_t)
/* 1395 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 1396 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1397 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1398 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(nccell const *)
/* 1399 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 1400 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1401 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(struct ncplane *, uint32_t)
/* 1402 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1403 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1404 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1405 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(struct ncplane const *)
/* 1406 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1407 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1408 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(struct nctabbed *)
/* 1409 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1410 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1411 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(uint32_t, uint32_t)
/* 1412 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1413 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1414 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1415 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(uint64_t *)
/* 1416 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1417 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1418 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(uint64_t *, uint32_t)
/* 1419 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1420 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1421 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1422 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(uint64_t *, uint64_t)
/* 1423 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1424 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1425 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1426 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // uint64_t()(uint64_t)
/* 1427 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1428 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1429 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // unsigned int()(nccell const *)
/* 1430 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 1431 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1432 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // unsigned int()(struct ncdirect *)
/* 1433 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 1434 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1435 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // unsigned int()(struct ncdirect const *)
/* 1436 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 1437 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1438 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // unsigned int()(struct ncplane const *)
/* 1439 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1440 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1441 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // unsigned int()(struct notcurses const *)
/* 1442 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1443 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1444 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // unsigned int()(uint32_t)
/* 1445 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1446 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1447 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // unsigned int()(uint64_t)
/* 1448 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1449 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1450 */ _CFFI_OP(_CFFI_OP_FUNCTION, 243), // void *()(struct ncplane *)
/* 1451 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1452 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1453 */ _CFFI_OP(_CFFI_OP_FUNCTION, 243), // void *()(struct ncplane *, void *)
/* 1454 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1455 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1456 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1457 */ _CFFI_OP(_CFFI_OP_FUNCTION, 243), // void *()(struct nctab *)
/* 1458 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1459 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1460 */ _CFFI_OP(_CFFI_OP_FUNCTION, 243), // void *()(struct nctab *, void *)
/* 1461 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1462 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1463 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1464 */ _CFFI_OP(_CFFI_OP_FUNCTION, 243), // void *()(struct nctablet *)
/* 1465 */ _CFFI_OP(_CFFI_OP_NOOP, 824),
/* 1466 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1467 */ _CFFI_OP(_CFFI_OP_FUNCTION, 243), // void *()(struct nctree *)
/* 1468 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 1469 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1470 */ _CFFI_OP(_CFFI_OP_FUNCTION, 243), // void *()(struct nctree *, unsigned int const *, int *)
/* 1471 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 1472 */ _CFFI_OP(_CFFI_OP_NOOP, 873),
/* 1473 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1474 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1475 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(int *, int *, int *, int *)
/* 1476 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1477 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1478 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1479 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1480 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1481 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(nccell *)
/* 1482 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 1483 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1484 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(nccell *, int, int, int)
/* 1485 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 1486 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1487 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1488 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1489 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1490 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(nccell *, unsigned int)
/* 1491 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 1492 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1493 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1494 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(ncdirectf *)
/* 1495 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 1496 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1497 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(ncpalette *)
/* 1498 */ _CFFI_OP(_CFFI_OP_NOOP, 212),
/* 1499 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1500 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncdplot *)
/* 1501 */ _CFFI_OP(_CFFI_OP_NOOP, 336),
/* 1502 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1503 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncfadectx *)
/* 1504 */ _CFFI_OP(_CFFI_OP_NOOP, 681),
/* 1505 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1506 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncmenu *)
/* 1507 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 1508 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1509 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncmultiselector *)
/* 1510 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 1511 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1512 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane *)
/* 1513 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1514 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1515 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane *, int(*)(struct ncplane *))
/* 1516 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1517 */ _CFFI_OP(_CFFI_OP_POINTER, 380), // int(*)(struct ncplane *)
/* 1518 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1519 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane *, int, int, int)
/* 1520 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1521 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1522 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1523 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1524 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1525 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane *, nccell *)
/* 1526 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1527 */ _CFFI_OP(_CFFI_OP_NOOP, 198),
/* 1528 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1529 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane *, uint64_t)
/* 1530 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1531 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1532 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1533 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane *, unsigned int)
/* 1534 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1535 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1536 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1537 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane const *, int *, int *)
/* 1538 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1539 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1540 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1541 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1542 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane const *, struct ncplane const *, int *, int *)
/* 1543 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1544 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1545 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1546 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 1547 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1548 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane const *, unsigned int *, unsigned int *)
/* 1549 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1550 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1551 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1552 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1553 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncplane const *, unsigned int *, unsigned int *, unsigned int *, unsigned int *, unsigned int *, unsigned int *)
/* 1554 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 1555 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1556 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1557 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1558 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1559 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1560 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1561 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1562 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncprogbar *)
/* 1563 */ _CFFI_OP(_CFFI_OP_NOOP, 809),
/* 1564 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1565 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncreader *, char * *)
/* 1566 */ _CFFI_OP(_CFFI_OP_NOOP, 43),
/* 1567 */ _CFFI_OP(_CFFI_OP_NOOP, 389),
/* 1568 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1569 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncreel *)
/* 1570 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 1571 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1572 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncselector *, char * *)
/* 1573 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 1574 */ _CFFI_OP(_CFFI_OP_NOOP, 389),
/* 1575 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1576 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct nctab *, struct ncplane *, void *)
/* 1577 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1578 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 1579 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 1580 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1581 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct nctabbed *)
/* 1582 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1583 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1584 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct nctabbed *, int)
/* 1585 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1586 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1587 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1588 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct nctabbed *, struct nctab *)
/* 1589 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1590 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1591 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1592 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct nctabbed *, uint64_t *, uint64_t *, uint64_t *)
/* 1593 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1594 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1595 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1596 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1597 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1598 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct nctabbed *, uint64_t)
/* 1599 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1600 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1601 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1602 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct nctree *)
/* 1603 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 1604 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1605 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct ncuplot *)
/* 1606 */ _CFFI_OP(_CFFI_OP_NOOP, 881),
/* 1607 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1608 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct notcurses *)
/* 1609 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1610 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1611 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct notcurses *, ncstats *)
/* 1612 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 1613 */ _CFFI_OP(_CFFI_OP_POINTER, 1670), // ncstats *
/* 1614 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1615 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct notcurses const *, FILE *)
/* 1616 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1617 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 1618 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1619 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(struct notcurses const *, unsigned int *, unsigned int *)
/* 1620 */ _CFFI_OP(_CFFI_OP_NOOP, 59),
/* 1621 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1622 */ _CFFI_OP(_CFFI_OP_NOOP, 231),
/* 1623 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1624 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(uint32_t *, int, int, int)
/* 1625 */ _CFFI_OP(_CFFI_OP_NOOP, 226),
/* 1626 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1627 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1628 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1629 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1630 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1709), // void()(uint64_t *, int, int, int)
/* 1631 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1632 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1633 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1634 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1635 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1636 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1230), // void(*()(struct nctab *))(struct nctab *, struct ncplane *, void *)
/* 1637 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1638 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1639 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1230), // void(*()(struct nctab *, void(*)(struct nctab *, struct ncplane *, void *)))(struct nctab *, struct ncplane *, void *)
/* 1640 */ _CFFI_OP(_CFFI_OP_NOOP, 150),
/* 1641 */ _CFFI_OP(_CFFI_OP_NOOP, 1230),
/* 1642 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1643 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // FILE
/* 1644 */ _CFFI_OP(_CFFI_OP_ARRAY, 418), // char[5]
/* 1645 */ (_cffi_opcode_t)(5),
/* 1646 */ _CFFI_OP(_CFFI_OP_POINTER, 268), // int(*)(struct ncdirect *, int, ncalign_e, char const *, ...)
/* 1647 */ _CFFI_OP(_CFFI_OP_POINTER, 396), // int(*)(struct ncplane *, char const *, ...)
/* 1648 */ _CFFI_OP(_CFFI_OP_POINTER, 435), // int(*)(struct ncplane *, int, int, char const *, ...)
/* 1649 */ _CFFI_OP(_CFFI_OP_POINTER, 572), // int(*)(struct ncplane *, int, ncalign_e, char const *, ...)
/* 1650 */ _CFFI_OP(_CFFI_OP_POINTER, 773), // int(*)(struct ncplane *, void *, int)
/* 1651 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23), // int64_t
/* 1652 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // nccapabilities
/* 1653 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // nccell
/* 1654 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 43), // ncdirectf
/* 1655 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // ncdirectv
/* 1656 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // ncfdplane_options
/* 1657 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // ncinput
/* 1658 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // ncintype_e
/* 1659 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // ncloglevel_e
/* 1660 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // ncmenu_options
/* 1661 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // ncmultiselector_options
/* 1662 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // ncpalette
/* 1663 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // ncpixelimpl_e
/* 1664 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // ncplane_options
/* 1665 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // ncplot_options
/* 1666 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // ncprogbar_options
/* 1667 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // ncreader_options
/* 1668 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // ncreel_options
/* 1669 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 30), // ncselector_options
/* 1670 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 31), // ncstats
/* 1671 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 33), // ncsubproc_options
/* 1672 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 36), // nctabbed_options
/* 1673 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 40), // nctree_options
/* 1674 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 42), // ncvgeom
/* 1675 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 46), // notcurses_options
/* 1676 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // sigset_t
/* 1677 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct ncdirect
/* 1678 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct ncdplot
/* 1679 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct ncfadectx
/* 1680 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct ncfdplane
/* 1681 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct ncmenu
/* 1682 */ _CFFI_OP(_CFFI_OP_POINTER, 1683), // struct ncmenu_item *
/* 1683 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct ncmenu_item
/* 1684 */ _CFFI_OP(_CFFI_OP_POINTER, 1685), // struct ncmenu_section *
/* 1685 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct ncmenu_section
/* 1686 */ _CFFI_OP(_CFFI_OP_POINTER, 1687), // struct ncmselector_item const *
/* 1687 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct ncmselector_item
/* 1688 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct ncmultiselector
/* 1689 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // struct ncprogbar
/* 1690 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // struct ncreader
/* 1691 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // struct ncreel
/* 1692 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 28), // struct ncselector
/* 1693 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 29), // struct ncselector_item
/* 1694 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 32), // struct ncsubproc
/* 1695 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 34), // struct nctab
/* 1696 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 35), // struct nctabbed
/* 1697 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 37), // struct nctablet
/* 1698 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 38), // struct nctree
/* 1699 */ _CFFI_OP(_CFFI_OP_POINTER, 1700), // struct nctree_item *
/* 1700 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 39), // struct nctree_item
/* 1701 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 41), // struct ncuplot
/* 1702 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 44), // struct ncvisual_options
/* 1703 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 45), // struct notcurses
/* 1704 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 47), // struct timespec
/* 1705 */ _CFFI_OP(_CFFI_OP_ARRAY, 62), // uint32_t[256]
/* 1706 */ (_cffi_opcode_t)(256),
/* 1707 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 1708 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 1709 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_NCALIGN_UNALIGNED(unsigned long long *o)
{
  int n = (NCALIGN_UNALIGNED) <= 0;
  *o = (unsigned long long)((NCALIGN_UNALIGNED) | 0);  /* check that NCALIGN_UNALIGNED is an integer */
  return n;
}

static int _cffi_const_NCALIGN_LEFT(unsigned long long *o)
{
  int n = (NCALIGN_LEFT) <= 0;
  *o = (unsigned long long)((NCALIGN_LEFT) | 0);  /* check that NCALIGN_LEFT is an integer */
  return n;
}

static int _cffi_const_NCALIGN_CENTER(unsigned long long *o)
{
  int n = (NCALIGN_CENTER) <= 0;
  *o = (unsigned long long)((NCALIGN_CENTER) | 0);  /* check that NCALIGN_CENTER is an integer */
  return n;
}

static int _cffi_const_NCALIGN_RIGHT(unsigned long long *o)
{
  int n = (NCALIGN_RIGHT) <= 0;
  *o = (unsigned long long)((NCALIGN_RIGHT) | 0);  /* check that NCALIGN_RIGHT is an integer */
  return n;
}

static int _cffi_const_NCBLIT_DEFAULT(unsigned long long *o)
{
  int n = (NCBLIT_DEFAULT) <= 0;
  *o = (unsigned long long)((NCBLIT_DEFAULT) | 0);  /* check that NCBLIT_DEFAULT is an integer */
  return n;
}

static int _cffi_const_NCBLIT_1x1(unsigned long long *o)
{
  int n = (NCBLIT_1x1) <= 0;
  *o = (unsigned long long)((NCBLIT_1x1) | 0);  /* check that NCBLIT_1x1 is an integer */
  return n;
}

static int _cffi_const_NCBLIT_2x1(unsigned long long *o)
{
  int n = (NCBLIT_2x1) <= 0;
  *o = (unsigned long long)((NCBLIT_2x1) | 0);  /* check that NCBLIT_2x1 is an integer */
  return n;
}

static int _cffi_const_NCBLIT_2x2(unsigned long long *o)
{
  int n = (NCBLIT_2x2) <= 0;
  *o = (unsigned long long)((NCBLIT_2x2) | 0);  /* check that NCBLIT_2x2 is an integer */
  return n;
}

static int _cffi_const_NCBLIT_3x2(unsigned long long *o)
{
  int n = (NCBLIT_3x2) <= 0;
  *o = (unsigned long long)((NCBLIT_3x2) | 0);  /* check that NCBLIT_3x2 is an integer */
  return n;
}

static int _cffi_const_NCBLIT_BRAILLE(unsigned long long *o)
{
  int n = (NCBLIT_BRAILLE) <= 0;
  *o = (unsigned long long)((NCBLIT_BRAILLE) | 0);  /* check that NCBLIT_BRAILLE is an integer */
  return n;
}

static int _cffi_const_NCBLIT_PIXEL(unsigned long long *o)
{
  int n = (NCBLIT_PIXEL) <= 0;
  *o = (unsigned long long)((NCBLIT_PIXEL) | 0);  /* check that NCBLIT_PIXEL is an integer */
  return n;
}

static int _cffi_const_NCBLIT_4x1(unsigned long long *o)
{
  int n = (NCBLIT_4x1) <= 0;
  *o = (unsigned long long)((NCBLIT_4x1) | 0);  /* check that NCBLIT_4x1 is an integer */
  return n;
}

static int _cffi_const_NCBLIT_8x1(unsigned long long *o)
{
  int n = (NCBLIT_8x1) <= 0;
  *o = (unsigned long long)((NCBLIT_8x1) | 0);  /* check that NCBLIT_8x1 is an integer */
  return n;
}

static int _cffi_const_NCTYPE_UNKNOWN(unsigned long long *o)
{
  int n = (NCTYPE_UNKNOWN) <= 0;
  *o = (unsigned long long)((NCTYPE_UNKNOWN) | 0);  /* check that NCTYPE_UNKNOWN is an integer */
  return n;
}

static int _cffi_const_NCTYPE_PRESS(unsigned long long *o)
{
  int n = (NCTYPE_PRESS) <= 0;
  *o = (unsigned long long)((NCTYPE_PRESS) | 0);  /* check that NCTYPE_PRESS is an integer */
  return n;
}

static int _cffi_const_NCTYPE_REPEAT(unsigned long long *o)
{
  int n = (NCTYPE_REPEAT) <= 0;
  *o = (unsigned long long)((NCTYPE_REPEAT) | 0);  /* check that NCTYPE_REPEAT is an integer */
  return n;
}

static int _cffi_const_NCTYPE_RELEASE(unsigned long long *o)
{
  int n = (NCTYPE_RELEASE) <= 0;
  *o = (unsigned long long)((NCTYPE_RELEASE) | 0);  /* check that NCTYPE_RELEASE is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_SILENT(unsigned long long *o)
{
  int n = (NCLOGLEVEL_SILENT) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_SILENT) | 0);  /* check that NCLOGLEVEL_SILENT is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_PANIC(unsigned long long *o)
{
  int n = (NCLOGLEVEL_PANIC) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_PANIC) | 0);  /* check that NCLOGLEVEL_PANIC is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_FATAL(unsigned long long *o)
{
  int n = (NCLOGLEVEL_FATAL) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_FATAL) | 0);  /* check that NCLOGLEVEL_FATAL is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_ERROR(unsigned long long *o)
{
  int n = (NCLOGLEVEL_ERROR) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_ERROR) | 0);  /* check that NCLOGLEVEL_ERROR is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_WARNING(unsigned long long *o)
{
  int n = (NCLOGLEVEL_WARNING) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_WARNING) | 0);  /* check that NCLOGLEVEL_WARNING is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_INFO(unsigned long long *o)
{
  int n = (NCLOGLEVEL_INFO) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_INFO) | 0);  /* check that NCLOGLEVEL_INFO is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_VERBOSE(unsigned long long *o)
{
  int n = (NCLOGLEVEL_VERBOSE) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_VERBOSE) | 0);  /* check that NCLOGLEVEL_VERBOSE is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_DEBUG(unsigned long long *o)
{
  int n = (NCLOGLEVEL_DEBUG) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_DEBUG) | 0);  /* check that NCLOGLEVEL_DEBUG is an integer */
  return n;
}

static int _cffi_const_NCLOGLEVEL_TRACE(unsigned long long *o)
{
  int n = (NCLOGLEVEL_TRACE) <= 0;
  *o = (unsigned long long)((NCLOGLEVEL_TRACE) | 0);  /* check that NCLOGLEVEL_TRACE is an integer */
  return n;
}

static int _cffi_const_NCPIXEL_NONE(unsigned long long *o)
{
  int n = (NCPIXEL_NONE) <= 0;
  *o = (unsigned long long)((NCPIXEL_NONE) | 0);  /* check that NCPIXEL_NONE is an integer */
  return n;
}

static int _cffi_const_NCPIXEL_SIXEL(unsigned long long *o)
{
  int n = (NCPIXEL_SIXEL) <= 0;
  *o = (unsigned long long)((NCPIXEL_SIXEL) | 0);  /* check that NCPIXEL_SIXEL is an integer */
  return n;
}

static int _cffi_const_NCPIXEL_LINUXFB(unsigned long long *o)
{
  int n = (NCPIXEL_LINUXFB) <= 0;
  *o = (unsigned long long)((NCPIXEL_LINUXFB) | 0);  /* check that NCPIXEL_LINUXFB is an integer */
  return n;
}

static int _cffi_const_NCPIXEL_ITERM2(unsigned long long *o)
{
  int n = (NCPIXEL_ITERM2) <= 0;
  *o = (unsigned long long)((NCPIXEL_ITERM2) | 0);  /* check that NCPIXEL_ITERM2 is an integer */
  return n;
}

static int _cffi_const_NCPIXEL_KITTY_STATIC(unsigned long long *o)
{
  int n = (NCPIXEL_KITTY_STATIC) <= 0;
  *o = (unsigned long long)((NCPIXEL_KITTY_STATIC) | 0);  /* check that NCPIXEL_KITTY_STATIC is an integer */
  return n;
}

static int _cffi_const_NCPIXEL_KITTY_ANIMATED(unsigned long long *o)
{
  int n = (NCPIXEL_KITTY_ANIMATED) <= 0;
  *o = (unsigned long long)((NCPIXEL_KITTY_ANIMATED) | 0);  /* check that NCPIXEL_KITTY_ANIMATED is an integer */
  return n;
}

static int _cffi_const_NCPIXEL_KITTY_SELFREF(unsigned long long *o)
{
  int n = (NCPIXEL_KITTY_SELFREF) <= 0;
  *o = (unsigned long long)((NCPIXEL_KITTY_SELFREF) | 0);  /* check that NCPIXEL_KITTY_SELFREF is an integer */
  return n;
}

static int _cffi_const_NCSCALE_NONE(unsigned long long *o)
{
  int n = (NCSCALE_NONE) <= 0;
  *o = (unsigned long long)((NCSCALE_NONE) | 0);  /* check that NCSCALE_NONE is an integer */
  return n;
}

static int _cffi_const_NCSCALE_SCALE(unsigned long long *o)
{
  int n = (NCSCALE_SCALE) <= 0;
  *o = (unsigned long long)((NCSCALE_SCALE) | 0);  /* check that NCSCALE_SCALE is an integer */
  return n;
}

static int _cffi_const_NCSCALE_STRETCH(unsigned long long *o)
{
  int n = (NCSCALE_STRETCH) <= 0;
  *o = (unsigned long long)((NCSCALE_STRETCH) | 0);  /* check that NCSCALE_STRETCH is an integer */
  return n;
}

static int _cffi_const_NCSCALE_NONE_HIRES(unsigned long long *o)
{
  int n = (NCSCALE_NONE_HIRES) <= 0;
  *o = (unsigned long long)((NCSCALE_NONE_HIRES) | 0);  /* check that NCSCALE_NONE_HIRES is an integer */
  return n;
}

static int _cffi_const_NCSCALE_SCALE_HIRES(unsigned long long *o)
{
  int n = (NCSCALE_SCALE_HIRES) <= 0;
  *o = (unsigned long long)((NCSCALE_SCALE_HIRES) | 0);  /* check that NCSCALE_SCALE_HIRES is an integer */
  return n;
}

static int _cffi_d_ncblit_bgrx(void const * x0, int x1, struct ncvisual_options const * x2)
{
  return ncblit_bgrx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncblit_bgrx(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  struct ncvisual_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncblit_bgrx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncblit_bgrx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncblit_bgrx _cffi_d_ncblit_bgrx
#endif

static int _cffi_d_ncblit_rgb_loose(void const * x0, int x1, struct ncvisual_options const * x2, int x3)
{
  return ncblit_rgb_loose(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncblit_rgb_loose(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  struct ncvisual_options const * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncblit_rgb_loose", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncblit_rgb_loose(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncblit_rgb_loose _cffi_d_ncblit_rgb_loose
#endif

static int _cffi_d_ncblit_rgb_packed(void const * x0, int x1, struct ncvisual_options const * x2, int x3)
{
  return ncblit_rgb_packed(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncblit_rgb_packed(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  struct ncvisual_options const * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncblit_rgb_packed", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncblit_rgb_packed(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncblit_rgb_packed _cffi_d_ncblit_rgb_packed
#endif

static int _cffi_d_ncblit_rgba(void const * x0, int x1, struct ncvisual_options const * x2)
{
  return ncblit_rgba(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncblit_rgba(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  struct ncvisual_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncblit_rgba", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncblit_rgba(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncblit_rgba _cffi_d_ncblit_rgba
#endif

static char const * _cffi_d_ncbprefix(uintmax_t x0, uintmax_t x1, char * x2, int x3)
{
  return ncbprefix(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncbprefix(PyObject *self, PyObject *args)
{
  uintmax_t x0;
  uintmax_t x1;
  char * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncbprefix", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uintmax_t);
  if (x0 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uintmax_t);
  if (x1 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncbprefix(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncbprefix _cffi_d_ncbprefix
#endif

static _Bool _cffi_d_nccapability_canchangecolor(nccapabilities const * x0)
{
  return nccapability_canchangecolor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccapability_canchangecolor(PyObject *self, PyObject *arg0)
{
  nccapabilities const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccapabilities const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccapability_canchangecolor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccapability_canchangecolor _cffi_d_nccapability_canchangecolor
#endif

static uint32_t _cffi_d_nccell_bchannel(nccell const * x0)
{
  return nccell_bchannel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_bchannel(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_bchannel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_bchannel _cffi_d_nccell_bchannel
#endif

static uint32_t _cffi_d_nccell_bg_alpha(nccell const * x0)
{
  return nccell_bg_alpha(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_bg_alpha(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_bg_alpha(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_bg_alpha _cffi_d_nccell_bg_alpha
#endif

static _Bool _cffi_d_nccell_bg_default_p(nccell const * x0)
{
  return nccell_bg_default_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_bg_default_p(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_bg_default_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_bg_default_p _cffi_d_nccell_bg_default_p
#endif

static uint32_t _cffi_d_nccell_bg_palindex(nccell const * x0)
{
  return nccell_bg_palindex(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_bg_palindex(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_bg_palindex(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_bg_palindex _cffi_d_nccell_bg_palindex
#endif

static _Bool _cffi_d_nccell_bg_palindex_p(nccell const * x0)
{
  return nccell_bg_palindex_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_bg_palindex_p(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_bg_palindex_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_bg_palindex_p _cffi_d_nccell_bg_palindex_p
#endif

static uint32_t _cffi_d_nccell_bg_rgb(nccell const * x0)
{
  return nccell_bg_rgb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_bg_rgb(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_bg_rgb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_bg_rgb _cffi_d_nccell_bg_rgb
#endif

static uint32_t _cffi_d_nccell_bg_rgb8(nccell const * x0, unsigned int * x1, unsigned int * x2, unsigned int * x3)
{
  return nccell_bg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_bg_rgb8(PyObject *self, PyObject *args)
{
  nccell const * x0;
  unsigned int * x1;
  unsigned int * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nccell_bg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_bg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_bg_rgb8 _cffi_d_nccell_bg_rgb8
#endif

static uint64_t _cffi_d_nccell_channels(nccell const * x0)
{
  return nccell_channels(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_channels(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_channels(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_channels _cffi_d_nccell_channels
#endif

static unsigned int _cffi_d_nccell_cols(nccell const * x0)
{
  return nccell_cols(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_cols(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_cols(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_cols _cffi_d_nccell_cols
#endif

static _Bool _cffi_d_nccell_double_wide_p(nccell const * x0)
{
  return nccell_double_wide_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_double_wide_p(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_double_wide_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_double_wide_p _cffi_d_nccell_double_wide_p
#endif

static int _cffi_d_nccell_duplicate(struct ncplane * x0, nccell * x1, nccell const * x2)
{
  return nccell_duplicate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_duplicate(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  nccell const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "nccell_duplicate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_duplicate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_duplicate _cffi_d_nccell_duplicate
#endif

static char const * _cffi_d_nccell_extended_gcluster(struct ncplane const * x0, nccell const * x1)
{
  return nccell_extended_gcluster(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_extended_gcluster(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  nccell const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_extended_gcluster", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_extended_gcluster(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_extended_gcluster _cffi_d_nccell_extended_gcluster
#endif

static char * _cffi_d_nccell_extract(struct ncplane const * x0, nccell const * x1, uint16_t * x2, uint64_t * x3)
{
  return nccell_extract(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_extract(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  nccell const * x1;
  uint16_t * x2;
  uint64_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nccell_extract", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint16_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(88), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_extract(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_extract _cffi_d_nccell_extract
#endif

static uint32_t _cffi_d_nccell_fchannel(nccell const * x0)
{
  return nccell_fchannel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_fchannel(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_fchannel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_fchannel _cffi_d_nccell_fchannel
#endif

static uint32_t _cffi_d_nccell_fg_alpha(nccell const * x0)
{
  return nccell_fg_alpha(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_fg_alpha(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_fg_alpha(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_fg_alpha _cffi_d_nccell_fg_alpha
#endif

static _Bool _cffi_d_nccell_fg_default_p(nccell const * x0)
{
  return nccell_fg_default_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_fg_default_p(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_fg_default_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_fg_default_p _cffi_d_nccell_fg_default_p
#endif

static uint32_t _cffi_d_nccell_fg_palindex(nccell const * x0)
{
  return nccell_fg_palindex(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_fg_palindex(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_fg_palindex(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_fg_palindex _cffi_d_nccell_fg_palindex
#endif

static _Bool _cffi_d_nccell_fg_palindex_p(nccell const * x0)
{
  return nccell_fg_palindex_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_fg_palindex_p(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_fg_palindex_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_fg_palindex_p _cffi_d_nccell_fg_palindex_p
#endif

static uint32_t _cffi_d_nccell_fg_rgb(nccell const * x0)
{
  return nccell_fg_rgb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_fg_rgb(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_fg_rgb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_fg_rgb _cffi_d_nccell_fg_rgb
#endif

static uint32_t _cffi_d_nccell_fg_rgb8(nccell const * x0, unsigned int * x1, unsigned int * x2, unsigned int * x3)
{
  return nccell_fg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_fg_rgb8(PyObject *self, PyObject *args)
{
  nccell const * x0;
  unsigned int * x1;
  unsigned int * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nccell_fg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_fg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_fg_rgb8 _cffi_d_nccell_fg_rgb8
#endif

static void _cffi_d_nccell_init(nccell * x0)
{
  nccell_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_init(PyObject *self, PyObject *arg0)
{
  nccell * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_init _cffi_d_nccell_init
#endif

static int _cffi_d_nccell_load(struct ncplane * x0, nccell * x1, char const * x2)
{
  return nccell_load(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_load(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "nccell_load", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_load(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_load _cffi_d_nccell_load
#endif

static int _cffi_d_nccell_load_char(struct ncplane * x0, nccell * x1, char x2)
{
  return nccell_load_char(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_load_char(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  char x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "nccell_load_char", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (char)_cffi_to_c_char(arg2);
  if (x2 == (char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_load_char(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_load_char _cffi_d_nccell_load_char
#endif

static int _cffi_d_nccell_load_egc32(struct ncplane * x0, nccell * x1, uint32_t x2)
{
  return nccell_load_egc32(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_load_egc32(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "nccell_load_egc32", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_load_egc32(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_load_egc32 _cffi_d_nccell_load_egc32
#endif

static int _cffi_d_nccell_load_ucs32(struct ncplane * x0, nccell * x1, uint32_t x2)
{
  return nccell_load_ucs32(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_load_ucs32(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "nccell_load_ucs32", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_load_ucs32(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_load_ucs32 _cffi_d_nccell_load_ucs32
#endif

static void _cffi_d_nccell_off_styles(nccell * x0, unsigned int x1)
{
  nccell_off_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_off_styles(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_off_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_off_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_off_styles _cffi_d_nccell_off_styles
#endif

static void _cffi_d_nccell_on_styles(nccell * x0, unsigned int x1)
{
  nccell_on_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_on_styles(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_on_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_on_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_on_styles _cffi_d_nccell_on_styles
#endif

static int _cffi_d_nccell_prime(struct ncplane * x0, nccell * x1, char const * x2, uint16_t x3, uint64_t x4)
{
  return nccell_prime(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_prime(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  char const * x2;
  uint16_t x3;
  uint64_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "nccell_prime", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, uint16_t);
  if (x3 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_prime(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_prime _cffi_d_nccell_prime
#endif

static void _cffi_d_nccell_release(struct ncplane * x0, nccell * x1)
{
  nccell_release(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_release(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_release", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_release(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_release _cffi_d_nccell_release
#endif

static uint64_t _cffi_d_nccell_set_bchannel(nccell * x0, uint32_t x1)
{
  return nccell_set_bchannel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_bchannel(PyObject *self, PyObject *args)
{
  nccell * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_bchannel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_bchannel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_bchannel _cffi_d_nccell_set_bchannel
#endif

static int _cffi_d_nccell_set_bg_alpha(nccell * x0, unsigned int x1)
{
  return nccell_set_bg_alpha(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_bg_alpha(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_bg_alpha", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_bg_alpha(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_bg_alpha _cffi_d_nccell_set_bg_alpha
#endif

static void _cffi_d_nccell_set_bg_default(nccell * x0)
{
  nccell_set_bg_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_bg_default(PyObject *self, PyObject *arg0)
{
  nccell * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_set_bg_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_set_bg_default _cffi_d_nccell_set_bg_default
#endif

static int _cffi_d_nccell_set_bg_palindex(nccell * x0, unsigned int x1)
{
  return nccell_set_bg_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_bg_palindex(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_bg_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_bg_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_bg_palindex _cffi_d_nccell_set_bg_palindex
#endif

static int _cffi_d_nccell_set_bg_rgb(nccell * x0, uint32_t x1)
{
  return nccell_set_bg_rgb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_bg_rgb(PyObject *self, PyObject *args)
{
  nccell * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_bg_rgb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_bg_rgb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_bg_rgb _cffi_d_nccell_set_bg_rgb
#endif

static int _cffi_d_nccell_set_bg_rgb8(nccell * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return nccell_set_bg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_bg_rgb8(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nccell_set_bg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_bg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_bg_rgb8 _cffi_d_nccell_set_bg_rgb8
#endif

static void _cffi_d_nccell_set_bg_rgb8_clipped(nccell * x0, int x1, int x2, int x3)
{
  nccell_set_bg_rgb8_clipped(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_bg_rgb8_clipped(PyObject *self, PyObject *args)
{
  nccell * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nccell_set_bg_rgb8_clipped", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_set_bg_rgb8_clipped(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_set_bg_rgb8_clipped _cffi_d_nccell_set_bg_rgb8_clipped
#endif

static uint64_t _cffi_d_nccell_set_channels(nccell * x0, uint64_t x1)
{
  return nccell_set_channels(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_channels(PyObject *self, PyObject *args)
{
  nccell * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_channels", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_channels(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_channels _cffi_d_nccell_set_channels
#endif

static uint64_t _cffi_d_nccell_set_fchannel(nccell * x0, uint32_t x1)
{
  return nccell_set_fchannel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_fchannel(PyObject *self, PyObject *args)
{
  nccell * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_fchannel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_fchannel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_fchannel _cffi_d_nccell_set_fchannel
#endif

static int _cffi_d_nccell_set_fg_alpha(nccell * x0, unsigned int x1)
{
  return nccell_set_fg_alpha(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_fg_alpha(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_fg_alpha", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_fg_alpha(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_fg_alpha _cffi_d_nccell_set_fg_alpha
#endif

static void _cffi_d_nccell_set_fg_default(nccell * x0)
{
  nccell_set_fg_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_fg_default(PyObject *self, PyObject *arg0)
{
  nccell * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_set_fg_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_set_fg_default _cffi_d_nccell_set_fg_default
#endif

static int _cffi_d_nccell_set_fg_palindex(nccell * x0, unsigned int x1)
{
  return nccell_set_fg_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_fg_palindex(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_fg_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_fg_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_fg_palindex _cffi_d_nccell_set_fg_palindex
#endif

static int _cffi_d_nccell_set_fg_rgb(nccell * x0, uint32_t x1)
{
  return nccell_set_fg_rgb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_fg_rgb(PyObject *self, PyObject *args)
{
  nccell * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_fg_rgb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_fg_rgb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_fg_rgb _cffi_d_nccell_set_fg_rgb
#endif

static int _cffi_d_nccell_set_fg_rgb8(nccell * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return nccell_set_fg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_fg_rgb8(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nccell_set_fg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_set_fg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_set_fg_rgb8 _cffi_d_nccell_set_fg_rgb8
#endif

static void _cffi_d_nccell_set_fg_rgb8_clipped(nccell * x0, int x1, int x2, int x3)
{
  nccell_set_fg_rgb8_clipped(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_fg_rgb8_clipped(PyObject *self, PyObject *args)
{
  nccell * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nccell_set_fg_rgb8_clipped", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_set_fg_rgb8_clipped(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_set_fg_rgb8_clipped _cffi_d_nccell_set_fg_rgb8_clipped
#endif

static void _cffi_d_nccell_set_styles(nccell * x0, unsigned int x1)
{
  nccell_set_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_set_styles(PyObject *self, PyObject *args)
{
  nccell * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_set_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nccell_set_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nccell_set_styles _cffi_d_nccell_set_styles
#endif

static char * _cffi_d_nccell_strdup(struct ncplane const * x0, nccell const * x1)
{
  return nccell_strdup(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_strdup(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  nccell const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nccell_strdup", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_strdup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_strdup _cffi_d_nccell_strdup
#endif

static uint16_t _cffi_d_nccell_styles(nccell const * x0)
{
  return nccell_styles(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_styles(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint16_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_styles(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint16_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_styles _cffi_d_nccell_styles
#endif

static _Bool _cffi_d_nccell_wide_left_p(nccell const * x0)
{
  return nccell_wide_left_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_wide_left_p(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_wide_left_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_wide_left_p _cffi_d_nccell_wide_left_p
#endif

static _Bool _cffi_d_nccell_wide_right_p(nccell const * x0)
{
  return nccell_wide_right_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccell_wide_right_p(PyObject *self, PyObject *arg0)
{
  nccell const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccell_wide_right_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccell_wide_right_p _cffi_d_nccell_wide_right_p
#endif

static _Bool _cffi_d_nccellcmp(struct ncplane const * x0, nccell const * x1, struct ncplane const * x2, nccell const * x3)
{
  return nccellcmp(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccellcmp(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  nccell const * x1;
  struct ncplane const * x2;
  nccell const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nccellcmp", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccellcmp(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccellcmp _cffi_d_nccellcmp
#endif

static int _cffi_d_nccells_ascii_box(struct ncplane * x0, uint16_t x1, uint64_t x2, nccell * x3, nccell * x4, nccell * x5, nccell * x6, nccell * x7, nccell * x8)
{
  return nccells_ascii_box(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccells_ascii_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  nccell * x3;
  nccell * x4;
  nccell * x5;
  nccell * x6;
  nccell * x7;
  nccell * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "nccells_ascii_box", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccells_ascii_box(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccells_ascii_box _cffi_d_nccells_ascii_box
#endif

static int _cffi_d_nccells_double_box(struct ncplane * x0, uint16_t x1, uint64_t x2, nccell * x3, nccell * x4, nccell * x5, nccell * x6, nccell * x7, nccell * x8)
{
  return nccells_double_box(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccells_double_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  nccell * x3;
  nccell * x4;
  nccell * x5;
  nccell * x6;
  nccell * x7;
  nccell * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "nccells_double_box", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccells_double_box(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccells_double_box _cffi_d_nccells_double_box
#endif

static int _cffi_d_nccells_heavy_box(struct ncplane * x0, uint16_t x1, uint64_t x2, nccell * x3, nccell * x4, nccell * x5, nccell * x6, nccell * x7, nccell * x8)
{
  return nccells_heavy_box(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccells_heavy_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  nccell * x3;
  nccell * x4;
  nccell * x5;
  nccell * x6;
  nccell * x7;
  nccell * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "nccells_heavy_box", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccells_heavy_box(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccells_heavy_box _cffi_d_nccells_heavy_box
#endif

static int _cffi_d_nccells_light_box(struct ncplane * x0, uint16_t x1, uint64_t x2, nccell * x3, nccell * x4, nccell * x5, nccell * x6, nccell * x7, nccell * x8)
{
  return nccells_light_box(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccells_light_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  nccell * x3;
  nccell * x4;
  nccell * x5;
  nccell * x6;
  nccell * x7;
  nccell * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "nccells_light_box", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccells_light_box(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccells_light_box _cffi_d_nccells_light_box
#endif

static int _cffi_d_nccells_load_box(struct ncplane * x0, uint16_t x1, uint64_t x2, nccell * x3, nccell * x4, nccell * x5, nccell * x6, nccell * x7, nccell * x8, char const * x9)
{
  return nccells_load_box(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccells_load_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  nccell * x3;
  nccell * x4;
  nccell * x5;
  nccell * x6;
  nccell * x7;
  nccell * x8;
  char const * x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "nccells_load_box", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccells_load_box(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccells_load_box _cffi_d_nccells_load_box
#endif

static int _cffi_d_nccells_rounded_box(struct ncplane * x0, uint16_t x1, uint64_t x2, nccell * x3, nccell * x4, nccell * x5, nccell * x6, nccell * x7, nccell * x8)
{
  return nccells_rounded_box(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nccells_rounded_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  nccell * x3;
  nccell * x4;
  nccell * x5;
  nccell * x6;
  nccell * x7;
  nccell * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "nccells_rounded_box", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nccells_rounded_box(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nccells_rounded_box _cffi_d_nccells_rounded_box
#endif

static unsigned int _cffi_d_ncchannel_alpha(uint32_t x0)
{
  return ncchannel_alpha(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_alpha(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_alpha(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_alpha _cffi_d_ncchannel_alpha
#endif

static unsigned int _cffi_d_ncchannel_b(uint32_t x0)
{
  return ncchannel_b(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_b(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_b(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_b _cffi_d_ncchannel_b
#endif

static _Bool _cffi_d_ncchannel_default_p(uint32_t x0)
{
  return ncchannel_default_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_default_p(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_default_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_default_p _cffi_d_ncchannel_default_p
#endif

static unsigned int _cffi_d_ncchannel_g(uint32_t x0)
{
  return ncchannel_g(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_g(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_g(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_g _cffi_d_ncchannel_g
#endif

static unsigned int _cffi_d_ncchannel_palindex(uint32_t x0)
{
  return ncchannel_palindex(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_palindex(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_palindex(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_palindex _cffi_d_ncchannel_palindex
#endif

static _Bool _cffi_d_ncchannel_palindex_p(uint32_t x0)
{
  return ncchannel_palindex_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_palindex_p(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_palindex_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_palindex_p _cffi_d_ncchannel_palindex_p
#endif

static unsigned int _cffi_d_ncchannel_r(uint32_t x0)
{
  return ncchannel_r(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_r(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_r(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_r _cffi_d_ncchannel_r
#endif

static uint32_t _cffi_d_ncchannel_rgb(uint32_t x0)
{
  return ncchannel_rgb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_rgb(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_rgb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_rgb _cffi_d_ncchannel_rgb
#endif

static uint32_t _cffi_d_ncchannel_rgb8(uint32_t x0, unsigned int * x1, unsigned int * x2, unsigned int * x3)
{
  return ncchannel_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_rgb8(PyObject *self, PyObject *args)
{
  uint32_t x0;
  unsigned int * x1;
  unsigned int * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannel_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_rgb8 _cffi_d_ncchannel_rgb8
#endif

static _Bool _cffi_d_ncchannel_rgb_p(uint32_t x0)
{
  return ncchannel_rgb_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_rgb_p(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_rgb_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_rgb_p _cffi_d_ncchannel_rgb_p
#endif

static int _cffi_d_ncchannel_set(uint32_t * x0, uint32_t x1)
{
  return ncchannel_set(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_set(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannel_set", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_set _cffi_d_ncchannel_set
#endif

static int _cffi_d_ncchannel_set_alpha(uint32_t * x0, unsigned int x1)
{
  return ncchannel_set_alpha(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_set_alpha(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannel_set_alpha", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_set_alpha(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_set_alpha _cffi_d_ncchannel_set_alpha
#endif

static uint32_t _cffi_d_ncchannel_set_default(uint32_t * x0)
{
  return ncchannel_set_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_set_default(PyObject *self, PyObject *arg0)
{
  uint32_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_set_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_set_default _cffi_d_ncchannel_set_default
#endif

static int _cffi_d_ncchannel_set_palindex(uint32_t * x0, unsigned int x1)
{
  return ncchannel_set_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_set_palindex(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannel_set_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_set_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_set_palindex _cffi_d_ncchannel_set_palindex
#endif

static int _cffi_d_ncchannel_set_rgb8(uint32_t * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return ncchannel_set_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_set_rgb8(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannel_set_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannel_set_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannel_set_rgb8 _cffi_d_ncchannel_set_rgb8
#endif

static void _cffi_d_ncchannel_set_rgb8_clipped(uint32_t * x0, int x1, int x2, int x3)
{
  ncchannel_set_rgb8_clipped(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannel_set_rgb8_clipped(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannel_set_rgb8_clipped", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncchannel_set_rgb8_clipped(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncchannel_set_rgb8_clipped _cffi_d_ncchannel_set_rgb8_clipped
#endif

static uint32_t _cffi_d_ncchannels_bchannel(uint64_t x0)
{
  return ncchannels_bchannel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_bchannel(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_bchannel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_bchannel _cffi_d_ncchannels_bchannel
#endif

static unsigned int _cffi_d_ncchannels_bg_alpha(uint64_t x0)
{
  return ncchannels_bg_alpha(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_bg_alpha(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_bg_alpha(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_bg_alpha _cffi_d_ncchannels_bg_alpha
#endif

static _Bool _cffi_d_ncchannels_bg_default_p(uint64_t x0)
{
  return ncchannels_bg_default_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_bg_default_p(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_bg_default_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_bg_default_p _cffi_d_ncchannels_bg_default_p
#endif

static unsigned int _cffi_d_ncchannels_bg_palindex(uint64_t x0)
{
  return ncchannels_bg_palindex(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_bg_palindex(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_bg_palindex(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_bg_palindex _cffi_d_ncchannels_bg_palindex
#endif

static _Bool _cffi_d_ncchannels_bg_palindex_p(uint64_t x0)
{
  return ncchannels_bg_palindex_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_bg_palindex_p(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_bg_palindex_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_bg_palindex_p _cffi_d_ncchannels_bg_palindex_p
#endif

static uint32_t _cffi_d_ncchannels_bg_rgb(uint64_t x0)
{
  return ncchannels_bg_rgb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_bg_rgb(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_bg_rgb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_bg_rgb _cffi_d_ncchannels_bg_rgb
#endif

static uint32_t _cffi_d_ncchannels_bg_rgb8(uint64_t x0, unsigned int * x1, unsigned int * x2, unsigned int * x3)
{
  return ncchannels_bg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_bg_rgb8(PyObject *self, PyObject *args)
{
  uint64_t x0;
  unsigned int * x1;
  unsigned int * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannels_bg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_bg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_bg_rgb8 _cffi_d_ncchannels_bg_rgb8
#endif

static _Bool _cffi_d_ncchannels_bg_rgb_p(uint64_t x0)
{
  return ncchannels_bg_rgb_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_bg_rgb_p(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_bg_rgb_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_bg_rgb_p _cffi_d_ncchannels_bg_rgb_p
#endif

static uint64_t _cffi_d_ncchannels_channels(uint64_t x0)
{
  return ncchannels_channels(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_channels(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  uint64_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_channels(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_channels _cffi_d_ncchannels_channels
#endif

static uint64_t _cffi_d_ncchannels_combine(uint32_t x0, uint32_t x1)
{
  return ncchannels_combine(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_combine(PyObject *self, PyObject *args)
{
  uint32_t x0;
  uint32_t x1;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_combine", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_combine(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_combine _cffi_d_ncchannels_combine
#endif

static uint32_t _cffi_d_ncchannels_fchannel(uint64_t x0)
{
  return ncchannels_fchannel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_fchannel(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_fchannel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_fchannel _cffi_d_ncchannels_fchannel
#endif

static unsigned int _cffi_d_ncchannels_fg_alpha(uint64_t x0)
{
  return ncchannels_fg_alpha(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_fg_alpha(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_fg_alpha(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_fg_alpha _cffi_d_ncchannels_fg_alpha
#endif

static _Bool _cffi_d_ncchannels_fg_default_p(uint64_t x0)
{
  return ncchannels_fg_default_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_fg_default_p(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_fg_default_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_fg_default_p _cffi_d_ncchannels_fg_default_p
#endif

static unsigned int _cffi_d_ncchannels_fg_palindex(uint64_t x0)
{
  return ncchannels_fg_palindex(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_fg_palindex(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_fg_palindex(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_fg_palindex _cffi_d_ncchannels_fg_palindex
#endif

static _Bool _cffi_d_ncchannels_fg_palindex_p(uint64_t x0)
{
  return ncchannels_fg_palindex_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_fg_palindex_p(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_fg_palindex_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_fg_palindex_p _cffi_d_ncchannels_fg_palindex_p
#endif

static uint32_t _cffi_d_ncchannels_fg_rgb(uint64_t x0)
{
  return ncchannels_fg_rgb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_fg_rgb(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_fg_rgb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_fg_rgb _cffi_d_ncchannels_fg_rgb
#endif

static uint32_t _cffi_d_ncchannels_fg_rgb8(uint64_t x0, unsigned int * x1, unsigned int * x2, unsigned int * x3)
{
  return ncchannels_fg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_fg_rgb8(PyObject *self, PyObject *args)
{
  uint64_t x0;
  unsigned int * x1;
  unsigned int * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannels_fg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_fg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_fg_rgb8 _cffi_d_ncchannels_fg_rgb8
#endif

static _Bool _cffi_d_ncchannels_fg_rgb_p(uint64_t x0)
{
  return ncchannels_fg_rgb_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_fg_rgb_p(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_fg_rgb_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_fg_rgb_p _cffi_d_ncchannels_fg_rgb_p
#endif

static uint64_t _cffi_d_ncchannels_reverse(uint64_t x0)
{
  return ncchannels_reverse(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_reverse(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  uint64_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_reverse(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_reverse _cffi_d_ncchannels_reverse
#endif

static uint64_t _cffi_d_ncchannels_set_bchannel(uint64_t * x0, uint32_t x1)
{
  return ncchannels_set_bchannel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_bchannel(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_bchannel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_bchannel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_bchannel _cffi_d_ncchannels_set_bchannel
#endif

static int _cffi_d_ncchannels_set_bg_alpha(uint64_t * x0, unsigned int x1)
{
  return ncchannels_set_bg_alpha(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_bg_alpha(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_bg_alpha", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_bg_alpha(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_bg_alpha _cffi_d_ncchannels_set_bg_alpha
#endif

static uint64_t _cffi_d_ncchannels_set_bg_default(uint64_t * x0)
{
  return ncchannels_set_bg_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_bg_default(PyObject *self, PyObject *arg0)
{
  uint64_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_bg_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_bg_default _cffi_d_ncchannels_set_bg_default
#endif

static int _cffi_d_ncchannels_set_bg_palindex(uint64_t * x0, unsigned int x1)
{
  return ncchannels_set_bg_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_bg_palindex(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_bg_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_bg_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_bg_palindex _cffi_d_ncchannels_set_bg_palindex
#endif

static int _cffi_d_ncchannels_set_bg_rgb(uint64_t * x0, unsigned int x1)
{
  return ncchannels_set_bg_rgb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_bg_rgb(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_bg_rgb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_bg_rgb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_bg_rgb _cffi_d_ncchannels_set_bg_rgb
#endif

static int _cffi_d_ncchannels_set_bg_rgb8(uint64_t * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return ncchannels_set_bg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_bg_rgb8(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_bg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_bg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_bg_rgb8 _cffi_d_ncchannels_set_bg_rgb8
#endif

static void _cffi_d_ncchannels_set_bg_rgb8_clipped(uint64_t * x0, int x1, int x2, int x3)
{
  ncchannels_set_bg_rgb8_clipped(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_bg_rgb8_clipped(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_bg_rgb8_clipped", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncchannels_set_bg_rgb8_clipped(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncchannels_set_bg_rgb8_clipped _cffi_d_ncchannels_set_bg_rgb8_clipped
#endif

static uint64_t _cffi_d_ncchannels_set_channels(uint64_t * x0, uint64_t x1)
{
  return ncchannels_set_channels(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_channels(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_channels", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_channels(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_channels _cffi_d_ncchannels_set_channels
#endif

static uint64_t _cffi_d_ncchannels_set_fchannel(uint64_t * x0, uint32_t x1)
{
  return ncchannels_set_fchannel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_fchannel(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_fchannel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_fchannel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_fchannel _cffi_d_ncchannels_set_fchannel
#endif

static int _cffi_d_ncchannels_set_fg_alpha(uint64_t * x0, unsigned int x1)
{
  return ncchannels_set_fg_alpha(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_fg_alpha(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_fg_alpha", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_fg_alpha(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_fg_alpha _cffi_d_ncchannels_set_fg_alpha
#endif

static uint64_t _cffi_d_ncchannels_set_fg_default(uint64_t * x0)
{
  return ncchannels_set_fg_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_fg_default(PyObject *self, PyObject *arg0)
{
  uint64_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_fg_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_fg_default _cffi_d_ncchannels_set_fg_default
#endif

static int _cffi_d_ncchannels_set_fg_palindex(uint64_t * x0, unsigned int x1)
{
  return ncchannels_set_fg_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_fg_palindex(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_fg_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_fg_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_fg_palindex _cffi_d_ncchannels_set_fg_palindex
#endif

static int _cffi_d_ncchannels_set_fg_rgb(uint64_t * x0, unsigned int x1)
{
  return ncchannels_set_fg_rgb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_fg_rgb(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_fg_rgb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_fg_rgb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_fg_rgb _cffi_d_ncchannels_set_fg_rgb
#endif

static int _cffi_d_ncchannels_set_fg_rgb8(uint64_t * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return ncchannels_set_fg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_fg_rgb8(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_fg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncchannels_set_fg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncchannels_set_fg_rgb8 _cffi_d_ncchannels_set_fg_rgb8
#endif

static void _cffi_d_ncchannels_set_fg_rgb8_clipped(uint64_t * x0, int x1, int x2, int x3)
{
  ncchannels_set_fg_rgb8_clipped(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncchannels_set_fg_rgb8_clipped(PyObject *self, PyObject *args)
{
  uint64_t * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncchannels_set_fg_rgb8_clipped", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncchannels_set_fg_rgb8_clipped(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncchannels_set_fg_rgb8_clipped _cffi_d_ncchannels_set_fg_rgb8_clipped
#endif

static int _cffi_d_ncdirect_ascii_box(struct ncdirect * x0, uint64_t x1, uint64_t x2, uint64_t x3, uint64_t x4, unsigned int x5, unsigned int x6, unsigned int x7)
{
  return ncdirect_ascii_box(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_ascii_box(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  unsigned int x5;
  unsigned int x6;
  unsigned int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ncdirect_ascii_box", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_ascii_box(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_ascii_box _cffi_d_ncdirect_ascii_box
#endif

static int _cffi_d_ncdirect_box(struct ncdirect * x0, uint64_t x1, uint64_t x2, uint64_t x3, uint64_t x4, wchar_t const * x5, unsigned int x6, unsigned int x7, unsigned int x8)
{
  return ncdirect_box(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_box(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  wchar_t const * x5;
  unsigned int x6;
  unsigned int x7;
  unsigned int x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "ncdirect_box", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, unsigned int);
  if (x8 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_box(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_box _cffi_d_ncdirect_box
#endif

static _Bool _cffi_d_ncdirect_canbraille(struct ncdirect const * x0)
{
  return ncdirect_canbraille(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canbraille(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canbraille(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canbraille _cffi_d_ncdirect_canbraille
#endif

static _Bool _cffi_d_ncdirect_canchangecolor(struct ncdirect const * x0)
{
  return ncdirect_canchangecolor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canchangecolor(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canchangecolor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canchangecolor _cffi_d_ncdirect_canchangecolor
#endif

static _Bool _cffi_d_ncdirect_canfade(struct ncdirect const * x0)
{
  return ncdirect_canfade(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canfade(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canfade(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canfade _cffi_d_ncdirect_canfade
#endif

static _Bool _cffi_d_ncdirect_canget_cursor(struct ncdirect const * x0)
{
  return ncdirect_canget_cursor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canget_cursor(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canget_cursor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canget_cursor _cffi_d_ncdirect_canget_cursor
#endif

static _Bool _cffi_d_ncdirect_canhalfblock(struct ncdirect const * x0)
{
  return ncdirect_canhalfblock(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canhalfblock(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canhalfblock(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canhalfblock _cffi_d_ncdirect_canhalfblock
#endif

static _Bool _cffi_d_ncdirect_canopen_images(struct ncdirect const * x0)
{
  return ncdirect_canopen_images(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canopen_images(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canopen_images(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canopen_images _cffi_d_ncdirect_canopen_images
#endif

static _Bool _cffi_d_ncdirect_canopen_videos(struct ncdirect const * x0)
{
  return ncdirect_canopen_videos(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canopen_videos(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canopen_videos(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canopen_videos _cffi_d_ncdirect_canopen_videos
#endif

static _Bool _cffi_d_ncdirect_canquadrant(struct ncdirect const * x0)
{
  return ncdirect_canquadrant(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canquadrant(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canquadrant(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canquadrant _cffi_d_ncdirect_canquadrant
#endif

static _Bool _cffi_d_ncdirect_cansextant(struct ncdirect const * x0)
{
  return ncdirect_cansextant(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cansextant(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cansextant(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cansextant _cffi_d_ncdirect_cansextant
#endif

static _Bool _cffi_d_ncdirect_cantruecolor(struct ncdirect const * x0)
{
  return ncdirect_cantruecolor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cantruecolor(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cantruecolor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cantruecolor _cffi_d_ncdirect_cantruecolor
#endif

static _Bool _cffi_d_ncdirect_canutf8(struct ncdirect const * x0)
{
  return ncdirect_canutf8(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_canutf8(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_canutf8(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_canutf8 _cffi_d_ncdirect_canutf8
#endif

static nccapabilities const * _cffi_d_ncdirect_capabilities(struct ncdirect const * x0)
{
  return ncdirect_capabilities(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_capabilities(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  nccapabilities const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_capabilities(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_capabilities _cffi_d_ncdirect_capabilities
#endif

static int _cffi_d_ncdirect_check_pixel_support(struct ncdirect const * x0)
{
  return ncdirect_check_pixel_support(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_check_pixel_support(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_check_pixel_support(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_check_pixel_support _cffi_d_ncdirect_check_pixel_support
#endif

static int _cffi_d_ncdirect_clear(struct ncdirect * x0)
{
  return ncdirect_clear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_clear(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_clear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_clear _cffi_d_ncdirect_clear
#endif

static struct ncdirect * _cffi_d_ncdirect_core_init(char const * x0, FILE * x1, uint64_t x2)
{
  return ncdirect_core_init(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_core_init(PyObject *self, PyObject *args)
{
  char const * x0;
  FILE * x1;
  uint64_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncdirect * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdirect_core_init", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_core_init(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(68));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_core_init _cffi_d_ncdirect_core_init
#endif

static int _cffi_d_ncdirect_cursor_disable(struct ncdirect * x0)
{
  return ncdirect_cursor_disable(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_disable(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_disable(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_disable _cffi_d_ncdirect_cursor_disable
#endif

static int _cffi_d_ncdirect_cursor_down(struct ncdirect * x0, int x1)
{
  return ncdirect_cursor_down(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_down(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_cursor_down", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_down(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_down _cffi_d_ncdirect_cursor_down
#endif

static int _cffi_d_ncdirect_cursor_enable(struct ncdirect * x0)
{
  return ncdirect_cursor_enable(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_enable(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_enable(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_enable _cffi_d_ncdirect_cursor_enable
#endif

static int _cffi_d_ncdirect_cursor_left(struct ncdirect * x0, int x1)
{
  return ncdirect_cursor_left(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_left(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_cursor_left", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_left(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_left _cffi_d_ncdirect_cursor_left
#endif

static int _cffi_d_ncdirect_cursor_move_yx(struct ncdirect * x0, int x1, int x2)
{
  return ncdirect_cursor_move_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_move_yx(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdirect_cursor_move_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_move_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_move_yx _cffi_d_ncdirect_cursor_move_yx
#endif

static int _cffi_d_ncdirect_cursor_pop(struct ncdirect * x0)
{
  return ncdirect_cursor_pop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_pop(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_pop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_pop _cffi_d_ncdirect_cursor_pop
#endif

static int _cffi_d_ncdirect_cursor_push(struct ncdirect * x0)
{
  return ncdirect_cursor_push(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_push(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_push(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_push _cffi_d_ncdirect_cursor_push
#endif

static int _cffi_d_ncdirect_cursor_right(struct ncdirect * x0, int x1)
{
  return ncdirect_cursor_right(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_right(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_cursor_right", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_right(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_right _cffi_d_ncdirect_cursor_right
#endif

static int _cffi_d_ncdirect_cursor_up(struct ncdirect * x0, int x1)
{
  return ncdirect_cursor_up(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_up(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_cursor_up", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_up(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_up _cffi_d_ncdirect_cursor_up
#endif

static int _cffi_d_ncdirect_cursor_yx(struct ncdirect * x0, unsigned int * x1, unsigned int * x2)
{
  return ncdirect_cursor_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_cursor_yx(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  unsigned int * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdirect_cursor_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_cursor_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_cursor_yx _cffi_d_ncdirect_cursor_yx
#endif

static char * _cffi_d_ncdirect_detected_terminal(struct ncdirect const * x0)
{
  return ncdirect_detected_terminal(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_detected_terminal(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_detected_terminal(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_detected_terminal _cffi_d_ncdirect_detected_terminal
#endif

static unsigned int _cffi_d_ncdirect_dim_x(struct ncdirect * x0)
{
  return ncdirect_dim_x(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_dim_x(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_dim_x(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_dim_x _cffi_d_ncdirect_dim_x
#endif

static unsigned int _cffi_d_ncdirect_dim_y(struct ncdirect * x0)
{
  return ncdirect_dim_y(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_dim_y(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_dim_y(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_dim_y _cffi_d_ncdirect_dim_y
#endif

static int _cffi_d_ncdirect_double_box(struct ncdirect * x0, uint64_t x1, uint64_t x2, uint64_t x3, uint64_t x4, unsigned int x5, unsigned int x6, unsigned int x7)
{
  return ncdirect_double_box(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_double_box(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  unsigned int x5;
  unsigned int x6;
  unsigned int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ncdirect_double_box", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_double_box(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_double_box _cffi_d_ncdirect_double_box
#endif

static int _cffi_d_ncdirect_flush(struct ncdirect const * x0)
{
  return ncdirect_flush(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_flush(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_flush(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_flush _cffi_d_ncdirect_flush
#endif

static uint32_t _cffi_d_ncdirect_get(struct ncdirect * x0, struct timespec const * x1, ncinput * x2)
{
  return ncdirect_get(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_get(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  struct timespec const * x1;
  ncinput * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdirect_get", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(706), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(706), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_get(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_get _cffi_d_ncdirect_get
#endif

static uint32_t _cffi_d_ncdirect_get_blocking(struct ncdirect * x0, ncinput * x1)
{
  return ncdirect_get_blocking(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_get_blocking(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  ncinput * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_get_blocking", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_get_blocking(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_get_blocking _cffi_d_ncdirect_get_blocking
#endif

static uint32_t _cffi_d_ncdirect_get_nblock(struct ncdirect * x0, ncinput * x1)
{
  return ncdirect_get_nblock(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_get_nblock(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  ncinput * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_get_nblock", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_get_nblock(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_get_nblock _cffi_d_ncdirect_get_nblock
#endif

static int _cffi_d_ncdirect_heavy_box(struct ncdirect * x0, uint64_t x1, uint64_t x2, uint64_t x3, uint64_t x4, unsigned int x5, unsigned int x6, unsigned int x7)
{
  return ncdirect_heavy_box(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_heavy_box(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  unsigned int x5;
  unsigned int x6;
  unsigned int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ncdirect_heavy_box", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_heavy_box(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_heavy_box _cffi_d_ncdirect_heavy_box
#endif

static int _cffi_d_ncdirect_hline_interp(struct ncdirect * x0, char const * x1, unsigned int x2, uint64_t x3, uint64_t x4)
{
  return ncdirect_hline_interp(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_hline_interp(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  char const * x1;
  unsigned int x2;
  uint64_t x3;
  uint64_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncdirect_hline_interp", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_hline_interp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_hline_interp _cffi_d_ncdirect_hline_interp
#endif

static struct ncdirect * _cffi_d_ncdirect_init(char const * x0, FILE * x1, uint64_t x2)
{
  return ncdirect_init(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_init(PyObject *self, PyObject *args)
{
  char const * x0;
  FILE * x1;
  uint64_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncdirect * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdirect_init", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_init(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(68));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_init _cffi_d_ncdirect_init
#endif

static int _cffi_d_ncdirect_inputready_fd(struct ncdirect * x0)
{
  return ncdirect_inputready_fd(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_inputready_fd(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_inputready_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_inputready_fd _cffi_d_ncdirect_inputready_fd
#endif

static int _cffi_d_ncdirect_light_box(struct ncdirect * x0, uint64_t x1, uint64_t x2, uint64_t x3, uint64_t x4, unsigned int x5, unsigned int x6, unsigned int x7)
{
  return ncdirect_light_box(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_light_box(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  unsigned int x5;
  unsigned int x6;
  unsigned int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ncdirect_light_box", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_light_box(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_light_box _cffi_d_ncdirect_light_box
#endif

static int _cffi_d_ncdirect_off_styles(struct ncdirect * x0, unsigned int x1)
{
  return ncdirect_off_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_off_styles(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_off_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_off_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_off_styles _cffi_d_ncdirect_off_styles
#endif

static int _cffi_d_ncdirect_on_styles(struct ncdirect * x0, unsigned int x1)
{
  return ncdirect_on_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_on_styles(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_on_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_on_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_on_styles _cffi_d_ncdirect_on_styles
#endif

static unsigned int _cffi_d_ncdirect_palette_size(struct ncdirect const * x0)
{
  return ncdirect_palette_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_palette_size(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_palette_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_palette_size _cffi_d_ncdirect_palette_size
#endif

static void _cffi_const_ncdirect_printf_aligned(char *o)
{
  *(int(* *)(struct ncdirect *, int, ncalign_e, char const *, ...))o = ncdirect_printf_aligned;
}

static int _cffi_d_ncdirect_putegc(struct ncdirect * x0, uint64_t x1, char const * x2, int * x3)
{
  return ncdirect_putegc(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_putegc(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  uint64_t x1;
  char const * x2;
  int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncdirect_putegc", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_putegc(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_putegc _cffi_d_ncdirect_putegc
#endif

static int _cffi_d_ncdirect_putstr(struct ncdirect * x0, uint64_t x1, char const * x2)
{
  return ncdirect_putstr(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_putstr(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  uint64_t x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdirect_putstr", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_putstr(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_putstr _cffi_d_ncdirect_putstr
#endif

static int _cffi_d_ncdirect_raster_frame(struct ncdirect * x0, ncdirectv * x1, ncalign_e x2)
{
  return ncdirect_raster_frame(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_raster_frame(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  ncdirectv * x1;
  ncalign_e x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdirect_raster_frame", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncdirectv *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(194), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_raster_frame(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_raster_frame _cffi_d_ncdirect_raster_frame
#endif

static char * _cffi_d_ncdirect_readline(struct ncdirect * x0, char const * x1)
{
  return ncdirect_readline(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_readline(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_readline", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_readline(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_readline _cffi_d_ncdirect_readline
#endif

static ncdirectv * _cffi_d_ncdirect_render_frame(struct ncdirect * x0, char const * x1, ncblitter_e x2, ncscale_e x3, int x4, int x5)
{
  return ncdirect_render_frame(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_render_frame(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  char const * x1;
  ncblitter_e x2;
  ncscale_e x3;
  int x4;
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ncdirectv * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncdirect_render_frame", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(125), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(128), arg3) < 0)
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_render_frame(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_render_frame _cffi_d_ncdirect_render_frame
#endif

static int _cffi_d_ncdirect_render_image(struct ncdirect * x0, char const * x1, ncalign_e x2, ncblitter_e x3, ncscale_e x4)
{
  return ncdirect_render_image(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_render_image(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  char const * x1;
  ncalign_e x2;
  ncblitter_e x3;
  ncscale_e x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncdirect_render_image", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(194), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(125), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(128), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_render_image(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_render_image _cffi_d_ncdirect_render_image
#endif

static int _cffi_d_ncdirect_rounded_box(struct ncdirect * x0, uint64_t x1, uint64_t x2, uint64_t x3, uint64_t x4, unsigned int x5, unsigned int x6, unsigned int x7)
{
  return ncdirect_rounded_box(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_rounded_box(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  unsigned int x5;
  unsigned int x6;
  unsigned int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ncdirect_rounded_box", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_rounded_box(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_rounded_box _cffi_d_ncdirect_rounded_box
#endif

static int _cffi_d_ncdirect_set_bg_default(struct ncdirect * x0)
{
  return ncdirect_set_bg_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_bg_default(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_bg_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_bg_default _cffi_d_ncdirect_set_bg_default
#endif

static int _cffi_d_ncdirect_set_bg_palindex(struct ncdirect * x0, int x1)
{
  return ncdirect_set_bg_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_bg_palindex(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_set_bg_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_bg_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_bg_palindex _cffi_d_ncdirect_set_bg_palindex
#endif

static int _cffi_d_ncdirect_set_bg_rgb(struct ncdirect * x0, unsigned int x1)
{
  return ncdirect_set_bg_rgb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_bg_rgb(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_set_bg_rgb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_bg_rgb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_bg_rgb _cffi_d_ncdirect_set_bg_rgb
#endif

static int _cffi_d_ncdirect_set_bg_rgb8(struct ncdirect * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return ncdirect_set_bg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_bg_rgb8(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncdirect_set_bg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_bg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_bg_rgb8 _cffi_d_ncdirect_set_bg_rgb8
#endif

static int _cffi_d_ncdirect_set_fg_default(struct ncdirect * x0)
{
  return ncdirect_set_fg_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_fg_default(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_fg_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_fg_default _cffi_d_ncdirect_set_fg_default
#endif

static int _cffi_d_ncdirect_set_fg_palindex(struct ncdirect * x0, int x1)
{
  return ncdirect_set_fg_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_fg_palindex(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_set_fg_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_fg_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_fg_palindex _cffi_d_ncdirect_set_fg_palindex
#endif

static int _cffi_d_ncdirect_set_fg_rgb(struct ncdirect * x0, unsigned int x1)
{
  return ncdirect_set_fg_rgb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_fg_rgb(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_set_fg_rgb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_fg_rgb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_fg_rgb _cffi_d_ncdirect_set_fg_rgb
#endif

static int _cffi_d_ncdirect_set_fg_rgb8(struct ncdirect * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return ncdirect_set_fg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_fg_rgb8(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncdirect_set_fg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_fg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_fg_rgb8 _cffi_d_ncdirect_set_fg_rgb8
#endif

static int _cffi_d_ncdirect_set_styles(struct ncdirect * x0, unsigned int x1)
{
  return ncdirect_set_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_set_styles(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirect_set_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_set_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_set_styles _cffi_d_ncdirect_set_styles
#endif

static int _cffi_d_ncdirect_stop(struct ncdirect * x0)
{
  return ncdirect_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_stop(PyObject *self, PyObject *arg0)
{
  struct ncdirect * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_stop _cffi_d_ncdirect_stop
#endif

static int _cffi_d_ncdirect_stream(struct ncdirect * x0, char const * x1, int(* x2)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *), struct ncvisual_options * x3, void * x4)
{
  return ncdirect_stream(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_stream(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  char const * x1;
  int(* x2)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *);
  struct ncvisual_options * x3;
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncdirect_stream", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *))_cffi_to_c_pointer(arg2, _cffi_type(241));
  if (x2 == (int(*)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(242), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct ncvisual_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(242), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_stream(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_stream _cffi_d_ncdirect_stream
#endif

static uint16_t _cffi_d_ncdirect_styles(struct ncdirect const * x0)
{
  return ncdirect_styles(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_styles(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint16_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_styles(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint16_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_styles _cffi_d_ncdirect_styles
#endif

static uint16_t _cffi_d_ncdirect_supported_styles(struct ncdirect const * x0)
{
  return ncdirect_supported_styles(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_supported_styles(PyObject *self, PyObject *arg0)
{
  struct ncdirect const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint16_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_supported_styles(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint16_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_supported_styles _cffi_d_ncdirect_supported_styles
#endif

static int _cffi_d_ncdirect_vline_interp(struct ncdirect * x0, char const * x1, unsigned int x2, uint64_t x3, uint64_t x4)
{
  return ncdirect_vline_interp(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirect_vline_interp(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  char const * x1;
  unsigned int x2;
  uint64_t x3;
  uint64_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncdirect_vline_interp", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirect_vline_interp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirect_vline_interp _cffi_d_ncdirect_vline_interp
#endif

static void _cffi_d_ncdirectf_free(ncdirectf * x0)
{
  ncdirectf_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirectf_free(PyObject *self, PyObject *arg0)
{
  ncdirectf * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncdirectf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncdirectf_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncdirectf_free _cffi_d_ncdirectf_free
#endif

static ncdirectf * _cffi_d_ncdirectf_from_file(struct ncdirect * x0, char const * x1)
{
  return ncdirectf_from_file(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirectf_from_file(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ncdirectf * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncdirectf_from_file", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirectf_from_file(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirectf_from_file _cffi_d_ncdirectf_from_file
#endif

static int _cffi_d_ncdirectf_geom(struct ncdirect * x0, ncdirectf * x1, struct ncvisual_options const * x2, ncvgeom * x3)
{
  return ncdirectf_geom(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirectf_geom(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  ncdirectf * x1;
  struct ncvisual_options const * x2;
  ncvgeom * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncdirectf_geom", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncdirectf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(278), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (ncvgeom *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(278), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirectf_geom(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirectf_geom _cffi_d_ncdirectf_geom
#endif

static ncdirectv * _cffi_d_ncdirectf_render(struct ncdirect * x0, ncdirectf * x1, struct ncvisual_options const * x2)
{
  return ncdirectf_render(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdirectf_render(PyObject *self, PyObject *args)
{
  struct ncdirect * x0;
  ncdirectf * x1;
  struct ncvisual_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ncdirectv * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdirectf_render", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdirect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncdirectf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdirectf_render(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdirectf_render _cffi_d_ncdirectf_render
#endif

static int _cffi_d_ncdplot_add_sample(struct ncdplot * x0, uint64_t x1, double x2)
{
  return ncdplot_add_sample(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdplot_add_sample(PyObject *self, PyObject *args)
{
  struct ncdplot * x0;
  uint64_t x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdplot_add_sample", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(336), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdplot *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(336), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdplot_add_sample(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdplot_add_sample _cffi_d_ncdplot_add_sample
#endif

static struct ncdplot * _cffi_d_ncdplot_create(struct ncplane * x0, ncplot_options const * x1, double x2, double x3)
{
  return ncdplot_create(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdplot_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncplot_options const * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncdplot * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncdplot_create", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1069), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncplot_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1069), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdplot_create(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(336));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdplot_create _cffi_d_ncdplot_create
#endif

static void _cffi_d_ncdplot_destroy(struct ncdplot * x0)
{
  ncdplot_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdplot_destroy(PyObject *self, PyObject *arg0)
{
  struct ncdplot * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(336), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdplot *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(336), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncdplot_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncdplot_destroy _cffi_d_ncdplot_destroy
#endif

static struct ncplane * _cffi_d_ncdplot_plane(struct ncdplot * x0)
{
  return ncdplot_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdplot_plane(PyObject *self, PyObject *arg0)
{
  struct ncdplot * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(336), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdplot *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(336), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdplot_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdplot_plane _cffi_d_ncdplot_plane
#endif

static int _cffi_d_ncdplot_sample(struct ncdplot const * x0, uint64_t x1, double * x2)
{
  return ncdplot_sample(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdplot_sample(PyObject *self, PyObject *args)
{
  struct ncdplot const * x0;
  uint64_t x1;
  double * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdplot_sample", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(341), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdplot const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(341), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(343), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(343), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdplot_sample(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdplot_sample _cffi_d_ncdplot_sample
#endif

static int _cffi_d_ncdplot_set_sample(struct ncdplot * x0, uint64_t x1, double x2)
{
  return ncdplot_set_sample(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncdplot_set_sample(PyObject *self, PyObject *args)
{
  struct ncdplot * x0;
  uint64_t x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncdplot_set_sample", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(336), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncdplot *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(336), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncdplot_set_sample(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncdplot_set_sample _cffi_d_ncdplot_set_sample
#endif

static void _cffi_d_ncfadectx_free(struct ncfadectx * x0)
{
  ncfadectx_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncfadectx_free(PyObject *self, PyObject *arg0)
{
  struct ncfadectx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(681), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncfadectx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(681), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncfadectx_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncfadectx_free _cffi_d_ncfadectx_free
#endif

static int _cffi_d_ncfadectx_iterations(struct ncfadectx const * x0)
{
  return ncfadectx_iterations(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncfadectx_iterations(PyObject *self, PyObject *arg0)
{
  struct ncfadectx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(346), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncfadectx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(346), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncfadectx_iterations(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncfadectx_iterations _cffi_d_ncfadectx_iterations
#endif

static struct ncfadectx * _cffi_d_ncfadectx_setup(struct ncplane * x0)
{
  return ncfadectx_setup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncfadectx_setup(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncfadectx * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncfadectx_setup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(681));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncfadectx_setup _cffi_d_ncfadectx_setup
#endif

static struct ncfdplane * _cffi_d_ncfdplane_create(struct ncplane * x0, ncfdplane_options const * x1, int x2, int(* x3)(struct ncfdplane *, void const *, size_t, void *), int(* x4)(struct ncfdplane *, int, void *))
{
  return ncfdplane_create(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncfdplane_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncfdplane_options const * x1;
  int x2;
  int(* x3)(struct ncfdplane *, void const *, size_t, void *);
  int(* x4)(struct ncfdplane *, int, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncfdplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncfdplane_create", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1078), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncfdplane_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1078), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(struct ncfdplane *, void const *, size_t, void *))_cffi_to_c_pointer(arg3, _cffi_type(1080));
  if (x3 == (int(*)(struct ncfdplane *, void const *, size_t, void *))NULL && PyErr_Occurred())
    return NULL;

  x4 = (int(*)(struct ncfdplane *, int, void *))_cffi_to_c_pointer(arg4, _cffi_type(1081));
  if (x4 == (int(*)(struct ncfdplane *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncfdplane_create(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(349));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncfdplane_create _cffi_d_ncfdplane_create
#endif

static int _cffi_d_ncfdplane_destroy(struct ncfdplane * x0)
{
  return ncfdplane_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncfdplane_destroy(PyObject *self, PyObject *arg0)
{
  struct ncfdplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(349), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncfdplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(349), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncfdplane_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncfdplane_destroy _cffi_d_ncfdplane_destroy
#endif

static struct ncplane * _cffi_d_ncfdplane_plane(struct ncfdplane * x0)
{
  return ncfdplane_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncfdplane_plane(PyObject *self, PyObject *arg0)
{
  struct ncfdplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(349), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncfdplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(349), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncfdplane_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncfdplane_plane _cffi_d_ncfdplane_plane
#endif

static _Bool _cffi_d_ncinput_alt_p(ncinput const * x0)
{
  return ncinput_alt_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_alt_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_alt_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_alt_p _cffi_d_ncinput_alt_p
#endif

static _Bool _cffi_d_ncinput_capslock_p(ncinput const * x0)
{
  return ncinput_capslock_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_capslock_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_capslock_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_capslock_p _cffi_d_ncinput_capslock_p
#endif

static _Bool _cffi_d_ncinput_ctrl_p(ncinput const * x0)
{
  return ncinput_ctrl_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_ctrl_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_ctrl_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_ctrl_p _cffi_d_ncinput_ctrl_p
#endif

static _Bool _cffi_d_ncinput_equal_p(ncinput const * x0, ncinput const * x1)
{
  return ncinput_equal_p(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_equal_p(PyObject *self, PyObject *args)
{
  ncinput const * x0;
  ncinput const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncinput_equal_p", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_equal_p(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_equal_p _cffi_d_ncinput_equal_p
#endif

static _Bool _cffi_d_ncinput_hyper_p(ncinput const * x0)
{
  return ncinput_hyper_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_hyper_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_hyper_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_hyper_p _cffi_d_ncinput_hyper_p
#endif

static _Bool _cffi_d_ncinput_meta_p(ncinput const * x0)
{
  return ncinput_meta_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_meta_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_meta_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_meta_p _cffi_d_ncinput_meta_p
#endif

static _Bool _cffi_d_ncinput_nomod_p(ncinput const * x0)
{
  return ncinput_nomod_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_nomod_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_nomod_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_nomod_p _cffi_d_ncinput_nomod_p
#endif

static _Bool _cffi_d_ncinput_numlock_p(ncinput const * x0)
{
  return ncinput_numlock_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_numlock_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_numlock_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_numlock_p _cffi_d_ncinput_numlock_p
#endif

static _Bool _cffi_d_ncinput_shift_p(ncinput const * x0)
{
  return ncinput_shift_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_shift_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_shift_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_shift_p _cffi_d_ncinput_shift_p
#endif

static _Bool _cffi_d_ncinput_super_p(ncinput const * x0)
{
  return ncinput_super_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncinput_super_p(PyObject *self, PyObject *arg0)
{
  ncinput const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncinput_super_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncinput_super_p _cffi_d_ncinput_super_p
#endif

static char const * _cffi_d_nciprefix(uintmax_t x0, uintmax_t x1, char * x2, int x3)
{
  return nciprefix(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nciprefix(PyObject *self, PyObject *args)
{
  uintmax_t x0;
  uintmax_t x1;
  char * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nciprefix", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uintmax_t);
  if (x0 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uintmax_t);
  if (x1 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nciprefix(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nciprefix _cffi_d_nciprefix
#endif

static _Bool _cffi_d_nckey_mouse_p(uint32_t x0)
{
  return nckey_mouse_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nckey_mouse_p(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nckey_mouse_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_nckey_mouse_p _cffi_d_nckey_mouse_p
#endif

static _Bool _cffi_d_nckey_pua_p(uint32_t x0)
{
  return nckey_pua_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nckey_pua_p(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nckey_pua_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_nckey_pua_p _cffi_d_nckey_pua_p
#endif

static _Bool _cffi_d_nckey_supppuaa_p(uint32_t x0)
{
  return nckey_supppuaa_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nckey_supppuaa_p(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nckey_supppuaa_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_nckey_supppuaa_p _cffi_d_nckey_supppuaa_p
#endif

static _Bool _cffi_d_nckey_supppuab_p(uint32_t x0)
{
  return nckey_supppuab_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nckey_supppuab_p(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nckey_supppuab_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_nckey_supppuab_p _cffi_d_nckey_supppuab_p
#endif

static _Bool _cffi_d_nckey_synthesized_p(uint32_t x0)
{
  return nckey_synthesized_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nckey_synthesized_p(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nckey_synthesized_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_nckey_synthesized_p _cffi_d_nckey_synthesized_p
#endif

static struct ncmenu * _cffi_d_ncmenu_create(struct ncplane * x0, ncmenu_options const * x1)
{
  return ncmenu_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncmenu_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncmenu * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncmenu_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1085), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncmenu_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1085), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_create _cffi_d_ncmenu_create
#endif

static void _cffi_d_ncmenu_destroy(struct ncmenu * x0)
{
  ncmenu_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_destroy(PyObject *self, PyObject *arg0)
{
  struct ncmenu * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncmenu_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncmenu_destroy _cffi_d_ncmenu_destroy
#endif

static int _cffi_d_ncmenu_item_set_status(struct ncmenu * x0, char const * x1, char const * x2, _Bool x3)
{
  return ncmenu_item_set_status(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_item_set_status(PyObject *self, PyObject *args)
{
  struct ncmenu * x0;
  char const * x1;
  char const * x2;
  _Bool x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncmenu_item_set_status", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (_Bool)_cffi_to_c__Bool(arg3);
  if (x3 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_item_set_status(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_item_set_status _cffi_d_ncmenu_item_set_status
#endif

static char const * _cffi_d_ncmenu_mouse_selected(struct ncmenu const * x0, ncinput const * x1, ncinput * x2)
{
  return ncmenu_mouse_selected(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_mouse_selected(PyObject *self, PyObject *args)
{
  struct ncmenu const * x0;
  ncinput const * x1;
  ncinput * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncmenu_mouse_selected", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_mouse_selected(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_mouse_selected _cffi_d_ncmenu_mouse_selected
#endif

static int _cffi_d_ncmenu_nextitem(struct ncmenu * x0)
{
  return ncmenu_nextitem(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_nextitem(PyObject *self, PyObject *arg0)
{
  struct ncmenu * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_nextitem(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_nextitem _cffi_d_ncmenu_nextitem
#endif

static int _cffi_d_ncmenu_nextsection(struct ncmenu * x0)
{
  return ncmenu_nextsection(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_nextsection(PyObject *self, PyObject *arg0)
{
  struct ncmenu * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_nextsection(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_nextsection _cffi_d_ncmenu_nextsection
#endif

static _Bool _cffi_d_ncmenu_offer_input(struct ncmenu * x0, ncinput const * x1)
{
  return ncmenu_offer_input(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_offer_input(PyObject *self, PyObject *args)
{
  struct ncmenu * x0;
  ncinput const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncmenu_offer_input", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_offer_input(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_offer_input _cffi_d_ncmenu_offer_input
#endif

static struct ncplane * _cffi_d_ncmenu_plane(struct ncmenu * x0)
{
  return ncmenu_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_plane(PyObject *self, PyObject *arg0)
{
  struct ncmenu * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_plane _cffi_d_ncmenu_plane
#endif

static int _cffi_d_ncmenu_previtem(struct ncmenu * x0)
{
  return ncmenu_previtem(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_previtem(PyObject *self, PyObject *arg0)
{
  struct ncmenu * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_previtem(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_previtem _cffi_d_ncmenu_previtem
#endif

static int _cffi_d_ncmenu_prevsection(struct ncmenu * x0)
{
  return ncmenu_prevsection(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_prevsection(PyObject *self, PyObject *arg0)
{
  struct ncmenu * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_prevsection(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_prevsection _cffi_d_ncmenu_prevsection
#endif

static int _cffi_d_ncmenu_rollup(struct ncmenu * x0)
{
  return ncmenu_rollup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_rollup(PyObject *self, PyObject *arg0)
{
  struct ncmenu * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_rollup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_rollup _cffi_d_ncmenu_rollup
#endif

static char const * _cffi_d_ncmenu_selected(struct ncmenu const * x0, ncinput * x1)
{
  return ncmenu_selected(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_selected(PyObject *self, PyObject *args)
{
  struct ncmenu const * x0;
  ncinput * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncmenu_selected", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_selected(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_selected _cffi_d_ncmenu_selected
#endif

static int _cffi_d_ncmenu_unroll(struct ncmenu * x0, int x1)
{
  return ncmenu_unroll(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmenu_unroll(PyObject *self, PyObject *args)
{
  struct ncmenu * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncmenu_unroll", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmenu *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmenu_unroll(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmenu_unroll _cffi_d_ncmenu_unroll
#endif

static struct ncmultiselector * _cffi_d_ncmultiselector_create(struct ncplane * x0, ncmultiselector_options const * x1)
{
  return ncmultiselector_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmultiselector_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncmultiselector_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncmultiselector * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncmultiselector_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1089), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncmultiselector_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1089), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmultiselector_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(21));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmultiselector_create _cffi_d_ncmultiselector_create
#endif

static void _cffi_d_ncmultiselector_destroy(struct ncmultiselector * x0)
{
  ncmultiselector_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmultiselector_destroy(PyObject *self, PyObject *arg0)
{
  struct ncmultiselector * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmultiselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncmultiselector_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncmultiselector_destroy _cffi_d_ncmultiselector_destroy
#endif

static _Bool _cffi_d_ncmultiselector_offer_input(struct ncmultiselector * x0, ncinput const * x1)
{
  return ncmultiselector_offer_input(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmultiselector_offer_input(PyObject *self, PyObject *args)
{
  struct ncmultiselector * x0;
  ncinput const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncmultiselector_offer_input", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmultiselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmultiselector_offer_input(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmultiselector_offer_input _cffi_d_ncmultiselector_offer_input
#endif

static struct ncplane * _cffi_d_ncmultiselector_plane(struct ncmultiselector * x0)
{
  return ncmultiselector_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmultiselector_plane(PyObject *self, PyObject *arg0)
{
  struct ncmultiselector * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmultiselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmultiselector_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmultiselector_plane _cffi_d_ncmultiselector_plane
#endif

static int _cffi_d_ncmultiselector_selected(struct ncmultiselector * x0, _Bool * x1, unsigned int x2)
{
  return ncmultiselector_selected(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncmultiselector_selected(PyObject *self, PyObject *args)
{
  struct ncmultiselector * x0;
  _Bool * x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncmultiselector_selected", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncmultiselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(377), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(377), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncmultiselector_selected(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncmultiselector_selected _cffi_d_ncmultiselector_selected
#endif

static char const * _cffi_d_ncnmetric(uintmax_t x0, size_t x1, uintmax_t x2, char * x3, int x4, uintmax_t x5, int x6)
{
  return ncnmetric(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncnmetric(PyObject *self, PyObject *args)
{
  uintmax_t x0;
  size_t x1;
  uintmax_t x2;
  char * x3;
  int x4;
  uintmax_t x5;
  int x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ncnmetric", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uintmax_t);
  if (x0 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uintmax_t);
  if (x2 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uintmax_t);
  if (x5 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncnmetric(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncnmetric _cffi_d_ncnmetric
#endif

static void _cffi_d_ncpalette_free(ncpalette * x0)
{
  ncpalette_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpalette_free(PyObject *self, PyObject *arg0)
{
  ncpalette * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(212), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncpalette *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(212), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncpalette_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncpalette_free _cffi_d_ncpalette_free
#endif

static int _cffi_d_ncpalette_get(ncpalette const * x0, int x1, uint32_t * x2)
{
  return ncpalette_get(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpalette_get(PyObject *self, PyObject *args)
{
  ncpalette const * x0;
  int x1;
  uint32_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncpalette_get", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(224), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncpalette const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(224), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpalette_get(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpalette_get _cffi_d_ncpalette_get
#endif

static int _cffi_d_ncpalette_get_rgb8(ncpalette const * x0, int x1, unsigned int * x2, unsigned int * x3, unsigned int * x4)
{
  return ncpalette_get_rgb8(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpalette_get_rgb8(PyObject *self, PyObject *args)
{
  ncpalette const * x0;
  int x1;
  unsigned int * x2;
  unsigned int * x3;
  unsigned int * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncpalette_get_rgb8", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(224), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncpalette const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(224), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpalette_get_rgb8(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpalette_get_rgb8 _cffi_d_ncpalette_get_rgb8
#endif

static ncpalette * _cffi_d_ncpalette_new(struct notcurses * x0)
{
  return ncpalette_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpalette_new(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ncpalette * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpalette_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(212));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpalette_new _cffi_d_ncpalette_new
#endif

static int _cffi_d_ncpalette_set(ncpalette * x0, int x1, unsigned int x2)
{
  return ncpalette_set(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpalette_set(PyObject *self, PyObject *args)
{
  ncpalette * x0;
  int x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncpalette_set", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(212), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncpalette *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(212), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpalette_set(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpalette_set _cffi_d_ncpalette_set
#endif

static int _cffi_d_ncpalette_set_rgb8(ncpalette * x0, int x1, unsigned int x2, unsigned int x3, unsigned int x4)
{
  return ncpalette_set_rgb8(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpalette_set_rgb8(PyObject *self, PyObject *args)
{
  ncpalette * x0;
  int x1;
  unsigned int x2;
  unsigned int x3;
  unsigned int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncpalette_set_rgb8", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(212), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ncpalette *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(212), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpalette_set_rgb8(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpalette_set_rgb8 _cffi_d_ncpalette_set_rgb8
#endif

static int _cffi_d_ncpalette_use(struct notcurses * x0, ncpalette const * x1)
{
  return ncpalette_use(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpalette_use(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  ncpalette const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncpalette_use", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(224), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncpalette const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(224), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpalette_use(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpalette_use _cffi_d_ncpalette_use
#endif

static struct ncplane * _cffi_d_ncpile_bottom(struct ncplane * x0)
{
  return ncpile_bottom(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpile_bottom(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpile_bottom(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpile_bottom _cffi_d_ncpile_bottom
#endif

static struct ncplane * _cffi_d_ncpile_create(struct notcurses * x0, ncplane_options const * x1)
{
  return ncpile_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpile_create(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  ncplane_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncpile_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1108), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncplane_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1108), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpile_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpile_create _cffi_d_ncpile_create
#endif

static int _cffi_d_ncpile_rasterize(struct ncplane * x0)
{
  return ncpile_rasterize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpile_rasterize(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpile_rasterize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpile_rasterize _cffi_d_ncpile_rasterize
#endif

static int _cffi_d_ncpile_render(struct ncplane * x0)
{
  return ncpile_render(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpile_render(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpile_render(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpile_render _cffi_d_ncpile_render
#endif

static int _cffi_d_ncpile_render_to_buffer(struct ncplane * x0, char * * x1, size_t * x2)
{
  return ncpile_render_to_buffer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpile_render_to_buffer(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char * * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncpile_render_to_buffer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(389), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(389), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(390), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(390), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpile_render_to_buffer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpile_render_to_buffer _cffi_d_ncpile_render_to_buffer
#endif

static int _cffi_d_ncpile_render_to_file(struct ncplane * x0, FILE * x1)
{
  return ncpile_render_to_file(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpile_render_to_file(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  FILE * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncpile_render_to_file", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpile_render_to_file(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpile_render_to_file _cffi_d_ncpile_render_to_file
#endif

static struct ncplane * _cffi_d_ncpile_top(struct ncplane * x0)
{
  return ncpile_top(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpile_top(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpile_top(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpile_top _cffi_d_ncpile_top
#endif

static uint32_t _cffi_d_ncpixel(unsigned int x0, unsigned int x1, unsigned int x2)
{
  return ncpixel(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel(PyObject *self, PyObject *args)
{
  unsigned int x0;
  unsigned int x1;
  unsigned int x2;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncpixel", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, unsigned int);
  if (x0 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel _cffi_d_ncpixel
#endif

static unsigned int _cffi_d_ncpixel_a(uint32_t x0)
{
  return ncpixel_a(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_a(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_a(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_a _cffi_d_ncpixel_a
#endif

static unsigned int _cffi_d_ncpixel_b(uint32_t x0)
{
  return ncpixel_b(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_b(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_b(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_b _cffi_d_ncpixel_b
#endif

static unsigned int _cffi_d_ncpixel_g(uint32_t x0)
{
  return ncpixel_g(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_g(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_g(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_g _cffi_d_ncpixel_g
#endif

static unsigned int _cffi_d_ncpixel_r(uint32_t x0)
{
  return ncpixel_r(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_r(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_r(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_r _cffi_d_ncpixel_r
#endif

static int _cffi_d_ncpixel_set_a(uint32_t * x0, unsigned int x1)
{
  return ncpixel_set_a(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_set_a(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncpixel_set_a", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_set_a(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_set_a _cffi_d_ncpixel_set_a
#endif

static int _cffi_d_ncpixel_set_b(uint32_t * x0, unsigned int x1)
{
  return ncpixel_set_b(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_set_b(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncpixel_set_b", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_set_b(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_set_b _cffi_d_ncpixel_set_b
#endif

static int _cffi_d_ncpixel_set_g(uint32_t * x0, unsigned int x1)
{
  return ncpixel_set_g(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_set_g(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncpixel_set_g", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_set_g(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_set_g _cffi_d_ncpixel_set_g
#endif

static int _cffi_d_ncpixel_set_r(uint32_t * x0, unsigned int x1)
{
  return ncpixel_set_r(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_set_r(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncpixel_set_r", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_set_r(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_set_r _cffi_d_ncpixel_set_r
#endif

static int _cffi_d_ncpixel_set_rgb8(uint32_t * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return ncpixel_set_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncpixel_set_rgb8(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncpixel_set_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncpixel_set_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncpixel_set_rgb8 _cffi_d_ncpixel_set_rgb8
#endif

static struct ncplane * _cffi_d_ncplane_above(struct ncplane * x0)
{
  return ncplane_above(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_above(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_above(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_above _cffi_d_ncplane_above
#endif

static int _cffi_d_ncplane_abs_x(struct ncplane const * x0)
{
  return ncplane_abs_x(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_abs_x(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_abs_x(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_abs_x _cffi_d_ncplane_abs_x
#endif

static int _cffi_d_ncplane_abs_y(struct ncplane const * x0)
{
  return ncplane_abs_y(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_abs_y(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_abs_y(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_abs_y _cffi_d_ncplane_abs_y
#endif

static void _cffi_d_ncplane_abs_yx(struct ncplane const * x0, int * x1, int * x2)
{
  ncplane_abs_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_abs_yx(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_abs_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_abs_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_abs_yx _cffi_d_ncplane_abs_yx
#endif

static uint32_t * _cffi_d_ncplane_as_rgba(struct ncplane const * x0, ncblitter_e x1, int x2, int x3, unsigned int x4, unsigned int x5, unsigned int * x6, unsigned int * x7)
{
  return ncplane_as_rgba(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_as_rgba(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  ncblitter_e x1;
  int x2;
  int x3;
  unsigned int x4;
  unsigned int x5;
  unsigned int * x6;
  unsigned int * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ncplane_as_rgba", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(125), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_as_rgba(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(226));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_as_rgba _cffi_d_ncplane_as_rgba
#endif

static int _cffi_d_ncplane_ascii_box(struct ncplane * x0, uint16_t x1, uint64_t x2, unsigned int x3, unsigned int x4, unsigned int x5)
{
  return ncplane_ascii_box(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_ascii_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  unsigned int x3;
  unsigned int x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncplane_ascii_box", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_ascii_box(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_ascii_box _cffi_d_ncplane_ascii_box
#endif

static char * _cffi_d_ncplane_at_cursor(struct ncplane const * x0, uint16_t * x1, uint64_t * x2)
{
  return ncplane_at_cursor(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_at_cursor(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  uint16_t * x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_at_cursor", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint16_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(88), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_at_cursor(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_at_cursor _cffi_d_ncplane_at_cursor
#endif

static int _cffi_d_ncplane_at_cursor_cell(struct ncplane * x0, nccell * x1)
{
  return ncplane_at_cursor_cell(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_at_cursor_cell(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_at_cursor_cell", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_at_cursor_cell(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_at_cursor_cell _cffi_d_ncplane_at_cursor_cell
#endif

static char * _cffi_d_ncplane_at_yx(struct ncplane const * x0, int x1, int x2, uint16_t * x3, uint64_t * x4)
{
  return ncplane_at_yx(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_at_yx(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  int x1;
  int x2;
  uint16_t * x3;
  uint64_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_at_yx", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint16_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(88), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_at_yx(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_at_yx _cffi_d_ncplane_at_yx
#endif

static int _cffi_d_ncplane_at_yx_cell(struct ncplane * x0, int x1, int x2, nccell * x3)
{
  return ncplane_at_yx_cell(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_at_yx_cell(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  nccell * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_at_yx_cell", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_at_yx_cell(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_at_yx_cell _cffi_d_ncplane_at_yx_cell
#endif

static _Bool _cffi_d_ncplane_autogrow_p(struct ncplane const * x0)
{
  return ncplane_autogrow_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_autogrow_p(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_autogrow_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_autogrow_p _cffi_d_ncplane_autogrow_p
#endif

static int _cffi_d_ncplane_base(struct ncplane * x0, nccell * x1)
{
  return ncplane_base(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_base(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_base", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(198), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(198), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_base(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_base _cffi_d_ncplane_base
#endif

static uint32_t _cffi_d_ncplane_bchannel(struct ncplane const * x0)
{
  return ncplane_bchannel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_bchannel(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_bchannel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_bchannel _cffi_d_ncplane_bchannel
#endif

static struct ncplane * _cffi_d_ncplane_below(struct ncplane * x0)
{
  return ncplane_below(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_below(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_below(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_below _cffi_d_ncplane_below
#endif

static uint32_t _cffi_d_ncplane_bg_alpha(struct ncplane const * x0)
{
  return ncplane_bg_alpha(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_bg_alpha(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_bg_alpha(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_bg_alpha _cffi_d_ncplane_bg_alpha
#endif

static _Bool _cffi_d_ncplane_bg_default_p(struct ncplane const * x0)
{
  return ncplane_bg_default_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_bg_default_p(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_bg_default_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_bg_default_p _cffi_d_ncplane_bg_default_p
#endif

static uint32_t _cffi_d_ncplane_bg_rgb(struct ncplane const * x0)
{
  return ncplane_bg_rgb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_bg_rgb(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_bg_rgb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_bg_rgb _cffi_d_ncplane_bg_rgb
#endif

static uint32_t _cffi_d_ncplane_bg_rgb8(struct ncplane const * x0, unsigned int * x1, unsigned int * x2, unsigned int * x3)
{
  return ncplane_bg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_bg_rgb8(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  unsigned int * x1;
  unsigned int * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_bg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_bg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_bg_rgb8 _cffi_d_ncplane_bg_rgb8
#endif

static int _cffi_d_ncplane_box(struct ncplane * x0, nccell const * x1, nccell const * x2, nccell const * x3, nccell const * x4, nccell const * x5, nccell const * x6, unsigned int x7, unsigned int x8, unsigned int x9)
{
  return ncplane_box(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  nccell const * x2;
  nccell const * x3;
  nccell const * x4;
  nccell const * x5;
  nccell const * x6;
  unsigned int x7;
  unsigned int x8;
  unsigned int x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "ncplane_box", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, unsigned int);
  if (x8 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x9 = _cffi_to_c_int(arg9, unsigned int);
  if (x9 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_box(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_box _cffi_d_ncplane_box
#endif

static int _cffi_d_ncplane_box_sized(struct ncplane * x0, nccell const * x1, nccell const * x2, nccell const * x3, nccell const * x4, nccell const * x5, nccell const * x6, unsigned int x7, unsigned int x8, unsigned int x9)
{
  return ncplane_box_sized(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_box_sized(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  nccell const * x2;
  nccell const * x3;
  nccell const * x4;
  nccell const * x5;
  nccell const * x6;
  unsigned int x7;
  unsigned int x8;
  unsigned int x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "ncplane_box_sized", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, unsigned int);
  if (x8 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x9 = _cffi_to_c_int(arg9, unsigned int);
  if (x9 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_box_sized(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_box_sized _cffi_d_ncplane_box_sized
#endif

static void _cffi_d_ncplane_center_abs(struct ncplane const * x0, int * x1, int * x2)
{
  ncplane_center_abs(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_center_abs(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_center_abs", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_center_abs(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_center_abs _cffi_d_ncplane_center_abs
#endif

static uint64_t _cffi_d_ncplane_channels(struct ncplane const * x0)
{
  return ncplane_channels(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_channels(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_channels(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_channels _cffi_d_ncplane_channels
#endif

static char * _cffi_d_ncplane_contents(struct ncplane * x0, int x1, int x2, unsigned int x3, unsigned int x4)
{
  return ncplane_contents(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_contents(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  unsigned int x3;
  unsigned int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_contents", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_contents(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_contents _cffi_d_ncplane_contents
#endif

static struct ncplane * _cffi_d_ncplane_create(struct ncplane * x0, ncplane_options const * x1)
{
  return ncplane_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncplane_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1108), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncplane_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1108), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_create _cffi_d_ncplane_create
#endif

static int _cffi_d_ncplane_cursor_move_rel(struct ncplane * x0, int x1, int x2)
{
  return ncplane_cursor_move_rel(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_cursor_move_rel(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_cursor_move_rel", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_cursor_move_rel(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_cursor_move_rel _cffi_d_ncplane_cursor_move_rel
#endif

static int _cffi_d_ncplane_cursor_move_yx(struct ncplane * x0, int x1, int x2)
{
  return ncplane_cursor_move_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_cursor_move_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_cursor_move_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_cursor_move_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_cursor_move_yx _cffi_d_ncplane_cursor_move_yx
#endif

static unsigned int _cffi_d_ncplane_cursor_x(struct ncplane const * x0)
{
  return ncplane_cursor_x(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_cursor_x(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_cursor_x(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_cursor_x _cffi_d_ncplane_cursor_x
#endif

static unsigned int _cffi_d_ncplane_cursor_y(struct ncplane const * x0)
{
  return ncplane_cursor_y(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_cursor_y(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_cursor_y(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_cursor_y _cffi_d_ncplane_cursor_y
#endif

static void _cffi_d_ncplane_cursor_yx(struct ncplane const * x0, unsigned int * x1, unsigned int * x2)
{
  ncplane_cursor_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_cursor_yx(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  unsigned int * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_cursor_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_cursor_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_cursor_yx _cffi_d_ncplane_cursor_yx
#endif

static int _cffi_d_ncplane_descendant_p(struct ncplane const * x0, struct ncplane const * x1)
{
  return ncplane_descendant_p(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_descendant_p(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  struct ncplane const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_descendant_p", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_descendant_p(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_descendant_p _cffi_d_ncplane_descendant_p
#endif

static int _cffi_d_ncplane_destroy(struct ncplane * x0)
{
  return ncplane_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_destroy(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_destroy _cffi_d_ncplane_destroy
#endif

static unsigned int _cffi_d_ncplane_dim_x(struct ncplane const * x0)
{
  return ncplane_dim_x(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_dim_x(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_dim_x(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_dim_x _cffi_d_ncplane_dim_x
#endif

static unsigned int _cffi_d_ncplane_dim_y(struct ncplane const * x0)
{
  return ncplane_dim_y(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_dim_y(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_dim_y(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_dim_y _cffi_d_ncplane_dim_y
#endif

static void _cffi_d_ncplane_dim_yx(struct ncplane const * x0, unsigned int * x1, unsigned int * x2)
{
  ncplane_dim_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_dim_yx(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  unsigned int * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_dim_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_dim_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_dim_yx _cffi_d_ncplane_dim_yx
#endif

static int _cffi_d_ncplane_double_box(struct ncplane * x0, uint16_t x1, uint64_t x2, unsigned int x3, unsigned int x4, unsigned int x5)
{
  return ncplane_double_box(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_double_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  unsigned int x3;
  unsigned int x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncplane_double_box", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_double_box(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_double_box _cffi_d_ncplane_double_box
#endif

static int _cffi_d_ncplane_double_box_sized(struct ncplane * x0, uint16_t x1, uint64_t x2, unsigned int x3, unsigned int x4, unsigned int x5)
{
  return ncplane_double_box_sized(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_double_box_sized(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  unsigned int x3;
  unsigned int x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncplane_double_box_sized", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_double_box_sized(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_double_box_sized _cffi_d_ncplane_double_box_sized
#endif

static struct ncplane * _cffi_d_ncplane_dup(struct ncplane const * x0, void * x1)
{
  return ncplane_dup(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_dup(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_dup", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_dup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_dup _cffi_d_ncplane_dup
#endif

static void _cffi_d_ncplane_erase(struct ncplane * x0)
{
  ncplane_erase(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_erase(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_erase(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_erase _cffi_d_ncplane_erase
#endif

static int _cffi_d_ncplane_erase_region(struct ncplane * x0, int x1, int x2, int x3, int x4)
{
  return ncplane_erase_region(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_erase_region(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_erase_region", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_erase_region(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_erase_region _cffi_d_ncplane_erase_region
#endif

static int _cffi_d_ncplane_fadein(struct ncplane * x0, struct timespec const * x1, int(* x2)(struct notcurses *, struct ncplane *, struct timespec const *, void *), void * x3)
{
  return ncplane_fadein(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fadein(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct timespec const * x1;
  int(* x2)(struct notcurses *, struct ncplane *, struct timespec const *, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_fadein", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(706), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(706), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))_cffi_to_c_pointer(arg2, _cffi_type(683));
  if (x2 == (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fadein(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fadein _cffi_d_ncplane_fadein
#endif

static int _cffi_d_ncplane_fadein_iteration(struct ncplane * x0, struct ncfadectx * x1, int x2, int(* x3)(struct notcurses *, struct ncplane *, struct timespec const *, void *), void * x4)
{
  return ncplane_fadein_iteration(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fadein_iteration(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncfadectx * x1;
  int x2;
  int(* x3)(struct notcurses *, struct ncplane *, struct timespec const *, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_fadein_iteration", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(681), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncfadectx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(681), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))_cffi_to_c_pointer(arg3, _cffi_type(683));
  if (x3 == (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fadein_iteration(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fadein_iteration _cffi_d_ncplane_fadein_iteration
#endif

static int _cffi_d_ncplane_fadeout(struct ncplane * x0, struct timespec const * x1, int(* x2)(struct notcurses *, struct ncplane *, struct timespec const *, void *), void * x3)
{
  return ncplane_fadeout(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fadeout(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct timespec const * x1;
  int(* x2)(struct notcurses *, struct ncplane *, struct timespec const *, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_fadeout", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(706), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(706), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))_cffi_to_c_pointer(arg2, _cffi_type(683));
  if (x2 == (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fadeout(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fadeout _cffi_d_ncplane_fadeout
#endif

static int _cffi_d_ncplane_fadeout_iteration(struct ncplane * x0, struct ncfadectx * x1, int x2, int(* x3)(struct notcurses *, struct ncplane *, struct timespec const *, void *), void * x4)
{
  return ncplane_fadeout_iteration(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fadeout_iteration(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncfadectx * x1;
  int x2;
  int(* x3)(struct notcurses *, struct ncplane *, struct timespec const *, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_fadeout_iteration", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(681), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncfadectx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(681), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))_cffi_to_c_pointer(arg3, _cffi_type(683));
  if (x3 == (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fadeout_iteration(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fadeout_iteration _cffi_d_ncplane_fadeout_iteration
#endif

static uint32_t _cffi_d_ncplane_fchannel(struct ncplane const * x0)
{
  return ncplane_fchannel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fchannel(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fchannel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fchannel _cffi_d_ncplane_fchannel
#endif

static uint32_t _cffi_d_ncplane_fg_alpha(struct ncplane const * x0)
{
  return ncplane_fg_alpha(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fg_alpha(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fg_alpha(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fg_alpha _cffi_d_ncplane_fg_alpha
#endif

static _Bool _cffi_d_ncplane_fg_default_p(struct ncplane const * x0)
{
  return ncplane_fg_default_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fg_default_p(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fg_default_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fg_default_p _cffi_d_ncplane_fg_default_p
#endif

static uint32_t _cffi_d_ncplane_fg_rgb(struct ncplane const * x0)
{
  return ncplane_fg_rgb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fg_rgb(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fg_rgb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fg_rgb _cffi_d_ncplane_fg_rgb
#endif

static uint32_t _cffi_d_ncplane_fg_rgb8(struct ncplane const * x0, unsigned int * x1, unsigned int * x2, unsigned int * x3)
{
  return ncplane_fg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_fg_rgb8(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  unsigned int * x1;
  unsigned int * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_fg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_fg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_fg_rgb8 _cffi_d_ncplane_fg_rgb8
#endif

static int _cffi_d_ncplane_format(struct ncplane * x0, int x1, int x2, unsigned int x3, unsigned int x4, uint16_t x5)
{
  return ncplane_format(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_format(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  unsigned int x3;
  unsigned int x4;
  uint16_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncplane_format", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint16_t);
  if (x5 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_format(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_format _cffi_d_ncplane_format
#endif

static int _cffi_d_ncplane_gradient(struct ncplane * x0, int x1, int x2, unsigned int x3, unsigned int x4, char const * x5, uint16_t x6, uint64_t x7, uint64_t x8, uint64_t x9, uint64_t x10)
{
  return ncplane_gradient(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_gradient(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  unsigned int x3;
  unsigned int x4;
  char const * x5;
  uint16_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "ncplane_gradient", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, uint16_t);
  if (x6 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint64_t);
  if (x7 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, uint64_t);
  if (x8 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x9 = _cffi_to_c_int(arg9, uint64_t);
  if (x9 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x10 = _cffi_to_c_int(arg10, uint64_t);
  if (x10 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_gradient(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_gradient _cffi_d_ncplane_gradient
#endif

static int _cffi_d_ncplane_gradient2x1(struct ncplane * x0, int x1, int x2, unsigned int x3, unsigned int x4, uint32_t x5, uint32_t x6, uint32_t x7, uint32_t x8)
{
  return ncplane_gradient2x1(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_gradient2x1(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  unsigned int x3;
  unsigned int x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "ncplane_gradient2x1", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint32_t);
  if (x7 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, uint32_t);
  if (x8 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_gradient2x1(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_gradient2x1 _cffi_d_ncplane_gradient2x1
#endif

static void _cffi_d_ncplane_greyscale(struct ncplane * x0)
{
  ncplane_greyscale(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_greyscale(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_greyscale(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_greyscale _cffi_d_ncplane_greyscale
#endif

static int _cffi_d_ncplane_halign(struct ncplane const * x0, ncalign_e x1, int x2)
{
  return ncplane_halign(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_halign(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  ncalign_e x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_halign", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(194), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_halign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_halign _cffi_d_ncplane_halign
#endif

static int _cffi_d_ncplane_hline(struct ncplane * x0, nccell const * x1, unsigned int x2)
{
  return ncplane_hline(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_hline(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_hline", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_hline(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_hline _cffi_d_ncplane_hline
#endif

static int _cffi_d_ncplane_hline_interp(struct ncplane * x0, nccell const * x1, unsigned int x2, uint64_t x3, uint64_t x4)
{
  return ncplane_hline_interp(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_hline_interp(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  unsigned int x2;
  uint64_t x3;
  uint64_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_hline_interp", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_hline_interp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_hline_interp _cffi_d_ncplane_hline_interp
#endif

static void _cffi_d_ncplane_home(struct ncplane * x0)
{
  ncplane_home(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_home(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_home(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_home _cffi_d_ncplane_home
#endif

static int _cffi_d_ncplane_mergedown(struct ncplane * x0, struct ncplane * x1, int x2, int x3, unsigned int x4, unsigned int x5, int x6, int x7)
{
  return ncplane_mergedown(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_mergedown(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane * x1;
  int x2;
  int x3;
  unsigned int x4;
  unsigned int x5;
  int x6;
  int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ncplane_mergedown", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_mergedown(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_mergedown _cffi_d_ncplane_mergedown
#endif

static int _cffi_d_ncplane_mergedown_simple(struct ncplane * x0, struct ncplane * x1)
{
  return ncplane_mergedown_simple(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_mergedown_simple(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_mergedown_simple", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_mergedown_simple(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_mergedown_simple _cffi_d_ncplane_mergedown_simple
#endif

static int _cffi_d_ncplane_move_above(struct ncplane * x0, struct ncplane * x1)
{
  return ncplane_move_above(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_above(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_move_above", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_move_above(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_move_above _cffi_d_ncplane_move_above
#endif

static int _cffi_d_ncplane_move_below(struct ncplane * x0, struct ncplane * x1)
{
  return ncplane_move_below(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_below(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_move_below", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_move_below(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_move_below _cffi_d_ncplane_move_below
#endif

static void _cffi_d_ncplane_move_bottom(struct ncplane * x0)
{
  ncplane_move_bottom(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_bottom(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_move_bottom(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_move_bottom _cffi_d_ncplane_move_bottom
#endif

static int _cffi_d_ncplane_move_family_above(struct ncplane * x0, struct ncplane * x1)
{
  return ncplane_move_family_above(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_family_above(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_move_family_above", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_move_family_above(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_move_family_above _cffi_d_ncplane_move_family_above
#endif

static int _cffi_d_ncplane_move_family_below(struct ncplane * x0, struct ncplane * x1)
{
  return ncplane_move_family_below(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_family_below(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_move_family_below", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_move_family_below(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_move_family_below _cffi_d_ncplane_move_family_below
#endif

static void _cffi_d_ncplane_move_family_bottom(struct ncplane * x0)
{
  ncplane_move_family_bottom(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_family_bottom(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_move_family_bottom(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_move_family_bottom _cffi_d_ncplane_move_family_bottom
#endif

static void _cffi_d_ncplane_move_family_top(struct ncplane * x0)
{
  ncplane_move_family_top(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_family_top(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_move_family_top(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_move_family_top _cffi_d_ncplane_move_family_top
#endif

static int _cffi_d_ncplane_move_rel(struct ncplane * x0, int x1, int x2)
{
  return ncplane_move_rel(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_rel(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_move_rel", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_move_rel(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_move_rel _cffi_d_ncplane_move_rel
#endif

static void _cffi_d_ncplane_move_top(struct ncplane * x0)
{
  ncplane_move_top(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_top(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_move_top(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_move_top _cffi_d_ncplane_move_top
#endif

static int _cffi_d_ncplane_move_yx(struct ncplane * x0, int x1, int x2)
{
  return ncplane_move_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_move_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_move_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_move_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_move_yx _cffi_d_ncplane_move_yx
#endif

static char * _cffi_d_ncplane_name(struct ncplane const * x0)
{
  return ncplane_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_name(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_name _cffi_d_ncplane_name
#endif

static struct notcurses * _cffi_d_ncplane_notcurses(struct ncplane const * x0)
{
  return ncplane_notcurses(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_notcurses(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct notcurses * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_notcurses(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(110));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_notcurses _cffi_d_ncplane_notcurses
#endif

static struct notcurses const * _cffi_d_ncplane_notcurses_const(struct ncplane const * x0)
{
  return ncplane_notcurses_const(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_notcurses_const(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct notcurses const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_notcurses_const(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(59));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_notcurses_const _cffi_d_ncplane_notcurses_const
#endif

static void _cffi_d_ncplane_off_styles(struct ncplane * x0, unsigned int x1)
{
  ncplane_off_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_off_styles(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_off_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_off_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_off_styles _cffi_d_ncplane_off_styles
#endif

static void _cffi_d_ncplane_on_styles(struct ncplane * x0, unsigned int x1)
{
  ncplane_on_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_on_styles(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_on_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_on_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_on_styles _cffi_d_ncplane_on_styles
#endif

static struct ncplane * _cffi_d_ncplane_parent(struct ncplane * x0)
{
  return ncplane_parent(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_parent(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_parent(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_parent _cffi_d_ncplane_parent
#endif

static struct ncplane const * _cffi_d_ncplane_parent_const(struct ncplane const * x0)
{
  return ncplane_parent_const(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_parent_const(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_parent_const(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_parent_const _cffi_d_ncplane_parent_const
#endif

static int _cffi_d_ncplane_perimeter(struct ncplane * x0, nccell const * x1, nccell const * x2, nccell const * x3, nccell const * x4, nccell const * x5, nccell const * x6, unsigned int x7)
{
  return ncplane_perimeter(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_perimeter(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  nccell const * x2;
  nccell const * x3;
  nccell const * x4;
  nccell const * x5;
  nccell const * x6;
  unsigned int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ncplane_perimeter", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_perimeter(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_perimeter _cffi_d_ncplane_perimeter
#endif

static int _cffi_d_ncplane_perimeter_double(struct ncplane * x0, uint16_t x1, uint64_t x2, unsigned int x3)
{
  return ncplane_perimeter_double(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_perimeter_double(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_perimeter_double", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_perimeter_double(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_perimeter_double _cffi_d_ncplane_perimeter_double
#endif

static int _cffi_d_ncplane_perimeter_rounded(struct ncplane * x0, uint16_t x1, uint64_t x2, unsigned int x3)
{
  return ncplane_perimeter_rounded(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_perimeter_rounded(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_perimeter_rounded", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_perimeter_rounded(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_perimeter_rounded _cffi_d_ncplane_perimeter_rounded
#endif

static void _cffi_d_ncplane_pixel_geom(struct ncplane const * x0, unsigned int * x1, unsigned int * x2, unsigned int * x3, unsigned int * x4, unsigned int * x5, unsigned int * x6)
{
  ncplane_pixel_geom(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_pixel_geom(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  unsigned int * x1;
  unsigned int * x2;
  unsigned int * x3;
  unsigned int * x4;
  unsigned int * x5;
  unsigned int * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ncplane_pixel_geom", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_pixel_geom(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_pixel_geom _cffi_d_ncplane_pixel_geom
#endif

static int _cffi_d_ncplane_polyfill_yx(struct ncplane * x0, int x1, int x2, nccell const * x3)
{
  return ncplane_polyfill_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_polyfill_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  nccell const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_polyfill_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_polyfill_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_polyfill_yx _cffi_d_ncplane_polyfill_yx
#endif

static void _cffi_const_ncplane_printf(char *o)
{
  *(int(* *)(struct ncplane *, char const *, ...))o = ncplane_printf;
}

static void _cffi_const_ncplane_printf_aligned(char *o)
{
  *(int(* *)(struct ncplane *, int, ncalign_e, char const *, ...))o = ncplane_printf_aligned;
}

static void _cffi_const_ncplane_printf_stained(char *o)
{
  *(int(* *)(struct ncplane *, char const *, ...))o = ncplane_printf_stained;
}

static void _cffi_const_ncplane_printf_yx(char *o)
{
  *(int(* *)(struct ncplane *, int, int, char const *, ...))o = ncplane_printf_yx;
}

static int _cffi_d_ncplane_pulse(struct ncplane * x0, struct timespec const * x1, int(* x2)(struct notcurses *, struct ncplane *, struct timespec const *, void *), void * x3)
{
  return ncplane_pulse(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_pulse(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct timespec const * x1;
  int(* x2)(struct notcurses *, struct ncplane *, struct timespec const *, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_pulse", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(706), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(706), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))_cffi_to_c_pointer(arg2, _cffi_type(683));
  if (x2 == (int(*)(struct notcurses *, struct ncplane *, struct timespec const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_pulse(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_pulse _cffi_d_ncplane_pulse
#endif

static int _cffi_d_ncplane_putc(struct ncplane * x0, nccell const * x1)
{
  return ncplane_putc(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putc(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putc", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putc(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putc _cffi_d_ncplane_putc
#endif

static int _cffi_d_ncplane_putc_yx(struct ncplane * x0, int x1, int x2, nccell const * x3)
{
  return ncplane_putc_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putc_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  nccell const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_putc_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putc_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putc_yx _cffi_d_ncplane_putc_yx
#endif

static int _cffi_d_ncplane_putchar(struct ncplane * x0, char x1)
{
  return ncplane_putchar(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putchar(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putchar", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (char)_cffi_to_c_char(arg1);
  if (x1 == (char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putchar(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putchar _cffi_d_ncplane_putchar
#endif

static int _cffi_d_ncplane_putchar_stained(struct ncplane * x0, char x1)
{
  return ncplane_putchar_stained(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putchar_stained(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putchar_stained", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (char)_cffi_to_c_char(arg1);
  if (x1 == (char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putchar_stained(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putchar_stained _cffi_d_ncplane_putchar_stained
#endif

static int _cffi_d_ncplane_putchar_yx(struct ncplane * x0, int x1, int x2, char x3)
{
  return ncplane_putchar_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putchar_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  char x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_putchar_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (char)_cffi_to_c_char(arg3);
  if (x3 == (char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putchar_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putchar_yx _cffi_d_ncplane_putchar_yx
#endif

static int _cffi_d_ncplane_putegc(struct ncplane * x0, char const * x1, size_t * x2)
{
  return ncplane_putegc(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putegc(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char const * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_putegc", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(390), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(390), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putegc(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putegc _cffi_d_ncplane_putegc
#endif

static int _cffi_d_ncplane_putegc_stained(struct ncplane * x0, char const * x1, size_t * x2)
{
  return ncplane_putegc_stained(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putegc_stained(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char const * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_putegc_stained", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(390), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(390), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putegc_stained(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putegc_stained _cffi_d_ncplane_putegc_stained
#endif

static int _cffi_d_ncplane_putegc_yx(struct ncplane * x0, int x1, int x2, char const * x3, size_t * x4)
{
  return ncplane_putegc_yx(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putegc_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  char const * x3;
  size_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_putegc_yx", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(390), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(390), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putegc_yx(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putegc_yx _cffi_d_ncplane_putegc_yx
#endif

static int _cffi_d_ncplane_putnstr(struct ncplane * x0, size_t x1, char const * x2)
{
  return ncplane_putnstr(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putnstr(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  size_t x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_putnstr", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putnstr(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putnstr _cffi_d_ncplane_putnstr
#endif

static int _cffi_d_ncplane_putnstr_aligned(struct ncplane * x0, int x1, ncalign_e x2, size_t x3, char const * x4)
{
  return ncplane_putnstr_aligned(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putnstr_aligned(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  ncalign_e x2;
  size_t x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_putnstr_aligned", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(194), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putnstr_aligned(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putnstr_aligned _cffi_d_ncplane_putnstr_aligned
#endif

static int _cffi_d_ncplane_putnstr_yx(struct ncplane * x0, int x1, int x2, size_t x3, char const * x4)
{
  return ncplane_putnstr_yx(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putnstr_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  size_t x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_putnstr_yx", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putnstr_yx(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putnstr_yx _cffi_d_ncplane_putnstr_yx
#endif

static int _cffi_d_ncplane_putstr(struct ncplane * x0, char const * x1)
{
  return ncplane_putstr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putstr(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putstr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putstr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putstr _cffi_d_ncplane_putstr
#endif

static int _cffi_d_ncplane_putstr_aligned(struct ncplane * x0, int x1, ncalign_e x2, char const * x3)
{
  return ncplane_putstr_aligned(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putstr_aligned(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  ncalign_e x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_putstr_aligned", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(194), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putstr_aligned(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putstr_aligned _cffi_d_ncplane_putstr_aligned
#endif

static int _cffi_d_ncplane_putstr_stained(struct ncplane * x0, char const * x1)
{
  return ncplane_putstr_stained(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putstr_stained(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putstr_stained", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putstr_stained(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putstr_stained _cffi_d_ncplane_putstr_stained
#endif

static int _cffi_d_ncplane_putstr_yx(struct ncplane * x0, int x1, int x2, char const * x3)
{
  return ncplane_putstr_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putstr_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_putstr_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putstr_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putstr_yx _cffi_d_ncplane_putstr_yx
#endif

static int _cffi_d_ncplane_puttext(struct ncplane * x0, int x1, ncalign_e x2, char const * x3, size_t * x4)
{
  return ncplane_puttext(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_puttext(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  ncalign_e x2;
  char const * x3;
  size_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_puttext", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(194), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(390), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(390), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_puttext(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_puttext _cffi_d_ncplane_puttext
#endif

static int _cffi_d_ncplane_pututf32_yx(struct ncplane * x0, int x1, int x2, uint32_t x3)
{
  return ncplane_pututf32_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_pututf32_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_pututf32_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_pututf32_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_pututf32_yx _cffi_d_ncplane_pututf32_yx
#endif

static int _cffi_d_ncplane_putwc(struct ncplane * x0, wchar_t x1)
{
  return ncplane_putwc(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwc(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  wchar_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putwc", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (wchar_t)_cffi_to_c_wchar_t(arg1);
  if (x1 == (wchar_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwc(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwc _cffi_d_ncplane_putwc
#endif

static int _cffi_d_ncplane_putwc_stained(struct ncplane * x0, wchar_t x1)
{
  return ncplane_putwc_stained(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwc_stained(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  wchar_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putwc_stained", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (wchar_t)_cffi_to_c_wchar_t(arg1);
  if (x1 == (wchar_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwc_stained(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwc_stained _cffi_d_ncplane_putwc_stained
#endif

static int _cffi_d_ncplane_putwc_utf32(struct ncplane * x0, wchar_t const * x1, unsigned int * x2)
{
  return ncplane_putwc_utf32(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwc_utf32(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  wchar_t const * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_putwc_utf32", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwc_utf32(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwc_utf32 _cffi_d_ncplane_putwc_utf32
#endif

static int _cffi_d_ncplane_putwc_yx(struct ncplane * x0, int x1, int x2, wchar_t x3)
{
  return ncplane_putwc_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwc_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  wchar_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_putwc_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (wchar_t)_cffi_to_c_wchar_t(arg3);
  if (x3 == (wchar_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwc_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwc_yx _cffi_d_ncplane_putwc_yx
#endif

static int _cffi_d_ncplane_putwegc(struct ncplane * x0, wchar_t const * x1, size_t * x2)
{
  return ncplane_putwegc(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwegc(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  wchar_t const * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_putwegc", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(390), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(390), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwegc(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwegc _cffi_d_ncplane_putwegc
#endif

static int _cffi_d_ncplane_putwegc_stained(struct ncplane * x0, wchar_t const * x1, size_t * x2)
{
  return ncplane_putwegc_stained(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwegc_stained(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  wchar_t const * x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_putwegc_stained", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(390), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(390), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwegc_stained(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwegc_stained _cffi_d_ncplane_putwegc_stained
#endif

static int _cffi_d_ncplane_putwegc_yx(struct ncplane * x0, int x1, int x2, wchar_t const * x3, size_t * x4)
{
  return ncplane_putwegc_yx(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwegc_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  wchar_t const * x3;
  size_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_putwegc_yx", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(390), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(390), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwegc_yx(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwegc_yx _cffi_d_ncplane_putwegc_yx
#endif

static int _cffi_d_ncplane_putwstr(struct ncplane * x0, wchar_t const * x1)
{
  return ncplane_putwstr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwstr(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  wchar_t const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putwstr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwstr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwstr _cffi_d_ncplane_putwstr
#endif

static int _cffi_d_ncplane_putwstr_aligned(struct ncplane * x0, int x1, ncalign_e x2, wchar_t const * x3)
{
  return ncplane_putwstr_aligned(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwstr_aligned(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  ncalign_e x2;
  wchar_t const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_putwstr_aligned", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(194), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwstr_aligned(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwstr_aligned _cffi_d_ncplane_putwstr_aligned
#endif

static int _cffi_d_ncplane_putwstr_stained(struct ncplane * x0, wchar_t const * x1)
{
  return ncplane_putwstr_stained(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwstr_stained(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  wchar_t const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_putwstr_stained", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwstr_stained(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwstr_stained _cffi_d_ncplane_putwstr_stained
#endif

static int _cffi_d_ncplane_putwstr_yx(struct ncplane * x0, int x1, int x2, wchar_t const * x3)
{
  return ncplane_putwstr_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_putwstr_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  wchar_t const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_putwstr_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_putwstr_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_putwstr_yx _cffi_d_ncplane_putwstr_yx
#endif

static int _cffi_d_ncplane_qrcode(struct ncplane * x0, unsigned int * x1, unsigned int * x2, void const * x3, size_t x4)
{
  return ncplane_qrcode(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_qrcode(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int * x1;
  unsigned int * x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_qrcode", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_qrcode(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_qrcode _cffi_d_ncplane_qrcode
#endif

static struct ncplane * _cffi_d_ncplane_reparent(struct ncplane * x0, struct ncplane * x1)
{
  return ncplane_reparent(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_reparent(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_reparent", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_reparent(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_reparent _cffi_d_ncplane_reparent
#endif

static struct ncplane * _cffi_d_ncplane_reparent_family(struct ncplane * x0, struct ncplane * x1)
{
  return ncplane_reparent_family(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_reparent_family(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_reparent_family", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_reparent_family(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_reparent_family _cffi_d_ncplane_reparent_family
#endif

static int _cffi_d_ncplane_resize(struct ncplane * x0, int x1, int x2, unsigned int x3, unsigned int x4, int x5, int x6, unsigned int x7, unsigned int x8)
{
  return ncplane_resize(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_resize(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  unsigned int x3;
  unsigned int x4;
  int x5;
  int x6;
  unsigned int x7;
  unsigned int x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "ncplane_resize", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, unsigned int);
  if (x7 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, unsigned int);
  if (x8 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_resize(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_resize _cffi_d_ncplane_resize
#endif

static int _cffi_d_ncplane_resize_marginalized(struct ncplane * x0)
{
  return ncplane_resize_marginalized(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_resize_marginalized(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_resize_marginalized(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_resize_marginalized _cffi_d_ncplane_resize_marginalized
#endif

static int _cffi_d_ncplane_resize_maximize(struct ncplane * x0)
{
  return ncplane_resize_maximize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_resize_maximize(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_resize_maximize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_resize_maximize _cffi_d_ncplane_resize_maximize
#endif

static int _cffi_d_ncplane_resize_placewithin(struct ncplane * x0)
{
  return ncplane_resize_placewithin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_resize_placewithin(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_resize_placewithin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_resize_placewithin _cffi_d_ncplane_resize_placewithin
#endif

static int _cffi_d_ncplane_resize_realign(struct ncplane * x0)
{
  return ncplane_resize_realign(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_resize_realign(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_resize_realign(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_resize_realign _cffi_d_ncplane_resize_realign
#endif

static int _cffi_d_ncplane_resize_simple(struct ncplane * x0, unsigned int x1, unsigned int x2)
{
  return ncplane_resize_simple(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_resize_simple(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_resize_simple", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_resize_simple(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_resize_simple _cffi_d_ncplane_resize_simple
#endif

static int(* _cffi_d_ncplane_resizecb(struct ncplane const * x0))(struct ncplane *)
{
  return ncplane_resizecb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_resizecb(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int(* result)(struct ncplane *);
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_resizecb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1517));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_resizecb _cffi_d_ncplane_resizecb
#endif

static int _cffi_d_ncplane_rotate_ccw(struct ncplane * x0)
{
  return ncplane_rotate_ccw(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_rotate_ccw(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_rotate_ccw(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_rotate_ccw _cffi_d_ncplane_rotate_ccw
#endif

static int _cffi_d_ncplane_rotate_cw(struct ncplane * x0)
{
  return ncplane_rotate_cw(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_rotate_cw(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_rotate_cw(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_rotate_cw _cffi_d_ncplane_rotate_cw
#endif

static int _cffi_d_ncplane_rounded_box(struct ncplane * x0, uint16_t x1, uint64_t x2, unsigned int x3, unsigned int x4, unsigned int x5)
{
  return ncplane_rounded_box(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_rounded_box(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  unsigned int x3;
  unsigned int x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncplane_rounded_box", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_rounded_box(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_rounded_box _cffi_d_ncplane_rounded_box
#endif

static int _cffi_d_ncplane_rounded_box_sized(struct ncplane * x0, uint16_t x1, uint64_t x2, unsigned int x3, unsigned int x4, unsigned int x5)
{
  return ncplane_rounded_box_sized(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_rounded_box_sized(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint16_t x1;
  uint64_t x2;
  unsigned int x3;
  unsigned int x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncplane_rounded_box_sized", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint16_t);
  if (x1 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_rounded_box_sized(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_rounded_box_sized _cffi_d_ncplane_rounded_box_sized
#endif

static _Bool _cffi_d_ncplane_scrolling_p(struct ncplane const * x0)
{
  return ncplane_scrolling_p(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_scrolling_p(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_scrolling_p(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_scrolling_p _cffi_d_ncplane_scrolling_p
#endif

static int _cffi_d_ncplane_scrollup(struct ncplane * x0, int x1)
{
  return ncplane_scrollup(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_scrollup(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_scrollup", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_scrollup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_scrollup _cffi_d_ncplane_scrollup
#endif

static int _cffi_d_ncplane_scrollup_child(struct ncplane * x0, struct ncplane const * x1)
{
  return ncplane_scrollup_child(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_scrollup_child(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncplane const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_scrollup_child", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_scrollup_child(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_scrollup_child _cffi_d_ncplane_scrollup_child
#endif

static _Bool _cffi_d_ncplane_set_autogrow(struct ncplane * x0, unsigned int x1)
{
  return ncplane_set_autogrow(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_autogrow(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_autogrow", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_autogrow(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_autogrow _cffi_d_ncplane_set_autogrow
#endif

static int _cffi_d_ncplane_set_base(struct ncplane * x0, char const * x1, uint16_t x2, uint64_t x3)
{
  return ncplane_set_base(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_base(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char const * x1;
  uint16_t x2;
  uint64_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_set_base", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint16_t);
  if (x2 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_base(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_base _cffi_d_ncplane_set_base
#endif

static int _cffi_d_ncplane_set_base_cell(struct ncplane * x0, nccell const * x1)
{
  return ncplane_set_base_cell(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_base_cell(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_base_cell", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_base_cell(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_base_cell _cffi_d_ncplane_set_base_cell
#endif

static uint64_t _cffi_d_ncplane_set_bchannel(struct ncplane * x0, uint32_t x1)
{
  return ncplane_set_bchannel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_bchannel(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_bchannel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_bchannel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_bchannel _cffi_d_ncplane_set_bchannel
#endif

static int _cffi_d_ncplane_set_bg_alpha(struct ncplane * x0, int x1)
{
  return ncplane_set_bg_alpha(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_bg_alpha(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_bg_alpha", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_bg_alpha(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_bg_alpha _cffi_d_ncplane_set_bg_alpha
#endif

static void _cffi_d_ncplane_set_bg_default(struct ncplane * x0)
{
  ncplane_set_bg_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_bg_default(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_set_bg_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_set_bg_default _cffi_d_ncplane_set_bg_default
#endif

static int _cffi_d_ncplane_set_bg_palindex(struct ncplane * x0, unsigned int x1)
{
  return ncplane_set_bg_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_bg_palindex(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_bg_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_bg_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_bg_palindex _cffi_d_ncplane_set_bg_palindex
#endif

static int _cffi_d_ncplane_set_bg_rgb(struct ncplane * x0, uint32_t x1)
{
  return ncplane_set_bg_rgb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_bg_rgb(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_bg_rgb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_bg_rgb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_bg_rgb _cffi_d_ncplane_set_bg_rgb
#endif

static int _cffi_d_ncplane_set_bg_rgb8(struct ncplane * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return ncplane_set_bg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_bg_rgb8(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_set_bg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_bg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_bg_rgb8 _cffi_d_ncplane_set_bg_rgb8
#endif

static void _cffi_d_ncplane_set_bg_rgb8_clipped(struct ncplane * x0, int x1, int x2, int x3)
{
  ncplane_set_bg_rgb8_clipped(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_bg_rgb8_clipped(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_set_bg_rgb8_clipped", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_set_bg_rgb8_clipped(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_set_bg_rgb8_clipped _cffi_d_ncplane_set_bg_rgb8_clipped
#endif

static void _cffi_d_ncplane_set_channels(struct ncplane * x0, uint64_t x1)
{
  ncplane_set_channels(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_channels(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_channels", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_set_channels(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_set_channels _cffi_d_ncplane_set_channels
#endif

static uint64_t _cffi_d_ncplane_set_fchannel(struct ncplane * x0, uint32_t x1)
{
  return ncplane_set_fchannel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_fchannel(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_fchannel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_fchannel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_fchannel _cffi_d_ncplane_set_fchannel
#endif

static int _cffi_d_ncplane_set_fg_alpha(struct ncplane * x0, int x1)
{
  return ncplane_set_fg_alpha(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_fg_alpha(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_fg_alpha", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_fg_alpha(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_fg_alpha _cffi_d_ncplane_set_fg_alpha
#endif

static void _cffi_d_ncplane_set_fg_default(struct ncplane * x0)
{
  ncplane_set_fg_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_fg_default(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_set_fg_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_set_fg_default _cffi_d_ncplane_set_fg_default
#endif

static int _cffi_d_ncplane_set_fg_palindex(struct ncplane * x0, unsigned int x1)
{
  return ncplane_set_fg_palindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_fg_palindex(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_fg_palindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_fg_palindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_fg_palindex _cffi_d_ncplane_set_fg_palindex
#endif

static int _cffi_d_ncplane_set_fg_rgb(struct ncplane * x0, uint32_t x1)
{
  return ncplane_set_fg_rgb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_fg_rgb(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_fg_rgb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_fg_rgb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_fg_rgb _cffi_d_ncplane_set_fg_rgb
#endif

static int _cffi_d_ncplane_set_fg_rgb8(struct ncplane * x0, unsigned int x1, unsigned int x2, unsigned int x3)
{
  return ncplane_set_fg_rgb8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_fg_rgb8(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  unsigned int x2;
  unsigned int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_set_fg_rgb8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_fg_rgb8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_fg_rgb8 _cffi_d_ncplane_set_fg_rgb8
#endif

static void _cffi_d_ncplane_set_fg_rgb8_clipped(struct ncplane * x0, int x1, int x2, int x3)
{
  ncplane_set_fg_rgb8_clipped(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_fg_rgb8_clipped(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_set_fg_rgb8_clipped", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_set_fg_rgb8_clipped(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_set_fg_rgb8_clipped _cffi_d_ncplane_set_fg_rgb8_clipped
#endif

static int _cffi_d_ncplane_set_name(struct ncplane * x0, char const * x1)
{
  return ncplane_set_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_name(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_name _cffi_d_ncplane_set_name
#endif

static void _cffi_d_ncplane_set_resizecb(struct ncplane * x0, int(* x1)(struct ncplane *))
{
  ncplane_set_resizecb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_resizecb(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int(* x1)(struct ncplane *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_resizecb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(struct ncplane *))_cffi_to_c_pointer(arg1, _cffi_type(1517));
  if (x1 == (int(*)(struct ncplane *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_set_resizecb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_set_resizecb _cffi_d_ncplane_set_resizecb
#endif

static _Bool _cffi_d_ncplane_set_scrolling(struct ncplane * x0, unsigned int x1)
{
  return ncplane_set_scrolling(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_scrolling(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_scrolling", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_scrolling(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_scrolling _cffi_d_ncplane_set_scrolling
#endif

static void _cffi_d_ncplane_set_styles(struct ncplane * x0, unsigned int x1)
{
  ncplane_set_styles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_styles(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_styles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_set_styles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_set_styles _cffi_d_ncplane_set_styles
#endif

static void * _cffi_d_ncplane_set_userptr(struct ncplane * x0, void * x1)
{
  return ncplane_set_userptr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_set_userptr(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncplane_set_userptr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_set_userptr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_set_userptr _cffi_d_ncplane_set_userptr
#endif

static int _cffi_d_ncplane_stain(struct ncplane * x0, int x1, int x2, unsigned int x3, unsigned int x4, uint64_t x5, uint64_t x6, uint64_t x7, uint64_t x8)
{
  return ncplane_stain(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_stain(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  unsigned int x3;
  unsigned int x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "ncplane_stain", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint64_t);
  if (x5 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint64_t);
  if (x6 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint64_t);
  if (x7 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, uint64_t);
  if (x8 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_stain(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_stain _cffi_d_ncplane_stain
#endif

static uint16_t _cffi_d_ncplane_styles(struct ncplane const * x0)
{
  return ncplane_styles(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_styles(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint16_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_styles(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint16_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_styles _cffi_d_ncplane_styles
#endif

static void _cffi_d_ncplane_translate(struct ncplane const * x0, struct ncplane const * x1, int * x2, int * x3)
{
  ncplane_translate(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_translate(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  struct ncplane const * x1;
  int * x2;
  int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncplane_translate", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_translate(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_translate _cffi_d_ncplane_translate
#endif

static _Bool _cffi_d_ncplane_translate_abs(struct ncplane const * x0, int * x1, int * x2)
{
  return ncplane_translate_abs(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_translate_abs(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_translate_abs", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_translate_abs(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_translate_abs _cffi_d_ncplane_translate_abs
#endif

static void * _cffi_d_ncplane_userptr(struct ncplane * x0)
{
  return ncplane_userptr(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_userptr(PyObject *self, PyObject *arg0)
{
  struct ncplane * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_userptr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_userptr _cffi_d_ncplane_userptr
#endif

static int _cffi_d_ncplane_valign(struct ncplane const * x0, ncalign_e x1, int x2)
{
  return ncplane_valign(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_valign(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  ncalign_e x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_valign", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(194), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_valign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_valign _cffi_d_ncplane_valign
#endif

static int _cffi_d_ncplane_vline(struct ncplane * x0, nccell const * x1, unsigned int x2)
{
  return ncplane_vline(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_vline(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_vline", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_vline(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_vline _cffi_d_ncplane_vline
#endif

static int _cffi_d_ncplane_vline_interp(struct ncplane * x0, nccell const * x1, unsigned int x2, uint64_t x3, uint64_t x4)
{
  return ncplane_vline_interp(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_vline_interp(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nccell const * x1;
  unsigned int x2;
  uint64_t x3;
  uint64_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_vline_interp", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nccell const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_vline_interp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_vline_interp _cffi_d_ncplane_vline_interp
#endif

static int _cffi_d_ncplane_vprintf(struct ncplane * x0, char const * x1, va_list x2)
{
  return ncplane_vprintf(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_vprintf(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char const * x1;
  va_list x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_vprintf", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(414), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_vprintf(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static int _cffi_f_ncplane_vprintf(struct ncplane * x0, char const * x1, va_list *x2)
{
  int result;
  { result = ncplane_vprintf(x0, x1, *x2); }
  return result;
}
#endif

static int _cffi_d_ncplane_vprintf_aligned(struct ncplane * x0, int x1, ncalign_e x2, char const * x3, va_list x4)
{
  return ncplane_vprintf_aligned(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_vprintf_aligned(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  ncalign_e x2;
  char const * x3;
  va_list x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_vprintf_aligned", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(194), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x4, _cffi_type(414), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_vprintf_aligned(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static int _cffi_f_ncplane_vprintf_aligned(struct ncplane * x0, int x1, ncalign_e x2, char const * x3, va_list *x4)
{
  int result;
  { result = ncplane_vprintf_aligned(x0, x1, x2, x3, *x4); }
  return result;
}
#endif

static int _cffi_d_ncplane_vprintf_stained(struct ncplane * x0, char const * x1, va_list x2)
{
  return ncplane_vprintf_stained(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_vprintf_stained(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  char const * x1;
  va_list x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_vprintf_stained", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(414), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_vprintf_stained(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static int _cffi_f_ncplane_vprintf_stained(struct ncplane * x0, char const * x1, va_list *x2)
{
  int result;
  { result = ncplane_vprintf_stained(x0, x1, *x2); }
  return result;
}
#endif

static int _cffi_d_ncplane_vprintf_yx(struct ncplane * x0, int x1, int x2, char const * x3, va_list x4)
{
  return ncplane_vprintf_yx(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_vprintf_yx(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  int x1;
  int x2;
  char const * x3;
  va_list x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncplane_vprintf_yx", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x4, _cffi_type(414), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_vprintf_yx(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static int _cffi_f_ncplane_vprintf_yx(struct ncplane * x0, int x1, int x2, char const * x3, va_list *x4)
{
  int result;
  { result = ncplane_vprintf_yx(x0, x1, x2, x3, *x4); }
  return result;
}
#endif

static int _cffi_d_ncplane_x(struct ncplane const * x0)
{
  return ncplane_x(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_x(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_x(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_x _cffi_d_ncplane_x
#endif

static int _cffi_d_ncplane_y(struct ncplane const * x0)
{
  return ncplane_y(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_y(PyObject *self, PyObject *arg0)
{
  struct ncplane const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncplane_y(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncplane_y _cffi_d_ncplane_y
#endif

static void _cffi_d_ncplane_yx(struct ncplane const * x0, int * x1, int * x2)
{
  ncplane_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncplane_yx(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncplane_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncplane_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncplane_yx _cffi_d_ncplane_yx
#endif

static struct ncprogbar * _cffi_d_ncprogbar_create(struct ncplane * x0, ncprogbar_options const * x1)
{
  return ncprogbar_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncprogbar_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncprogbar_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncprogbar * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncprogbar_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1185), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncprogbar_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1185), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncprogbar_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(809));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncprogbar_create _cffi_d_ncprogbar_create
#endif

static void _cffi_d_ncprogbar_destroy(struct ncprogbar * x0)
{
  ncprogbar_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncprogbar_destroy(PyObject *self, PyObject *arg0)
{
  struct ncprogbar * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(809), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncprogbar *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(809), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncprogbar_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncprogbar_destroy _cffi_d_ncprogbar_destroy
#endif

static struct ncplane * _cffi_d_ncprogbar_plane(struct ncprogbar * x0)
{
  return ncprogbar_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncprogbar_plane(PyObject *self, PyObject *arg0)
{
  struct ncprogbar * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(809), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncprogbar *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(809), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncprogbar_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncprogbar_plane _cffi_d_ncprogbar_plane
#endif

static double _cffi_d_ncprogbar_progress(struct ncprogbar const * x0)
{
  return ncprogbar_progress(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncprogbar_progress(PyObject *self, PyObject *arg0)
{
  struct ncprogbar const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(173), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncprogbar const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(173), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncprogbar_progress(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncprogbar_progress _cffi_d_ncprogbar_progress
#endif

static int _cffi_d_ncprogbar_set_progress(struct ncprogbar * x0, double x1)
{
  return ncprogbar_set_progress(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncprogbar_set_progress(PyObject *self, PyObject *args)
{
  struct ncprogbar * x0;
  double x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncprogbar_set_progress", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(809), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncprogbar *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(809), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncprogbar_set_progress(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncprogbar_set_progress _cffi_d_ncprogbar_set_progress
#endif

static char const * _cffi_d_ncqprefix(uintmax_t x0, uintmax_t x1, char * x2, int x3)
{
  return ncqprefix(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncqprefix(PyObject *self, PyObject *args)
{
  uintmax_t x0;
  uintmax_t x1;
  char * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncqprefix", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uintmax_t);
  if (x0 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, uintmax_t);
  if (x1 == (uintmax_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncqprefix(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncqprefix _cffi_d_ncqprefix
#endif

static int _cffi_d_ncreader_clear(struct ncreader * x0)
{
  return ncreader_clear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_clear(PyObject *self, PyObject *arg0)
{
  struct ncreader * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_clear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_clear _cffi_d_ncreader_clear
#endif

static char * _cffi_d_ncreader_contents(struct ncreader const * x0)
{
  return ncreader_contents(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_contents(PyObject *self, PyObject *arg0)
{
  struct ncreader const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_contents(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_contents _cffi_d_ncreader_contents
#endif

static struct ncreader * _cffi_d_ncreader_create(struct ncplane * x0, ncreader_options const * x1)
{
  return ncreader_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncreader_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncreader * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncreader_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1189), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncreader_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1189), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(43));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_create _cffi_d_ncreader_create
#endif

static void _cffi_d_ncreader_destroy(struct ncreader * x0, char * * x1)
{
  ncreader_destroy(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_destroy(PyObject *self, PyObject *args)
{
  struct ncreader * x0;
  char * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncreader_destroy", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(389), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(389), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncreader_destroy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncreader_destroy _cffi_d_ncreader_destroy
#endif

static int _cffi_d_ncreader_move_down(struct ncreader * x0)
{
  return ncreader_move_down(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_move_down(PyObject *self, PyObject *arg0)
{
  struct ncreader * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_move_down(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_move_down _cffi_d_ncreader_move_down
#endif

static int _cffi_d_ncreader_move_left(struct ncreader * x0)
{
  return ncreader_move_left(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_move_left(PyObject *self, PyObject *arg0)
{
  struct ncreader * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_move_left(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_move_left _cffi_d_ncreader_move_left
#endif

static int _cffi_d_ncreader_move_right(struct ncreader * x0)
{
  return ncreader_move_right(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_move_right(PyObject *self, PyObject *arg0)
{
  struct ncreader * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_move_right(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_move_right _cffi_d_ncreader_move_right
#endif

static int _cffi_d_ncreader_move_up(struct ncreader * x0)
{
  return ncreader_move_up(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_move_up(PyObject *self, PyObject *arg0)
{
  struct ncreader * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_move_up(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_move_up _cffi_d_ncreader_move_up
#endif

static _Bool _cffi_d_ncreader_offer_input(struct ncreader * x0, ncinput const * x1)
{
  return ncreader_offer_input(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_offer_input(PyObject *self, PyObject *args)
{
  struct ncreader * x0;
  ncinput const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncreader_offer_input", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_offer_input(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_offer_input _cffi_d_ncreader_offer_input
#endif

static struct ncplane * _cffi_d_ncreader_plane(struct ncreader * x0)
{
  return ncreader_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_plane(PyObject *self, PyObject *arg0)
{
  struct ncreader * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_plane _cffi_d_ncreader_plane
#endif

static int _cffi_d_ncreader_write_egc(struct ncreader * x0, char const * x1)
{
  return ncreader_write_egc(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreader_write_egc(PyObject *self, PyObject *args)
{
  struct ncreader * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncreader_write_egc", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreader_write_egc(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreader_write_egc _cffi_d_ncreader_write_egc
#endif

static struct nctablet * _cffi_d_ncreel_add(struct ncreel * x0, struct nctablet * x1, struct nctablet * x2, int(* x3)(struct nctablet *, _Bool), void * x4)
{
  return ncreel_add(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_add(PyObject *self, PyObject *args)
{
  struct ncreel * x0;
  struct nctablet * x1;
  struct nctablet * x2;
  int(* x3)(struct nctablet *, _Bool);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctablet * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncreel_add", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(824), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct nctablet *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(824), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(824), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct nctablet *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(824), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (int(*)(struct nctablet *, _Bool))_cffi_to_c_pointer(arg3, _cffi_type(1245));
  if (x3 == (int(*)(struct nctablet *, _Bool))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_add(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(824));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_add _cffi_d_ncreel_add
#endif

static struct ncreel * _cffi_d_ncreel_create(struct ncplane * x0, ncreel_options const * x1)
{
  return ncreel_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncreel_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncreel * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncreel_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1193), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncreel_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1193), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(47));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_create _cffi_d_ncreel_create
#endif

static int _cffi_d_ncreel_del(struct ncreel * x0, struct nctablet * x1)
{
  return ncreel_del(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_del(PyObject *self, PyObject *args)
{
  struct ncreel * x0;
  struct nctablet * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncreel_del", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(824), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct nctablet *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(824), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_del(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_del _cffi_d_ncreel_del
#endif

static void _cffi_d_ncreel_destroy(struct ncreel * x0)
{
  ncreel_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_destroy(PyObject *self, PyObject *arg0)
{
  struct ncreel * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncreel_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncreel_destroy _cffi_d_ncreel_destroy
#endif

static struct nctablet * _cffi_d_ncreel_focused(struct ncreel * x0)
{
  return ncreel_focused(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_focused(PyObject *self, PyObject *arg0)
{
  struct ncreel * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctablet * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_focused(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(824));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_focused _cffi_d_ncreel_focused
#endif

static struct nctablet * _cffi_d_ncreel_next(struct ncreel * x0)
{
  return ncreel_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_next(PyObject *self, PyObject *arg0)
{
  struct ncreel * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctablet * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(824));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_next _cffi_d_ncreel_next
#endif

static _Bool _cffi_d_ncreel_offer_input(struct ncreel * x0, ncinput const * x1)
{
  return ncreel_offer_input(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_offer_input(PyObject *self, PyObject *args)
{
  struct ncreel * x0;
  ncinput const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncreel_offer_input", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_offer_input(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_offer_input _cffi_d_ncreel_offer_input
#endif

static struct ncplane * _cffi_d_ncreel_plane(struct ncreel * x0)
{
  return ncreel_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_plane(PyObject *self, PyObject *arg0)
{
  struct ncreel * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_plane _cffi_d_ncreel_plane
#endif

static struct nctablet * _cffi_d_ncreel_prev(struct ncreel * x0)
{
  return ncreel_prev(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_prev(PyObject *self, PyObject *arg0)
{
  struct ncreel * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctablet * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_prev(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(824));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_prev _cffi_d_ncreel_prev
#endif

static int _cffi_d_ncreel_redraw(struct ncreel * x0)
{
  return ncreel_redraw(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_redraw(PyObject *self, PyObject *arg0)
{
  struct ncreel * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_redraw(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_redraw _cffi_d_ncreel_redraw
#endif

static int _cffi_d_ncreel_tabletcount(struct ncreel const * x0)
{
  return ncreel_tabletcount(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncreel_tabletcount(PyObject *self, PyObject *arg0)
{
  struct ncreel const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(827), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncreel const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(827), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncreel_tabletcount(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncreel_tabletcount _cffi_d_ncreel_tabletcount
#endif

static int _cffi_d_ncselector_additem(struct ncselector * x0, struct ncselector_item const * x1)
{
  return ncselector_additem(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_additem(PyObject *self, PyObject *args)
{
  struct ncselector * x0;
  struct ncselector_item const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncselector_additem", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(835), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncselector_item const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(835), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncselector_additem(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncselector_additem _cffi_d_ncselector_additem
#endif

static struct ncselector * _cffi_d_ncselector_create(struct ncplane * x0, ncselector_options const * x1)
{
  return ncselector_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncselector_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncselector * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncselector_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1197), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncselector_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1197), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncselector_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(51));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncselector_create _cffi_d_ncselector_create
#endif

static int _cffi_d_ncselector_delitem(struct ncselector * x0, char const * x1)
{
  return ncselector_delitem(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_delitem(PyObject *self, PyObject *args)
{
  struct ncselector * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncselector_delitem", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncselector_delitem(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncselector_delitem _cffi_d_ncselector_delitem
#endif

static void _cffi_d_ncselector_destroy(struct ncselector * x0, char * * x1)
{
  ncselector_destroy(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_destroy(PyObject *self, PyObject *args)
{
  struct ncselector * x0;
  char * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncselector_destroy", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(389), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(389), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncselector_destroy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncselector_destroy _cffi_d_ncselector_destroy
#endif

static char const * _cffi_d_ncselector_nextitem(struct ncselector * x0)
{
  return ncselector_nextitem(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_nextitem(PyObject *self, PyObject *arg0)
{
  struct ncselector * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncselector_nextitem(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncselector_nextitem _cffi_d_ncselector_nextitem
#endif

static _Bool _cffi_d_ncselector_offer_input(struct ncselector * x0, ncinput const * x1)
{
  return ncselector_offer_input(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_offer_input(PyObject *self, PyObject *args)
{
  struct ncselector * x0;
  ncinput const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncselector_offer_input", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncselector_offer_input(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncselector_offer_input _cffi_d_ncselector_offer_input
#endif

static struct ncplane * _cffi_d_ncselector_plane(struct ncselector * x0)
{
  return ncselector_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_plane(PyObject *self, PyObject *arg0)
{
  struct ncselector * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncselector_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncselector_plane _cffi_d_ncselector_plane
#endif

static char const * _cffi_d_ncselector_previtem(struct ncselector * x0)
{
  return ncselector_previtem(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_previtem(PyObject *self, PyObject *arg0)
{
  struct ncselector * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncselector *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncselector_previtem(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncselector_previtem _cffi_d_ncselector_previtem
#endif

static char const * _cffi_d_ncselector_selected(struct ncselector const * x0)
{
  return ncselector_selected(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncselector_selected(PyObject *self, PyObject *arg0)
{
  struct ncselector const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(147), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncselector const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(147), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncselector_selected(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncselector_selected _cffi_d_ncselector_selected
#endif

static int _cffi_d_ncstrwidth(char const * x0, int * x1, int * x2)
{
  return ncstrwidth(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncstrwidth(PyObject *self, PyObject *args)
{
  char const * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncstrwidth", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncstrwidth(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncstrwidth _cffi_d_ncstrwidth
#endif

static struct ncsubproc * _cffi_d_ncsubproc_createv(struct ncplane * x0, ncsubproc_options const * x1, char const * x2, char const * const * x3, int(* x4)(struct ncfdplane *, void const *, size_t, void *), int(* x5)(struct ncfdplane *, int, void *))
{
  return ncsubproc_createv(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncsubproc_createv(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncsubproc_options const * x1;
  char const * x2;
  char const * const * x3;
  int(* x4)(struct ncfdplane *, void const *, size_t, void *);
  int(* x5)(struct ncfdplane *, int, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncsubproc * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncsubproc_createv", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1201), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncsubproc_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1201), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1203), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1203), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (int(*)(struct ncfdplane *, void const *, size_t, void *))_cffi_to_c_pointer(arg4, _cffi_type(1080));
  if (x4 == (int(*)(struct ncfdplane *, void const *, size_t, void *))NULL && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(struct ncfdplane *, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(1081));
  if (x5 == (int(*)(struct ncfdplane *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncsubproc_createv(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(838));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncsubproc_createv _cffi_d_ncsubproc_createv
#endif

static struct ncsubproc * _cffi_d_ncsubproc_createvp(struct ncplane * x0, ncsubproc_options const * x1, char const * x2, char const * const * x3, int(* x4)(struct ncfdplane *, void const *, size_t, void *), int(* x5)(struct ncfdplane *, int, void *))
{
  return ncsubproc_createvp(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncsubproc_createvp(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncsubproc_options const * x1;
  char const * x2;
  char const * const * x3;
  int(* x4)(struct ncfdplane *, void const *, size_t, void *);
  int(* x5)(struct ncfdplane *, int, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncsubproc * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncsubproc_createvp", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1201), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncsubproc_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1201), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1203), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1203), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (int(*)(struct ncfdplane *, void const *, size_t, void *))_cffi_to_c_pointer(arg4, _cffi_type(1080));
  if (x4 == (int(*)(struct ncfdplane *, void const *, size_t, void *))NULL && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(struct ncfdplane *, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(1081));
  if (x5 == (int(*)(struct ncfdplane *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncsubproc_createvp(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(838));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncsubproc_createvp _cffi_d_ncsubproc_createvp
#endif

static struct ncsubproc * _cffi_d_ncsubproc_createvpe(struct ncplane * x0, ncsubproc_options const * x1, char const * x2, char const * const * x3, char const * const * x4, int(* x5)(struct ncfdplane *, void const *, size_t, void *), int(* x6)(struct ncfdplane *, int, void *))
{
  return ncsubproc_createvpe(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncsubproc_createvpe(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncsubproc_options const * x1;
  char const * x2;
  char const * const * x3;
  char const * const * x4;
  int(* x5)(struct ncfdplane *, void const *, size_t, void *);
  int(* x6)(struct ncfdplane *, int, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncsubproc * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ncsubproc_createvpe", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1201), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncsubproc_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1201), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1203), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1203), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1203), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1203), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (int(*)(struct ncfdplane *, void const *, size_t, void *))_cffi_to_c_pointer(arg5, _cffi_type(1080));
  if (x5 == (int(*)(struct ncfdplane *, void const *, size_t, void *))NULL && PyErr_Occurred())
    return NULL;

  x6 = (int(*)(struct ncfdplane *, int, void *))_cffi_to_c_pointer(arg6, _cffi_type(1081));
  if (x6 == (int(*)(struct ncfdplane *, int, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncsubproc_createvpe(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(838));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncsubproc_createvpe _cffi_d_ncsubproc_createvpe
#endif

static int _cffi_d_ncsubproc_destroy(struct ncsubproc * x0)
{
  return ncsubproc_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncsubproc_destroy(PyObject *self, PyObject *arg0)
{
  struct ncsubproc * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(838), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncsubproc *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(838), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncsubproc_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncsubproc_destroy _cffi_d_ncsubproc_destroy
#endif

static struct ncplane * _cffi_d_ncsubproc_plane(struct ncsubproc * x0)
{
  return ncsubproc_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncsubproc_plane(PyObject *self, PyObject *arg0)
{
  struct ncsubproc * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(838), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncsubproc *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(838), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncsubproc_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncsubproc_plane _cffi_d_ncsubproc_plane
#endif

static void(* _cffi_d_nctab_cb(struct nctab * x0))(struct nctab *, struct ncplane *, void *)
{
  return nctab_cb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_cb(PyObject *self, PyObject *arg0)
{
  struct nctab * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void(* result)(struct nctab *, struct ncplane *, void *);
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_cb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1230));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_cb _cffi_d_nctab_cb
#endif

static int _cffi_d_nctab_move(struct nctabbed * x0, struct nctab * x1, struct nctab * x2, struct nctab * x3)
{
  return nctab_move(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_move(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  struct nctab * x1;
  struct nctab * x2;
  struct nctab * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nctab_move", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_move(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_move _cffi_d_nctab_move
#endif

static void _cffi_d_nctab_move_left(struct nctabbed * x0, struct nctab * x1)
{
  nctab_move_left(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_move_left(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  struct nctab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctab_move_left", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctab_move_left(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctab_move_left _cffi_d_nctab_move_left
#endif

static void _cffi_d_nctab_move_right(struct nctabbed * x0, struct nctab * x1)
{
  nctab_move_right(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_move_right(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  struct nctab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctab_move_right", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctab_move_right(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctab_move_right _cffi_d_nctab_move_right
#endif

static char const * _cffi_d_nctab_name(struct nctab * x0)
{
  return nctab_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_name(PyObject *self, PyObject *arg0)
{
  struct nctab * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_name _cffi_d_nctab_name
#endif

static int _cffi_d_nctab_name_width(struct nctab * x0)
{
  return nctab_name_width(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_name_width(PyObject *self, PyObject *arg0)
{
  struct nctab * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_name_width(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_name_width _cffi_d_nctab_name_width
#endif

static struct nctab * _cffi_d_nctab_next(struct nctab * x0)
{
  return nctab_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_next(PyObject *self, PyObject *arg0)
{
  struct nctab * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctab * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(150));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_next _cffi_d_nctab_next
#endif

static struct nctab * _cffi_d_nctab_prev(struct nctab * x0)
{
  return nctab_prev(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_prev(PyObject *self, PyObject *arg0)
{
  struct nctab * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctab * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_prev(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(150));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_prev _cffi_d_nctab_prev
#endif

static void(* _cffi_d_nctab_set_cb(struct nctab * x0, void(* x1)(struct nctab *, struct ncplane *, void *)))(struct nctab *, struct ncplane *, void *)
{
  return nctab_set_cb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_set_cb(PyObject *self, PyObject *args)
{
  struct nctab * x0;
  void(* x1)(struct nctab *, struct ncplane *, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void(* result)(struct nctab *, struct ncplane *, void *);
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctab_set_cb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct nctab *, struct ncplane *, void *))_cffi_to_c_pointer(arg1, _cffi_type(1230));
  if (x1 == (void(*)(struct nctab *, struct ncplane *, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_set_cb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1230));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_set_cb _cffi_d_nctab_set_cb
#endif

static int _cffi_d_nctab_set_name(struct nctab * x0, char const * x1)
{
  return nctab_set_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_set_name(PyObject *self, PyObject *args)
{
  struct nctab * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctab_set_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_set_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_set_name _cffi_d_nctab_set_name
#endif

static void * _cffi_d_nctab_set_userptr(struct nctab * x0, void * x1)
{
  return nctab_set_userptr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_set_userptr(PyObject *self, PyObject *args)
{
  struct nctab * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctab_set_userptr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_set_userptr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_set_userptr _cffi_d_nctab_set_userptr
#endif

static void * _cffi_d_nctab_userptr(struct nctab * x0)
{
  return nctab_userptr(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctab_userptr(PyObject *self, PyObject *arg0)
{
  struct nctab * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctab_userptr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctab_userptr _cffi_d_nctab_userptr
#endif

static struct nctab * _cffi_d_nctabbed_add(struct nctabbed * x0, struct nctab * x1, struct nctab * x2, void(* x3)(struct nctab *, struct ncplane *, void *), char const * x4, void * x5)
{
  return nctabbed_add(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_add(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  struct nctab * x1;
  struct nctab * x2;
  void(* x3)(struct nctab *, struct ncplane *, void *);
  char const * x4;
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctab * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "nctabbed_add", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (void(*)(struct nctab *, struct ncplane *, void *))_cffi_to_c_pointer(arg3, _cffi_type(1230));
  if (x3 == (void(*)(struct nctab *, struct ncplane *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_add(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(150));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_add _cffi_d_nctabbed_add
#endif

static void _cffi_d_nctabbed_channels(struct nctabbed * x0, uint64_t * x1, uint64_t * x2, uint64_t * x3)
{
  nctabbed_channels(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_channels(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  uint64_t * x1;
  uint64_t * x2;
  uint64_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "nctabbed_channels", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctabbed_channels(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctabbed_channels _cffi_d_nctabbed_channels
#endif

static struct ncplane * _cffi_d_nctabbed_content_plane(struct nctabbed * x0)
{
  return nctabbed_content_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_content_plane(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_content_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_content_plane _cffi_d_nctabbed_content_plane
#endif

static struct nctabbed * _cffi_d_nctabbed_create(struct ncplane * x0, nctabbed_options const * x1)
{
  return nctabbed_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nctabbed_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctabbed * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctabbed_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1236), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nctabbed_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1236), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(153));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_create _cffi_d_nctabbed_create
#endif

static int _cffi_d_nctabbed_del(struct nctabbed * x0, struct nctab * x1)
{
  return nctabbed_del(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_del(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  struct nctab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctabbed_del", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_del(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_del _cffi_d_nctabbed_del
#endif

static void _cffi_d_nctabbed_destroy(struct nctabbed * x0)
{
  nctabbed_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_destroy(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctabbed_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctabbed_destroy _cffi_d_nctabbed_destroy
#endif

static void _cffi_d_nctabbed_ensure_selected_header_visible(struct nctabbed * x0)
{
  nctabbed_ensure_selected_header_visible(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_ensure_selected_header_visible(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctabbed_ensure_selected_header_visible(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctabbed_ensure_selected_header_visible _cffi_d_nctabbed_ensure_selected_header_visible
#endif

static uint64_t _cffi_d_nctabbed_hdrchan(struct nctabbed * x0)
{
  return nctabbed_hdrchan(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_hdrchan(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_hdrchan(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_hdrchan _cffi_d_nctabbed_hdrchan
#endif

static struct nctab * _cffi_d_nctabbed_leftmost(struct nctabbed * x0)
{
  return nctabbed_leftmost(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_leftmost(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctab * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_leftmost(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(150));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_leftmost _cffi_d_nctabbed_leftmost
#endif

static struct nctab * _cffi_d_nctabbed_next(struct nctabbed * x0)
{
  return nctabbed_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_next(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctab * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(150));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_next _cffi_d_nctabbed_next
#endif

static struct ncplane * _cffi_d_nctabbed_plane(struct nctabbed * x0)
{
  return nctabbed_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_plane(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_plane _cffi_d_nctabbed_plane
#endif

static struct nctab * _cffi_d_nctabbed_prev(struct nctabbed * x0)
{
  return nctabbed_prev(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_prev(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctab * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_prev(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(150));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_prev _cffi_d_nctabbed_prev
#endif

static void _cffi_d_nctabbed_redraw(struct nctabbed * x0)
{
  nctabbed_redraw(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_redraw(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctabbed_redraw(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctabbed_redraw _cffi_d_nctabbed_redraw
#endif

static void _cffi_d_nctabbed_rotate(struct nctabbed * x0, int x1)
{
  nctabbed_rotate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_rotate(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctabbed_rotate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctabbed_rotate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctabbed_rotate _cffi_d_nctabbed_rotate
#endif

static uint64_t _cffi_d_nctabbed_selchan(struct nctabbed * x0)
{
  return nctabbed_selchan(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_selchan(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_selchan(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_selchan _cffi_d_nctabbed_selchan
#endif

static struct nctab * _cffi_d_nctabbed_select(struct nctabbed * x0, struct nctab * x1)
{
  return nctabbed_select(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_select(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  struct nctab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctab * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctabbed_select", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(150), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct nctab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(150), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_select(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(150));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_select _cffi_d_nctabbed_select
#endif

static struct nctab * _cffi_d_nctabbed_selected(struct nctabbed * x0)
{
  return nctabbed_selected(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_selected(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctab * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_selected(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(150));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_selected _cffi_d_nctabbed_selected
#endif

static char const * _cffi_d_nctabbed_separator(struct nctabbed * x0)
{
  return nctabbed_separator(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_separator(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_separator(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_separator _cffi_d_nctabbed_separator
#endif

static int _cffi_d_nctabbed_separator_width(struct nctabbed * x0)
{
  return nctabbed_separator_width(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_separator_width(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_separator_width(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_separator_width _cffi_d_nctabbed_separator_width
#endif

static uint64_t _cffi_d_nctabbed_sepchan(struct nctabbed * x0)
{
  return nctabbed_sepchan(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_sepchan(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_sepchan(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_sepchan _cffi_d_nctabbed_sepchan
#endif

static void _cffi_d_nctabbed_set_hdrchan(struct nctabbed * x0, uint64_t x1)
{
  nctabbed_set_hdrchan(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_set_hdrchan(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctabbed_set_hdrchan", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctabbed_set_hdrchan(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctabbed_set_hdrchan _cffi_d_nctabbed_set_hdrchan
#endif

static void _cffi_d_nctabbed_set_selchan(struct nctabbed * x0, uint64_t x1)
{
  nctabbed_set_selchan(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_set_selchan(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctabbed_set_selchan", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctabbed_set_selchan(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctabbed_set_selchan _cffi_d_nctabbed_set_selchan
#endif

static int _cffi_d_nctabbed_set_separator(struct nctabbed * x0, char const * x1)
{
  return nctabbed_set_separator(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_set_separator(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctabbed_set_separator", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_set_separator(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_set_separator _cffi_d_nctabbed_set_separator
#endif

static void _cffi_d_nctabbed_set_sepchan(struct nctabbed * x0, uint64_t x1)
{
  nctabbed_set_sepchan(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_set_sepchan(PyObject *self, PyObject *args)
{
  struct nctabbed * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctabbed_set_sepchan", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctabbed_set_sepchan(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctabbed_set_sepchan _cffi_d_nctabbed_set_sepchan
#endif

static int _cffi_d_nctabbed_tabcount(struct nctabbed * x0)
{
  return nctabbed_tabcount(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctabbed_tabcount(PyObject *self, PyObject *arg0)
{
  struct nctabbed * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctabbed *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctabbed_tabcount(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctabbed_tabcount _cffi_d_nctabbed_tabcount
#endif

static struct ncplane * _cffi_d_nctablet_plane(struct nctablet * x0)
{
  return nctablet_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctablet_plane(PyObject *self, PyObject *arg0)
{
  struct nctablet * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(824), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctablet *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(824), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctablet_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctablet_plane _cffi_d_nctablet_plane
#endif

static void * _cffi_d_nctablet_userptr(struct nctablet * x0)
{
  return nctablet_userptr(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctablet_userptr(PyObject *self, PyObject *arg0)
{
  struct nctablet * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(824), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctablet *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(824), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctablet_userptr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctablet_userptr _cffi_d_nctablet_userptr
#endif

static int _cffi_d_nctree_add(struct nctree * x0, unsigned int const * x1, struct nctree_item const * x2)
{
  return nctree_add(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_add(PyObject *self, PyObject *args)
{
  struct nctree * x0;
  unsigned int const * x1;
  struct nctree_item const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "nctree_add", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(873), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(873), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(878), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct nctree_item const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(878), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_add(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_add _cffi_d_nctree_add
#endif

static struct nctree * _cffi_d_nctree_create(struct ncplane * x0, nctree_options const * x1)
{
  return nctree_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  nctree_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nctree * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctree_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1250), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (nctree_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1250), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_create _cffi_d_nctree_create
#endif

static int _cffi_d_nctree_del(struct nctree * x0, unsigned int const * x1)
{
  return nctree_del(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_del(PyObject *self, PyObject *args)
{
  struct nctree * x0;
  unsigned int const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctree_del", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(873), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(873), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_del(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_del _cffi_d_nctree_del
#endif

static void _cffi_d_nctree_destroy(struct nctree * x0)
{
  nctree_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_destroy(PyObject *self, PyObject *arg0)
{
  struct nctree * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { nctree_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_nctree_destroy _cffi_d_nctree_destroy
#endif

static void * _cffi_d_nctree_focused(struct nctree * x0)
{
  return nctree_focused(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_focused(PyObject *self, PyObject *arg0)
{
  struct nctree * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_focused(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_focused _cffi_d_nctree_focused
#endif

static void * _cffi_d_nctree_goto(struct nctree * x0, unsigned int const * x1, int * x2)
{
  return nctree_goto(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_goto(PyObject *self, PyObject *args)
{
  struct nctree * x0;
  unsigned int const * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "nctree_goto", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(873), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(873), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_goto(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_goto _cffi_d_nctree_goto
#endif

static void * _cffi_d_nctree_next(struct nctree * x0)
{
  return nctree_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_next(PyObject *self, PyObject *arg0)
{
  struct nctree * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_next _cffi_d_nctree_next
#endif

static _Bool _cffi_d_nctree_offer_input(struct nctree * x0, ncinput const * x1)
{
  return nctree_offer_input(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_offer_input(PyObject *self, PyObject *args)
{
  struct nctree * x0;
  ncinput const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nctree_offer_input", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_offer_input(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_offer_input _cffi_d_nctree_offer_input
#endif

static struct ncplane * _cffi_d_nctree_plane(struct nctree * x0)
{
  return nctree_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_plane(PyObject *self, PyObject *arg0)
{
  struct nctree * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_plane _cffi_d_nctree_plane
#endif

static void * _cffi_d_nctree_prev(struct nctree * x0)
{
  return nctree_prev(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_prev(PyObject *self, PyObject *arg0)
{
  struct nctree * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_prev(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(243));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_prev _cffi_d_nctree_prev
#endif

static int _cffi_d_nctree_redraw(struct nctree * x0)
{
  return nctree_redraw(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nctree_redraw(PyObject *self, PyObject *arg0)
{
  struct nctree * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nctree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nctree_redraw(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nctree_redraw _cffi_d_nctree_redraw
#endif

static int _cffi_d_ncuplot_add_sample(struct ncuplot * x0, uint64_t x1, uint64_t x2)
{
  return ncuplot_add_sample(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncuplot_add_sample(PyObject *self, PyObject *args)
{
  struct ncuplot * x0;
  uint64_t x1;
  uint64_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncuplot_add_sample", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(881), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncuplot *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(881), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncuplot_add_sample(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncuplot_add_sample _cffi_d_ncuplot_add_sample
#endif

static struct ncuplot * _cffi_d_ncuplot_create(struct ncplane * x0, ncplot_options const * x1, uint64_t x2, uint64_t x3)
{
  return ncuplot_create(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncuplot_create(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  ncplot_options const * x1;
  uint64_t x2;
  uint64_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncuplot * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncuplot_create", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1069), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncplot_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1069), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint64_t);
  if (x3 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncuplot_create(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(881));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncuplot_create _cffi_d_ncuplot_create
#endif

static void _cffi_d_ncuplot_destroy(struct ncuplot * x0)
{
  ncuplot_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncuplot_destroy(PyObject *self, PyObject *arg0)
{
  struct ncuplot * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(881), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncuplot *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(881), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncuplot_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncuplot_destroy _cffi_d_ncuplot_destroy
#endif

static struct ncplane * _cffi_d_ncuplot_plane(struct ncuplot * x0)
{
  return ncuplot_plane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncuplot_plane(PyObject *self, PyObject *arg0)
{
  struct ncuplot * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(881), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncuplot *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(881), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncuplot_plane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncuplot_plane _cffi_d_ncuplot_plane
#endif

static int _cffi_d_ncuplot_sample(struct ncuplot const * x0, uint64_t x1, uint64_t * x2)
{
  return ncuplot_sample(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncuplot_sample(PyObject *self, PyObject *args)
{
  struct ncuplot const * x0;
  uint64_t x1;
  uint64_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncuplot_sample", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(886), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncuplot const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(886), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncuplot_sample(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncuplot_sample _cffi_d_ncuplot_sample
#endif

static int _cffi_d_ncuplot_set_sample(struct ncuplot * x0, uint64_t x1, uint64_t x2)
{
  return ncuplot_set_sample(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncuplot_set_sample(PyObject *self, PyObject *args)
{
  struct ncuplot * x0;
  uint64_t x1;
  uint64_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncuplot_set_sample", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(881), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncuplot *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(881), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncuplot_set_sample(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncuplot_set_sample _cffi_d_ncuplot_set_sample
#endif

static int _cffi_d_ncvisual_at_yx(struct ncvisual const * x0, unsigned int x1, unsigned int x2, uint32_t * x3)
{
  return ncvisual_at_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_at_yx(PyObject *self, PyObject *args)
{
  struct ncvisual const * x0;
  unsigned int x1;
  unsigned int x2;
  uint32_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncvisual_at_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(915), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(915), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_at_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_at_yx _cffi_d_ncvisual_at_yx
#endif

static struct ncplane * _cffi_d_ncvisual_blit(struct notcurses * x0, struct ncvisual * x1, struct ncvisual_options const * x2)
{
  return ncvisual_blit(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_blit(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  struct ncvisual * x1;
  struct ncvisual_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncvisual_blit", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_blit(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_blit _cffi_d_ncvisual_blit
#endif

static int _cffi_d_ncvisual_decode(struct ncvisual * x0)
{
  return ncvisual_decode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_decode(PyObject *self, PyObject *arg0)
{
  struct ncvisual * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_decode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_decode _cffi_d_ncvisual_decode
#endif

static int _cffi_d_ncvisual_decode_loop(struct ncvisual * x0)
{
  return ncvisual_decode_loop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_decode_loop(PyObject *self, PyObject *arg0)
{
  struct ncvisual * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_decode_loop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_decode_loop _cffi_d_ncvisual_decode_loop
#endif

static void _cffi_d_ncvisual_destroy(struct ncvisual * x0)
{
  ncvisual_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_destroy(PyObject *self, PyObject *arg0)
{
  struct ncvisual * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ncvisual_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ncvisual_destroy _cffi_d_ncvisual_destroy
#endif

static struct ncvisual * _cffi_d_ncvisual_from_bgra(void const * x0, int x1, int x2, int x3)
{
  return ncvisual_from_bgra(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_from_bgra(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncvisual * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncvisual_from_bgra", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_from_bgra(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_from_bgra _cffi_d_ncvisual_from_bgra
#endif

static struct ncvisual * _cffi_d_ncvisual_from_file(char const * x0)
{
  return ncvisual_from_file(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_from_file(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncvisual * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_from_file(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_from_file _cffi_d_ncvisual_from_file
#endif

static struct ncvisual * _cffi_d_ncvisual_from_palidx(void const * x0, int x1, int x2, int x3, int x4, int x5, uint32_t const * x6)
{
  return ncvisual_from_palidx(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_from_palidx(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  int x5;
  uint32_t const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncvisual * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ncvisual_from_palidx", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(997), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (uint32_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(997), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_from_palidx(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_from_palidx _cffi_d_ncvisual_from_palidx
#endif

static struct ncvisual * _cffi_d_ncvisual_from_plane(struct ncplane const * x0, ncblitter_e x1, int x2, int x3, unsigned int x4, unsigned int x5)
{
  return ncvisual_from_plane(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_from_plane(PyObject *self, PyObject *args)
{
  struct ncplane const * x0;
  ncblitter_e x1;
  int x2;
  int x3;
  unsigned int x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncvisual * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncvisual_from_plane", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(125), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_from_plane(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_from_plane _cffi_d_ncvisual_from_plane
#endif

static struct ncvisual * _cffi_d_ncvisual_from_rgb_loose(void const * x0, int x1, int x2, int x3, int x4)
{
  return ncvisual_from_rgb_loose(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_from_rgb_loose(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncvisual * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncvisual_from_rgb_loose", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_from_rgb_loose(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_from_rgb_loose _cffi_d_ncvisual_from_rgb_loose
#endif

static struct ncvisual * _cffi_d_ncvisual_from_rgb_packed(void const * x0, int x1, int x2, int x3, int x4)
{
  return ncvisual_from_rgb_packed(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_from_rgb_packed(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncvisual * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ncvisual_from_rgb_packed", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_from_rgb_packed(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_from_rgb_packed _cffi_d_ncvisual_from_rgb_packed
#endif

static struct ncvisual * _cffi_d_ncvisual_from_rgba(void const * x0, int x1, int x2, int x3)
{
  return ncvisual_from_rgba(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_from_rgba(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncvisual * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncvisual_from_rgba", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(358), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(358), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_from_rgba(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_from_rgba _cffi_d_ncvisual_from_rgba
#endif

static struct ncvisual * _cffi_d_ncvisual_from_sixel(char const * x0, unsigned int x1, unsigned int x2)
{
  return ncvisual_from_sixel(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_from_sixel(PyObject *self, PyObject *args)
{
  char const * x0;
  unsigned int x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncvisual * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncvisual_from_sixel", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_from_sixel(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_from_sixel _cffi_d_ncvisual_from_sixel
#endif

static int _cffi_d_ncvisual_geom(struct notcurses const * x0, struct ncvisual const * x1, struct ncvisual_options const * x2, ncvgeom * x3)
{
  return ncvisual_geom(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_geom(PyObject *self, PyObject *args)
{
  struct notcurses const * x0;
  struct ncvisual const * x1;
  struct ncvisual_options const * x2;
  ncvgeom * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncvisual_geom", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(915), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncvisual const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(915), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(278), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (ncvgeom *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(278), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_geom(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_geom _cffi_d_ncvisual_geom
#endif

static ncblitter_e _cffi_d_ncvisual_media_defblitter(struct notcurses const * x0, ncscale_e x1)
{
  return ncvisual_media_defblitter(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_media_defblitter(PyObject *self, PyObject *args)
{
  struct notcurses const * x0;
  ncscale_e x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ncblitter_e result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncvisual_media_defblitter", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(128), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_media_defblitter(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(125));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_media_defblitter _cffi_d_ncvisual_media_defblitter
#endif

static int _cffi_d_ncvisual_polyfill_yx(struct ncvisual * x0, unsigned int x1, unsigned int x2, uint32_t x3)
{
  return ncvisual_polyfill_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_polyfill_yx(PyObject *self, PyObject *args)
{
  struct ncvisual * x0;
  unsigned int x1;
  unsigned int x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncvisual_polyfill_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_polyfill_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_polyfill_yx _cffi_d_ncvisual_polyfill_yx
#endif

static int _cffi_d_ncvisual_resize(struct ncvisual * x0, int x1, int x2)
{
  return ncvisual_resize(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_resize(PyObject *self, PyObject *args)
{
  struct ncvisual * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncvisual_resize", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_resize(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_resize _cffi_d_ncvisual_resize
#endif

static int _cffi_d_ncvisual_resize_noninterpolative(struct ncvisual * x0, int x1, int x2)
{
  return ncvisual_resize_noninterpolative(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_resize_noninterpolative(PyObject *self, PyObject *args)
{
  struct ncvisual * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ncvisual_resize_noninterpolative", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_resize_noninterpolative(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_resize_noninterpolative _cffi_d_ncvisual_resize_noninterpolative
#endif

static int _cffi_d_ncvisual_rotate(struct ncvisual * x0, double x1)
{
  return ncvisual_rotate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_rotate(PyObject *self, PyObject *args)
{
  struct ncvisual * x0;
  double x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncvisual_rotate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_rotate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_rotate _cffi_d_ncvisual_rotate
#endif

static int _cffi_d_ncvisual_set_yx(struct ncvisual const * x0, unsigned int x1, unsigned int x2, uint32_t x3)
{
  return ncvisual_set_yx(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_set_yx(PyObject *self, PyObject *args)
{
  struct ncvisual const * x0;
  unsigned int x1;
  unsigned int x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncvisual_set_yx", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(915), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(915), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_set_yx(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_set_yx _cffi_d_ncvisual_set_yx
#endif

static int _cffi_d_ncvisual_simple_streamer(struct ncvisual * x0, struct ncvisual_options * x1, struct timespec const * x2, void * x3)
{
  return ncvisual_simple_streamer(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_simple_streamer(PyObject *self, PyObject *args)
{
  struct ncvisual * x0;
  struct ncvisual_options * x1;
  struct timespec const * x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncvisual_simple_streamer", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(242), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncvisual_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(242), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(706), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(706), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_simple_streamer(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_simple_streamer _cffi_d_ncvisual_simple_streamer
#endif

static int _cffi_d_ncvisual_stream(struct notcurses * x0, struct ncvisual * x1, float x2, int(* x3)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *), struct ncvisual_options const * x4, void * x5)
{
  return ncvisual_stream(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_stream(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  struct ncvisual * x1;
  float x2;
  int(* x3)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *);
  struct ncvisual_options const * x4;
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ncvisual_stream", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *))_cffi_to_c_pointer(arg3, _cffi_type(241));
  if (x3 == (int(*)(struct ncvisual *, struct ncvisual_options *, struct timespec const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(277), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (struct ncvisual_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(277), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_stream(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_stream _cffi_d_ncvisual_stream
#endif

static struct ncplane * _cffi_d_ncvisual_subtitle_plane(struct ncplane * x0, struct ncvisual const * x1)
{
  return ncvisual_subtitle_plane(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisual_subtitle_plane(PyObject *self, PyObject *args)
{
  struct ncplane * x0;
  struct ncvisual const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ncvisual_subtitle_plane", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ncplane *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(915), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ncvisual const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(915), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisual_subtitle_plane(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisual_subtitle_plane _cffi_d_ncvisual_subtitle_plane
#endif

static struct ncplane * _cffi_d_ncvisualplane_create(struct notcurses * x0, ncplane_options const * x1, struct ncvisual * x2, struct ncvisual_options * x3)
{
  return ncvisualplane_create(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncvisualplane_create(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  ncplane_options const * x1;
  struct ncvisual * x2;
  struct ncvisual_options * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ncvisualplane_create", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1108), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncplane_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1108), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ncvisual *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(242), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct ncvisual_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(242), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncvisualplane_create(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncvisualplane_create _cffi_d_ncvisualplane_create
#endif

static char * _cffi_d_ncwcsrtombs(wchar_t const * x0)
{
  return ncwcsrtombs(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ncwcsrtombs(PyObject *self, PyObject *arg0)
{
  wchar_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (wchar_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(122), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ncwcsrtombs(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ncwcsrtombs _cffi_d_ncwcsrtombs
#endif

static char * _cffi_d_notcurses_accountname(void)
{
  return notcurses_accountname();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_accountname(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_accountname(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  return pyresult;
}
#else
#  define _cffi_f_notcurses_accountname _cffi_d_notcurses_accountname
#endif

static int _cffi_d_notcurses_align(int x0, ncalign_e x1, int x2)
{
  return notcurses_align(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_align(PyObject *self, PyObject *args)
{
  int x0;
  ncalign_e x1;
  int x2;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notcurses_align", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(194), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_align(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_align _cffi_d_notcurses_align
#endif

static char * _cffi_d_notcurses_at_yx(struct notcurses * x0, unsigned int x1, unsigned int x2, uint16_t * x3, uint64_t * x4)
{
  return notcurses_at_yx(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_at_yx(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  unsigned int x1;
  unsigned int x2;
  uint16_t * x3;
  uint64_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "notcurses_at_yx", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint16_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(88), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_at_yx(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_at_yx _cffi_d_notcurses_at_yx
#endif

static struct ncplane * _cffi_d_notcurses_bottom(struct notcurses * x0)
{
  return notcurses_bottom(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_bottom(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_bottom(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_bottom _cffi_d_notcurses_bottom
#endif

static _Bool _cffi_d_notcurses_canbraille(struct notcurses const * x0)
{
  return notcurses_canbraille(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canbraille(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canbraille(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canbraille _cffi_d_notcurses_canbraille
#endif

static _Bool _cffi_d_notcurses_canchangecolor(struct notcurses const * x0)
{
  return notcurses_canchangecolor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canchangecolor(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canchangecolor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canchangecolor _cffi_d_notcurses_canchangecolor
#endif

static _Bool _cffi_d_notcurses_canfade(struct notcurses const * x0)
{
  return notcurses_canfade(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canfade(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canfade(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canfade _cffi_d_notcurses_canfade
#endif

static _Bool _cffi_d_notcurses_canhalfblock(struct notcurses const * x0)
{
  return notcurses_canhalfblock(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canhalfblock(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canhalfblock(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canhalfblock _cffi_d_notcurses_canhalfblock
#endif

static _Bool _cffi_d_notcurses_canopen_images(struct notcurses const * x0)
{
  return notcurses_canopen_images(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canopen_images(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canopen_images(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canopen_images _cffi_d_notcurses_canopen_images
#endif

static _Bool _cffi_d_notcurses_canopen_videos(struct notcurses const * x0)
{
  return notcurses_canopen_videos(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canopen_videos(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canopen_videos(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canopen_videos _cffi_d_notcurses_canopen_videos
#endif

static _Bool _cffi_d_notcurses_canpixel(struct notcurses const * x0)
{
  return notcurses_canpixel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canpixel(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canpixel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canpixel _cffi_d_notcurses_canpixel
#endif

static _Bool _cffi_d_notcurses_canquadrant(struct notcurses const * x0)
{
  return notcurses_canquadrant(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canquadrant(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canquadrant(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canquadrant _cffi_d_notcurses_canquadrant
#endif

static _Bool _cffi_d_notcurses_cansextant(struct notcurses const * x0)
{
  return notcurses_cansextant(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_cansextant(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_cansextant(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_cansextant _cffi_d_notcurses_cansextant
#endif

static _Bool _cffi_d_notcurses_cantruecolor(struct notcurses const * x0)
{
  return notcurses_cantruecolor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_cantruecolor(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_cantruecolor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_cantruecolor _cffi_d_notcurses_cantruecolor
#endif

static _Bool _cffi_d_notcurses_canutf8(struct notcurses const * x0)
{
  return notcurses_canutf8(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_canutf8(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_canutf8(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_canutf8 _cffi_d_notcurses_canutf8
#endif

static nccapabilities const * _cffi_d_notcurses_capabilities(struct notcurses const * x0)
{
  return notcurses_capabilities(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_capabilities(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  nccapabilities const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_capabilities(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_capabilities _cffi_d_notcurses_capabilities
#endif

static ncpixelimpl_e _cffi_d_notcurses_check_pixel_support(struct notcurses const * x0)
{
  return notcurses_check_pixel_support(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_check_pixel_support(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ncpixelimpl_e result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_check_pixel_support(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(1663));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_check_pixel_support _cffi_d_notcurses_check_pixel_support
#endif

static struct notcurses * _cffi_d_notcurses_core_init(notcurses_options const * x0, FILE * x1)
{
  return notcurses_core_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_core_init(PyObject *self, PyObject *args)
{
  notcurses_options const * x0;
  FILE * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct notcurses * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_core_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notcurses_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_core_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(110));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_core_init _cffi_d_notcurses_core_init
#endif

static int _cffi_d_notcurses_cursor_disable(struct notcurses * x0)
{
  return notcurses_cursor_disable(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_cursor_disable(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_cursor_disable(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_cursor_disable _cffi_d_notcurses_cursor_disable
#endif

static int _cffi_d_notcurses_cursor_enable(struct notcurses * x0, int x1, int x2)
{
  return notcurses_cursor_enable(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_cursor_enable(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notcurses_cursor_enable", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_cursor_enable(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_cursor_enable _cffi_d_notcurses_cursor_enable
#endif

static int _cffi_d_notcurses_cursor_yx(struct notcurses const * x0, int * x1, int * x2)
{
  return notcurses_cursor_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_cursor_yx(PyObject *self, PyObject *args)
{
  struct notcurses const * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notcurses_cursor_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_cursor_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_cursor_yx _cffi_d_notcurses_cursor_yx
#endif

static void _cffi_d_notcurses_debug(struct notcurses const * x0, FILE * x1)
{
  notcurses_debug(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_debug(PyObject *self, PyObject *args)
{
  struct notcurses const * x0;
  FILE * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_debug", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notcurses_debug(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notcurses_debug _cffi_d_notcurses_debug
#endif

static int _cffi_d_notcurses_default_background(struct notcurses const * x0, uint32_t * x1)
{
  return notcurses_default_background(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_default_background(PyObject *self, PyObject *args)
{
  struct notcurses const * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_default_background", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_default_background(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_default_background _cffi_d_notcurses_default_background
#endif

static int _cffi_d_notcurses_default_foreground(struct notcurses const * x0, uint32_t * x1)
{
  return notcurses_default_foreground(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_default_foreground(PyObject *self, PyObject *args)
{
  struct notcurses const * x0;
  uint32_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_default_foreground", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(226), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(226), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_default_foreground(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_default_foreground _cffi_d_notcurses_default_foreground
#endif

static char * _cffi_d_notcurses_detected_terminal(struct notcurses const * x0)
{
  return notcurses_detected_terminal(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_detected_terminal(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_detected_terminal(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_detected_terminal _cffi_d_notcurses_detected_terminal
#endif

static void _cffi_d_notcurses_drop_planes(struct notcurses * x0)
{
  notcurses_drop_planes(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_drop_planes(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notcurses_drop_planes(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notcurses_drop_planes _cffi_d_notcurses_drop_planes
#endif

static int _cffi_d_notcurses_enter_alternate_screen(struct notcurses * x0)
{
  return notcurses_enter_alternate_screen(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_enter_alternate_screen(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_enter_alternate_screen(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_enter_alternate_screen _cffi_d_notcurses_enter_alternate_screen
#endif

static uint32_t _cffi_d_notcurses_get(struct notcurses * x0, struct timespec const * x1, ncinput * x2)
{
  return notcurses_get(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_get(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  struct timespec const * x1;
  ncinput * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notcurses_get", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(706), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(706), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_get(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_get _cffi_d_notcurses_get
#endif

static uint32_t _cffi_d_notcurses_get_blocking(struct notcurses * x0, ncinput * x1)
{
  return notcurses_get_blocking(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_get_blocking(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  ncinput * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_get_blocking", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_get_blocking(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_get_blocking _cffi_d_notcurses_get_blocking
#endif

static uint32_t _cffi_d_notcurses_get_nblock(struct notcurses * x0, ncinput * x1)
{
  return notcurses_get_nblock(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_get_nblock(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  ncinput * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_get_nblock", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_get_nblock(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_get_nblock _cffi_d_notcurses_get_nblock
#endif

static int _cffi_d_notcurses_getvec(struct notcurses * x0, struct timespec const * x1, ncinput * x2, int x3)
{
  return notcurses_getvec(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_getvec(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  struct timespec const * x1;
  ncinput * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "notcurses_getvec", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(706), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(706), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ncinput *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_getvec(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_getvec _cffi_d_notcurses_getvec
#endif

static char * _cffi_d_notcurses_hostname(void)
{
  return notcurses_hostname();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_hostname(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_hostname(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  return pyresult;
}
#else
#  define _cffi_f_notcurses_hostname _cffi_d_notcurses_hostname
#endif

static struct notcurses * _cffi_d_notcurses_init(notcurses_options const * x0, FILE * x1)
{
  return notcurses_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_init(PyObject *self, PyObject *args)
{
  notcurses_options const * x0;
  FILE * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct notcurses * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notcurses_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(110));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_init _cffi_d_notcurses_init
#endif

static int _cffi_d_notcurses_inputready_fd(struct notcurses * x0)
{
  return notcurses_inputready_fd(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_inputready_fd(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_inputready_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_inputready_fd _cffi_d_notcurses_inputready_fd
#endif

static int _cffi_d_notcurses_leave_alternate_screen(struct notcurses * x0)
{
  return notcurses_leave_alternate_screen(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_leave_alternate_screen(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_leave_alternate_screen(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_leave_alternate_screen _cffi_d_notcurses_leave_alternate_screen
#endif

static int _cffi_d_notcurses_lex_blitter(char const * x0, ncblitter_e * x1)
{
  return notcurses_lex_blitter(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_lex_blitter(PyObject *self, PyObject *args)
{
  char const * x0;
  ncblitter_e * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_lex_blitter", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(182), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncblitter_e *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(182), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_lex_blitter(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_lex_blitter _cffi_d_notcurses_lex_blitter
#endif

static int _cffi_d_notcurses_lex_margins(char const * x0, notcurses_options * x1)
{
  return notcurses_lex_margins(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_lex_margins(PyObject *self, PyObject *args)
{
  char const * x0;
  notcurses_options * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_lex_margins", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (notcurses_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_lex_margins(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_lex_margins _cffi_d_notcurses_lex_margins
#endif

static int _cffi_d_notcurses_lex_scalemode(char const * x0, ncscale_e * x1)
{
  return notcurses_lex_scalemode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_lex_scalemode(PyObject *self, PyObject *args)
{
  char const * x0;
  ncscale_e * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_lex_scalemode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(186), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncscale_e *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(186), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_lex_scalemode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_lex_scalemode _cffi_d_notcurses_lex_scalemode
#endif

static int _cffi_d_notcurses_linesigs_disable(struct notcurses * x0)
{
  return notcurses_linesigs_disable(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_linesigs_disable(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_linesigs_disable(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_linesigs_disable _cffi_d_notcurses_linesigs_disable
#endif

static int _cffi_d_notcurses_linesigs_enable(struct notcurses * x0)
{
  return notcurses_linesigs_enable(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_linesigs_enable(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_linesigs_enable(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_linesigs_enable _cffi_d_notcurses_linesigs_enable
#endif

static int _cffi_d_notcurses_mice_disable(struct notcurses * x0)
{
  return notcurses_mice_disable(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_mice_disable(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_mice_disable(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_mice_disable _cffi_d_notcurses_mice_disable
#endif

static int _cffi_d_notcurses_mice_enable(struct notcurses * x0, unsigned int x1)
{
  return notcurses_mice_enable(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_mice_enable(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_mice_enable", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_mice_enable(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_mice_enable _cffi_d_notcurses_mice_enable
#endif

static char * _cffi_d_notcurses_osversion(void)
{
  return notcurses_osversion();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_osversion(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_osversion(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  return pyresult;
}
#else
#  define _cffi_f_notcurses_osversion _cffi_d_notcurses_osversion
#endif

static unsigned int _cffi_d_notcurses_palette_size(struct notcurses const * x0)
{
  return notcurses_palette_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_palette_size(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_palette_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_palette_size _cffi_d_notcurses_palette_size
#endif

static int _cffi_d_notcurses_refresh(struct notcurses * x0, unsigned int * x1, unsigned int * x2)
{
  return notcurses_refresh(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_refresh(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  unsigned int * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notcurses_refresh", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_refresh(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_refresh _cffi_d_notcurses_refresh
#endif

static int _cffi_d_notcurses_render(struct notcurses * x0)
{
  return notcurses_render(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_render(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_render(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_render _cffi_d_notcurses_render
#endif

static void _cffi_d_notcurses_stats(struct notcurses * x0, ncstats * x1)
{
  notcurses_stats(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_stats(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  ncstats * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_stats", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1613), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncstats *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1613), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notcurses_stats(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notcurses_stats _cffi_d_notcurses_stats
#endif

static ncstats * _cffi_d_notcurses_stats_alloc(struct notcurses const * x0)
{
  return notcurses_stats_alloc(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_stats_alloc(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ncstats * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_stats_alloc(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1613));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_stats_alloc _cffi_d_notcurses_stats_alloc
#endif

static void _cffi_d_notcurses_stats_reset(struct notcurses * x0, ncstats * x1)
{
  notcurses_stats_reset(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_stats_reset(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  ncstats * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notcurses_stats_reset", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1613), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ncstats *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1613), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notcurses_stats_reset(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notcurses_stats_reset _cffi_d_notcurses_stats_reset
#endif

static struct ncplane * _cffi_d_notcurses_stddim_yx(struct notcurses * x0, unsigned int * x1, unsigned int * x2)
{
  return notcurses_stddim_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_stddim_yx(PyObject *self, PyObject *args)
{
  struct notcurses * x0;
  unsigned int * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notcurses_stddim_yx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_stddim_yx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_stddim_yx _cffi_d_notcurses_stddim_yx
#endif

static struct ncplane const * _cffi_d_notcurses_stddim_yx_const(struct notcurses const * x0, unsigned int * x1, unsigned int * x2)
{
  return notcurses_stddim_yx_const(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_stddim_yx_const(PyObject *self, PyObject *args)
{
  struct notcurses const * x0;
  unsigned int * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notcurses_stddim_yx_const", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(231), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(231), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_stddim_yx_const(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_stddim_yx_const _cffi_d_notcurses_stddim_yx_const
#endif

static struct ncplane * _cffi_d_notcurses_stdplane(struct notcurses * x0)
{
  return notcurses_stdplane(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_stdplane(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_stdplane(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_stdplane _cffi_d_notcurses_stdplane
#endif

static struct ncplane const * _cffi_d_notcurses_stdplane_const(struct notcurses const * x0)
{
  return notcurses_stdplane_const(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_stdplane_const(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ncplane const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_stdplane_const(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_stdplane_const _cffi_d_notcurses_stdplane_const
#endif

static int _cffi_d_notcurses_stop(struct notcurses * x0)
{
  return notcurses_stop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_stop(PyObject *self, PyObject *arg0)
{
  struct notcurses * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_stop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_stop _cffi_d_notcurses_stop
#endif

static char const * _cffi_d_notcurses_str_blitter(ncblitter_e x0)
{
  return notcurses_str_blitter(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_str_blitter(PyObject *self, PyObject *arg0)
{
  ncblitter_e x0;
  char const * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(125), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_str_blitter(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  return pyresult;
}
#else
#  define _cffi_f_notcurses_str_blitter _cffi_d_notcurses_str_blitter
#endif

static char const * _cffi_d_notcurses_str_scalemode(ncscale_e x0)
{
  return notcurses_str_scalemode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_str_scalemode(PyObject *self, PyObject *arg0)
{
  ncscale_e x0;
  char const * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(128), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_str_scalemode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  return pyresult;
}
#else
#  define _cffi_f_notcurses_str_scalemode _cffi_d_notcurses_str_scalemode
#endif

static uint16_t _cffi_d_notcurses_supported_styles(struct notcurses const * x0)
{
  return notcurses_supported_styles(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_supported_styles(PyObject *self, PyObject *arg0)
{
  struct notcurses const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint16_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct notcurses const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(59), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notcurses_supported_styles(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint16_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notcurses_supported_styles _cffi_d_notcurses_supported_styles
#endif

static void _cffi_d_notcurses_term_dim_yx(struct notcurses const * x0, unsigned int * x1, unsigned int * x2)
{
  notcurses_term_dim_yx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notcurses_term_dim_yx(PyObject *self, PyObject *args)
{
  struct notcurses const * x0;
  unsigned int * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyA