/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "object-player.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__INT64 (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_Int64Func)
       (void *data1,
        gint64 arg_Position,
        void *data2);
  _GDbusCodegenMarshalVoid_Int64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_Int64Func)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_int64 (param_values + 1),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT64 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectInt64Func)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint64 arg_Offset,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectInt64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectInt64Func)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int64 (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT64 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringInt64Func)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_TrackId,
        gint64 arg_Position,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringInt64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringInt64Func)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_int64 (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.mpris.MediaPlayer2.Player
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MprisMediaPlayer2Player
 * @title: MprisMediaPlayer2Player
 * @short_description: Generated C code for the org.mpris.MediaPlayer2.Player D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link> D-Bus interface in C.
 */

enum
{
  MPRIS__MEDIA_PLAYER2_PLAYER_SEEKED,
};

static unsigned MPRIS__MEDIA_PLAYER2_PLAYER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.mpris.MediaPlayer2.Player ---- */

static const _ExtendedGDBusMethodInfo _mpris_media_player2_player_method_info_next =
{
  {
    -1,
    (gchar *) "Next",
    NULL,
    NULL,
    NULL
  },
  "handle-next",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_media_player2_player_method_info_pause =
{
  {
    -1,
    (gchar *) "Pause",
    NULL,
    NULL,
    NULL
  },
  "handle-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_media_player2_player_method_info_play =
{
  {
    -1,
    (gchar *) "Play",
    NULL,
    NULL,
    NULL
  },
  "handle-play",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_media_player2_player_method_info_play_pause =
{
  {
    -1,
    (gchar *) "PlayPause",
    NULL,
    NULL,
    NULL
  },
  "handle-play-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_media_player2_player_method_info_previous =
{
  {
    -1,
    (gchar *) "Previous",
    NULL,
    NULL,
    NULL
  },
  "handle-previous",
  FALSE
};

static const _ExtendedGDBusArgInfo _mpris_media_player2_player_method_info_seek_IN_ARG_Offset =
{
  {
    -1,
    (gchar *) "Offset",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mpris_media_player2_player_method_info_seek_IN_ARG_pointers[] =
{
  &_mpris_media_player2_player_method_info_seek_IN_ARG_Offset.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mpris_media_player2_player_method_info_seek =
{
  {
    -1,
    (gchar *) "Seek",
    (GDBusArgInfo **) &_mpris_media_player2_player_method_info_seek_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-seek",
  FALSE
};

static const _ExtendedGDBusArgInfo _mpris_media_player2_player_method_info_set_position_IN_ARG_TrackId =
{
  {
    -1,
    (gchar *) "TrackId",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mpris_media_player2_player_method_info_set_position_IN_ARG_Position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mpris_media_player2_player_method_info_set_position_IN_ARG_pointers[] =
{
  &_mpris_media_player2_player_method_info_set_position_IN_ARG_TrackId.parent_struct,
  &_mpris_media_player2_player_method_info_set_position_IN_ARG_Position.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mpris_media_player2_player_method_info_set_position =
{
  {
    -1,
    (gchar *) "SetPosition",
    (GDBusArgInfo **) &_mpris_media_player2_player_method_info_set_position_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-position",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_media_player2_player_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const GDBusMethodInfo * const _mpris_media_player2_player_method_info_pointers[] =
{
  &_mpris_media_player2_player_method_info_next.parent_struct,
  &_mpris_media_player2_player_method_info_pause.parent_struct,
  &_mpris_media_player2_player_method_info_play.parent_struct,
  &_mpris_media_player2_player_method_info_play_pause.parent_struct,
  &_mpris_media_player2_player_method_info_previous.parent_struct,
  &_mpris_media_player2_player_method_info_seek.parent_struct,
  &_mpris_media_player2_player_method_info_set_position.parent_struct,
  &_mpris_media_player2_player_method_info_stop.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mpris_media_player2_player_signal_info_seeked_ARG_Position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mpris_media_player2_player_signal_info_seeked_ARG_pointers[] =
{
  &_mpris_media_player2_player_signal_info_seeked_ARG_Position.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mpris_media_player2_player_signal_info_seeked =
{
  {
    -1,
    (gchar *) "Seeked",
    (GDBusArgInfo **) &_mpris_media_player2_player_signal_info_seeked_ARG_pointers,
    NULL
  },
  "seeked"
};

static const GDBusSignalInfo * const _mpris_media_player2_player_signal_info_pointers[] =
{
  &_mpris_media_player2_player_signal_info_seeked.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_can_control =
{
  {
    -1,
    (gchar *) "CanControl",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-control",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_can_go_next =
{
  {
    -1,
    (gchar *) "CanGoNext",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-go-next",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_can_go_previous =
{
  {
    -1,
    (gchar *) "CanGoPrevious",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-go-previous",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_can_pause =
{
  {
    -1,
    (gchar *) "CanPause",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-pause",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_can_play =
{
  {
    -1,
    (gchar *) "CanPlay",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-play",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_can_seek =
{
  {
    -1,
    (gchar *) "CanSeek",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-seek",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "metadata",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_playback_status =
{
  {
    -1,
    (gchar *) "PlaybackStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "playback-status",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_media_player2_player_property_position_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_media_player2_player_property_position_annotation_info_pointers[] =
{
  &_mpris_media_player2_player_property_position_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_media_player2_player_property_position_annotation_info_pointers
  },
  "position",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _mpris_media_player2_player_property_info_volume =
{
  {
    -1,
    (gchar *) "Volume",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "volume",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mpris_media_player2_player_property_info_pointers[] =
{
  &_mpris_media_player2_player_property_info_can_control.parent_struct,
  &_mpris_media_player2_player_property_info_can_go_next.parent_struct,
  &_mpris_media_player2_player_property_info_can_go_previous.parent_struct,
  &_mpris_media_player2_player_property_info_can_pause.parent_struct,
  &_mpris_media_player2_player_property_info_can_play.parent_struct,
  &_mpris_media_player2_player_property_info_can_seek.parent_struct,
  &_mpris_media_player2_player_property_info_metadata.parent_struct,
  &_mpris_media_player2_player_property_info_playback_status.parent_struct,
  &_mpris_media_player2_player_property_info_position.parent_struct,
  &_mpris_media_player2_player_property_info_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mpris_media_player2_player_interface_info =
{
  {
    -1,
    (gchar *) "org.mpris.MediaPlayer2.Player",
    (GDBusMethodInfo **) &_mpris_media_player2_player_method_info_pointers,
    (GDBusSignalInfo **) &_mpris_media_player2_player_signal_info_pointers,
    (GDBusPropertyInfo **) &_mpris_media_player2_player_property_info_pointers,
    NULL
  },
  "media-player2-player",
};


/**
 * mpris_media_player2_player_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mpris_media_player2_player_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mpris_media_player2_player_interface_info.parent_struct;
}

/**
 * mpris_media_player2_player_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MprisMediaPlayer2Player interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mpris_media_player2_player_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "can-control");
  g_object_class_override_property (klass, property_id_begin++, "can-go-next");
  g_object_class_override_property (klass, property_id_begin++, "can-go-previous");
  g_object_class_override_property (klass, property_id_begin++, "can-pause");
  g_object_class_override_property (klass, property_id_begin++, "can-play");
  g_object_class_override_property (klass, property_id_begin++, "can-seek");
  g_object_class_override_property (klass, property_id_begin++, "metadata");
  g_object_class_override_property (klass, property_id_begin++, "playback-status");
  g_object_class_override_property (klass, property_id_begin++, "position");
  g_object_class_override_property (klass, property_id_begin++, "volume");
  return property_id_begin - 1;
}


inline static void
mpris_media_player2_player_signal_marshal_seeked (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mpris_media_player2_player_method_marshal_next (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mpris_media_player2_player_method_marshal_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mpris_media_player2_player_method_marshal_play (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mpris_media_player2_player_method_marshal_play_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mpris_media_player2_player_method_marshal_previous (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mpris_media_player2_player_method_marshal_seek (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mpris_media_player2_player_method_marshal_set_position (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mpris_media_player2_player_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MprisMediaPlayer2Player:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 */

/**
 * MprisMediaPlayer2PlayerIface:
 * @parent_iface: The parent interface.
 * @handle_next: Handler for the #MprisMediaPlayer2Player::handle-next signal.
 * @handle_pause: Handler for the #MprisMediaPlayer2Player::handle-pause signal.
 * @handle_play: Handler for the #MprisMediaPlayer2Player::handle-play signal.
 * @handle_play_pause: Handler for the #MprisMediaPlayer2Player::handle-play-pause signal.
 * @handle_previous: Handler for the #MprisMediaPlayer2Player::handle-previous signal.
 * @handle_seek: Handler for the #MprisMediaPlayer2Player::handle-seek signal.
 * @handle_set_position: Handler for the #MprisMediaPlayer2Player::handle-set-position signal.
 * @handle_stop: Handler for the #MprisMediaPlayer2Player::handle-stop signal.
 * @get_can_control: Getter for the #MprisMediaPlayer2Player:can-control property.
 * @get_can_go_next: Getter for the #MprisMediaPlayer2Player:can-go-next property.
 * @get_can_go_previous: Getter for the #MprisMediaPlayer2Player:can-go-previous property.
 * @get_can_pause: Getter for the #MprisMediaPlayer2Player:can-pause property.
 * @get_can_play: Getter for the #MprisMediaPlayer2Player:can-play property.
 * @get_can_seek: Getter for the #MprisMediaPlayer2Player:can-seek property.
 * @get_metadata: Getter for the #MprisMediaPlayer2Player:metadata property.
 * @get_playback_status: Getter for the #MprisMediaPlayer2Player:playback-status property.
 * @get_position: Getter for the #MprisMediaPlayer2Player:position property.
 * @get_volume: Getter for the #MprisMediaPlayer2Player:volume property.
 * @seeked: Handler for the #MprisMediaPlayer2Player::seeked signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 */

typedef MprisMediaPlayer2PlayerIface MprisMediaPlayer2PlayerInterface;
G_DEFINE_INTERFACE (MprisMediaPlayer2Player, mpris_media_player2_player, G_TYPE_OBJECT)

static void
mpris_media_player2_player_default_init (MprisMediaPlayer2PlayerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MprisMediaPlayer2Player::handle-next:
   * @object: A #MprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_media_player2_player_complete_next() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-next",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, handle_next),
    g_signal_accumulator_true_handled,
    NULL,
      mpris_media_player2_player_method_marshal_next,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisMediaPlayer2Player::handle-pause:
   * @object: A #MprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_media_player2_player_complete_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, handle_pause),
    g_signal_accumulator_true_handled,
    NULL,
      mpris_media_player2_player_method_marshal_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisMediaPlayer2Player::handle-play:
   * @object: A #MprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_media_player2_player_complete_play() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, handle_play),
    g_signal_accumulator_true_handled,
    NULL,
      mpris_media_player2_player_method_marshal_play,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisMediaPlayer2Player::handle-play-pause:
   * @object: A #MprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_media_player2_player_complete_play_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, handle_play_pause),
    g_signal_accumulator_true_handled,
    NULL,
      mpris_media_player2_player_method_marshal_play_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisMediaPlayer2Player::handle-previous:
   * @object: A #MprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_media_player2_player_complete_previous() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-previous",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, handle_previous),
    g_signal_accumulator_true_handled,
    NULL,
      mpris_media_player2_player_method_marshal_previous,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisMediaPlayer2Player::handle-seek:
   * @object: A #MprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Offset: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_media_player2_player_complete_seek() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-seek",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, handle_seek),
    g_signal_accumulator_true_handled,
    NULL,
      mpris_media_player2_player_method_marshal_seek,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT64);

  /**
   * MprisMediaPlayer2Player::handle-set-position:
   * @object: A #MprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_TrackId: Argument passed by remote caller.
   * @arg_Position: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_media_player2_player_complete_set_position() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-position",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, handle_set_position),
    g_signal_accumulator_true_handled,
    NULL,
      mpris_media_player2_player_method_marshal_set_position,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_INT64);

  /**
   * MprisMediaPlayer2Player::handle-stop:
   * @object: A #MprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_media_player2_player_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      mpris_media_player2_player_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * MprisMediaPlayer2Player::seeked:
   * @object: A #MprisMediaPlayer2Player.
   * @arg_Position: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mpris-MediaPlayer2-Player.Seeked">"Seeked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  MPRIS__MEDIA_PLAYER2_PLAYER_SIGNALS[MPRIS__MEDIA_PLAYER2_PLAYER_SEEKED] =
    g_signal_new ("seeked",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MprisMediaPlayer2PlayerIface, seeked),
      NULL,
      NULL,
      mpris_media_player2_player_signal_marshal_seeked,
      G_TYPE_NONE,
      1, G_TYPE_INT64);

  /* GObject properties for D-Bus properties: */
  /**
   * MprisMediaPlayer2Player:can-control:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-control", "CanControl", "CanControl", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:can-go-next:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-go-next", "CanGoNext", "CanGoNext", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:can-go-previous:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-go-previous", "CanGoPrevious", "CanGoPrevious", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:can-pause:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-pause", "CanPause", "CanPause", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:can-play:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-play", "CanPlay", "CanPlay", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:can-seek:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-seek", "CanSeek", "CanSeek", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:metadata:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("metadata", "Metadata", "Metadata", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:playback-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("playback-status", "PlaybackStatus", "PlaybackStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:position:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("position", "Position", "Position", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisMediaPlayer2Player:volume:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("volume", "Volume", "Volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mpris_media_player2_player_get_can_control: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_media_player2_player_get_can_control (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_control (object);
}

/**
 * mpris_media_player2_player_set_can_control: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_can_control (MprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-control", value, NULL);
}

/**
 * mpris_media_player2_player_get_can_go_next: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_media_player2_player_get_can_go_next (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_go_next (object);
}

/**
 * mpris_media_player2_player_set_can_go_next: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_can_go_next (MprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-go-next", value, NULL);
}

/**
 * mpris_media_player2_player_get_can_go_previous: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_media_player2_player_get_can_go_previous (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_go_previous (object);
}

/**
 * mpris_media_player2_player_set_can_go_previous: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_can_go_previous (MprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-go-previous", value, NULL);
}

/**
 * mpris_media_player2_player_get_can_pause: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_media_player2_player_get_can_pause (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_pause (object);
}

/**
 * mpris_media_player2_player_set_can_pause: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_can_pause (MprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-pause", value, NULL);
}

/**
 * mpris_media_player2_player_get_can_play: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_media_player2_player_get_can_play (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_play (object);
}

/**
 * mpris_media_player2_player_set_can_play: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_can_play (MprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-play", value, NULL);
}

/**
 * mpris_media_player2_player_get_can_seek: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_media_player2_player_get_can_seek (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_seek (object);
}

/**
 * mpris_media_player2_player_set_can_seek: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_can_seek (MprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-seek", value, NULL);
}

/**
 * mpris_media_player2_player_get_metadata: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mpris_media_player2_player_dup_metadata() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mpris_media_player2_player_get_metadata (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), NULL);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_metadata (object);
}

/**
 * mpris_media_player2_player_dup_metadata: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mpris_media_player2_player_dup_metadata (MprisMediaPlayer2Player *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "metadata", &value, NULL);
  return value;
}

/**
 * mpris_media_player2_player_set_metadata: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_metadata (MprisMediaPlayer2Player *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "metadata", value, NULL);
}

/**
 * mpris_media_player2_player_get_playback_status: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mpris_media_player2_player_dup_playback_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mpris_media_player2_player_get_playback_status (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), NULL);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_playback_status (object);
}

/**
 * mpris_media_player2_player_dup_playback_status: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mpris_media_player2_player_dup_playback_status (MprisMediaPlayer2Player *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "playback-status", &value, NULL);
  return value;
}

/**
 * mpris_media_player2_player_set_playback_status: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_playback_status (MprisMediaPlayer2Player *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "playback-status", value, NULL);
}

/**
 * mpris_media_player2_player_get_position: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
mpris_media_player2_player_get_position (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), 0);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_position (object);
}

/**
 * mpris_media_player2_player_set_position: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_media_player2_player_set_position (MprisMediaPlayer2Player *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "position", value, NULL);
}

/**
 * mpris_media_player2_player_get_volume: (skip)
 * @object: A #MprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
mpris_media_player2_player_get_volume (MprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), 0.0);

  return MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_volume (object);
}

/**
 * mpris_media_player2_player_set_volume: (skip)
 * @object: A #MprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
mpris_media_player2_player_set_volume (MprisMediaPlayer2Player *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "volume", value, NULL);
}

/**
 * mpris_media_player2_player_emit_seeked:
 * @object: A #MprisMediaPlayer2Player.
 * @arg_Position: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mpris-MediaPlayer2-Player.Seeked">"Seeked"</link> D-Bus signal.
 */
void
mpris_media_player2_player_emit_seeked (
    MprisMediaPlayer2Player *object,
    gint64 arg_Position)
{
  g_signal_emit (object, MPRIS__MEDIA_PLAYER2_PLAYER_SIGNALS[MPRIS__MEDIA_PLAYER2_PLAYER_SEEKED], 0, arg_Position);
}

/**
 * mpris_media_player2_player_call_next:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_call_next_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_call_next_sync() for the synchronous, blocking version of this method.
 */
void
mpris_media_player2_player_call_next (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_media_player2_player_call_next_finish:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_call_next().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_media_player2_player_call_next().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_next_finish (
    MprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_next_sync:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_call_next() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_next_sync (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_pause:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_call_pause_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_call_pause_sync() for the synchronous, blocking version of this method.
 */
void
mpris_media_player2_player_call_pause (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_media_player2_player_call_pause_finish:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_call_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_media_player2_player_call_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_pause_finish (
    MprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_pause_sync:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_call_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_pause_sync (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_play:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_call_play_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_call_play_sync() for the synchronous, blocking version of this method.
 */
void
mpris_media_player2_player_call_play (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_media_player2_player_call_play_finish:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_call_play().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_media_player2_player_call_play().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_play_finish (
    MprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_play_sync:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_call_play() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_play_sync (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_play_pause:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_call_play_pause_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_call_play_pause_sync() for the synchronous, blocking version of this method.
 */
void
mpris_media_player2_player_call_play_pause (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_media_player2_player_call_play_pause_finish:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_call_play_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_media_player2_player_call_play_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_play_pause_finish (
    MprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_play_pause_sync:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_call_play_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_play_pause_sync (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_previous:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_call_previous_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_call_previous_sync() for the synchronous, blocking version of this method.
 */
void
mpris_media_player2_player_call_previous (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_media_player2_player_call_previous_finish:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_call_previous().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_media_player2_player_call_previous().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_previous_finish (
    MprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_previous_sync:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_call_previous() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_previous_sync (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_seek:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @arg_Offset: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_call_seek_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_call_seek_sync() for the synchronous, blocking version of this method.
 */
void
mpris_media_player2_player_call_seek (
    MprisMediaPlayer2Player *proxy,
    gint64 arg_Offset,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(x)",
                   arg_Offset),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_media_player2_player_call_seek_finish:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_call_seek().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_media_player2_player_call_seek().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_seek_finish (
    MprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_seek_sync:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @arg_Offset: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_call_seek() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_seek_sync (
    MprisMediaPlayer2Player *proxy,
    gint64 arg_Offset,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(x)",
                   arg_Offset),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_set_position:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @arg_Position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_call_set_position_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_call_set_position_sync() for the synchronous, blocking version of this method.
 */
void
mpris_media_player2_player_call_set_position (
    MprisMediaPlayer2Player *proxy,
    const gchar *arg_TrackId,
    gint64 arg_Position,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPosition",
    g_variant_new ("(ox)",
                   arg_TrackId,
                   arg_Position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_media_player2_player_call_set_position_finish:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_call_set_position().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_media_player2_player_call_set_position().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_set_position_finish (
    MprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_set_position_sync:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @arg_Position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_call_set_position() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_set_position_sync (
    MprisMediaPlayer2Player *proxy,
    const gchar *arg_TrackId,
    gint64 arg_Position,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPosition",
    g_variant_new ("(ox)",
                   arg_TrackId,
                   arg_Position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_stop:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_call_stop_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
mpris_media_player2_player_call_stop (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_media_player2_player_call_stop_finish:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_media_player2_player_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_stop_finish (
    MprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_call_stop_sync:
 * @proxy: A #MprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_media_player2_player_call_stop_sync (
    MprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_media_player2_player_complete_next:
 * @object: A #MprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_media_player2_player_complete_next (
    MprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_media_player2_player_complete_pause:
 * @object: A #MprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_media_player2_player_complete_pause (
    MprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_media_player2_player_complete_play:
 * @object: A #MprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_media_player2_player_complete_play (
    MprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_media_player2_player_complete_play_pause:
 * @object: A #MprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_media_player2_player_complete_play_pause (
    MprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_media_player2_player_complete_previous:
 * @object: A #MprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_media_player2_player_complete_previous (
    MprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_media_player2_player_complete_seek:
 * @object: A #MprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_media_player2_player_complete_seek (
    MprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_media_player2_player_complete_set_position:
 * @object: A #MprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_media_player2_player_complete_set_position (
    MprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_media_player2_player_complete_stop:
 * @object: A #MprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_media_player2_player_complete_stop (
    MprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MprisMediaPlayer2PlayerProxy:
 *
 * The #MprisMediaPlayer2PlayerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MprisMediaPlayer2PlayerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MprisMediaPlayer2PlayerProxy.
 */

struct _MprisMediaPlayer2PlayerProxyPrivate
{
  GData *qdata;
};

static void mpris_media_player2_player_proxy_iface_init (MprisMediaPlayer2PlayerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MprisMediaPlayer2PlayerProxy, mpris_media_player2_player_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MprisMediaPlayer2PlayerProxy)
                         G_IMPLEMENT_INTERFACE (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER, mpris_media_player2_player_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MprisMediaPlayer2PlayerProxy, mpris_media_player2_player_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER, mpris_media_player2_player_proxy_iface_init))

#endif
static void
mpris_media_player2_player_proxy_finalize (GObject *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mpris_media_player2_player_proxy_parent_class)->finalize (object);
}

static void
mpris_media_player2_player_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _mpris_media_player2_player_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mpris_media_player2_player_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.mpris.MediaPlayer2.Player: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mpris_media_player2_player_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _mpris_media_player2_player_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.mpris.MediaPlayer2.Player", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mpris_media_player2_player_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mpris_media_player2_player_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mpris_media_player2_player_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MPRIS_TYPE_MEDIA_PLAYER2_PLAYER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MPRIS_TYPE_MEDIA_PLAYER2_PLAYER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mpris_media_player2_player_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mpris_media_player2_player_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mpris_media_player2_player_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
mpris_media_player2_player_proxy_get_can_control (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanControl");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_media_player2_player_proxy_get_can_go_next (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanGoNext");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_media_player2_player_proxy_get_can_go_previous (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanGoPrevious");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_media_player2_player_proxy_get_can_pause (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPause");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_media_player2_player_proxy_get_can_play (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPlay");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_media_player2_player_proxy_get_can_seek (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanSeek");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mpris_media_player2_player_proxy_get_metadata (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Metadata");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
mpris_media_player2_player_proxy_get_playback_status (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PlaybackStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint64 
mpris_media_player2_player_proxy_get_position (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Position");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
mpris_media_player2_player_proxy_get_volume (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerProxy *proxy = MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Volume");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mpris_media_player2_player_proxy_init (MprisMediaPlayer2PlayerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mpris_media_player2_player_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, MprisMediaPlayer2PlayerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mpris_media_player2_player_interface_info ());
}

static void
mpris_media_player2_player_proxy_class_init (MprisMediaPlayer2PlayerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mpris_media_player2_player_proxy_finalize;
  gobject_class->get_property = mpris_media_player2_player_proxy_get_property;
  gobject_class->set_property = mpris_media_player2_player_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mpris_media_player2_player_proxy_g_signal;
  proxy_class->g_properties_changed = mpris_media_player2_player_proxy_g_properties_changed;

  mpris_media_player2_player_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MprisMediaPlayer2PlayerProxyPrivate));
#endif
}

static void
mpris_media_player2_player_proxy_iface_init (MprisMediaPlayer2PlayerIface *iface)
{
  iface->get_can_control = mpris_media_player2_player_proxy_get_can_control;
  iface->get_can_go_next = mpris_media_player2_player_proxy_get_can_go_next;
  iface->get_can_go_previous = mpris_media_player2_player_proxy_get_can_go_previous;
  iface->get_can_pause = mpris_media_player2_player_proxy_get_can_pause;
  iface->get_can_play = mpris_media_player2_player_proxy_get_can_play;
  iface->get_can_seek = mpris_media_player2_player_proxy_get_can_seek;
  iface->get_metadata = mpris_media_player2_player_proxy_get_metadata;
  iface->get_playback_status = mpris_media_player2_player_proxy_get_playback_status;
  iface->get_position = mpris_media_player2_player_proxy_get_position;
  iface->get_volume = mpris_media_player2_player_proxy_get_volume;
}

/**
 * mpris_media_player2_player_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_proxy_new_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mpris_media_player2_player_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
}

/**
 * mpris_media_player2_player_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mpris_media_player2_player_proxy_new().
 *
 * Returns: (transfer full) (type MprisMediaPlayer2PlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
MprisMediaPlayer2Player *
mpris_media_player2_player_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MPRIS_MEDIA_PLAYER2_PLAYER (ret);
  else
    return NULL;
}

/**
 * mpris_media_player2_player_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MprisMediaPlayer2PlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
MprisMediaPlayer2Player *
mpris_media_player2_player_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
  if (ret != NULL)
    return MPRIS_MEDIA_PLAYER2_PLAYER (ret);
  else
    return NULL;
}


/**
 * mpris_media_player2_player_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mpris_media_player2_player_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_media_player2_player_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mpris_media_player2_player_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mpris_media_player2_player_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
}

/**
 * mpris_media_player2_player_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_media_player2_player_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mpris_media_player2_player_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MprisMediaPlayer2PlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
MprisMediaPlayer2Player *
mpris_media_player2_player_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MPRIS_MEDIA_PLAYER2_PLAYER (ret);
  else
    return NULL;
}

/**
 * mpris_media_player2_player_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mpris_media_player2_player_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mpris_media_player2_player_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MprisMediaPlayer2PlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
MprisMediaPlayer2Player *
mpris_media_player2_player_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
  if (ret != NULL)
    return MPRIS_MEDIA_PLAYER2_PLAYER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MprisMediaPlayer2PlayerSkeleton:
 *
 * The #MprisMediaPlayer2PlayerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MprisMediaPlayer2PlayerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MprisMediaPlayer2PlayerSkeleton.
 */

struct _MprisMediaPlayer2PlayerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mpris_media_player2_player_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MPRIS_TYPE_MEDIA_PLAYER2_PLAYER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MPRIS_TYPE_MEDIA_PLAYER2_PLAYER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mpris_media_player2_player_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mpris_media_player2_player_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mpris_media_player2_player_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mpris_media_player2_player_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mpris_media_player2_player_skeleton_vtable =
{
  _mpris_media_player2_player_skeleton_handle_method_call,
  _mpris_media_player2_player_skeleton_handle_get_property,
  _mpris_media_player2_player_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mpris_media_player2_player_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mpris_media_player2_player_interface_info ();
}

static GDBusInterfaceVTable *
mpris_media_player2_player_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mpris_media_player2_player_skeleton_vtable;
}

static GVariant *
mpris_media_player2_player_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mpris_media_player2_player_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mpris_media_player2_player_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mpris_media_player2_player_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mpris_media_player2_player_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.Player", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mpris_media_player2_player_emit_changed (gpointer user_data);

static void
mpris_media_player2_player_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mpris_media_player2_player_emit_changed (skeleton);
}

static void
_mpris_media_player2_player_on_signal_seeked (
    MprisMediaPlayer2Player *object,
    gint64 arg_Position)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(x)",
                   arg_Position));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.Player", "Seeked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mpris_media_player2_player_skeleton_iface_init (MprisMediaPlayer2PlayerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MprisMediaPlayer2PlayerSkeleton, mpris_media_player2_player_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MprisMediaPlayer2PlayerSkeleton)
                         G_IMPLEMENT_INTERFACE (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER, mpris_media_player2_player_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MprisMediaPlayer2PlayerSkeleton, mpris_media_player2_player_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER, mpris_media_player2_player_skeleton_iface_init))

#endif
static void
mpris_media_player2_player_skeleton_finalize (GObject *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  guint n;
  for (n = 0; n < 10; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mpris_media_player2_player_skeleton_parent_class)->finalize (object);
}

static void
mpris_media_player2_player_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mpris_media_player2_player_emit_changed (gpointer user_data)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.mpris.MediaPlayer2.Player",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mpris_media_player2_player_schedule_emit_changed (MprisMediaPlayer2PlayerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mpris_media_player2_player_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mpris_media_player2_player_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mpris_media_player2_player_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mpris_media_player2_player_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _mpris_media_player2_player_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mpris_media_player2_player_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mpris_media_player2_player_skeleton_init (MprisMediaPlayer2PlayerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mpris_media_player2_player_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_SKELETON, MprisMediaPlayer2PlayerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 10);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_DOUBLE);
}

static gboolean 
mpris_media_player2_player_skeleton_get_can_control (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_media_player2_player_skeleton_get_can_go_next (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_media_player2_player_skeleton_get_can_go_previous (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_media_player2_player_skeleton_get_can_pause (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_media_player2_player_skeleton_get_can_play (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_media_player2_player_skeleton_get_can_seek (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mpris_media_player2_player_skeleton_get_metadata (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mpris_media_player2_player_skeleton_get_playback_status (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint64 
mpris_media_player2_player_skeleton_get_position (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int64 (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
mpris_media_player2_player_skeleton_get_volume (MprisMediaPlayer2Player *object)
{
  MprisMediaPlayer2PlayerSkeleton *skeleton = MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mpris_media_player2_player_skeleton_class_init (MprisMediaPlayer2PlayerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mpris_media_player2_player_skeleton_finalize;
  gobject_class->get_property = mpris_media_player2_player_skeleton_get_property;
  gobject_class->set_property = mpris_media_player2_player_skeleton_set_property;
  gobject_class->notify       = mpris_media_player2_player_skeleton_notify;


  mpris_media_player2_player_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mpris_media_player2_player_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mpris_media_player2_player_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mpris_media_player2_player_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mpris_media_player2_player_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MprisMediaPlayer2PlayerSkeletonPrivate));
#endif
}

static void
mpris_media_player2_player_skeleton_iface_init (MprisMediaPlayer2PlayerIface *iface)
{
  iface->seeked = _mpris_media_player2_player_on_signal_seeked;
  iface->get_can_control = mpris_media_player2_player_skeleton_get_can_control;
  iface->get_can_go_next = mpris_media_player2_player_skeleton_get_can_go_next;
  iface->get_can_go_previous = mpris_media_player2_player_skeleton_get_can_go_previous;
  iface->get_can_pause = mpris_media_player2_player_skeleton_get_can_pause;
  iface->get_can_play = mpris_media_player2_player_skeleton_get_can_play;
  iface->get_can_seek = mpris_media_player2_player_skeleton_get_can_seek;
  iface->get_metadata = mpris_media_player2_player_skeleton_get_metadata;
  iface->get_playback_status = mpris_media_player2_player_skeleton_get_playback_status;
  iface->get_position = mpris_media_player2_player_skeleton_get_position;
  iface->get_volume = mpris_media_player2_player_skeleton_get_volume;
}

/**
 * mpris_media_player2_player_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 *
 * Returns: (transfer full) (type MprisMediaPlayer2PlayerSkeleton): The skeleton object.
 */
MprisMediaPlayer2Player *
mpris_media_player2_player_skeleton_new (void)
{
  return MPRIS_MEDIA_PLAYER2_PLAYER (g_object_new (MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_SKELETON, NULL));
}

